<?php echo $__env->make('dashboard.include.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">User Manage</h1>
          </div><!-- /.col -->
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="#">Home</a></li>
              <li class="breadcrumb-item active">User Manage</li>
            </ol>
          </div><!-- /.col -->
        </div><!-- /.row -->
      </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->
    <section class="content">
      <div class="container-fluid">
        <table id="example" class="table table-striped table-bordered" style="width:100%">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email </th>
                            <th>Role</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $item; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($data->email=="admin@admin.com"): ?>
                    <?php else: ?>
                        <tr>
                            <td><?php echo e($data->name); ?></td>
                            <td><?php echo e($data->email); ?></td>
                            <td class="text-center"><?php if($data->type=="Delivery_Guy"): ?> Delivery Rider 
                            <?php elseif($data->type=="disabled"): ?> <span class="badge badge-danger">Disabled</span> 
                            <?php else: ?> <?php echo e($data->type); ?> <?php endif; ?></td>
                            <td class="text-center">
                                <button type="button" class="btn btn-primary btn-sm" data-branch="<?php echo e($data->branch); ?>" data-id="<?php echo e($data->id); ?>" data-name="<?php echo e($data->name); ?>" data-email="<?php echo e($data->email); ?>"  data-role="<?php echo e($data->type); ?>" data-toggle="modal" data-target="#updatepagemodel">Edit</button>
                                <a href="" data-id="<?php echo e($data->id); ?>" class="btn btn-danger btn-sm button" data-url="">Delete </a>
                            </td>                        
                        </tr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Name</th>
                            <th>Email </th>
                            <th>Role</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>    
      </div>
    </section>
  </div>
 


    <div class="modal fade" id="updatepagemodel" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title" id="exampleModalLongTitle">User Details Change</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
            </button>
        </div>
        <form class="form-horizontal" method="POST" action="/usermangeupdate">
            <?php echo e(csrf_field()); ?>

        <div class="modal-body"> 
            <input type="hidden" name="id" id="id">           
        <div class="form-group<?php echo e($errors->has('name') ? ' has-error' : ''); ?>">
            <label for="name" class="col-md-4 control-label">Name</label>
                <input id="name" type="text" class="form-control" name="name" value="<?php echo e(old('name')); ?>" required autofocus>
                <?php if($errors->has('name')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('name')); ?></strong>
                    </span>
                <?php endif; ?>
        </div>
        <div class="form-group<?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
            <label for="email" class="col-md-4 control-label">E-Mail Address</label>
                <input id="email" type="email" class="form-control" name="email" value="<?php echo e(old('email')); ?>" required>
                <?php if($errors->has('email')): ?>
                    <span class="help-block">
                        <strong><?php echo e($errors->first('email')); ?></strong>
                    </span>
                <?php endif; ?>
        </div>
        <div class="form-group">
        <label for="type" class="col-md-4 control-label" >User Type:</label>

                <select class="form-control" name="type" id="type">
                        <option value="super_admin">Super Admin</option>
                        <option value="Reseller">Reseller Admin</option>   
                        <option value="Confirm Department">Confirm Department</option>  
                        <option value="Printing Department">Printing Department</option>  
                        <option value="Packing Department">Packing Department</option>   
                        <option value="Dispatched Department">Dispatched Department</option>   
                        <option value="Return Department">Return Department</option>  
                        <option value="Recovery Department">Recovery Department</option>    
                        <option value="Accountant">Accountant</option>     
                        <option value="Delivery_Guy">Delivery Rider</option>
                        <option value="disabled">Disabled</option> 
                </select>
        </div>

        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save changes</button>
        </div>
        </form>
        </div>
    </div>
</div>
  

  <?php echo $__env->make('dashboard.include.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>;

<script>
$(document).ready(function() {
    $('#example').DataTable();
} );

$('#updatepagemodel').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal
var recipient = button.data('id') 
var name = button.data('name') 
var email = button.data('email') 
var role = button.data('role') 


var modal = $(this)
modal.find('.modal-body #id').val(recipient)
modal.find('.modal-body #name').val(name)
modal.find('.modal-body #email').val(email)
$("#type").val(role).change();

})




$(document).on('click', '.btn-danger', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;

            swal({
            title: "Are you sure?",
            text: "Are you Sure to Remove this User",
            icon: "warning",
            showCancelButton: true,
confirmButtonColor: '#3085d6',
cancelButtonColor: '#d33',
confirmButtonText: 'Yes, delete it!',
            dangerMode: true,
        }).then(function(isConfirm) {
            
            if (isConfirm.value===true) {

                    $.ajax({
                        url: "<?php echo e(url('/deleteuser')); ?>/"+id ,
                        method: "POST",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        cache: false,
                        contentType: false,
                        processData: false,
                        dataType: 'JSON',
                        data:{
                            "id":id
                        },
                        success: function (result, code, ex) {
                            swal("Done!", "It was successfully deleted!", "success");
                            $(ele).closest('tr').hide();
                            // $("#here").load(location.href + " #here");
                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            swal("Warning", "Unable to Process your request", "error");
                        },
                    });

            } else {
                swal("Cancelled", "Not Removed User", "error");
            }
        })
});
</script>