<!DOCTYPE html>
<html lang="en">
<head>
	<title>Kids Mart - Baby Shop</title>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<link rel="icon" type="image/png" href="<?php echo e(asset('front/images/icons/favicon.png')); ?>"/>
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/bootstrap/css/bootstrap.min.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/fonts/font-awesome-4.7.0/css/font-awesome.min.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/fonts/themify/themify-icons.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/fonts/Linearicons-Free-v1.0.0/icon-font.min.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/fonts/elegant-font/html-css/style.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/animate/animate.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/css-hamburgers/hamburgers.min.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/animsition/css/animsition.min.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/select2/select2.min.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/daterangepicker/daterangepicker.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/slick/slick.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/vendor/lightbox2/css/lightbox.min.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/css/util.css')); ?>">
	<link rel="stylesheet" type="text/css" href="<?php echo e(asset('front/css/main.css')); ?>">

</head>
<body class="animsition">

	<!-- Header -->
	<?php echo View::make('frontview/inclu/header2'); ?>

	<!-- Title Page -->
	<section class="bg-title-page p-t-40 p-b-50 flex-col-c-m" style="background-image: url(<?php echo e(asset('front/images/cart.jpg')); ?>);">
		<h2 class="l-text2 t-center">
			Order Review
		</h2>
	</section>

	<!-- Cart -->
    <section class="cart bgwhite p-t-70 p-b-100">
		<div class="container" id="divcart">
			<!-- Cart item -->
			<div class="container-table-cart pos-relative">
				<div class="wrap-table-shopping-cart bgwhite">
					<table class="table-shopping-cart">
						<tr class="table-head">
							<th class="column-1"></th>
							<th class="column-2">Product</th>
							<th class="column-3 p-l-90">Price</th>
							<th class="column-4 p-l-110">Quantity</th>
							<th class="column-5">Total</th>
						</tr>
						<?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr class="table-row">
							<td class="column-1">
								<div class="cart-img-product b-rad-4 o-f-hidden">
								<?php if($data->cartData->image ==''): ?> 
									<img src="<?php echo e(asset('front/images/item-10.jpg')); ?>" alt="IMG-PRODUCT">
								<?php else: ?>
									<img src="<?php echo e(url('uploads/'.$data->cartData->image)); ?>" alt="IMG-PRODUCT">
								<?php endif; ?>
									
								</div>
							</td>
							<td class="column-2"><?php echo e($data->cartData->name); ?></td>
							<td class="column-3 p-l-90">Rs.<?php echo e($data->cartData->sell_price); ?></td>
							<td class="column-4 p-l-90">
								<div class="flex-w bo5 of-hidden w-size17">
									<input class="size4 m-text18 t-center num-product" type="number" id="num-product1" name="num-product1" value="<?php echo e($data->qty); ?>" readonly>
								</div>
							</td>
							<td class="column-5">Rs.<?php echo e($data->cartData->sell_price * $data->qty); ?></td>
						</tr>	
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <tr class="table-row">
                            <td class="nopadding"></td>
                            <td class="nopadding"></td>
                            <td class="nopadding"></td>
                            <td class="column-4 p-l-90 nopadding">Sub-Total</td>
                            <td class="text-center nopadding">Rs. <?php echo e($subtot); ?></td>
                        </tr>
                        <tr class="table-row">
                            <td class="nopadding"></td>
                            <td class="nopadding"></td>
                            <td class="nopadding"></td>
                            <td class="column-4 p-l-90 nopadding">Delivery charge</td>
                            <td class="text-center nopadding">Rs. <?php echo e($deli); ?></td>
                        </tr>
                        <tr class="table-row">
                            <td class="nopadding"></td>
                            <td class="nopadding"></td>
                            <td class="nopadding"></td>
                            <td class="column-4 p-l-90 nopadding"><strong>Total</strong></td>
                            <td class="text-center nopadding"><strong>Rs. <?php echo e($deli+$subtot); ?></strong></td>
                        </tr>
					</table>
					
				</div>
			</div>

			<div class="flex-w flex-sb-m p-t-25 p-b-25 bo8 p-l-35 p-r-60 p-lr-15-sm">
				<div class="flex-w flex-m w-full-sm">To Order Click "Order Now" Button >>>
					<div class="size12 trans-0-6 m-t-10 m-b-10 m-r-10">
						<!-- <a href="/" class="flex-c-m sizefull bg1 bo-rad-23 hov1 s-text1 trans-0-4" >Continue Shopping</a> -->
					</div>
				</div>

				<div class="size12 trans-0-4 m-t-10 m-b-10">
					<button class="flex-c-m sizefull bg1 bo-rad-23 hov1 s-text1 trans-0-4 ordernow">Order Now !</button>
				</div>
			</div>	

		</div>
	</section>


	<!-- Footer -->
	<?php echo View::make('frontview/inclu/footer'); ?>
	
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/jquery/jquery-3.2.1.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/animsition/js/animsition.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/bootstrap/js/popper.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/bootstrap/js/bootstrap.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/select2/select2.min.js')); ?>"></script>
	<script type="text/javascript">
		$(".selection-1").select2({
			minimumResultsForSearch: 20,
			dropdownParent: $('#dropDownSelect1')
		});
	</script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/slick/slick.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/js/slick-custom.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/countdowntime/countdowntime.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/lightbox2/js/lightbox.min.js')); ?>"></script>
	<script type="text/javascript" src="<?php echo e(asset('front/vendor/sweetalert/sweetalert.min.js')); ?>"></script>
	<script type="text/javascript">
		$('.block2-btn-addcart').each(function(){
			var nameProduct = $(this).parent().parent().parent().find('.block2-name').html();
			$(this).on('click', function(){
				swal(nameProduct, "is added to cart !", "success");
			});
		});

		$('.block2-btn-addwishlist').each(function(){
			var nameProduct = $(this).parent().parent().parent().find('.block2-name').html();
			$(this).on('click', function(){
				swal(nameProduct, "is added to wishlist !", "success");
			});
		});
	</script>

	<script type="text/javascript" src="<?php echo e(asset('front/vendor/parallax100/parallax100.js')); ?>"></script>
	<script type="text/javascript">
        $('.parallax100').parallax100();
	</script>
	<script src="<?php echo e(asset('front/js/main.js')); ?>"></script>
</body>
</html>

<style>
    .table-shopping-cart td.nopadding {
    font-family: Montserrat-Regular;
    font-size: 16px;
    color: #555555;
    line-height: 1.5;
    padding-top: 12px !important;
    padding-bottom: 12px !important;
}
</style>


<script>
$(document).on('click', '.ordernow', function (e) {
    e.preventDefault();
    let ele = this;
	$.ajax({
		url: "<?php echo e(url('/webcustomeritems')); ?>",
		method: "POST",
		headers: {
			'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		},
		cache: false,
		contentType: false,
		processData: false,
		dataType: 'JSON',
		data:{
		},
		success: function (result, code, ex) {
			loadCartData();
            swal("Done!", "Order successfully Added!", "success");
			var delay = 3000; 
			setTimeout(function(){ window.location = '/'; }, delay);
			// window.location.href='/'            
		},
		error: function (jqXHR, textStatus, errorThrown) {
			swal("Warning", "Unable to Process your request", "message");
		},
	});
});


</script>

