<?php echo $__env->make('dashboard.include.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Products Manage</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Products Manage</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                    <div align="right">
                        <button type="button" name="add" id="add_data" class="btn btn-success btn-sm">Add Product</button>
                    </div>
                    <br />
                    <table id="student_table" class="table table-bordered" style="width:100%">
                        <thead>
                            <tr>
                                <th>Product Name</th>
                                <th>Sell Price</th>
                                <th>Cost</th>
                                <th>Stock</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                    </table>
                    
                    </div>
                </div>
            </div>
        </div>
      </div>
    </section>
  </div>
 



  <?php echo $__env->make('dashboard.include.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>;



<script>
$(document).ready(function() {
    $('#example').DataTable();
} );
</script>
<script type="text/javascript">
$(document).ready(function() {
     $('#student_table').DataTable({
        "processing": false,
        "serverSide": true,
        "ajax": "<?php echo e(route('ajaxdata.getdata')); ?>",
        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
        "columns":[
            { "data": "name" },
            { "data": "sell_price" },
            { "data": "cost_price" },
            { "data": "stock" },
            { "data": "action", orderable:false, searchable: false}
        ]
     });

    $('#add_data').click(function(){
        $('#studentModal').modal('show');
        $('#student_form')[0].reset();
        $('#form_output').html('');
        $('#button_action').val('insert');
        $('#action').val('Add');
        $('.modal-title').text('Add Product');
    });

    $('#student_form').on('submit', function(event){
        event.preventDefault();
        var form_data = $(this).serialize();
        $.ajax({
            url:"<?php echo e(route('ajaxdata.postdata')); ?>",
            method:"POST",
            cache: false,
            //contentType: 'multipart/form-data',
            data:  new FormData(this),
            cache: false,
                            contentType: false,
                            processData: false,
            dataType:"json",
            success:function(data)
            {
                if(data.error.length > 0)
                {
                    var error_html = '';
                    for(var count = 0; count < data.error.length; count++)
                    {
                        error_html += '<div class="alert alert-danger">'+data.error[count]+'</div>';
                    }
                    $('#form_output').html(error_html);
                }
                else
                {
                    $('#form_output').html(data.success);
                    $('#student_form')[0].reset();
                    $('#action').val('Add');
                    $('.modal-title').text('Add Data');
                    $('#button_action').val('insert');
                    $('#student_table').DataTable().ajax.reload();
                }
            }
        })
    });

    $(document).on('click', '.edit', function(){
        var id = $(this).attr("id");
        $('#form_output').html('');
        $.ajax({
            url:"<?php echo e(route('ajaxdata.fetchdata')); ?>",
            method:'get',
            data:{id:id},
            dataType:'json',
            success:function(data)
            {
                
                $('#name').val(data.name);
                $('#sell_price').val(data.sell_price);
                $('#cost_price').val(data.cost_price);
                $('#stock').val(data.stock);
                if(data.attribu=="yes"){
                    $('#attribu').prop('checked',true);    
                }
                else{
                    $('#attribu').prop('checked',false);      
                }
                if(data.visible=="yes"){
                    $('#visible').prop('checked',true);    
                }
                else{
                    $('#visible').prop('checked',false);      
                }
                $('#input_img').val(data.image);
                $('#id').val(id);
                $('#studentModal').modal('show');
                $('#action').val('Update');
                $('.modal-title').text('Update Product');
                $('#button_action').val('update');
            }
        })
    });

});
</script>
<script>
$(document).on('click', '.btn-danger', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    console.log(id);

                swal({
                title: "Are you sure?",
                text: "Are you Sure to Remove Product",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, delete it!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "<?php echo e(url('/deleteproduct')); ?>/"+id ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            data:{
                                "id":id
                            },
                            success: function (result, code, ex) {
                                swal("Done!", "It was successfully deleted!", "success");
                                // $(ele).closest('tr').hide();
                                // $("#here").load(location.href + " #here");
                                $('#student_table').DataTable().ajax.reload();

                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "No Product Removed", "error");
                }
            })
});
</script>


<div id="studentModal" class="modal fade" role="dialog">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <form method="post" id="student_form">
                <div class="modal-header">
                <h4 class="modal-title">Add Product</h4>
                   <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <?php echo e(csrf_field()); ?>

                    <span id="form_output"></span>
                    <div class="form-group">
                        <label>Product Name</label>
                        <input type="text" name="name" id="name" placeholder="Product Name" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label>Sell Price</label>
                        <input type="number" name="sell_price" id="sell_price" placeholder="Sell Price" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label>Cost</label>
                        <input type="number" name="cost_price" id="cost_price" placeholder="Cost" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label>Stock</label>
                        <input type="number" name="stock" id="stock" placeholder="Stock" class="form-control" />
                    </div>

                    <div class="form-group">
                        <label>Upload Product Image</label><br>
                            <input  name="input_img" type="file" id="profile-img2">
                            <img src="" id="profile-img-tag2" width="200px" />                                
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" name="attribu[]" id="attribu" >Has Attribue</label>
                    </div>
                    <div class="checkbox">
                        <label><input type="checkbox" name="visible[]" id="visible" >Web Visibal</label>
                    </div>
                </div>
                <div class="modal-footer">
                     <input type="hidden" name="id" id="id" value="" />
                    <input type="hidden" name="button_action" id="button_action" value="insert" />
                    <input type="submit" name="submit" id="action" value="Add" class="btn btn-info" />
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </form>
        </div>
    </div>
</div>