<?php echo $__env->make('dashboard.include.header', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Rider Request Orders</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Rider Request Orders</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="reqtable" data-page-length='50' class="table table-bordered" style="width:100%; font-size:12px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Rider</th>
                            <th>Delivery Date</th>
                            <th>Call Center</th>
                            <th>Product</th>
                            <th>Phone</th>
                            <th>Note</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  <?php echo $__env->make('dashboard.include.footer', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>;

<script>
$(document).ready(function() {
  var table = $('#reqtable').DataTable({
        "ajax": {   "url": '/requestdata',
                    "type": 'GET',
        },
        order: [[2, 'asc']],
        columns: [
            { data: 'id', name: 'id' },
            { data: 'ridername', name: 'ridername' },
            { data: 'deliverydate', name: 'deliverydate'},
            { data: 'username', name: 'username' },
            { data: 'productname', name: 'productname' },
            { data: 'phone', name: 'phone'},
            { data: 'note', name: 'note'},
            { data: 'status', 
              render: function(data) { 
                if(data==38) {
                  return '<span class="badge badge-primary">Date Change</span>' 
                }
                else if(data==41){
                  return '<span class="badge badge-danger">Cancel</span>'
                }
                else if(data==42){
                  return '<span class="badge badge-dark" >Phone Off</span>'
                }
                else if(data==43){
                  return '<span class="badge badge-warning">No Answer</span>'
                }
                else if(data==44){
                  return '<span class="badge badge-warning">Out of Stock</span>'
                }
                else if(data==45){
                  return '<span class="badge badge-warning">Rider Out Order Req</span>'
                }
                else if(data==46){
                  return '<span class="badge badge-warning">Faild to Delivery</span>'
                }
                else if(data==47){
                  return '<span class="badge badge-warning">Reschedul Confirm</span>'
                }
                },
              defaultContent: '<span class="badge badge-warning">Other</span>'
            },
            { data: 'action', name: 'action', orderable: false, searchable: false}
        ],
    });
} );

$(document).on('click', '.resetlockscreen', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    $.ajax({
        url: "<?php echo e(url('/resetlock')); ?>/"+id ,
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'JSON',
        data:{
            "id":id
        },
        success: function (result, code, ex) {
            // swal("Done!", "It was successfully deleted!", "success");
            // $(ele).closest('tr').hide();
            toastr.success('Lock Order Reset successfully')
            $('#reqtable').DataTable().ajax.reload();
            // location.reload();
        },
        error: function (jqXHR, textStatus, errorThrown) {
            swal("Warning", "Unable to Process your request", "error");
        },
    });

});

// $(document).on('click', '.approvelbtn', function (e) {
//     e.preventDefault();
//     var id = $(this).data('id');
//     let ele = this;
//     $.ajax({
//         url: "<?php echo e(url('/callcenterapprovel')); ?>/"+id ,
//         method: "POST",
//         headers: {
//             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//         },
//         cache: false,
//         contentType: false,
//         processData: false,
//         dataType: 'JSON',
//         data:{
//             "id":id
//         },
//         success: function (result, code, ex) {
//             // swal("Done!", "It was successfully deleted!", "success");
//             // $(ele).closest('tr').hide();
//             toastr.success('It was successfully Approvel!')
//             $('#example12').DataTable().ajax.reload();
//         },
//         error: function (jqXHR, textStatus, errorThrown) {
//             swal("Warning", "Unable to Process your request", "error");
//         },
//     });

// });

$(document).on('click', '.approvelbtn', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    console.log(id);

                swal({
                title: "Are you sure?",
                text: "Are you Sure to Approvel this Order",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Approvel it!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "<?php echo e(url('/callcenterapprovel')); ?>/"+id ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            data:{
                                "id":id
                            },
                            success: function (result, code, ex) {
                                // swal("Done!", "It was successfully deleted!", "success");
                                // $(ele).closest('tr').hide();
                                toastr.success('It was successfully Approvel!')
                                $('#reqtable').DataTable().ajax.reload();
                                // $("#here").load(location.href + " #here");
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "Not Approved", "error");
                }
            })
});



$(document).on('click', '.reassignbtn', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    console.log(id);

                swal({
                title: "Are you sure?",
                text: "Are you Sure to Approvel this Order",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Approvel it!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "<?php echo e(url('/callcenterreassignbtn')); ?>/"+id ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            data:{
                                "id":id
                            },
                            success: function (result, code, ex) {
                                // swal("Done!", "It was successfully deleted!", "success");
                                // $(ele).closest('tr').hide();
                                toastr.success('It was successfully Approvel!')
                                $('#reqtable').DataTable().ajax.reload();
                                // $("#here").load(location.href + " #here");
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "Not Approved", "error");
                }
            })
});
</script>