@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Wholsale Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Wholsale Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/wholesalesummaryfilter">
          {{csrf_field()}}
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label>wholesaler Name</label>
                    <select class="form-control select2" name="whole_name" style="width: 100%;" required>
                        <option value="" selected="selected" disabled>Select</option>
                        @foreach($item as $itemd)
                        <option value="{{$itemd->id}}" @if($whole == $itemd->id) selected @else @endif >{{$itemd->name}}</option>
                        @endforeach 
                    </select>
                </div>

            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>Paid Status</label>
                    <select class="form-control" name="status" style="width: 100%;" required>
                        <option value="" selected="selected" disabled>Select</option>
                        <option value="55" @if($sta == 55) selected @else @endif >All</option>
                        <option value="0" @if($sta == 0) selected @else @endif >Not Paid</option>
                        <option value="1" @if($sta == 1) selected @else @endif >Paid</option>
                    </select>
                </div>

            </div>
            <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="far fa-calendar-alt"></i>
                    </span>
                    </div>
                    <input type="text" class="form-control float-right" id="reservation" value="{{ $dateran }}" name="daterange">
                </div>
                </div>

            </div>
            <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>
        </div>
</form>

        </div>
    </div>

    <div class="card">
        <div class="card-body">

          <div class="row">
            <div class="col-md-12">
            <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size: 10px;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Wholesaler Name</th>
                    <th>Total</th>
                    <th>Paid Amount</th>
                    <th>Balance</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
        @if($whole == "null")
        @else
        @foreach($purce as $data)
            <tr>
                <td>{{ $data->id}}</td>
                <td>{{ $data->getseholsellername->name}}</td>
                <td>{{ $data->total}}</td>
                <td>{{ $data->amountpaid}}</td>
                <td><span class="badge badge-danger">{{ $data->total - $data->amountpaid }}</span></td>
                <td class="text-center">
                @if($data->status=='0')
                <span class="badge badge-warning">Not paid</span>

                @elseif($data->status=='1')
                <span class="badge badge-success">paid</span>
                @endif
                </td>
                <td class="text-center">   
                @if($data->status=='0')           
                
                    <button type="button" class="btn btn-primary btn-xs supmodel" data-total="{{$data->total}}" data-bank="{{$data->bankid}}" data-wholename="{{$data->getseholsellername->name}}" data-statuss="{{$data->status}}" data-id="{{$data->id}}" data-amountpaid="{{$data->amountpaid}}" data-cdate="{{$data->ccdate}}" data-pdate="{{$data->paiddate}}" data-id="{{$data->id}}" data-supid="{{$data->wholesaleuserid}}" data-payment="{{$data->paymentmethod}}"  data-toggle="modal" data-target="#supmodel">Edit</button>
               <a data-id="{{$data->id}}" class="btn btn-success btn-xs" target="_blank" href="wholesalerprodetails/{{$data->id}}">Payment</a>       
                @elseif($data->status=='1')
                <button type="button" class="btn btn-primary btn-xs supmodel"  data-toggle="modal" data-target="#supmodel" disabled>Edit</button>
                <a data-id="{{$data->id}}" class="btn btn-success btn-xs" target="_blank" href="wholesalerprodetails/{{$data->id}}">Payment</a>
                @endif
                </td>                        
            </tr>
        @endforeach
        @endif
        </tbody>
        </table>
            
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>
 




  @include('dashboard.include.footer')

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 6, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>