@include('dashboard.include.header')
@if(Auth::user()->type == "User")
<script>
    document.location.href = '/resellerdash'
</script>
@endif
  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Top Selling Products</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Top Selling Products</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

    <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/topsellingfilter">
          {{csrf_field()}}
            <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                  <div class="input-group">
                      <div class="input-group-prepend">
                      <span class="input-group-text">
                          <i class="far fa-calendar-alt"></i>
                      </span>
                      </div>
                      <input type="text" class="form-control float-right" id="reservation" value="{{$date}}" name="daterange">
                  </div>
                  </div>
              </div>
              <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>
            </div>
        </form>
        </div>
    </div>


      <div class="card">
        <div class="card-body">
            <div class="row">
            <div class="col-md-12">
                <table id="example12" class="table table-bordered" style="width:100%;">
                    <thead>
                        <tr>
                            <th>Product ID</th>
                            <th>Product Name</th>
                            <th>Selling Count</th>
                            <th>Sell Price</th>
                            <th>Dropshipping Price</th>
                            <th>Weight</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($dataor as $data)
                        <tr>
                            <td>{{$data->item_id}}</td>
                            <td>{{$data->pro_name}}</td>
                            <td>{{$data->qty}}</td>
                            <td>{{$data->sell_price}}</td>
                            <td>{{$data->cost}}</td>
                            <td>{{$data->weight}}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>





        </div>
        </div>
      

     

      </div>
    </section>
  </div>




  @include('dashboard.include.footer');

<script>
$('#reservationdate').datetimepicker({
    format: 'YYYY/MM/DD'
    });

$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );

    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

</script>