@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Riders Payment Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Riders Payment Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">

    <form method="post" action="/riderpaymentsummaryfilter">
        {{csrf_field()}}
        <div class="row">
                <div class="col-md-4">
                <div class="form-group row">
                    <label for="">Delivery Date :</label>
                        <div class="input-group date" id="reservationdate" data-target-input="nearest">
                            <input type="text" class="form-control datetimepicker-input" value="{{$ldate}}" id="delivery_date" name="delivery_date" data-target="#reservationdate"/  required>
                            <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                </div>
            </div>
            <div class="col-md-2" style="padding-top:30px;"><button type="submit" class="btn btn-primary btn-block">Filter</button></div>

  </div>
  
  </form>

        </div>
    </div>

    <div class="card">
        <div class="card-body">

          <div class="row">
            <div class="col-md-12">
            <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size: 13px;">
            <thead>
                        <tr>
                            <th>Rider Name</th>
                            <th>Number of Line</th>
                            <th>Total Collected COD</th>
                            <th>Total Delivery Charge</th>
                            <th>Total Net COD</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($dataor as $dddata)
                        <tr>
                            <td>{{$dddata->name}}</td>
                            <td>{{$dddata->count}}</td>
                            <td>{{$dddata->cod}}</td>
                            <td>{{$dddata->count * 250}}</td>
                            <td>{{$dddata->cod - ($dddata->count * 250 )}}</td>
                        </tr>
                    @endforeach
                        <tr>
                            <th>Total</th>
                            <th>{{$noofline}}</th>
                            <th>{{$tcod}}</th>
                            <th>{{$noofline * 200}}</th>
                            <th>{{$tcod - ($noofline * 200 )}}</th>
                        </tr>
                    </tbody>
                </table>
            
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>
 




  @include('dashboard.include.footer')

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()

$('#reservationdate').datetimepicker({
    format: 'YYYY/MM/DD'
    });
</script>