@include('dashboard.include.header')
@if(Auth::user()->type == "User")
<script>
    document.location.href = '/resellerdash'
</script>
@endif
  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Sales Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Sales Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

    <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/resellersellsummaryfilter">
          {{csrf_field()}}
            <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                  <div class="input-group">
                      <div class="input-group-prepend">
                      <span class="input-group-text">
                          <i class="far fa-calendar-alt"></i>
                      </span>
                      </div>
                      <input type="text" class="form-control float-right" id="reservation" value="{{$date}}" name="daterange">
                  </div>
                  </div>
              </div>
              <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>
            </div>
        </form>
        </div>
    </div>


      <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-1"></div>
                <div class="col-md-2">
                    <div class="callout callout-info">
                    <h5>{{$totcod - $totrefundcod}}</h5>
                    <p>Total Collected COD</p>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="callout callout-primary">
                    <h5>{{$mondel}}</h5>
                    <p>Delivery Charge</p>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="callout callout-warning">
                    <h5>{{$totinventory}}</h5>
                    <p>Products Charge</p>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="callout callout-danger">
                    <h5>{{($servicech)}}</h5>
                    <p>Service Charge</p>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="callout callout-success">
                    <h5>{{$totcod - $totrefundcod - $totinventory - ($mondel+$servicech) }}</h5>
                    <p>Total Profit</p>
                    </div>
                </div>
            </div><br><hr><br>
            <div class="col-md-12">
                <table id="example12" class="table table-bordered" style="width:100%;">
                    <thead>
                        <tr>
                            <th>Invoice ID</th>
                            <th>Status</th>
                            <th>Weight (KG)</th>
                            <th>COD</th>
                            <th>Delivery Charge</th>
                            <th>Service Charge</th>
                            <th>Product Charge</th>
                            <th>Net Payable</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($money as $data)
                        @php $deli=0; $tot=0; $unit=0; @endphp
                        @foreach($data->cus_or as $cudata) 
                            @php
                            $unit = ($cudata->reseller_cost)*($cudata->qty);
                            $tot += $unit;
                            @endphp
                        @endforeach
                        <tr>
                            <td><a target="_blank"  href="/viewallorders/{{$data->id}}">{{$data->id}}</a></td>
                            <td>
                            @if($data->ordertype == 1)
                            <span class="badge badge-success">Money Received</span>
                            @elseif($data->ordertype == 2)
                            <span class="badge badge-warning">Exchange Order</span>
                            @endif
                            </td>
                            <td>{{$data->weight}}</td>
                            <td>{{$data->cod}}</td>
                            <td>{{$data->orderdelivery}}</td>
                            <td>{{$data->servicecharge}}</td>
                            <td>{{$tot}}</td>
                            <td>{{$data->cod - ($data->orderdelivery+$data->servicecharge+$tot) }}</td>
                        </tr>
                        @endforeach

                        @foreach($return as $data)
                        <tr>
                            <td><a target="_blank"  href="/viewallorders/{{$data->id}}">{{$data->id}}</a></td>
                            <td><span class="badge badge-danger">Return Order</span></td>
                            <td>{{$data->weight}}</td>
                            <td>0</td>
                            <td>0</td>
                            <td>{{$data->servicecharge}}</td>
                            <td>0</td>
                            <td>{{0 - $data->servicecharge }}</td>
                        </tr>
                        @endforeach

                        @foreach($refund as $data)
                        <tr>
                            <td><a target="_blank"  href="/viewallorders/{{$data->id}}">{{$data->id}}</a></td>
                            <td><span class="badge badge-dark">Refund Order</span></td>
                            <td>{{$data->weight}}</td>
                            <td>-{{$data->cod}}</td>
                            <td>0</td>
                            <td>0</td>
                            <td>0</td>
                            <td>{{0 - $data->cod }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>






        </div>
        </div>
      

     

      </div>
    </section>
  </div>




  @include('dashboard.include.footer');

<script>
$('#reservationdate').datetimepicker({
    format: 'YYYY/MM/DD'
    });

$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );

    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

</script>