@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Purchase Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Purchase Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/purchasesummaryfilter">
          {{csrf_field()}}
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label>Supplier Name</label>
                    <select class="form-control select2" name="supplier_name" style="width: 100%;" required>
                        <option value="" selected="selected" disabled>Select</option>
                        @foreach($purc as $itemd)
                        <option value="{{$itemd->id}}" @if($supid == $itemd->id) selected @else @endif >{{$itemd->Sname}}</option>
                        @endforeach 
                    </select>
                </div>

            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label>Paid Status</label>
                    <select class="form-control" name="status" style="width: 100%;" required>
                        <option value="" selected="selected" disabled>Select</option>
                        <option value="55" @if($sta == 55) selected @else @endif >All</option>
                        <option value="0" @if($sta == 0) selected @else @endif >Not Paid</option>
                        <option value="1" @if($sta == 1) selected @else @endif >Paid</option>
                    </select>
                </div>

            </div>
            <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="far fa-calendar-alt"></i>
                    </span>
                    </div>
                    <input type="text" class="form-control float-right" id="reservation" value="{{ $dateran }}" name="daterange">
                </div>
                </div>

            </div>
            <div class="col-md-1" style="padding-top:32px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>
        </div>
</form>

        </div>
    </div>

    <div class="card">
        <div class="card-body">

          <div class="row">
            <div class="col-md-12">
            <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size: 10px;">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Supplier Name</th>
                    <th>Cost</th>
                    <th>Paid Amount</th>
                    <th>Balance</th>
                    <th>Invoice No</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            @if($supid == "null")
            @else
        @foreach($purce as $data)
            <tr>
                <td>{{ $data->id}}</td>
                <td>{{ $data->getsupplier->Sname}}</td>
                <td>{{ $data->cost}}</td>
                <td>{{ $data->amountpaid}}</td>
                <td>{{ $data->cost - $data->amountpaid}}</td>
                <td>{{ $data->invoiceno}}</td>
                <td class="text-center">
                @if($data->status=='0')
                <span class="badge badge-warning">Not paid</span>
                @elseif($data->status=='1')
                <span class="badge badge-success">paid</span>
                @endif
                </td>
                <td class="text-center">   
                @if($data->status=='0')           
                      
                    <button type="button" class="btn btn-primary btn-xs supmodel" data-invoiceid="{{$data->invoiceno}}" data-supname="{{$data->getsupplier->Sname}}" data-amount="{{$data->amountpaid}}" data-checkno="{{$data->checkno}}" data-note="{{$data->note}}" data-statuss="{{$data->status}}" data-id="{{$data->id}}" data-cost="{{$data->cost}}" data-cdate="{{$data->ccdate}}" data-pdate="{{$data->paiddate}}" data-id="{{$data->id}}" data-supid="{{$data->supplierid}}" data-payment="{{$data->paymentmethod}}" data-proid="{{$data->productid}}"  data-qtyss="{{$data->qty}}" data-toggle="modal" data-target="#supmodel">Edit</button>
                    <a data-id="{{$data->id}}" class="btn btn-success btn-xs" target="_blank" href="supplierproductdetails/{{$data->id}}">Payment</a> 
                     <!-- &nbsp;<a href="" data-id="{{$data->id}}" class="btn btn-danger btn-xs button purchasingdelete" data-url=""><i class="far fa-trash-alt"></i> </a>  -->
                @elseif($data->status=='1')
                
                <button type="button" class="btn btn-primary btn-xs supmodel" data-statuss="{{$data->status}}" data-id="{{$data->id}}" data-cost="{{$data->cost}}" data-cdate="{{$data->ccdate}}" data-pdate="{{$data->paiddate}}" data-id="{{$data->id}}" data-supid="{{$data->supplierid}}" data-payment="{{$data->paymentmethod}}" data-proid="{{$data->productid}}"  data-qtyss="{{$data->qty}}" data-toggle="modal" data-target="#supmodel" disabled>Edit</button>
                <a data-id="{{$data->id}}" class="btn btn-success btn-xs" target="_blank" href="supplierproductdetails/{{$data->id}}">Payment</a>
                 <!-- &nbsp;<a href="" data-id="{{$data->id}}" style=" pointer-events: none;cursor: default;" class="btn btn-danger btn-xs button purchasingdelete" data-url="" disabled><i class="far fa-trash-alt"></i> </a>  -->
                @endif
                </td>                        
            </tr>
        @endforeach
        @endif
        </tbody>
        </table>
            
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>
 




  @include('dashboard.include.footer')

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 6, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>