@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Orders Packed Count</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Orders Packed Count</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/packedcountfilter">
          {{csrf_field()}}
          <div class="row">
            <div class="col-md-3">
                  <div class="form-group">
                      <label>User Name</label>
                      <select class="form-control select2" name="delivery" id="delivery" style="width: 100%;" required>
                          <option value="" selected="selected" disabled>Select</option>
                              @foreach($delise as $data)
                              @if($data->type=="Packing Department")
                              <option value="{{ $data->name }}" @if($del==$data->name) selected @else @endif>{{ $data->name }}</option>
                              @endif
                              @endforeach
                      </select>
                  </div>
              </div>
              <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                  <div class="input-group">
                      <div class="input-group-prepend">
                      <span class="input-group-text">
                          <i class="far fa-calendar-alt"></i>
                      </span>
                      </div>
                      <input type="text" class="form-control float-right" id="reservation" value="{{$date}}" name="daterange">
                  </div>
                  </div>
              </div>
              <div class="col-md-1" style="padding-top:30px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>


          </div>
          </form>
        </div>
      </div>




      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>User Name</th>
                            <th>Packed Count</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>@if($del=="null")
                            <td></td>
                            <td></td>

                            @else
                            <td>
                                {{$del}}
                            </td>
                            
                            <td>
                              @foreach($dataor as $dataord)
                              @if($del == $dataord->username)
                                {{$dataord->count}}
                              @endif
                              @endforeach
                            </td>   
                            @endif                          
                        </tr>
                    </tbody>

                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1]}},      
    ]  
    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>