@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Cheque Summary</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Cheque Summary</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
        <form class="form-horizontal" method="POST" action="/chequesummaryfilter">
          {{csrf_field()}}
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    <label>Paid Status</label>
                    <select class="form-control" name="status" style="width: 100%;" required>
                        <option value="all" @if($paym=="all") selected @eles @endif >All</option>
                        <option value="0" @if($paym=="0") selected @eles @endif >Not Paid</option>
                        <option value="1" @if($paym=="1") selected @eles @endif >Paid</option>
                    </select>
                </div>

            </div>
            <div class="col-md-3">
                <div class="form-group">
                <label>Date Range</label>
                <div class="input-group">
                    <div class="input-group-prepend">
                    <span class="input-group-text">
                        <i class="far fa-calendar-alt"></i>
                    </span>
                    </div>
                    <input type="text" class="form-control float-right" id="reservation" value="{{$today}}" name="daterange">
                </div>
                </div>

            </div>
            <div class="col-md-1" style="padding-top:32px;">
                <button type="submit" class="btn btn-primary btn-block">Filter</button>
            </div>
        </div>
</form>
        </div>
    </div>

    <div class="card">
        <div class="card-body">

          <div class="row">
            <div class="col-md-12">
            <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size: 10px;">
            <thead>
                <tr>
                    <!-- <th>ID</th> -->
                    <th>Dealer Name</th>
                    <th>Payment</th>
                    <th>Day to pay</th>
                    <th>Paid date</th>
                    <th>Cost</th>
                    <th>Bank</th>
                    <th>Account</th>
                    <th>Check No</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
        @foreach($supplier as $data)
            <tr>
                <!-- <td>{{ $data->id}}</td> -->
                <td>{{ $data->purc1->getsupplier->Sname}}</td>
                <td>{{ $data->paymenttype}}</td>
                <td>{{ $data->ccdate}}</td>
                <td>{{ $data->paiddate}}</td>
                <td>{{ $data->amount}}</td>
                <td>{{ $data->getbank->accountname}}-{{ $data->getbank->bank}}</td>
                <td>Debit</td>
                <td>{{ $data->checkno}}</td>
                <td class="text-center">
                @if($data->status=='0')
                  <span class="badge badge-warning">{{ \Carbon\Carbon::parse( $data->ccdate )->diffInDays( $ldate ) }} days overdue</span>
                @elseif($data->status=='1')
                <span class="badge badge-success">paid</span>
                @endif
                </td>
                <td class="text-center">   
                     <a data-id="{{$data->id}}" class="btn btn-success btn-xs" target="_blank" href="supplierproductdetails/{{$data->purc1->id}}">Payment</a> 
                </td>                        
            </tr>
        @endforeach

                @foreach($whol as $data)
            <tr>
                <!-- <td>{{ $data->id}}</td> -->
                <td>{{ $data->whole1->getseholsellername->name}}</td>
                <td>{{ $data->paymenttype}}</td>
                <td>{{ $data->ccdate}}</td>
                <td>{{ $data->paiddate}}</td>
                <td>{{ $data->amount}}</td>
                <td>{{ $data->getbankwhole->accountname}}-{{ $data->getbankwhole->bank}}</td>
                <td>Credit</td>
                <td>{{ $data->checkno}}</td>
                <td class="text-center">
                @if($data->status=='0')
                  <span class="badge badge-warning">{{ \Carbon\Carbon::parse( $data->ccdate )->diffInDays( $ldate ) }} days overdue</span>
                @elseif($data->status=='1')
                <span class="badge badge-success">paid</span>
                @endif
                </td>
                <td class="text-center">   
                     <a data-id="{{$data->id}}" class="btn btn-success btn-xs" target="_blank" href="wholesalerprodetails/{{$data->whole1->id}}">Payment</a> 
                </td>                        
            </tr>
        @endforeach

        @foreach($chequem as $data)
            <tr>
                <td>{{ $data->dealername}}</td>
                <td>Cheque</td>
                <td>{{ $data->ccdate}}</td>
                <td>{{ $data->paiddate}}</td>
                <td>{{ $data->amount}}</td>
                <td>{{ $data->getbankche->accountname}}-{{ $data->getbankche->bank}}</td>
                <td>{{ $data->paymenttype}}</td>
                <td>{{ $data->checkno}}</td>
                <td class="text-center">
                @if($data->status=='0')
                  <span class="badge badge-warning">{{ \Carbon\Carbon::parse( $data->ccdate )->diffInDays( $ldate ) }} days overdue</span>
                @elseif($data->status=='1')
                <span class="badge badge-success">paid</span>
                @endif
                </td>
                <td class="text-center">   
                <button type="button" class="btn btn-secondary btn-xs button"  data-id="{{$data->id}}"  data-bankid="{{$data->bankid}}" data-amount="{{$data->amount}}"  data-toggle="modal" data-target="#paymentrecive" disabled>Payment</button>
                </td>                        
            </tr>
        @endforeach

        </tbody>
        </table>
            
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>
 




  @include('dashboard.include.footer')

<script>
$(document).ready(function() {
    $('#example12').DataTable({
        "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 6, "asc" ]],
      // "buttons": ["copy", "csv", "excel", "pdf", "print"]
      "buttons": [ {extend: 'copy',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},   
      {extend: 'csv',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},
      {extend: 'excel',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},
      {extend: 'pdf',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},
      {extend: 'print',footer: true,exportOptions: {columns: [0,1,2,3,4,5,6,7,8]}},      
    ],


    }).buttons().container().appendTo('#example12_wrapper .col-md-6:eq(0)');
} );


    $('#reservation').daterangepicker({
        locale: {
            format: 'YYYY/MM/DD'
        }
    });

    $('.select2').select2()
</script>