@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Remaining Stock</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Remaining Stock</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
            <table id="example1" class="table table-bordered" style="width:100%">
                <thead>
                    <tr>
                        <th>Id</th>
                        <th>Product Name</th>
                        <th>Sell Price</th>
                        <th>Cost</th>
                        <th>Stock</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($product as $data)
                    <tr>
                        <td>{{$data->id}}</td>
                        <td>{{$data->name}}</td>
                        <td>{{$data->sell_price}}</td>
                        <td>{{$data->cost_price}}</td>                
                        <td>{{$data->stock}}</td>                
              
                    </tr>
                @endforeach 
                </tbody>
                <tfoot>
                    <tr>
                        <th>Id</th>
                        <th>Product Name</th>
                        <th>Sell Price</th>
                        <th>Cost</th>
                        <th>Stock</th>
                    </tr>
                </tfoot>
            </table>
            
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$(function () {
    $("#example1").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 0, "asc" ]],
      "buttons": [ "colvis", "excel"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
  });
</script>

