@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Item Status Update</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Item Status Update</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form method="post" class="itemstatusform" enctype="multipart/form-data">
          {{csrf_field()}}
        <div class="row">
            <div class="col-md-3">
            <div class="form-group">
                  <label>Barcode</label>
                    <input type="text" class="form-control barcodetxt" name="waybill" id="waybill" placeholder="Baracode + Press Enter Key" required autofocus>
                </div>
            </div>
        </div>
        </form> <hr>
          <div class="row">
            <div class="col-md-12">
                <table id="example12" class="table table-bordered" style="width:100%; font-size:13px;">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Product Id</th>
                            <th>Barcode</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');

<script>
$('.barcodetxt').bind("enterKey",function(e){
    $(".itemstatusform").submit();
});


$(function () {
    $('.select2').select2()
})


$(document).ready(function() {
    $('#example12').DataTable({
        processing: false,
        serverSide: true,
        responsive: true,
        ajax: '/getdamageitem',
        columns: [
            { data: 'id', name: 'id' },
            {  data: 'productid', name: 'productid' },
            {  data: 'barcode', name: 'barcode' },
            { data: 'itemstatus', 
              render: function(data) { 
                if(data==0) {
                  return '<span class="badge badge-warning">Not Used</span>' 
                }
                else if(data==1){
                  return ' <span class="badge badge-success">Used</span>'
                }
                else{
                    return ' <span class="badge badge-danger">Damage</span>'
                }},
              defaultContent: '<span class="badge badge-warning">Not Used</span>'
              ,orderable: false, searchable: false}
        ]
    });


} );
</script>
<script>

 $('.itemstatusform').on('submit', function(event){
    let ele = this;
        event.preventDefault();
        var form_data = $(this).serialize();
        $.ajax({
            url:"/senddamageitem",
            method:"POST",
            data:form_data,
            dataType:"json",      
            success: function (data, code, ex) {
                toastr.success('It was successfully!')
                $('#example12').DataTable().ajax.reload();
                $('input[name=waybill').val('');
                $('input[name=waybill').focus();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                swal("Warning", "Unable to Process your request", "error");
            },
            
        })
    });
</script>
