@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Reshedule/Fail Orders</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Reshedule/Fail Orders</li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table id="reqtable" data-page-length='50' class="table table-bordered" style="width:100%; font-size:12px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Reseller</th>
                            <th>Delivery Service</th>
                            <th>Date</th>
                            <!-- <th>Call Center</th> -->
                            <th>Product</th>
                            <th>Phone</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 

  <div class="modal fade" id="editordermodel" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title">Update Reshedule Details</h4>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              
            </div>
            
            <form method="post" enctype="multipart/form-data" id="colombostupdate">
            {{csrf_field()}}
                <div class="modal-body">
                <input type="hidden" id="id" name="id">
                
                <div class="form-group">
                    <label for="">Delivery Date :</label>                        
                        <div class="input-group date" id="reservationdate" data-target-input="nearest">
                            <input type="text" class="form-control datetimepicker-input" value="" id="delivery_date" name="delivery_date" data-target="#reservationdate"/  required>
                            <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                </div>
                <div class="form-group">
                  <label>Note</label>
                  <textarea type="text" placeholder="" value="" id="note" rows="2" name="note" class="form-control" required></textarea>
              </div>
                </div>
           
            <div class="modal-footer">
            <input type="submit" name="btnform1" id="action" class="btn btn-primary right" value="Submit"/>
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
          </div>
          
        </div>

</div>

  @include('dashboard.include.footer');

<script>
  $('#reservationdate').datetimepicker({
    format: 'YYYY/MM/DD'
    });

    $('#editordermodel').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal

var id = button.data('id') 
var note1 = button.data('date') 
var note = button.data('note') 
var modal = $(this)

modal.find('.modal-body #id').val(id)
modal.find('.modal-body #delivery_date').val(note1)
modal.find('.modal-body #note').val(note)




})

$(document).ready(function() {
  var table = $('#reqtable').DataTable({
        "ajax": {   "url": '/faildata',
                    "type": 'GET',
        },
        order: [[2, 'asc']],
        columns: [
            { data: 'id', name: 'id' },
            { data: 'pagename', name: 'pagename' },
            { data: 'delservice', name: 'delservice' },
            { data: 'deliverydate', name: 'deliverydate'},
            // { data: 'username', name: 'username' },
            { data: 'productname', name: 'productname' },
            { data: 'phone', name: 'phone'},
            { data: 'deliverystatus', 
              render: function(data) { 
                if(data==30) {
                  return '<span class="badge badge-primary">Reshedule Orders</span>' 
                }
                else if(data==46){
                  return '<span class="badge badge-danger">Fail to delivery</span>'
                }
                },
              defaultContent: '<span class="badge badge-warning">Other</span>'
            },
            { data: 'action', name: 'action', orderable: false, searchable: false}
        ],
    });
} );

$(document).on('click', '.resetlockscreen', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    $.ajax({
        url: "{{url('/resetlock')}}/"+id ,
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'JSON',
        data:{
            "id":id
        },
        success: function (result, code, ex) {
            // swal("Done!", "It was successfully deleted!", "success");
            // $(ele).closest('tr').hide();
            toastr.success('Lock Order Reset successfully')
            $('#reqtable').DataTable().ajax.reload();
            // location.reload();
        },
        error: function (jqXHR, textStatus, errorThrown) {
            swal("Warning", "Unable to Process your request", "error");
        },
    });

});


$(document).on('click', '.approvelbtn', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    console.log(id);

                swal({
                title: "Are you sure?",
                text: "Are you Sure to Approvel this Order",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Approvel it!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "{{url('/failorderapprovel')}}/"+id ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            data:{
                                "id":id
                            },
                            success: function (result, code, ex) {
                                // swal("Done!", "It was successfully deleted!", "success");
                                // $(ele).closest('tr').hide();
                                toastr.success('It was successfully Approvel!')
                                $('#reqtable').DataTable().ajax.reload();
                                // $("#here").load(location.href + " #here");
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "Not Approved", "error");
                }
            })
});


$(document).on('click', '.Reshedulebtn', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    console.log(id);

                swal({
                title: "Are you sure?",
                text: "Are you Sure to Approvel this Order",
                icon: "warning",
                showCancelButton: true,
    confirmButtonColor: '#3085d6',
    cancelButtonColor: '#d33',
    confirmButtonText: 'Yes, Approvel it!',
                dangerMode: true,
            }).then(function(isConfirm) {
                
                if (isConfirm.value===true) {

                        $.ajax({
                            url: "{{url('/reshedulapprovel')}}/"+id ,
                            method: "POST",
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            },
                            cache: false,
                            contentType: false,
                            processData: false,
                            dataType: 'JSON',
                            data:{
                                "id":id
                            },
                            success: function (result, code, ex) {
                                // swal("Done!", "It was successfully deleted!", "success");
                                // $(ele).closest('tr').hide();
                                toastr.success('It was successfully Approvel!')
                                $('#reqtable').DataTable().ajax.reload();
                                // $("#here").load(location.href + " #here");
                            },
                            error: function (jqXHR, textStatus, errorThrown) {
                                swal("Warning", "Unable to Process your request", "error");
                            },
                        });

                } else {
                    swal("Cancelled", "Not Approved", "error");
                }
            })
});



$('#colombostupdate').on('submit', function(event){
    let ele = this;
        event.preventDefault();
        var form_data = $(this).serialize();
        $.ajax({
            url:"/updatereshedule",
            method:"POST",
            data:form_data,
            dataType:"json",      
            success: function (result, code, ex) {
                // swal("Done!", "It was successfully!", "success");
                $("#editordermodel").modal('hide');  
                toastr.success('Your work has been saved!')
                $('#reqtable').DataTable().ajax.reload();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                swal("Warning", "Unable to Process your request", "error");
            },
            
        })
    });
</script>