@include('dashboard.include.header')

  
  <div class="content-wrapper" style="">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Pending Orders</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Pending Orders<a href="/checkviewpending">!</a></li>
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">

      <div class="card">
        <div class="card-body">
        <form method="post" id="formFilter" class="formFilter">
          {{csrf_field()}}
          <div class="row">
            <div class="col-md-4">
              <div class="form-group">
                <label>Filter Orders by Reseller Name</label>
                <select class="form-control" name="resellerid" id="resellerid" style="width: 100%;" required>
                    <option value="" selected="selected" disabled>Select</option>
                    <option value="all" selected>All</option>
                    @foreach($userd as $userdata)
                    <option value="{{$userdata->id}}">{{$userdata->companyname}}</option>
                    @endforeach
                </select>
            </div>
            </div>
          </div>
          </form>
        </div>
      </div>



      <div class="card">
        <div class="card-body">
          <div class="row">
            <div class="col-md-12">
                <table data-page-length='500' id="example12" class="table table-striped table-hover" style="width:100%; font-size:12px;">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Reseller</th>
                            <th>Name</th>
                            <th>Address</th>
                            <th>City</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                </table>
            </div>
          </div>
          </div>
        </div>

      </div>
    </section>
  </div>
 



  @include('dashboard.include.footer');



<script>
    $('#resellerid').change(function() {
      $('#example12').DataTable().ajax.reload();
    });

$(document).ready(function() {
  var table = $('#example12').DataTable({
        "ajax": {   "url": '/pendinglockajex',
                    "type": 'POST',
                    "data": function ( d ) {
                    return $('.formFilter').serialize();
                    }
        },
        columns: [
            { data: 'id', name: 'id' },
            { data: 'pageName', name: 'pageName' },
            { data: 'name', name: 'name' },
            { data: 'address', name: 'address'},
            { data: 'citydata', name: 'citydata'},
            { data: 'action', name: 'action', orderable: false, searchable: false}
        ],
    });
} );


// setInterval(function(){
//   $('#example12').DataTable().ajax.reload();
// }, 20000);


$(document).on('click', '.outconfirm', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    $.ajax({
        url: "{{url('/outconfirmpending')}}/"+id ,
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'JSON',
        data:{
            "id":id
        },
        success: function (data) {
          jQuery.each(data, function(key,value){
                    if(value=="2"){
                        swal({
                            title: "Invoice ID "+id,
                            text: "This order has been send to out Of stock tab",
                            icon: "error",
                            button: "OK",
                        });
                        $('#example12').DataTable().ajax.reload();
                    }
                    else{
                      toastr.success('Out Order Confirm successfully')
                      $('#example12').DataTable().ajax.reload();
                    }
        });

        },
        error: function (jqXHR, textStatus, errorThrown) {
            swal("Warning", "Unable to Process your request", "error");
        },
    });

});

$(document).on('click', '.colomboconfirm', function (e) {
    e.preventDefault();
    var id = $(this).data('id');
    let ele = this;
    $.ajax({
        url: "{{url('/colomboconfirmpending')}}/"+id ,
        method: "POST",
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        cache: false,
        contentType: false,
        processData: false,
        dataType: 'JSON',
        data:{
            "id":id
        },
        success: function (data) {
          jQuery.each(data, function(key,value){
                    if(value=="2"){
                        swal({
                            title: "Invoice ID "+id,
                            text: "This order has been send to out Of stock tab",
                            icon: "error",
                            button: "OK",
                        });
                        $('#example12').DataTable().ajax.reload();
                    }
                    else{
                      toastr.success('Colombo Order Confirm successfully')
                      $('#example12').DataTable().ajax.reload();
                    }
        });

        },
        error: function (jqXHR, textStatus, errorThrown) {
            swal("Warning", "Unable to Process your request", "error");
        },
    });

});

</script>








