@include('dashboard.include.header')

  
  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1 class="m-0">Assign Orders</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <!-- <li class="breadcrumb-item"><a href="/home">Home</a></li>
              <li class="breadcrumb-item active">Delivery Status Change</li> -->
            </ol>
          </div>
        </div>
      </div>
    </div>
   
    <section class="content">
      <div class="container-fluid">
      <div class="card">
        <div class="card-body">
          <div class="row">
          <div class="col-md-12">
                <table id="example12" data-page-length='50' class="table table-bordered" style="width:100%; font-size:12px;">
                    <thead>
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Delivery Date</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>COD</th>
                            <th>Note</th>
                            <th>Status</th>
                            <th>Print</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    @foreach($item as $data)
                        <tr>
                            <td>{{$data->id}}</td>
                            <td>{{$data->name}}</td>
                            <td>
                            @if($data->deliverydate==$ldate)
                            <span class="badge badge-info">Today</span>
                            @else
                            {{$data->deliverydate}}
                            @endif
                            </td>
                            <td>{{$data->address}}</td>
                            <td><a href="tel:{{$data->phone}}">{{$data->phone}}</a>/<a href="tel:{{$data->secondaryphone}}">{{$data->secondaryphone}}</a></td>
                            <td>
                            @foreach($data->cus_or as $pro)
                            {{$pro->qty}} <b>*</b> {{ $pro->orders->pro_name }},
                            @endforeach
                            </td>
                            <td>{{$data->cod}}</td>
                            <td>{{$data->note}}</td>
                            <td class="text-center">
                            @if($data->deliverystatus=='0')
                            <span class="badge badge-warning">Not Delivery</span>
                            @elseif($data->deliverystatus=='1')
                            <span class="badge badge-success">Delivered</span>
                            @elseif($data->deliverystatus=='21')
                            <span class="badge badge-warning">Not Delivery</span>
                            @endif
                            </td>
                            <td>
                            @if($data->print=="0")
                            <span class="badge badge-warning">Not Print</span>
                            @else
                            <span class="badge badge-success">Printed</span>
                            @endif
                            </td>
                            <td class="text-center">    
                            <form method="post" action="/riderconfirmpost">
                            {{csrf_field()}}
                            <input type="hidden" name="id" value="{{$data->id}}">
                            <button type="submit" id="submit" data-id="{{$data->id}}"  onclick="return confirmation();" class="btn btn-success btn-xs">Confirm</button>
                            </form>
                            
                            <button type="button" data-id="{{$data->id}}" data-date="{{$data->deliverydate}}" data-rider="{{$data->ridername}}" data-status="{{$data->deliverystatus}}"  class="btn btn-warning btn-xs" data-toggle="modal" data-target="#editmodeldate">Date</button>
                            &nbsp;
                            <button type="button" data-id="{{$data->id}}" data-date="{{$data->deliverydate}}" data-rider="{{$data->ridername}}" data-note="{{$data->note}}" data-status="{{$data->deliverystatus}}"  class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodel">Update</button>
                            </td>
                            
                        </tr>
                    @endforeach 
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Delivery Date</th>
                            <th>Address</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>COD</th>
                            <th>Note</th>
                            <th>Status</th>
                            <th>Print</th>
                            <th>Action</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
          </div>
          </div>
        </div>
      </div>
    </section>
  </div>

    <div class="modal fade" id="editmodeldate" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title">Update Delivery Details</h4>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              
            </div>
            
            <form method="post" enctype="multipart/form-data" action="/riderdeliverydate">
            {{csrf_field()}}
                <div class="modal-body">
                <input type="hidden" id="id1" name="id">

              <div class="form-group">
                    <label for="">Delivery Date :</label>                        
                        <div class="input-group date" id="reservationdate" data-target-input="nearest">
                            <input type="text" class="form-control datetimepicker-input" value="" id="delivery_date" name="delivery_date" data-target="#reservationdate"/  required>
                            <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                </div>

                </div>
           
            <div class="modal-footer">
            <input type="submit" name="btnform1" id="action" class="btn btn-primary right" value="Submit"/>
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
          </div>
          
        </div>

</div>


 
  <div class="modal fade" id="editordermodel" role="dialog">
        <div class="modal-dialog">
        
          <!-- Modal content-->
          <div class="modal-content">
            <div class="modal-header">
                    <h4 class="modal-title">Update Delivery Details</h4>
              <button type="button" class="close" data-dismiss="modal">&times;</button>
              
            </div>
            
            <form method="post" enctype="multipart/form-data" action="/riderdeliveryupdate">
            {{csrf_field()}}
                <div class="modal-body">
                <input type="hidden" id="id" name="id">
                <div class="form-group">
                    <label>Assign Rider</label>
                        <select class="form-control" name="deliveryrid" id="deliveryrid" required>
                            @foreach($delise as $data)
                            @if($data->type=="Delivery_Guy")
                            <option value="{{ $data->id }}">{{ $data->name }}</option>
                            @endif
                            @endforeach
                        </select>
                </div>
                <div class="form-group">
                    <label>Order Status</label>
                        <select class="form-control" name="statusdelauth" id="statusdelauth" required>
                            <option value="12">Assign Rider</option>
                            <option value="41">Cancel Request</option>
                            <option value="42">Phone off Request</option>
                            <option value="43">No Answer Request</option>
                            <option value="44">Out of Stock</option>
                            <option value="21">Not Delivery</option>
                            <!-- <option value="18">Delivered</option> -->
                            <option value="45">Out Confirm</option>
                        </select>
                </div>
                <div class="form-group">
                  <label>Reason</label>
                  <textarea type="text" placeholder="" value="" id="note" rows="2" name="note" class="form-control" required></textarea>
              </div>

                </div>
           
            <div class="modal-footer">
            <input type="submit" name="btnform1" id="action" class="btn btn-primary right" value="Submit"/>
              <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
            </form>
          </div>
          
        </div>

</div>



  @include('dashboard.include.footer')

<script>
$(function () {
    $("#example12").DataTable({
      "responsive": true, "lengthChange": true, "autoWidth": false,"order": [[ 7, "asc" ]],
      "buttons": ["colvis"]
    }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
  });

$('#reservationdate').datetimepicker({
    format: 'YYYY/MM/DD'
    });

</script>

<script>

$('#editmodeldate').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal

var id = button.data('id') 
var date = button.data('date') 

var modal = $(this)

modal.find('.modal-body #id1').val(id)
modal.find('.modal-body #delivery_date').val(date)




})


$('#editordermodel').on('show.bs.modal', function (event) {

var button = $(event.relatedTarget) // Button that triggered the modal

var id = button.data('id') 
var status = button.data('status') 
var note1 = button.data('note') 
var date = button.data('date') 
var rider = button.data('rider') 
var modal = $(this)

modal.find('.modal-body #id').val(id)
// modal.find('.modal-body #note').val(note1)
modal.find('.modal-body #delivery_date').val(date)
$("#statusdelauth").val(status).change();
$("#deliveryrid").val(rider).change();

})
</script>

<script type="text/javascript">
 
 function confirmation(){
    if(confirm('Do you want to confirm order?')){
        document.getElementById('delete-form').submit();
    }else{
        return false;
    }   
}
</script>