<?php

namespace App\Http\Controllers;

use Session;
use Illuminate\Http\Request;
use App\orders;
use App\orderItem;
use App\attribute;
use App\cart;
use Response;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use App\customer;
use App\cus_orders;
use App\pages;
use App\User;
use App\productdata;
use App\resellerdetails;
use DataTables;
use Config;
use DB;
use Auth;
use File;
use Illuminate\Support\Facades\Validator;
use Charts;
use Excel;
use PDF;
use App;
use ImageResize;
use Hash;
use Mail;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Str;
use Webpatser\Uuid\Uuid;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;

class frontendcontroller extends Controller
{
    
    public function home(){
        return view('about');

    }
    public function index2(){
        return view('front/index');

    }
    public function sellerregister(Request $request){
        $redate= date('Y-m-d H:i:s');
    
        $image13 = $request->file('img1');  $input['imagename13'] = $image13->getFilename().'.'.$image13->extension();
        $destinationPath13  = public_path('uploads/');  $img13 = Image::make($image13->path());
        $img13->resize(600, 500, function ($constraint) {$constraint->aspectRatio();})->save($destinationPath13.$input['imagename13']);
      
    
        $data = new resellerdetails();
        try{
        $check = resellerdetails::where('phone',$request->phone)->first();
        $emc = User::where('email',$request->email)->first();

        if($emc != null){
            return redirect('/')->with('success', 'This email is already Used');
        }
        else if($check != null){
            return redirect('/')->with('success', 'This phone number is already Used');

        }
        else{
            $data->companyname = $request->company;
            $data->address = $request->address;
            $data->phone = $request->phone;
            $data->service = 0;
            $data->inventory = 0;
            $data->date = $redate;
            $data->image = $input['imagename13'];
            $data->save();
    
            $duser = new User;
            $duser->name=$request->name;
            $duser->email=$request->email;
            $duser->password=bcrypt($request->password);
            $duser->type="Reseller";
            $duser->resellerid=$data->id;
            $duser->save();
        
            return redirect('/')->with('success', 'Congratulations, Your Account Has Been Successfully Created!');
        }

            }
        catch (Exception $ex){
            return redirect('/')->with('error', 'Error : '.$ex->getMessage());
        }
    }


    public function addProduct(Request $request){
        // dd($request->all());
        $additem=new orderItem;
        $additem->name=$request->name;
        $additem->item_code=$request->code;
        $additem->sell_price=$request->price;
        $additem->cost_price=$request->cost;
        $additem->stock=$request->stock;
        $additem->save();
        return redirect()->back();
    }

    // public function index(){
    //     $itemsall = orderItem::with('attributes')->paginate(8);
    //     $cart = cart::where('session_id',Session::getId())->get();
    //     return view('frontview/home',['itemall'=>$itemsall, 'cart'=>$cart]);

    // }

    // public function index(){
    //     return view('comming');
    // }

    public function index(Request $request){

        $itemall = orderItem::with('attributes')->where('visible', '=', 'yes')->paginate(8);
        $cart = cart::where('session_id',Session::getId())->get();

        if ($request->ajax()) {
    		$view = view('frontview/products',['itemall'=>$itemall])->render();
            return response()->json(['html'=>$view]);
        }

        return view('frontview/home',['itemall'=>$itemall, 'cart'=>$cart]);

    }


    public function addtocart(Request $request, $id){

        if(empty($id)){
            return  Response::json(['status' => false,'message'=>'product ID not Found '], 423);
        }        
        else{ 

        $finddata = cart::where('session_id',Session::getId())->where('Product_id',$id)->get();

        if(!$finddata->isEmpty()){
                $qty=0;
                $getid=0;
                foreach($finddata as $item) {
                    $qty =($item->qty)+1;
                    $getid=($item->id);
                }
                $addqty = cart::find($getid);
                $addqty->qty=$qty;
                $addqty->save();
                return  Response::json(['status' => 'success'], 200);
        }
        else{
            $additem=new cart;

            $additem->session_id=Session::getId();
            $additem->Product_id=$id;
            $additem->qty='1';
            $additem->delivery='0';
            $additem->attribute='null';
            $additem->save();
            return  Response::json(['status' => 'success'], 200);
        }
    }
    }

    public function getProductAttr($id){
        $attr = attribute::where('proid',$id)->get();
        return Response::json(['data' => $attr], 200);

    }

    public function addtocartpostatrr(Request $request){

    $att = json_encode($request->product_properties);

    $additem=new cart;
    if(empty($request->id)){
        return  Response::json(['status' => false,'message'=>'product ID not Found '], 423);
    }   
    else{ 
        $finddata = cart::where('session_id',Session::getId())->where('Product_id',$request->id)->get();

        if(!$finddata->isEmpty()){
                $qty=0;
                $getid=0;
                foreach($finddata as $item) {
                    $qty =($item->qty)+1;
                    $getid=($item->id);
                }
                $addqty = cart::find($getid);
                $addqty->qty=$qty;
                $addqty->save();
                return  Response::json(['status' => 'success'], 200);
        }
        else{       
            $additem->session_id=Session::getId();
            $additem->Product_id=$request->id;
            $additem->qty='1';
            $additem->delivery='0';
            $additem->attribute=$att;
            $additem->save();
            return  Response::json(['status' => 'success'], 200);
    }  
 } 
}  

public function cartdataget(){
    $cart = cart::with('cartData')->where('session_id',Session::getId())->get();
    $cartCount = cart::where('session_id',Session::getId())->count();
    return  Response::json(['cart'=>$cart,'cartCount'=>$cartCount], 200);

}
public function viewcart(){
    $cart = cart::where('session_id',Session::getId())->get();
    $cartCount = cart::where('session_id',Session::getId())->count();
    return view('frontview/cart',['cartCount'=>$cartCount, 'cart'=>$cart]);

}

public function deletecartitem(Request $request, $id){
    $data = cart::find($id);
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        $data->delete();
        return  Response::json(['status' => $data], 200);
   }
}

public function qtychange(Request $request, $id){
    $data = cart::find($id);
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        $data->qty=$request['get_qty'];
        $data->save();
        return  Response::json(['status' => $data], 200);
   }
}
public function viewcartmain(){
    $cart = cart::where('session_id',Session::getId())->get();
    $cartCount = cart::where('session_id',Session::getId())->count();
    return view('frontview/cart',['cartCount'=>$cartCount, 'cart'=>$cart]);

}

public function checkout(){
    $cart = cart::where('session_id',Session::getId())->get();
    $cartCount = cart::where('session_id',Session::getId())->count();
    return view('frontview/checkout',['cartCount'=>$cartCount, 'cart'=>$cart]);

}

public function postwebcusomer(Request $request){
    $additem=new customer;

    $lastValue = DB::table('customers')->orderBy('id', 'desc')->first();
    $uniqid = ($lastValue->id)+1;

    Session::put('abc', $uniqid);
    $add = $request['address'].', '.$request['distric'];   

    if($request->name == null){
        return  Response::json(['status' => false,'message'=>'can not proccess'], 423);
    }        
    else{        
        if($request['distric']=="Colombo"){
            $cart = cart::where('session_id',Session::getId())->first();
            $cart->delivery='200';
            $cart->save();

            $additem->id=$uniqid;
            $additem->user='web-customer';
            $additem->pageName='1';
            $additem->name=$request['name'];
            $additem->address=$add;
            $additem->phone=$request['phonenumber'];
            $additem->status='0';
            $additem->tracking=' ';
            $additem->note=' ';
            $additem->print='0';
            $additem->cod='0';
            $additem->save();
            return  Response::json(['status' => 'success'], 200);
        }
        else{
            $cart = cart::where('session_id',Session::getId())->first();
            $cart->delivery='300';
            $cart->save();

            $additem->id=$uniqid;
            $additem->user='web-customer';
            $additem->pageName='1';
            $additem->name=$request['name'];
            $additem->address=$add;
            $additem->phone=$request['phonenumber'];
            $additem->status='0';
            $additem->tracking=' ';
            $additem->note=' ';
            $additem->print='0';
            $additem->cod='0';
            $additem->save();
            return  Response::json(['status' => 'success'], 200);
        }
    }    
}
public function checkout2(){
    $cart = cart::where('session_id',Session::getId())->get();
    $cartCount = cart::where('session_id',Session::getId())->count();
    $unit=0;
    $tot=0;
    $deli=0;
    foreach($cart as $item) {
        $deli +=$item->delivery;
        $unit = ($item->cartData->sell_price)*($item->qty);
        $tot += $unit;

    }
    return view('frontview/checkout2',['cartCount'=>$cartCount, 'cart'=>$cart, 'subtot'=>$tot, 'deli'=>$deli]);

}

public function webcustomeritems(Request $request){  
     
    $value = Session::get('abc');
    $additem=new cus_orders;

    if($request->name = null){
        return  Response::json(['status' => false,'message'=>'can not proccess'], 423);
    } 
    else{       

        $qrcodes = cart::where('session_id',Session::getId())->get()->map(function($qrcode) use ($value) {
            $ret = [
                'item_id' => $qrcode->Product_id,
                'cus_id' => $value,
                'attribute' => $qrcode->attribute,
                'qty' => $qrcode->qty,
                'delivery' => $qrcode->delivery
            ];
            $qrcode->delete();
            return $ret;
        });

        cus_orders::insert($qrcodes->all());

    return  Response::json(['status' => 'success'], 200);

}
}

public function productdetails($slug){
    $items = orderItem::where('slug', $slug)->get();
    foreach($items as $iteamID){
        $att = attribute::where('proid', $iteamID->id)->get();
        $des = productdata::where('product_id', $iteamID->id)->get();
    }


    return view('frontview/productdetail',['details'=>$items, 'attri'=>$att, 'des'=>$des]);

}

public function addtocartprodetails(Request $request){
    $att = json_encode($request['product_properties']);

    $additem=new cart;
    if(empty($request['pro_id'])){
        return  Response::json(['status' => false,'message'=>'product ID not Found'], 423);
    }        
    else{   
        $finddata = cart::where('session_id',Session::getId())->where('Product_id',$request['pro_id'])->get();

        if(!$finddata->isEmpty()){
                $qty=0;
                $getid=0;
                $tot=0;
                foreach($finddata as $item) {
                    $qty =($item->qty);
                    $getid=($item->id);
                }
                $tot=$qty+$request['num-product'];

                $addqty = cart::find($getid);
                $addqty->qty=$tot;
                $addqty->save();
                return  Response::json(['status' => 'success'], 200);
        }
        else{
        
        $additem->session_id=Session::getId();
        $additem->Product_id=$request['pro_id'];
        $additem->qty=$request['num-product'];
        $additem->delivery='0';
        $additem->attribute=$att;
        $additem->save();
        return  Response::json(['status' => 'success'], 200);
    }
    }    
} 
 
}



