<?php

namespace App\Http\Controllers;
use Session;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use App\orderItem;
use App\customer;
use App\cus_orders;
use App\pages;
use App\User;
use App\attribute;
use App\productdata;
use App\resellerdetails;
use App\resellerbank;
use App\purchasing;
use App\productbarcode;
use App\deliveryservice;
use App\trackingrange;
use App\dispatchsummary;
use App\purchesproduct;
use App\ordersbarcode;
use App\citylist;
use App\tempriderbarcode;
use App\courierrecivemoney;
use App\wholesalecustomer;
use App\wholesale;
use App\wholesalebuyproduct;
use App\statustrack;
use App\wholesalebarcode;
use App\companybank;
use App\banktransaction;
use App\salarytable;
use App\accountoption;
use App\wholesalepayemet;
use App\supplierpayment;
use App\bannedcustomers;
use App\branch;
use App\sellerproduct;
use App\fardarcitylist;
use App\notice;
use App\resellerpayment;
use App\trancecity;
use App\bulktemporders;
use App\commission;
use App\advance;
use Charts;
use DataTables;
use Config;
use DB;
use Auth;
use File;
use Illuminate\Support\Facades\Validator;
use Response;
use Excel;
use PDF;
use App;
use ImageResize;
use Hash;
use Mail;
use Intervention\Image\ImageManagerStatic as Image;
use Illuminate\Support\Str;
use Webpatser\Uuid\Uuid;
use Carbon\Carbon;
use Illuminate\Support\Facades\Crypt;

class HomeController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){

        if(Auth::user()->type=="Delivery_Guy"){
            return redirect('/deliverystatus');
        }
        else if(Auth::user()->type=="Reseller" OR Auth::user()->type=="User"){
            return redirect('/resellerdash');

        }
        else {

        $ldate1 = date('Y-m-d');
        $ldate2 = date('Y-m');
        $da= $ldate1.' 00:00:00';
        $da2= $ldate1.' 23:59:59';
        $ldaco = date('Y/m/d');
        $today = $ldaco.' - '.$ldaco;

        $pending = customer::where('status', 17)->count();
        // $colombo = customer::wherein('status', [5,12,14,8])->where('companydelivery',1)->whereBetween('created_at',[$da,$da2])->get()->count();
        // $out = customer::wherein('status', [6,11,13,15,8])->where('companydelivery',0)->whereBetween('created_at',[$da,$da2])->get()->count();
        // $dispatched = customer::where('status', 8)->whereBetween('updated_at',[$da,$da2])->get()->count();
        $delivered = customer::where('status', 18)->whereBetween('updated_at',[$da,$da2])->count();
        $moneyre = customer::where('status', 9)->whereBetween('updated_at',[$da,$da2])->count();
        $paid = customer::where('status', 33)->whereBetween('updated_at',[$da,$da2])->count();

        $confirm = statustrack::wherein('orderstatus', [6,5])->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->count();
        $print = statustrack::wherein('orderstatus', [13,14])->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->count();
        $pack = statustrack::where('orderstatus', 15)->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->count();
        $dispa = statustrack::where('orderstatus', 8)->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->count();
        $return = statustrack::where('orderstatus', 7)->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->count();

        $money = customer::wherein('status', [5,6,11,12,13,14,15,8])->whereBetween('updated_at',[$da,$da2])->get();
        $tot =0;
        foreach($money as $modata){
            $tot+=$modata->cod;
        }
        $colombo = statustrack::wherein('orderstatus', [5])->whereBetween('created_at',[$da,$da2])->count();
        $out = statustrack::wherein('orderstatus', [6])->whereBetween('created_at',[$da,$da2])->count();
        $dispatched = statustrack::where('orderstatus', 8)->whereBetween('created_at',[$da,$da2])->count();
        

        $toddate = date('Y-m-d');
        $notice = notice::where('sdate','<=',$toddate)->where('edate','>=',$toddate)->get();

        return view('dashboard/index')->with(['tot'=>$tot,'confirm'=>$confirm,'print'=>$print,'pack'=>$pack,'dispa'=>$dispa,'return'=>$return,
        'delivered'=>$delivered,'moneyre'=>$moneyre,'paid'=>$paid,'pending'=>$pending,'colombo'=>$colombo,'out'=>$out,'dispatched'=>$dispatched,'today'=>$today,'notice'=>$notice]);
    }
    }


    public function resellerdash(){

        $newDateTime = Carbon::now()->subDays(7);
        $edate=$newDateTime->toDateTimeString();
        $resedata = resellerdetails::where('id',Auth::user()->resellerid)->where('date','>=',$edate)->first();

        if($resedata == null){
            $rdata = resellerdetails::find(Auth::user()->resellerid);
            $rdata->inventory = 0;
            $rdata->save();
        }

        $ldate1 = date('Y-m-d');
        $ldate2 = date('Y-m');
        $da= $ldate1.' 00:00:00';
        $da2= $ldate1.' 23:59:59';
        $ldaco = date('Y/m/d');
        $today = $ldaco.' - '.$ldaco;

        $check = customer::where('status', 0)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $pending = customer::where('status', 1)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $attemp1st = customer::where('status', 2)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $attemp2st = customer::where('status', 3)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $attemp3st = customer::where('status', 4)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $hold = customer::wherein('status', [16,32,10])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $procces = customer::wherein('status', [17,5,6,11,12,13,14,15,8,30,9,18,33,7,34,35,36,37])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $dispatc = customer::where('status', 8)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $delivered = customer::wherein('status', [18,9])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $recived = customer::where('status', 33)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $return = customer::wherein('status', [7,34,35,36])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $duplicate = customer::where('status', 37)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $total = customer::where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();

        $toddate = date('Y-m-d');
        $notice = notice::where('sdate','<=',$toddate)->where('edate','>=',$toddate)->get();

        $ordersmo = customer::where(DB::raw("(DATE_FORMAT(created_at,'%Y'))"),date('Y'))->where('user', Auth::user()->resellerid)->where('status',33)->get();
        $chart2 = Charts::database($ordersmo, 'bar', 'highcharts')->title("Monthly Delivered Orders") ->elementLabel("Total Orders")->dimensions(1000, 500)->responsive(true)->groupByMonth(date('Y'), true);
 

        return view('dashboard/resellerdash',compact('chart2'))->with(['duplicate'=>$duplicate,'procces'=>$procces,'dispatc'=>$dispatc,'delivered'=>$delivered,'recived'=>$recived,'check'=>$check,
        'pending'=>$pending,'attemp1st'=>$attemp1st,'attemp2st'=>$attemp2st,'attemp3st'=>$attemp3st,'hold'=>$hold,'return'=>$return,'total'=>$total,
        'today'=>$today,'notice'=>$notice]);
    }

    public function resellerdashfilter(Request $request){

        $newDateTime = Carbon::now()->subDays(7);
        $edate=$newDateTime->toDateTimeString();
        $resedata = resellerdetails::where('id',Auth::user()->resellerid)->where('date','>=',$edate)->first();

        if($resedata == null){
            $rdata = resellerdetails::find(Auth::user()->resellerid);
            $rdata->inventory = 0;
            $rdata->save();
        }
        list($da1, $da222) = explode('-', $request->daterange);
      
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';
        $ldate1 = date('Y-m-d');
        $ldate2 = date('Y-m');
        $ldaco = date('Y/m/d');
        $today = $ldaco.' - '.$ldaco;

        $check = customer::where('status', 0)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $pending = customer::where('status', 1)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $attemp1st = customer::where('status', 2)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $attemp2st = customer::where('status', 3)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $attemp3st = customer::where('status', 4)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $hold = customer::wherein('status', [16,32,10,26,27,28,19,21,22,23])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $procces = customer::wherein('status', [17,5,6,11,12,13,14,15,8,30,9,18,33,7,34,35,36,37])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $dispatc = customer::where('status', 8)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $delivered = customer::wherein('status', [18,9])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $recived = customer::where('status', 33)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $return = customer::wherein('status', [7,34,35,36])->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $duplicate = customer::where('status', 37)->where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $total = customer::where('user', Auth::user()->resellerid)->whereBetween('created_at',[$da,$da2])->count();
        $toddate = date('Y-m-d');
        $notice = notice::where('sdate','<=',$toddate)->where('edate','>=',$toddate)->get();

        $ordersmo = customer::where(DB::raw("(DATE_FORMAT(created_at,'%Y'))"),date('Y'))->where('user', Auth::user()->resellerid)->where('status',33)->get();
        $chart2 = Charts::database($ordersmo, 'bar', 'highcharts')->title("Monthly Delivered Orders") ->elementLabel("Total Orders")->dimensions(1000, 500)->responsive(true)->groupByMonth(date('Y'), true);
 

        return view('dashboard/resellerdash',compact('chart2'))->with(['duplicate'=>$duplicate,'procces'=>$procces,'dispatc'=>$dispatc,'delivered'=>$delivered,'recived'=>$recived,'check'=>$check,
        'pending'=>$pending,'attemp1st'=>$attemp1st,'attemp2st'=>$attemp2st,'attemp3st'=>$attemp3st,'hold'=>$hold,'return'=>$return,'total'=>$total,
        'today'=>$request->daterange,'notice'=>$notice]);
    }





    public function dashboardfilter(Request $request){
        list($da1, $da222) = explode('-', $request->daterange);
      
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';

        $firstDay = Carbon::now()->startOfMonth()->toDateString();
        $lastDay = Carbon::now()->endOfMonth()->toDateString();
        $mo1= $firstDay.' 00:00:00';
        $mo2= $lastDay.' 23:59:59';
        $ldaco = date('Y/m/d');

        $da11 = str_replace(' ', '', $da1);
        $da22 = str_replace(' ', '', $da222);

        $pending = customer::where('status', 17)->get()->count();
        // $colombo = customer::wherein('status', [5,12,14,8])->where('companydelivery',1)->whereBetween('updated_at',[$da,$da2])->get()->count();
        // $out = customer::wherein('status', [6,11,13,15,8])->where('companydelivery',0)->whereBetween('updated_at',[$da,$da2])->get()->count();
        // $dispatched = customer::where('status', 8)->whereBetween('updated_at',[$da,$da2])->get()->count();
        $delivered = customer::where('status', 18)->whereBetween('updated_at',[$da,$da2])->get()->count();
        $moneyre = customer::where('status', 9)->whereBetween('updated_at',[$da,$da2])->get()->count();
        $paid = customer::where('status', 33)->whereBetween('updated_at',[$da,$da2])->get()->count();

        $confirm = statustrack::wherein('orderstatus', [6,5])->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->get()->count();
        $print = statustrack::wherein('orderstatus', [13,14])->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->get()->count();
        $pack = statustrack::where('orderstatus', 15)->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->get()->count();
        $dispa = statustrack::where('orderstatus', 8)->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->get()->count();
        $return = statustrack::where('orderstatus', 7)->where('username',Auth::user()->name)->whereBetween('created_at',[$da,$da2])->get()->count();

        $money = customer::wherein('status', [5,6,11,12,13,14,15,8])->whereBetween('updated_at',[$da,$da2])->get();
        $tot =0;
        foreach($money as $modata){
            $tot+=$modata->cod;
        }

        $colombo = statustrack::wherein('orderstatus', [5])->whereBetween('created_at',[$da,$da2])->count();
        $out = statustrack::wherein('orderstatus', [6])->whereBetween('created_at',[$da,$da2])->count();
        $dispatched = statustrack::where('orderstatus', 8)->whereBetween('created_at',[$da,$da2])->count();

        $ordersmo = customer::where(DB::raw("(DATE_FORMAT(created_at,'%Y'))"),date('Y'))->where('status',33)->get();

        $chart2 = Charts::database($ordersmo, 'bar', 'highcharts')->title("Monthly Reseller to Paid Orders") ->elementLabel("Total Orders")->dimensions(1000, 500)->responsive(true)->groupByMonth(date('Y'), true);
 
        $getdaydayout =  customer::select(DB::raw("(COUNT(*)) as count"),DB::raw("DAYNAME(updated_at) as dayname"))
        ->whereBetween('updated_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])
       ->whereYear('updated_at', date('Y'))
       ->wherein('status',[8,9,18])->where('deliveryservice','!=','-')->groupBy('dayname')->orderBy('id', 'asc')->get();

       $getdaydacolombo =  customer::select(DB::raw("(COUNT(*)) as count"),DB::raw("DAYNAME(updated_at) as dayname"))
       ->whereBetween('updated_at', [Carbon::now()->startOfWeek(), Carbon::now()->endOfWeek()])
      ->whereYear('updated_at', date('Y'))
      ->wherein('status',[8,9,18])->where('companydelivery','1')->groupBy('dayname')->orderBy('id', 'asc')->get();


       $output = [];
       $da255 = [];
       $dacolombo = [];
       foreach($getdaydayout as $entry) {
           $output[$entry->dayname] = $entry->count;
           $da255[]=$entry->count;
       }
       $getdddd2 = implode(',',$da255);
     
       foreach($getdaydacolombo as $entry) {
        $dacolombo[]=$entry->count;
    }
    $gedacolombo2 = implode(',',$dacolombo);
 
        $weekdaychart = Charts::multi('areaspline', 'highcharts')
        ->title('Orders Dispatched/delivered/Money Received chart')
        ->colors(['#ff0000', '#513b5a'])
        ->labels(['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday','Saturday', 'Sunday'])
        ->dataset('Out', [$getdddd2])
        ->dataset('Colombo',  [$gedacolombo2]);

        $dataor =  customer::select('customers.id','cus_orders.item_id','sellerproducts.pro_name','sellerproducts.seller_id', DB::raw("SUM(cus_orders.qty) as qty"))
        ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
        ->join('sellerproducts', 'sellerproducts.id', '=' , 'cus_orders.item_id');

        $dataor=$dataor->wherein('customers.status', [8,9,33])->whereBetween('customers.updated_at',[$da,$da2])->groupBy('sellerproducts.pro_id')->orderBy('qty', 'DESC')->get();

        $resllerd = resellerdetails::get();

        $toddate = date('Y-m-d');
        $notice = notice::where('sdate','<=',$toddate)->where('edate','>=',$toddate)->get();

        $maindata=[];
        $rate=0;
        $rese = resellerdetails::get();
        foreach($rese as $redata){
            $con = customer::whereIn('status', [17,5,6,11,12,13,14,15,8,30,9,18,33,7,34,35,36,37])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
            $dis = customer::whereIn('status', [8])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
            $ret = customer::whereIn('status', [7,34,35])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
            $mone = customer::whereIn('status', [18,9,33])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
   
            if($mone !=0 AND $ret !=0){
                $rate=(($mone)/($ret+$mone))*100;
            }
            else{
                $rate=0;
            }
            $minudata=['name'=>$redata->companyname,'con'=>$con,'dis'=>$dis,'ret'=>$ret,'mone'=>$mone,'rate'=>$rate];
            array_push($maindata, $minudata);
        }

        return view('dashboard/index1',compact('chart2','weekdaychart'))->with(['maindata'=>$maindata,'dataor'=>$dataor,'tot'=>$tot,'confirm'=>$confirm,'print'=>$print,'pack'=>$pack,'dispa'=>$dispa,'return'=>$return,
        'resllerd'=>$resllerd,'delivered'=>$delivered,'moneyre'=>$moneyre,'paid'=>$paid,'pending'=>$pending,'colombo'=>$colombo,'out'=>$out,'dispatched'=>$dispatched,'today'=>$request->daterange,'notice'=>$notice
]);
    }



//start user
    public function usermange(){
        $items = User::where('resellerid','not')->get();
        return view('dashboard/user/usermange')->with(['item'=>$items]);
    }

    public function userprofile(){
        $items = User::where('id',Auth::user()->id)->get();
        // Auth::user()->name;
        return view('dashboard/user/userprofile')->with(['item'=>$items]);
    }

    public function useredit(){
        $items = User::where('id',Auth::user()->id)->get();
        // Auth::user()->name;
        return view('dashboard/user/useredit')->with(['item'=>$items]);
    }



    public function changePassword(Request $request){

        if (!(Hash::check($request->get('current-password'), Auth::user()->password))) {
            // The passwords matches
            return redirect()->back()->with("error","Your current password does not matches with the password you provided. Please try again.");
        }

        if(strcmp($request->get('current-password'), $request->get('new-password')) == 0){
            //Current password and new password are same
            return redirect()->back()->with("error","New Password cannot be same as your current password. Please choose a different password.");
        }

        $validatedData = $request->validate([
            'current-password' => 'required',
            'new-password' => 'required|string|min:6|confirmed',
        ]);

        //Change Password
        $user = Auth::user();
        $user->password = bcrypt($request->get('new-password'));
        $user->save();

        return redirect()->back()->with("success","Password changed successfully !");

    }

    public function usermangeupdate2(Request $request){
        $data = User::find($request->id);
        try{
            $data->name = $request->username;
            $data->save();
    
            return redirect('/useredit')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/useredit')->with('error', 'Error : '.$ex->getMessage());
            }
    
    }
    
    public function usermangeupdate(Request $request){
    
        $data = User::find($request->id);
        try{
    
            $data->name = $request->name;
            $data->email = $request->email;
            $data->type = $request->type;
            $data->save();
    
            return redirect('/usermange')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/usermange')->with('error', 'Error : '.$ex->getMessage());
            }
    
    }
    
    public function deleteuser(Request $request, $id){
        $data = User::find($id);
        if($data==null){
            return  Response::json(['status' => false], 423);
       }else{
            $data->delete();
            return  Response::json(['status' => $data], 200);
       }
    }
//end user
    // start pages

    public function pageregister(){
        $pages = pages::get();
        $bradata = branch::get();
        return view('dashboard/product/pagereg')->with(['page'=>$pages,'bradata'=>$bradata]);
    }


    public function registerpagepost(Request $request){

        // $cover = $request->file('input_img');
        // $extension = $cover->getClientOriginalExtension();
        // Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));

        $image1 = $request->file('input_img');  $input['imagename1'] = $image1->getFilename().'.'.$image1->extension();
        $destinationPath1  = public_path('uploads/');  $img1 = Image::make($image1->path());
        $img1->resize(600, 500, function ($constraint) {$constraint->aspectRatio();})->save($destinationPath1.$input['imagename1']);


        $data = new pages();
        try{

        $data->pagename = $request->name;
        $data->number = $request->number;
        $data->address = $request->address;
        $data->image = $input['imagename1'];
        $data->branch = $request->branch;
        $data->save();

        return redirect('/pageregister')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/pageregister')->with('error', 'Error : '.$ex->getMessage());
        }
        
    }

    public function updateregisterpagepost(Request $request){

        $cover = $request->file('input_img');
        $data = pages::find($request->id);

        if($cover==null){
            try{

                $data->pagename = $request->name;
                $data->number = $request->number;
                $data->address = $request->address;
                $data->branch = $request->branch;
                $data->save();
        
                return redirect('/pageregister')->with('success', 'Successfully Saved!');
                    }
                catch (Exception $ex){
                    return redirect('/pageregister')->with('error', 'Error : '.$ex->getMessage());
                }
        }
        else{
            try{
                $extension = $cover->getClientOriginalExtension();
                Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));
                
                $data->pagename = $request->name;
                $data->number = $request->number;
                $data->address = $request->address;
                $data->branch = $request->branch;
                $data->image = $cover->getFilename().'.'.$extension;
                $data->save();
        
                return redirect('/pageregister')->with('success', 'Successfully Saved!');
                    }
                catch (Exception $ex){
                    return redirect('/pageregister')->with('error', 'Error : '.$ex->getMessage());
                }
        }   
    }

    public function deletepage(Request $request, $id){
        $data = pages::find($id);
        if($data==null){
            return  Response::json(['status' => false], 423);
       }else{
            $data->delete();
            return  Response::json(['status' => $data], 200);
       }
    }

//end pages

//add product
public function updateProductTemplate(){
    $delise = resellerdetails::get();
    $item = DB::connection('mysql2')->select("select * from order_items WHERE `seller` = 'yes' ");
    return view('dashboard/product/addproduct',['delise'=>$delise,'item'=>$item]);
}

    function getdata()
    {
     $students = orderItem::select('id', 'name', 'sell_price','cost_price','stock','hasattributes','visible');
     return DataTables::of($students)
            ->addColumn('action', function($student){
                $x='';
                if($student->hasattributes=="yes"){$x.='&nbsp;&nbsp;<a class="btn btn-secondary btn-xs" data-id="'.$student->id .'" href="productattribute/'.$student->id.'">Attribute</a>';}
                return '<a href="#" class="btn btn-xs btn-primary edit" id="'.$student->id.'"><i class="far fa-edit"></i> Edit</a>'.
                '&nbsp;&nbsp;<a class="btn btn-dark btn-xs" target="_blank" data-id="'.$student->id .'" href="productdetails/'.$student->id.'"><i class="fas fa-eye"></i></a>'.
                ''.$x.'';
            })
            ->make(true);
    }
    // '&nbsp;&nbsp;<a class="btn btn-danger btn-xs" data-id="'.$student->id .'"  href=""><i class="far fa-trash-alt"></i></a>'.



    public function deleteproduct(Request $request,$id){

        $data = orderItem::find($id);

       if($data==null){
            return  Response::json([
                'status' => false
            ], 423);
       }else{
            $data->delete();
                   return  Response::json([
            'status' => $data
        ], 200);
       }
    }

    function fetchdata(Request $request)
    {
        $id = $request->input('id');
        $student = orderItem::find($id);
        $output = array(
            'name'    =>  $student->name,
            'sell_price'     =>  $student->sell_price,
            'cost_price'     =>  $student->cost_price,
            'stock'     =>  $student->stock,
            'attribu'     =>  $student->hasattributes,
            'image'     =>  $student->image
        );
        echo json_encode($output);
    }


function postdata(Request $request){

    $cover = $request->file('input_img');

        $validation = Validator::make($request->all(), [
            'name' => 'required',
            'sell_price'  => 'required',
            'cost_price'  => 'required',
            'stock'  => 'required',
            // 'attribu'  => 'required',
        ]);
        
        $error_array = array();
        $success_output = '';
        if ($validation->fails())
        {
            foreach ($validation->messages()->getMessages() as $field_name => $messages)
            {
                $error_array[] = $messages; 
            }
        }
        else
        {
            if($request->get('button_action') == 'insert')
            {
                
                // $extension = $cover->getClientOriginalExtension();
                // Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));

                $image1 = $request->file('input_img');  $input['imagename1'] = $image1->getFilename().'.'.$image1->extension();
                $destinationPath1  = public_path('storage/');  $img1 = Image::make($image1->path());
                $img1->resize(600, 500, function ($constraint) {$constraint->aspectRatio();})->save($destinationPath1.$input['imagename1']);


                $student = new orderItem;
                $student->name = $request->input('name');
                $student->slug = str_replace(' ', '-', $request->input('name'));
                $student->sell_price = $request->input('sell_price');
                $student->cost_price = $request->input('cost_price');
                $student->stock = $request->input('stock');
                $state = 'no';
                $visi = 'no';

                if( $request->has('attribu') ){
                    $state = 'yes';
                }
                if( $request->has('visible') ){
                    $visi = 'yes';
                }
                $student->hasattributes = $state;
                $student->visible = $visi;
                $student->image = $input['imagename1'];
                $student->save();

                $prod = new productdata;
                $prod->product_id = $student->id;
                $prod->description = " ";
                $prod->img1 = "loadimage.jpg";
                $prod->img2 = "loadimage.jpg";
                $prod->img3 = "loadimage.jpg";
                $prod->img4 = "loadimage.jpg";
                $prod->save();

                $success_output = '<div class="alert alert-success">Data Inserted</div>';
            }

            if($request->input('button_action') == 'update')
            {
                if($cover==null){
                    $student = orderItem::find($request->input('id'));
                    $student->name = $request->input('name');
                    $student->slug = str_replace(' ', '-', $request->input('name'));
                    $student->sell_price = $request->input('sell_price');
                    $student->cost_price = $request->input('cost_price');
                    $student->stock = $request->input('stock');
                    $state = 'no';
                    $visi = 'no';
    
                    if( $request->has('attribu') ){
                        $state = 'yes';
                    }
                    if( $request->has('visible') ){
                        $visi = 'yes';
                    }
                    $student->visible = $visi;
                    $student->hasattributes = $state;
                    $student->save();
                    $success_output = '<div class="alert alert-success">Data Updated</div>';
            }
                else{
                    // $extension = $cover->getClientOriginalExtension();
                    // Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));

                    $image1 = $request->file('input_img');  $input['imagename1'] = $image1->getFilename().'.'.$image1->extension();
                    $destinationPath1  = public_path('storage/');  $img1 = Image::make($image1->path());
                    $img1->resize(600, 500, function ($constraint) {$constraint->aspectRatio();})->save($destinationPath1.$input['imagename1']);

                    $student = orderItem::find($request->input('id'));
                    $student->name = $request->input('name');
                    $student->slug = str_replace(' ', '-', $request->input('name'));
                    $student->sell_price = $request->input('sell_price');
                    $student->cost_price = $request->input('cost_price');
                    $student->stock = $request->input('stock');
                    $state = 'no';
                    $visi = 'no';
    
                    if( $request->has('attribu') ){
                        $state = 'yes';
                    }
                    if( $request->has('visible') ){
                        $visi = 'yes';
                    }
                    $student->hasattributes = $state;
                    $student->image = $input['imagename1'];
                    $student->save();
                    $success_output = '<div class="alert alert-success">Data Updated</div>';
                }
            }
            
        }
        
        $output = array(
            'error'     =>  $error_array,
            'success'   =>  $success_output
        );
        echo json_encode($output);
    }

    //end product

//start supplier
public function reseller(){
    $datas = resellerdetails::get();
    return view('dashboard/reseller/resellerdetails',['item'=>$datas]);
}
public function regreseller(Request $request){
    $redate= date('Y-m-d H:i:s');

    $image13 = $request->file('img1');  $input['imagename13'] = $image13->getFilename().'.'.$image13->extension();
    $destinationPath13  = public_path('uploads/');  $img13 = Image::make($image13->path());
    $img13->resize(600, 500, function ($constraint) {$constraint->aspectRatio();})->save($destinationPath13.$input['imagename13']);
  

    $data = new resellerdetails();
    try{

    $data->companyname = $request->Name;
    $data->address = $request->Address;
    $data->phone = $request->Phone_Number;
    $data->service = $request->service;
    $data->inventory = 1;
    $data->date = $redate;
    $data->image = $input['imagename13'];
    $data->save();

    return redirect('/reseller')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/reseller')->with('error', 'Error : '.$ex->getMessage());
    }
}
public function resellerbank($id){
    $datas2 = resellerdetails::where('id',$id)->get();
    $supdatas = resellerbank::where('resellerid',$id)->get();
    return view('dashboard/reseller/resellerbank',['datas2'=>$datas2,'supdata'=>$supdatas]);
}
public function addbankdetails(Request $request){
    $data = new resellerbank();
    try{

    $data->resellerid = $request->sid;
    $data->name = $request->Accont_Name;
    $data->bankname = $request->Bank_Name;
    $data->bankcode = $request->Bank_Code;
    $data->branch = $request->Branch;
    $data->branchcode = $request->Branch_code;
    $data->accountNo = $request->Account_Number;
    $data->save();

    return redirect('/resellerbank/'.$request->sid)->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/resellerbank/'.$request->sid)->with('error', 'Error : '.$ex->getMessage());
    }
}

public function deletesup(Request $request,$id){

    $data = resellerdetails::find($id);
    $bank = resellerbank::where('resellerid', $id);
    $resed = User::where('resellerid', $id);
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();
        $bank->delete();
        $resed->delete();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}
public function supplierupdate(Request $request){
    $data = resellerdetails::find($request->id);
    $visi = '0';
    $redate= date('Y-m-d H:i:s');
    if( $request->has('recivemon') ){
        $visi = '1';
        $data->date=$redate;
        $data->save();
    }

    try{

        $data->companyname = $request->Name;
        $data->phone = $request->Phone_Number;
        $data->address = $request->Address;
        $data->service = $request->service;
        $data->inventory=$visi;
        $data->save();

        if($request->file('img1') != null){

            $image13 = $request->file('img1');  $input['imagename13'] = $image13->getFilename().'.'.$image13->extension();
            $destinationPath13  = public_path('uploads/');  $img13 = Image::make($image13->path());
            $img13->resize(600, 500, function ($constraint) {$constraint->aspectRatio();})->save($destinationPath13.$input['imagename13']);

            $data->image = $input['imagename13'];
            $data->save();
        }else{}

        return redirect('/reseller')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/reseller')->with('error', 'Error : '.$ex->getMessage());
        }
}
public function supplierbankupdate(Request $request){
    $data = resellerbank::find($request->id);

    try{
        $data->name = $request->Accont_Name;
        $data->bankname = $request->Bank_Name;
        $data->bankcode = $request->Bank_Code;
        $data->branch = $request->Branch;
        $data->branchcode = $request->Branch_code;
        $data->accountNo = $request->Account_Number;
        $data->save();

        return redirect('/resellerbank/'.$request->supid)->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/resellerbank/'.$request->supid)->with('error', 'Error : '.$ex->getMessage());
        }
}
public function deletebankdetails(Request $request,$id){
    $data = resellerbank::find($id);

   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}
//end supplier

//start purchassing
public function purchasing(){
    $datas = supplier::get();
    $products = orderItem::get();
    $purces = purchasing::get();
    return view('dashboard/product/purchasing',['item'=>$datas, 'product'=>$products, 'purce'=>$purces]);
}

public function purchasingdetails(Request $request,$id){
    $datas = supplier::get();
    $products = orderItem::get();
    $purces2 = purchasing::get();
    $purces = purchesproduct::where('purchesid', $id)->get();
    return view('dashboard/product/purchasing2',['item'=>$datas, 'product'=>$products, 'purce'=>$purces]);
}

public function addpurchasing(Request $request){

    $array = array_merge($request->pro,$request->qty,$request->unit,$request->tot,$request->radiovalu);

    $data = new purchasing();
    

    try{
 
        $data->supplierid = $request->supplier_name;
        $data->cost = $request->nettotal;
        $data->amountpaid = 0;
        $data->invoiceno = $request->invoiceno;
        $data->note = "-";
        $data->status = "0";
        $data->save();

        $getbalance = supplier::where('id',$request->supplier_name)->first();

        $supupd = supplier::find($request->supplier_name);
        $supupd->balance = floatval($request->nettotal)+floatval($getbalance->balance);
        $supupd->save();

        for($i=0; $i<count($request->pro); $i++){
            $dataprod = new purchesproduct();

            $dataprod->productid = $request->pro[$i];
            $dataprod->purchesid = $data->id;
            $dataprod->qty = $request->qty[$i];
            $dataprod->unitprice = $request->unit[$i];
            $dataprod->barcodegen = "0";
            $dataprod->barcodetype = $request->radiovalu[$i];
            $dataprod->save();

            $products = orderItem::where('id',$request->pro[$i])->get();
            
            foreach($products as $dd){
                $oitem = orderItem::find($request->pro[$i]);
                $oitem->stock = $dd->stock+$request->qty[$i];
                $oitem->save();
            }
        }

    return redirect('/grnmanage')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/grnmanage')->with('error', 'Error : '.$ex->getMessage());
    }
}
public function deletepurchassing(Request $request,$id){
    $data = purchasing::find($id);
    $purchas = purchesproduct::where('purchesid',$id)->get();
    $qty1=0;

    foreach($purchas as $purdd){
        $qty1 = $purdd->qty;
        $proid = $purdd->productid;

        $products = orderItem::where('id',$proid)->get();
        $oitem = orderItem::find($proid);
    
        $sto=0;
        foreach($products as $dd){
            $sto = $dd->stock;
        }
        $oitem->stock = ($sto-$qty1);
        $oitem->save();
    }


   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();
        $purdel = purchesproduct::where('purchesid',$id)->get();
        foreach($purdel as $delp){
            $datapurporo = purchesproduct::find($delp->id);
            $datapurporo->delete();
        }

               return  Response::json([
        'status' => $data
    ], 200);
   }
}
public function purchasingupdate(Request $request){
    $data = purchasing::find($request->id);
    $sta = $request->has('paidstatus');
    $products = orderItem::where('id',$request->product_name)->get();
    $purchas = purchasing::where('id',$request->id)->get();
    $oitem = orderItem::find($request->product_name);
    try{

        // $sto=0;
        // $qty1=0;
        // foreach($products as $dd){
        //     $sto = $dd->stock;
        // }
        // foreach($purchas as $purdd){
        //     $qty1 = $purdd->qty;
        // }
        // $oitem->stock = ($sto-$qty1)+$request->Quantity;
        // $oitem->save();


        if($request->payment=="cash"){
            $data->supplierid = $request->supplier_name;
            $data->paymentmethod = $request->payment;
            $data->paiddate = $request->paid_date;
            $data->ccdate = "-";
            $data->cost = $request->cost;
            $data->save();
            if($sta=="true"){
                $data->status = '1';
                $data->save();
            }
            else{
                $data->status = '0';
                $data->save();
             }
        }
        else{
        $data->supplierid = $request->supplier_name;
        $data->paymentmethod = $request->payment;
        $data->paiddate = '-';
        $data->ccdate = $request->paid_date;
        $data->cost = $request->cost;
        $data->save();
        if($sta=="true"){
            $data->status = '1';
            $data->paiddate =$request->paid_date;
            $data->ccdate ='-';
            $data->save();
        }
        else{
            $data->status = '0';
            $data->save();
         }
        }

        return redirect('/productpurchasing')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('productpurchasing')->with('error', 'Error : '.$ex->getMessage());
        }
}
public function genaratebarcode(){
    $datas = supplier::get();
    $products = orderItem::get();
    $purces2 = purchasing::get();
    $purces = purchesproduct::get();
    return view('dashboard/product/genaratebarcode',['item'=>$datas, 'product'=>$products, 'purce'=>$purces]);
}



public function barcodegen(Request $request){
    $purc = purchesproduct::find($request->id);
    $pnamest = substr($request->proname, 0, 2);
    $uuid=[];
    ini_set('max_execution_time', 1000);
    try{
        if($request->bartype=='only product'){
            $data = new productbarcode();
            $uuid = (string) Uuid::generate(4);
            $idsss = explode('-', $uuid);

            $expense_id = productbarcode::get_random_string();

            $data->productid = $request->proid;
            $data->pur_pro = $request->id;
            $data->barcode = $expense_id;
            $data->itemstatus = '0';
            $data->save();

            $purc->barcodegen = '1';
            $purc->save();

        }else{
        for($i = 1;$i<=$request->qty;$i++){
            $data = new productbarcode();
            $uuid = (string) Uuid::generate(4);
            $idsss = explode('-', $uuid);

            $expense_id = productbarcode::get_random_string();

            $data->productid = $request->proid;
            $data->pur_pro = $request->id;
            $data->barcode = $expense_id;
            $data->itemstatus = '0';
            $data->save();
        }
        $purc->barcodegen = '1';
        $purc->save();
    }
        return redirect('/purchasingdetails/'.$request->pirchesid)->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/purchasingdetails/'.$request->pirchesid)->with('error', 'Error : '.$ex->getMessage());
        }
}
public function downloadcsv(Request $request){
$id = $request->id;
$prorealname = $request->prorealname;

$ldate = date('Y-m-d');

    $headers = array(
        "Content-type" => "text/csv",
        "Content-Disposition" => "attachment; filename=$prorealname-$ldate-barcode.csv",
        "Pragma" => "no-cache",
        "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
        "Expires" => "0"
    );

    $reviews = productbarcode::select(["productid","barcode"])->where('pur_pro',$id)->where('productid',$request->proname)->get();
    $columns = array('barcode','Product Name');

    $callback = function() use ($reviews, $columns)
    {
        $file = fopen('php://output', 'w');
        fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
        fputcsv($file, $columns);

        foreach($reviews as $review) {
            fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
            fputcsv($file, array($review->barcode,$review->probarcodeproname->name));
        }
        fclose($file);
    };
    return Response::stream($callback, 200, $headers);
}

public function downloadcsvnotused(Request $request){
    $id = $request->proname;
    $prorealname = $request->prorealname;
    
    $ldate = date('Y-m-d');
    
        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=$prorealname-$ldate-barcode.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = productbarcode::select(["productid","barcode"])->where('itemstatus', 0)->where('productid',$request->proname)->get();
        $columns = array('barcode','Product Name');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {
                fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
                fputcsv($file, array($review->barcode,$review->probarcodeproname->name));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);
    }

    public function downloadallbarcode(Request $request){
        $id = $request->puchesid;
        
        $ldate = date('Y-m-d');
        
            $headers = array(
                "Content-type" => "text/csv",
                "Content-Disposition" => "attachment; filename=$ldate-barcode.csv",
                "Pragma" => "no-cache",
                "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
                "Expires" => "0"
            );
        
            $reviews = productbarcode::select(["productid","barcode"])->wherein('pur_pro', $id)->orderBy('id', 'asc')->get();
            $columns = array('barcode','Product Name');
        
            $callback = function() use ($reviews, $columns)
            {
                $file = fopen('php://output', 'w');
                fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
                fputcsv($file, $columns);
        
                foreach($reviews as $review) {
                    fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
                    fputcsv($file, array($review->barcode,$review->probarcodeproname->name));
                }
                fclose($file);
            };
            return Response::stream($callback, 200, $headers);
        }
//end purchassing

//start remaning stock
public function remainingstock(){
    $prodet = DB::connection('mysql2')->select("select * from order_items");
    return view('dashboard/product/remaningstock',['product'=>$prodet]);
}
// end remaning stock
//start addorder
public function addorder(){
    $resedata = resellerdetails::where('id',Auth::user()->resellerid)->first();
    if($resedata->inventory == 0){
        return redirect('/resellerdash')->with('error', 'Inventory Locked, Please Contact SellerCenter Customer Support!!!');
    }
    else{
        return view('dashboard/addorder/addorder');
    }
}
public function addcustomer(Request $request){
    $additem=new customer;
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);
    $redate= date('Y-m-d H:i:s');

    try{

        $additem->reorderid=$request->orderid;
        $additem->user=Auth::user()->getresellerd->id;
        $additem->addeduser=Auth::user()->id;
        $additem->pageName=Auth::user()->getresellerd->companyname;
        $additem->name=$request->name;
        $additem->address=$request->address;
        $additem->phone=$request->phone;
        $additem->secondaryphone=$request->phone2;
        $additem->status=0;
        $additem->tracking='-';
        $additem->note='None';
        $additem->print='0';
        $additem->cod='0';
        $additem->deliverycharge=0;
        $additem->deliveryservice='-';
        $additem->dispatchid='-';
        $additem->branch="-";
        $additem->deliverydate= $ldate;
        $additem->ridername='-';
        $additem->companydelivery='0';
        $additem->city='-';
        $additem->district='-';
        $additem->weight=0;
        $additem->sellercodid='-';
        $additem->deliverystatus='21';
        $additem->moneyrecivestatus='0';
        $additem->oldwaybill="-";
        $additem->oldwaybillstatus=0;
        $additem->paymentmethod='cash';
        $additem->confirmuser='-';
        $additem->courierreciveid='-';
        $additem->ordertype=1;
        $additem->orderdelivery=0;
        $additem->lockuser='-';
        $additem->lockstatus=0;
        $additem->tracecity='-';
        $additem->servicecharge=Auth::user()->getresellerd->service;
        $additem->commisionstatus=0;
        $additem->commisionid='-';
        $additem->riderdelivery=250;
        $additem->comcommission='-';
        $additem->save();

        $addstat=new statustrack;
        $addstat->customerid=$additem->id;
        $addstat->username=Auth::user()->name;
        $addstat->orderstatus=0;
        $addstat->starttime=0;
        $addstat->endtime=0;
        $addstat->status=0;
        $addstat->save();

        $resed = resellerdetails::find(Auth::user()->getresellerd->id);
        $resed->date = $redate;
        $resed->save();


    return redirect('/viewaddorder/'.$additem->id)->with('success', 'Successfully Saved!');

    }
    catch (Exception $ex){
        return redirect('/addorder')->with('error', 'Error : '.$ex->getMessage());
    }    
}
public function viewaddorder(Request $request,$id){
    $data4 = customer::find($id);
    $data4->lockuser = Auth::user()->name;
    $data4->lockstatus = 1;
    $data4->save();

    $items = cus_orders::where('cus_id', $id)->get();
    $custds = customer::where('id', $id)->get();
    $ldate = date('Y-m-d');
    $citys = trancecity::get();

    $data = [];
    $deli=0;
    $unit=0;
    $tot=0;
    foreach($items as $item) {
        $deli =$item->customerorders->deliverycharge;
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    $cusord = customer::where('id', $id)->first();

    $checkhistory = customer::where('phone', 'like', '%' .substr($cusord->phone, -9). '%')->get();
    $items3 = sellerproduct::where('seller_id',Auth::user()->getresellerd->id)->get();
    return view('dashboard/addorder/additems')->with(['checkhistory'=>$checkhistory,'city'=>$citys,'ldate'=>$ldate,'cus_id'=>$id,'custd'=>$custds,'item'=>$items3, 'item2'=>$items, 'tot' => $tot, 'deli' => $deli, 'cus_id'=>$id , 'attrib_items'=>$items]);
}

public function addcustomerItems(Request $request){

    $att = json_encode($request->product_properties);   
     
    $value = $request->cus_id;
    $data = customer::find($value);
 
    try{ 
        $checkitems = cus_orders::where('item_id', $request->nameproduct)->where('cus_id', $value)->get();

            if(!$checkitems->isEmpty()){
                $qty=0;
                $getid=0;
                $cusitemid=0;
                foreach($checkitems as $checkd){
                    $qty =($checkd->qty)+$request->quantity;
                    $getid=($checkd->id);
                    $cusitemid=$checkd->id;
            }
            $checinse = cus_orders::find($getid);
            $checinse->qty=$qty;
            $checinse->pro_amount=$request->product_price;
            $checinse->save();
            $delqty = ordersbarcode::where('itemordid', $getid)->where('productid', $request->nameproduct)->get();
            foreach($delqty as $delete){
                $delete->delete();
            }
            
            for($i=0; $i<$qty; $i++){
                $addbarcode=new ordersbarcode;
                $addbarcode->customerid=$value;
                $addbarcode->productid=$request->nameproduct;
                $addbarcode->itemordid=$cusitemid;
                $addbarcode->barcode='-';
                $addbarcode->status='0';
                $addbarcode->save();
            }

            }
            else{
            $reprice = sellerproduct::where('id', $request->nameproduct)->first();

            $additem=new cus_orders;
            $additem->item_id=$request->nameproduct;
            $additem->cus_id=$value;
            $additem->attribute=$att;
            $additem->qty=$request->quantity;
            $additem->pro_amount=$request->product_price;
            $additem->reseller_cost=$reprice->cost;
            $additem->barcode='-';
            $additem->save();


            for($i=0; $i<$request->quantity; $i++){
                $addbarcode=new ordersbarcode;
                $addbarcode->customerid=$value;
                $addbarcode->productid=$request->nameproduct;
                $addbarcode->itemordid=$additem->id;
                $addbarcode->barcode='-';
                $addbarcode->status='0';
                $addbarcode->save();
            }
       

    }


    $items = cus_orders::where('cus_id', $value)->get();
    $custds = customer::where('id', $value)->get()->first();

    $deli=0;
    $unit=0;
    $tot=0;
    $weight=0;
    foreach($items as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
        $weight+=($item->orders->weight)*($item->qty);
    }
    if($weight <= 1){
        $deli=300;
    }
    else if($weight <= 2){
        $deli=350;
    }
    else if($weight <= 3){
        $deli=400;
    }
    else if($weight <= 4){
        $deli=450;
    }
    else if($weight <= 5){
        $deli=500;
    }
    else if($weight <= 6){
        $deli=550;
    }
    else if($weight <= 7){
        $deli=600;
    }
    else if($weight <= 8){
        $deli=650;
    }
    else if($weight <= 9){
        $deli=700;
    }
    else if($weight <= 10){
        $deli=750;
    }
    else if($weight <= 11){
        $deli=800;
    }
    else if($weight <= 12){
        $deli=850;
    }
    else if($weight <= 13){
        $deli=900;
    }
    else if($weight <= 14){
        $deli=950;
    }
    else if($weight <= 15){
        $deli=1000;
    }
    else if($weight <= 16){
        $deli=1050;
    }
    else if($weight <= 17){
        $deli=1100;
    }
    else if($weight <= 18){
        $deli=1150;
    }
    else if($weight <= 19){
        $deli=1200;
    }
    else if($weight <= 20){
        $deli=1250;
    }
    if($custds->ordertype == 3){
        $deli=0;
    }

    $data->cod=$tot+$custds->deliverycharge;
    $data->orderdelivery=$deli;
    $data->weight=$weight;
    $data->save();
    return redirect('/viewaddorder/'.$value)->with('success', 'Successfully Saved!');

    }
    catch (Exception $ex){
        return redirect('/viewaddorder/'.$value)->with('error', 'Error : '.$ex->getMessage());
    }
    //return redirect('/viewaddorder');
}

public function updateitem(Request $request){
    $reprice = sellerproduct::where('id', $request->nameproduct2)->first();

    try{
    $id = $request->id;
    $upddata = cus_orders::find($id);
    $upddata->item_id = $request->nameproduct2;
    $upddata->qty = $request->quantity;
    $upddata->pro_amount=$request->product_price;
    $upddata->reseller_cost=$reprice->cost;
    $upddata->save();

    $delqty = ordersbarcode::where('itemordid', $id)->get();
    foreach($delqty as $delete){
        $del = ordersbarcode::find($delete->id);
        $del->delete();
    }
    
    for($i=0; $i<$request->quantity; $i++){
        $addbarcode=new ordersbarcode;
        $addbarcode->customerid=$request->cusid;
        $addbarcode->productid=$request->nameproduct2;
        $addbarcode->itemordid=$id;
        $addbarcode->barcode='-';
        $addbarcode->status='0';
        $addbarcode->save();
    }


    $data = customer::find($request->cusid);
    $items = cus_orders::where('cus_id', $request->cusid)->get();
    $custds = customer::where('id', $request->cusid)->get()->first();

    $deli=0;
    $unit=0;
    $tot=0;
    $weight=0;
    foreach($items as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
        $weight+=($item->orders->weight)*($item->qty);
    }
    if($weight <= 1){
        $deli=300;
    }
    else if($weight <= 2){
        $deli=350;
    }
    else if($weight <= 3){
        $deli=400;
    }
    else if($weight <= 4){
        $deli=450;
    }
    else if($weight <= 5){
        $deli=500;
    }
    else if($weight <= 6){
        $deli=550;
    }
    else if($weight <= 7){
        $deli=600;
    }
    else if($weight <= 8){
        $deli=650;
    }
    else if($weight <= 9){
        $deli=700;
    }
    else if($weight <= 10){
        $deli=750;
    }
    else if($weight <= 11){
        $deli=800;
    }
    else if($weight <= 12){
        $deli=850;
    }
    else if($weight <= 13){
        $deli=900;
    }
    else if($weight <= 14){
        $deli=950;
    }
    else if($weight <= 15){
        $deli=1000;
    }
    else if($weight <= 16){
        $deli=1050;
    }
    else if($weight <= 17){
        $deli=1100;
    }
    else if($weight <= 18){
        $deli=1150;
    }
    else if($weight <= 19){
        $deli=1200;
    }
    else if($weight <= 20){
        $deli=1250;
    }
    if($custds->ordertype == 3){
        $deli=0;
    }else{}

    $data->cod=$tot+$custds->deliverycharge;
    $data->orderdelivery=$deli;
    $data->weight=$weight;
    $data->save();

    return redirect('/viewaddorder/'.$request->cusid)->with('success', 'Successfully Saved!');

    }
    catch (Exception $ex){
        return redirect('/viewaddorder/'.$request->cusid)->with('error', 'Error : '.$ex->getMessage());
    }
    
}
public function updatedelivery(Request $request){
    $items = cus_orders::where('cus_id', $request->id)->get();
    $deli=0;
    $unit=0;
    $tot=0;
    foreach($items as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    try{
    $id = $request->id;
    $data = customer::find($id);
    $data->deliverycharge=$request->Delivery;
    $data->cod=$request->Delivery+$tot;
    $data->save();
    return redirect('/viewaddorder')->with('success', 'Successfully Saved!');

    }
    catch (Exception $ex){
        return redirect('/viewaddorder')->with('error', 'Error : '.$ex->getMessage());
    }
    
}
public function deleteitem(Request $request,$id){

    $data = cus_orders::find($id);
    $getid = cus_orders::where('id', $id)->get();
    foreach($getid as $getida) {
        $cust_id = $getida->cus_id;
        $proid = $getida->item_id;
    }
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{

        $delqty = ordersbarcode::where('itemordid', $id)->where('productid', $proid)->get();
        foreach($delqty as $delete){
            $delete->delete();
        }

        $data->delete();

        $data = customer::find($cust_id);
        $items = cus_orders::where('cus_id', $cust_id)->get();
        $custds = customer::where('id', $cust_id)->get()->first();
        $deli=0;
        $unit=0;
        $tot=0;
        $weight=0;
        foreach($items as $item) {
            $unit = ($item->pro_amount)*($item->qty);
            $tot += $unit;
            $weight+=($item->orders->weight)*($item->qty);
        }
        if($weight <= 1){
            $deli=300;
        }
        else if($weight <= 2){
            $deli=350;
        }
        else if($weight <= 3){
            $deli=400;
        }
        else if($weight <= 4){
            $deli=450;
        }
        else if($weight <= 5){
            $deli=500;
        }
        else if($weight <= 6){
            $deli=550;
        }
        else if($weight <= 7){
            $deli=600;
        }
        else if($weight <= 8){
            $deli=650;
        }
        else if($weight <= 9){
            $deli=700;
        }
        else if($weight <= 10){
            $deli=750;
        }
        else if($weight <= 11){
            $deli=800;
        }
        else if($weight <= 12){
            $deli=850;
        }
        else if($weight <= 13){
            $deli=900;
        }
        else if($weight <= 14){
            $deli=950;
        }
        else if($weight <= 15){
            $deli=1000;
        }
        else if($weight <= 16){
            $deli=1050;
        }
        else if($weight <= 17){
            $deli=1100;
        }
        else if($weight <= 18){
            $deli=1150;
        }
        else if($weight <= 19){
            $deli=1200;
        }
        else if($weight <= 20){
            $deli=1250;
        }
        if($custds->ordertype == 3){
            $deli=0;
        }

        $data->cod=$tot+$deli;
        $data->orderdelivery=$deli;
        $data->weight=$weight;
        $data->save();


               return  Response::json([
        'status' => $data
    ], 200);
   }
}

public function importorders(){

    $city = citylist::get();
    $product = sellerproduct::where('seller_id',Auth::user()->resellerid)->get();
    $count=0;

    $resedata = resellerdetails::where('id',Auth::user()->resellerid)->first();
    if($resedata->inventory == 0){
        return redirect('/resellerdash')->with('error', 'Inventory Locked, Please Contact SellerCenter Customer Support!!!');
    }
    else{
        return view('dashboard/addorder/importorders')->with(['product'=>$product,'checkbanned'=>$count,'city'=>$city]);
    }
}


public function getpendingdata()
{
    $users = customer::select(['id','pagename', 'name', 'address', 'phone','city','confirmuser'])->where('user',Auth::user()->resellerid)->where('status',0);

    return Datatables::of($users)->addColumn('citydata', function($users){
        $x='';
        if($users->city == "-"){$x.= 'No select city';}else{$x.= ''.$users->getcity->city.'';};
        return ''.$x.'';})->addColumn('action', function($users){
        return
        '&nbsp;&nbsp;<button type="button" data-id="'.$users->id .'" data-city="'.$users->city .'" data-fadercity="'.$users->confirmuser .'" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#editordermodelphone">Select City</button>'.
        '&nbsp;&nbsp;<a class="btn btn-danger btn-xs" data-id="'.$users->id .'"  href="">Delete</a>'.
        '&nbsp;&nbsp;<a data-id="'.$users->id.'" class="btn btn-primary btn-xs" target="_blank" href="viewaddorder/'.$users->id.'">View</a>';})
    ->make(true);
}

public function pendinglockajex(Request $request){

    if($request->resellerid=="all"){
        $users = customer::select(['id','pageName', 'name', 'address', 'phone','ordertype','city','cod','user'])->where('status',17)->where('paymentmethod','cash')->where('ordertype',1)->skip(0)->take(500);
    }else{
        $users = customer::select(['id','pageName', 'name', 'address', 'phone','ordertype','city','cod','user'])->where('status',17)->where('paymentmethod','cash')->where('ordertype',1)->where('user',$request->resellerid);
    }
        

    return Datatables::of($users)->addColumn('citydata', function($users){
        $x='';
        if($users->city == "-"){$x.= 'No select city';}else{$x.= ''.$users->getcity->city.'';};
        return ''.$x.'';})->addColumn('action', function($users){
        $x='';
        $x.=
        '&nbsp;&nbsp;<a class="btn btn-success btn-xs outconfirm" data-id="'.$users->id .'"  href="">Out</a>'.
        '&nbsp;&nbsp;<a class="btn btn-info btn-xs colomboconfirm" data-id="'.$users->id .'"  href="">Colombo</a>'.
        '&nbsp;&nbsp;<a class="btn bg-gradient-secondary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';
        return ''.$x.'';})
    ->make(true);
}

public function pendinglockajexpaid(Request $request){

    if($request->resellerid=="all"){
        $users = customer::select(['id','pageName', 'name', 'address', 'phone','ordertype','city','cod','user'])->where('status',17)->where('paymentmethod','paid')->where('ordertype',1)->skip(0)->take(500);
    }else{
        $users = customer::select(['id','pageName', 'name', 'address', 'phone','ordertype','city','cod','user'])->where('status',17)->where('paymentmethod','paid')->where('ordertype',1)->where('user',$request->resellerid);
    }
        

    return Datatables::of($users)->addColumn('citydata', function($users){
        $x='';
        if($users->city == "-"){$x.= 'No select city';}else{$x.= ''.$users->getcity->city.'';};
        return ''.$x.'';})->addColumn('action', function($users){
        $x='';
        $x.=
        '&nbsp;&nbsp;<a class="btn btn-success btn-xs outconfirm" data-id="'.$users->id .'"  href="">Out</a>'.
        '&nbsp;&nbsp;<a class="btn btn-info btn-xs colomboconfirm" data-id="'.$users->id .'"  href="">Colombo</a>'.
        '&nbsp;&nbsp;<a class="btn bg-gradient-secondary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';
        return ''.$x.'';})
    ->make(true);
}
// <button type="button" class="btn btn-block bg-gradient-primary btn-sm">Primary</button>
// foreach($users->cus_or as $data){$y[]=$data->orders->name;}$da=implode(', ', $y);
// foreach($users->cus_or as $data){$data->orders->name};


public function checkpendinglockajex(Request $request)
{


    if($request->page=="all"){
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','cod'])->where('status',1);
    }else{
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','cod'])->where('status',1)->where('user',$request->resellerid);
    }

    

    return Datatables::of($users)->addColumn('action', function($users){
        $x='';
        $x.='<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';
        return ''.$x.'';})
    ->make(true);
}


public function deletecustomer(Request $request,$id){
    $data = customer::find($id);
    $itemde = cus_orders::where('cus_id', $id);
    $bardel = ordersbarcode::where('customerid', $id);

   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();
        $itemde->delete();
        $bardel->delete();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}
public function getproductprice(Request $request,$id){
    $data = sellerproduct::where('id',$id)->get();

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{

        return  Response::json(['status' => $data], 200);
   }
}
public function getpagebranch(Request $request,$id){
    $data = pages::where('id', $id)->get();

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{

        return  Response::json(['status' => $data], 200);
   }
}

public function importExcelOrders(Request $request){

    $redate= date('Y-m-d H:i:s');
    $resed = resellerdetails::find(Auth::user()->getresellerd->id);
    $resed->date = $redate;
    $resed->save();
    
    $upprice = sellerproduct::find($request->product_d);
    $upprice->sell_price = $request->product_price;
    $upprice->save();


		if($request->hasFile('import_file')){
			$path = $request->file('import_file')->getRealPath();
			$data = Excel::load($path, function($reader) {})->get();
            $date = date('Y-m-d');
            $ldate = str_replace('-', '/', $date);
			if(!empty($data) && $data->count()){
				foreach ($data->toArray() as $key => $value) {  
                        $gweig = sellerproduct::where('id',$request->product_d)->first();
                        $delc=0;
                        $weight=floatval($gweig->weight)*floatval($request->qty);
                        
                        if($weight <= floatval(1)){
                            $delc=300;
                        }
                        else if($weight <= floatval(2)){
                            $delc=350;
                        }
                        else if($weight <= floatval(3)){
                            $delc=400;
                        }
                        else if($weight <= floatval(4)){
                            $delc=450;
                        }
                        else if($weight <= floatval(5)){
                            $delc=500;
                        }
                        else if($weight <= floatval(6)){
                            $delc=550;
                        }
                        else if($weight <= floatval(7)){
                            $delc=600;
                        }
                        else if($weight <= floatval(8)){
                            $delc=650;
                        }
                        else if($weight <= floatval(9)){
                            $delc=700;
                        }
                        else if($weight <= floatval(10)){
                            $delc=750;
                        }
                        else if($weight <= floatval(11)){
                            $delc=800;
                        }
                        else if($weight <= floatval(12)){
                            $delc=850;
                        }
                        else if($weight <= floatval(13)){
                            $delc=900;
                        }
                        else if($weight <= floatval(14)){
                            $delc=950;
                        }
                        else if($weight <= floatval(15)){
                            $delc=1000;
                        }
                        else if($weight <= floatval(16)){
                            $delc=1050;
                        }
                        else if($weight <= floatval(17)){
                            $delc=1100;
                        }
                        else if($weight <= floatval(18)){
                            $delc=1150;
                        }
                        else if($weight <= floatval(19)){
                            $delc=1200;
                        }
                        else if($weight <= floatval(20)){
                            $delc=1250;
                        }
                        $inscustomer = customer::create(['reorderid' => '-', 'user' => Auth::user()->getresellerd->id,'addeduser' => Auth::user()->id,'pageName' => Auth::user()->getresellerd->companyname,'name' => $value['full_name'], 'address' => $value['street_address'], 'phone' => $value['phone_number'], 'secondaryphone' => '-', 'status' => '0','tracking' => '-', 'note' => 'None', 'print' => '0', 'cod' => ($request->product_price*$request->qty)+$delc, 'deliverycharge' => 300, 'deliveryservice' => '-','dispatchid' => '-','branch' => '-','deliverydate' => $ldate,'ridername' => '-','companydelivery' => '0','city' => '-','district' => ' ','weight' => $weight,'sellercodid' => '0','deliverystatus' => '21','moneyrecivestatus' => '0','oldwaybill' => '-','oldwaybillstatus' => '0','paymentmethod' => 'cash','confirmuser' => '-', 'courierreciveid' => '-','ordertype' => 1,'orderdelivery' => $delc,'lockuser' => '-', 'lockstatus' => 0, 'tracecity' => '-','servicecharge' => Auth::user()->getresellerd->service,'commisionstatus'=>0,'commisionid'=>'-','riderdelivery'=>250,'comcommission'=>'-']);
                        $insorder = cus_orders::create(['item_id' => $request->product_d, 'cus_id' => $inscustomer->id, 'attribute' => 'null', 'qty' => $request->qty, 'pro_amount' => $request->product_price,'reseller_cost' => $gweig->cost,'barcode' =>'-']);
                        $statustrack = statustrack::create(['customerid' => $inscustomer->id, 'username' => Auth::user()->name, 'orderstatus' => '0','starttime' =>'0','endtime' =>'0','status' =>'0']);          
                        
                for($i=0; $i<$request->qty; $i++){
                    $qtybarcode = ordersbarcode::create(['customerid' => $inscustomer->id, 'productid' => $request->product_d, 'itemordid' => $insorder->id, 'barcode' => '-', 'status' => '0']);
                }
				}

				if(!empty($value)){
                    return back()->with('success','Insert Record successfully.');
                    
                }
			}
		}
		return back()->with('error','Please Check your file, Something is wrong there.');
    }

    // public function sentocallcenter(Request $request)
    // {
    //     $data = DB::table('customers')->where('status',0)->get();
    //     if($data==null){
    //         return  Response::json(['status' => false], 423);
    //    }else{

    //     $items =  customer::where('status',0)->get();
    //     foreach($items as $dad){
    //         $co[]=$dad->id;

    //     }

    //     $dataor =  cus_orders::select('item_id', DB::raw('count(*) as qty'))
    //     ->wherein('cus_id', $co)
    //     ->groupBy('item_id')
    //     ->get();

    //     $ladate = date('Y-m-d H:i:s', strtotime("-4 days"));
    //     $tadate = date('Y-m-d H:i:s');
 
    //     foreach($dataor as $cusit){
    //         $pro = orderItem::where('id',$cusit->item_id)->first();
    //         if($pro->stock < $cusit->qty){

    //             $checkp =  customer::where('status','!=','0')->whereBetween('created_at',[$ladate,$tadate])->get();
    //             foreach($checkp as $checkdata){
    //                $lastdi= substr($checkdata->phone, -8);
    //                 DB::table('customers')->where('status',0)->Where('phone', 'like', '%' .$lastdi. '%')->update(['status' => 27]);
    //             }


    //             DB::table('customers')->where('status',0)->update(['status' => 26]);

    //             $data="2";
    //             return  Response::json(['status' => $data], 200);

    //         }
    //         else{
    //             $checkp =  customer::where('status','!=','0')->whereBetween('created_at',[$ladate,$tadate])->get();
              
    //             foreach($checkp as $checkdata){
    //                $lastdi= substr($checkdata->phone, -8);
    //                 DB::table('customers')->where('status',0)->Where('phone', 'like', '%' .$lastdi. '%')->update(['status' => 27]);
    //             }

    //             DB::table('customers')->where('status',0)->update(['status' => 1]);
    //             $data="1";
    //             return  Response::json(['status' => $data], 200);
    //         }
    //     }

    //         // DB::table('customers')->where('status',0)->update(['status' => 1]);
    //         // return  Response::json(['status' => $data], 200);
    //    }
       
    
    // }

    public function sentocallcenter(Request $request)
    {
        $newDateTime = Carbon::now()->subDays(5);
        $ldate = date('Y-m-d H:i:s');
        $edate=$newDateTime->toDateTimeString();
    
        $cusdata= customer::where('status','!=',0)->whereBetween('created_at',[$edate,$ldate])->get();
        $import = customer::where('status',0)->where('user',Auth::user()->resellerid)->get();
        $importco = customer::where('status',0)->where('user',Auth::user()->resellerid)->count();
    // if($importco != 0){
    //     foreach($cusdata as $cdata){
    //         foreach($import as $idata){
    //             $phone1= substr($cdata->phone, -9);
    //             $phone2= substr($idata->phone, -9);
    //             foreach($cdata->cus_or as $prod1){
    //                 foreach($idata->cus_or as $prod2){
    //                     if($prod1->orders->pro_id == $prod2->orders->pro_id AND $phone1 == $phone2 ){
    
    //                         DB::table('customers')->where('id',$idata->id)->update(['status' => 37]);
    //                         $statrack = new statustrack;
    //                         $statrack->customerid=$idata->id;
    //                         $statrack->username="System";
    //                         $statrack->orderstatus=37;
    //                         $statrack->starttime=0;
    //                         $statrack->endtime=0;
    //                         $statrack->status=0;
    //                         $statrack->save();
    
    //                     }
    
    //                 }
    
    //             }
    
    //         }
    //     }
    
    // }
    

        $data = DB::table('customers')->where('status',0)->get();
        if($data==null){
            return  Response::json(['status' => false], 423);
       }else{
            DB::table('customers')->where('user',Auth::user()->resellerid)->where('status',0)->update(['status' => 1]);
            return  Response::json(['status' => $data], 200);
       }
       
    
    }

//end addorder
public function viewbarcode(Request $request,$id){
    $items = productbarcode::where('productid', $id)->get();
    $pro = orderItem::where('id', $id)->get();
    return view('dashboard/product/barcodeview')->with(['pro'=>$pro, 'item'=>$items]);
}

public function viewpending(){

    $items = customer::where('status', '1')->get();
    $userd= resellerdetails::get();
    return view('dashboard/addorder/pending')->with(['item'=>$items, 'userd'=>$userd]);
}
public function viewpaid(){

    $items = customer::where('status', '1')->get();
    $userd= resellerdetails::get();
    return view('dashboard/addorder/paid')->with(['item'=>$items, 'userd'=>$userd]);
}
public function checkviewpending(){
    if(Auth::user()->type=="super_admin"){
        $items = customer::where('status', '1')->get();
    }
    else{
        $items = customer::where('status', '1')->where('branch', Auth::user()->branch)->get();
    }
    $userd= User::get();
    return view('dashboard/addorder/checkpending')->with(['item'=>$items, 'userd'=>$userd]);
}


public function reject(){
    if(Auth::user()->type=="super_admin"){
        $items = customer::where('status', '27')->get();
    }
    else{
        $items = customer::where('status', '27')->where('branch', Auth::user()->branch)->get();
    }
    
    return view('dashboard/addorder/reject')->with(['item'=>$items]);
}


public function viewcancel(){
 
    $items = customer::where('status', '10')->get();
    
    return view('dashboard/orders/cancel')->with(['item'=>$items]);
}
public function colomboorder(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);
  
    $items = customer::where('status', '5')->where('deliverydate', $ldate)->get();

    $dataor =  customer::select('customers.deliverydate', DB::raw("COUNT(*) as count"))->where('status', '5')->groupBy('customers.deliverydate')->get();


    $delise = user::get();
    return view('dashboard/shipping/colomboorder')->with(['dataor'=>$dataor,'ldate'=>$ldate,'delise'=>$delise,'item'=>$items]);
}

public function searchdeliverydate(Request $request){
    $ldate = $request->delivery_date;
    
    $items = customer::where('status', '5')->where('deliverydate', $request->delivery_date)->get();
    $dataor =  customer::select('customers.deliverydate', DB::raw("COUNT(*) as count"))->where('status', '5')->groupBy('customers.deliverydate')->get();

    $delise = user::get();
    return view('dashboard/shipping/colomboorder')->with(['dataor'=>$dataor,'ldate'=>$ldate,'delise'=>$delise,'item'=>$items]);
}


public function daycloseupdate(Request $request){

    $items = customer::where('status', 12)->get();
    foreach($items as $idata){
        $data2 = customer::find($idata->id);
        $data2->status = 5;
        $data2->save();

        $statrack = new statustrack;
        $statrack->customerid=$idata->id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=5;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();
    }

    // DB::table('customers')->wherein('status',[12])->update(['status' => 5]);
    return redirect('/colomboorder')->with('success', 'Successfully Saved!');
}

public function todayconfirm(){
    $date = date('Y/m/d');
    $items = customer::where('status', '6')->where('deliverydate', $date)->get();
    $delise = deliveryservice::get();
    $dataor =  customer::select('customers.deliverydate', DB::raw("COUNT(*) as count"))->where('status', '6')->groupBy('customers.deliverydate')->get();

    return view('dashboard/shipping/todayconfirm')->with(['dataor'=>$dataor,'ldate'=>$date,'delise'=>$delise,'item'=>$items]);
}


public function searchdeliverydateout(Request $request){
    $date =  $request->delivery_date;
    $items = customer::where('status', '6')->where('deliverydate', $date)->get();
    $delise = deliveryservice::get();
    $dataor =  customer::select('customers.deliverydate', DB::raw("COUNT(*) as count"))->where('status', '6')->groupBy('customers.deliverydate')->get();

    return view('dashboard/shipping/todayconfirm')->with(['dataor'=>$dataor,'ldate'=>$request->delivery_date,'delise'=>$delise,'item'=>$items]);
}



public function todayprint(){
 
    $items = customer::where('status', '11')->get();
 
    $delise = deliveryservice::get();
    $deli="all";
    return view('dashboard/shipping/todayprint')->with(['deli'=>$deli,'delise'=>$delise,'item'=>$items]);
}

public function colomboprint(){
 
    $items = customer::where('status', '12')->get();

    $delise = user::get();
    $deli="all";
    return view('dashboard/shipping/colomboprint')->with(['deli'=>$deli,'delise'=>$delise,'item'=>$items]);
}



public function inventorytoday(){

    $items = customer::where('status', '13')->get();

    $delise = deliveryservice::get();
    return view('dashboard/inventory/todayinventory')->with(['delise'=>$delise,'item'=>$items]);
}

public function inventorycolombo(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $items = customer::where('status', '14')->get();

    $deli="all";
    $delise = user::get();

    return view('dashboard/inventory/colombopacknew')->with(['ldate'=>$ldate,'deli'=>$deli,'delise'=>$delise,'item'=>$items]);
}



public function dispatchsummary(){
  
    $newDateTime = Carbon::now()->subDays(30);
    $edate=$newDateTime->toDateTimeString();
    $ldate1 = date('Y-m-d');
    $da2= $ldate1.' 23:59:59';
    $items = customer::where('status', '15')->get();

    $dis = dispatchsummary::whereBetween('created_at',[$edate,$da2])->get();
    $delise = deliveryservice::get();
    $dispa = customer::select('customers.dispatchid', DB::raw("COUNT(customers.id) as qty"))->where('customers.status', 8)->where('customers.deliverystatus', 21)->groupBy('customers.dispatchid')->get();

    return view('dashboard/orders/dispatchsummary')->with(['dispa'=>$dispa,'delise'=>$delise,'cuso'=>$dis,'item'=>$items]);
}
public function courierexcel(Request $request,$id){
    $getcour = dispatchsummary::where('id', $id)->first();

    $items = customer::where('status', 15)->where('deliveryservice', $getcour->courierservice)->get();
    $dispa = customer::where('dispatchid', $id)->where('deliveryservice', $getcour->courierservice)->get();

    
    $delise = deliveryservice::get();
    $dis = dispatchsummary::where('id',$id)->get();
    return view('dashboard/orders/deliveryexcel')->with(['getcour'=>$getcour,'dispa'=>$dispa,'delive'=>$dis,'delise'=>$delise,'item'=>$items, 'disid'=>$id]);
}
public function returnorders(){
  
    $items = customer::where('status', '7')->get();
    $delise = user::get();
    return view('dashboard/orders/returnorders')->with(['delise'=>$delise,'item'=>$items]);
}
public function cancelorders(){
 
    $items = customer::where('status', '10')->get();

    $delise = user::get();
    return view('dashboard/orders/cancelorders')->with(['delise'=>$delise,'item'=>$items]);
}
public function completeorderstable(){

    $items = customer::where('status', '8')->get();

    $delise = user::get();
    return view('dashboard/orders/completeorders')->with(['delise'=>$delise,'item'=>$items]);
}
public function paidorders(){
    
    $items = customer::where('status', '9')->get();

    $delise = user::get();
    return view('dashboard/orders/paidorders')->with(['delise'=>$delise,'item'=>$items]);
}
public function allorders(){
    
    $del = deliveryservice::get();
    $delise = user::get();
    $reseller = resellerdetails::get();
    return view('dashboard/orders/allorders')->with(['reseller'=>$reseller,'delise'=>$delise, 'del'=>$del]);
}







public function viwedetails($id){

    $data = customer::find($id);

    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);


    $items = customer::where('id', $id)->get();
    $items2 = cus_orders::where('cus_id', $id)->get();
    $citys = trancecity::get();
    $fardcity = fardarcitylist::get();
    $delise = user::get();
    $statustrack = statustrack::where('customerid',$id)->get();
    $prod = sellerproduct::where('seller_id',Auth::user()->id)->get();

    $deli=0;
    $unit=0;
    $tot=0;
    foreach($items2 as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
        
    }
    foreach($items as $itemsdata) {
        $deli =$itemsdata->deliverycharge;
        $lastdi= substr($itemsdata->phone, -9);
    }
    $checkdel = customer::where('id', $id)->get()->first();
    if($checkdel->ordertype == 2){
        $deli=0;
    }
    $proold = DB::connection('mysql2')->select('select * from order_items');
    return view('dashboard/addorder/vieworder')->with(['proold'=>$proold,'fardcity'=>$fardcity,'ldate'=>$date,'statustrack'=>$statustrack,'delise'=>$delise,'city'=>$citys,'prods'=>$prod,'item'=>$items,'tot' => $tot, 'deli' => $deli,'item3'=>$items2,'cus_id'=>$id]);
}


public function resetlock($id){

    $data = customer::find($id);

    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{
        $data->lockstatus=0;
        $data->save();
        return  Response::json(['status' => $data], 200);
    }
}


// public function resetlock($id){

//     $data = customer::find($id);
    
//     $data->lockstatus=0;
//     $data->save();

//     return redirect('/viewpending'); 
// }
public function viwedetailsship($id){

    $data = customer::find($id);

    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);


    $items = customer::where('id', $id)->get();
    $items2 = cus_orders::where('cus_id', $id)->get();
    $page_data = pages::where('id', $data->pageName)->get();
    $pages = pages::get();
    $prod = orderItem::get();
    $citys = citylist::get();


    $deli=0;
    $unit=0;
    $tot=0;

    foreach($items2 as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    foreach($items as $itemsdata) {
        $deli =$itemsdata->deliverycharge;
    }

    return view('dashboard/addorder/viewordership')->with(['city'=>$citys,'prods'=>$prod,'page'=>$pages,'item'=>$items,'tot' => $tot, 'deli' => $deli,'item3'=>$items2,'cus_id'=>$id,'pages'=>$page_data]);
}

public function viwedetailsshipconfirm($id){

    $data = customer::find($id);

    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);


    $items = customer::where('id', $id)->get();
    $items2 = cus_orders::where('cus_id', $id)->get();
    $page_data = pages::where('id', $data->pageName)->get();
    $pages = pages::get();
    $prod = orderItem::get();
    $citys = citylist::get();


    $deli=0;
    $unit=0;
    $tot=0;

    foreach($items2 as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    foreach($items as $itemsdata) {
        $deli =$itemsdata->deliverycharge;
    }

    return view('dashboard/addorder/viwedetailsshipconfirm')->with(['city'=>$citys,'prods'=>$prod,'page'=>$pages,'item'=>$items,'tot' => $tot, 'deli' => $deli,'item3'=>$items2,'cus_id'=>$id,'pages'=>$page_data]);
}

public function viwedetailsinventory($id){

    $data = customer::find($id);

    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $items = customer::where('id', $id)->get();
    $items2 = cus_orders::where('cus_id', $id)->get();
    $page_data = pages::where('id', $data->pageName)->get();
    $pages = pages::get();
    $prod = orderItem::get();
    $citys = citylist::get();


    $deli=0;
    $unit=0;
    $tot=0;

    foreach($items2 as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    foreach($items as $itemsdata) {
        $deli =$itemsdata->deliverycharge;
    }

    return view('dashboard/addorder/vieworderinventory')->with(['city'=>$citys,'prods'=>$prod,'page'=>$pages,'item'=>$items,'tot' => $tot, 'deli' => $deli,'item3'=>$items2,'cus_id'=>$id,'pages'=>$page_data]);
}


public function viwedetailsconfirm($id){

    $data = customer::find($id);

    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);


    $items = customer::where('id', $id)->get();
    $items2 = cus_orders::where('cus_id', $id)->get();
    $page_data = pages::where('id', $data->pageName)->get();
    $pages = pages::get();
    $prod = orderItem::get();
    $citys = citylist::get();


    $deli=0;
    $unit=0;
    $tot=0;

    foreach($items2 as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    foreach($items as $itemsdata) {
        $deli =$itemsdata->deliverycharge;
    }

    return view('dashboard/addorder/vieworder2')->with(['city'=>$citys,'prods'=>$prod,'page'=>$pages,'item'=>$items,'tot' => $tot, 'deli' => $deli,'item3'=>$items2,'cus_id'=>$id,'pages'=>$page_data]);
}


public function viewallorders($id){

    $data = customer::find($id);

    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);


    $items = customer::where('id', $id)->get();
    $items2 = cus_orders::where('cus_id', $id)->get();
    $citys = citylist::get();
    $barord = ordersbarcode::where('customerid',$id)->get();
    $statustrack = statustrack::where('customerid',$id)->get();
    

    $deli=0;
    $unit=0;
    $tot=0;

    foreach($items2 as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    foreach($items as $itemsdata) {
        $deli =$itemsdata->deliverycharge;
        $lastdi= substr($itemsdata->phone, -9);
    }
    $checkhistory = customer::where('phone', 'like', '%' .$lastdi. '%')->get();
    $banned = bannedcustomers::where('phoneno', 'like', '%' .$lastdi. '%')->get()->count();
    return view('dashboard/orders/allordersview')->with(['banned'=>$banned,'checkhistory'=>$checkhistory,'ldate'=>$date,'statustrack'=>$statustrack,'barord'=>$barord,'city'=>$citys,'item'=>$items,'tot' => $tot, 'deli' => $deli,'item3'=>$items2,'cus_id'=>$id]);
}



public function updatecusdetails(Request $request){

    $cus_id = $request->cus_id;

    $data = customer::find($cus_id);
    $data->name = $request->name;
    $data->address = $request->address;
    $data->phone = $request->phone;
    $data->tracking = $request->tracking;
    $data->note = $request->note;
    $data->save();
    return redirect('/viwedetails/'.$cus_id); 
}

public function dependdata($id){    
    $data = DB::table("attributes")->where("proid",$id)->select(["attname","id","attributes"])->get();
    return Response::json($data, 200);
}
public function dependdata2($id){    
    $data = DB::table("attributes")->where("proid",$id)->select(["attname","id","attributes"])->get();
    return Response::json($data, 200);
}

public function deliveryupdateview(Request $request){
    $items = cus_orders::where('cus_id', $request->id)->get();
    $deli=0;
    $unit=0;
    $tot=0;
    foreach($items as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    try{
    $id = $request->id;
    $data = customer::find($id);
    $data->deliverycharge=$request->Delivery;
    $data->cod=$request->Delivery+$tot;
    $data->save();
    return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }
    
}

public function deliverybtnupdate(Request $request){
    $items = cus_orders::where('cus_id', $request->id)->get();
    $deli=0;
    $unit=0;
    $tot=0;
        foreach($items as $item) {
            $unit = ($item->pro_amount)*($item->qty);
            $tot += $unit;
        }
        try{
        $id = $request->id;
        $data = customer::find($id);
        $data->deliverycharge=250;
        $data->cod=250+$tot;
        $data->save();
        return  Response::json(['status' => $data], 200);
        }
        catch (Exception $ex){
            return  Response::json(['status' => false], 423);
        }    
}

public function deliverybtnupdate2(Request $request){
    $items = cus_orders::where('cus_id', $request->id)->get();
    $deli=0;
    $unit=0;
    $tot=0;
        foreach($items as $item) {
            $unit = ($item->pro_amount)*($item->qty);
            $tot += $unit;
        }
        try{
        $id = $request->id;
        $data = customer::find($id);
        $data->deliverycharge=275;
        $data->cod=275+$tot;
        $data->save();
        return  Response::json(['status' => $data], 200);
        }
        catch (Exception $ex){
            return  Response::json(['status' => false], 423);
        }
        
}
// public function addcustomerItemsview(Request $request){

//     $att = json_encode($request->product_properties);   
    
//     $value = $request->id;
//     $additem=new cus_orders;

//     try{
//     $additem->item_id=$request->nameproduct;
//     $additem->cus_id=$value;
//     $additem->attribute=$att;
//     $additem->qty=$request->quantity;
//     $additem->pro_amount='0';
//     $additem->barcode='-';
//     $additem->save();

//     $data = customer::find($value);
//     $items = cus_orders::where('cus_id', $value)->get();
//     $custds = customer::where('id', $value)->get();
//     $items3 = orderItem::where('id', $request->nameproduct)->get();
//     $deli=0;
//     $unit=0;
//     $tot=0;
//     $nowpro=0;

//     foreach($items as $item) {
//         $unit = ($item->orders->sell_price)*($item->qty);
//         $tot += $unit;
//     }
//     foreach($custds as $cusdata) {
//         $deli = $cusdata->deliverycharge;
//     }
//     $data->cod=$tot+$deli;
//     $data->save();
//     return redirect('/viwedetails/'.$value)->with('success', 'Successfully Saved!');

//     }
//     catch (Exception $ex){
//         return redirect('/viwedetails/'.$value)->with('error', 'Error : '.$ex->getMessage());
//     }
// }

public function addcustomerItemsview(Request $request){

    $att = json_encode($request->product_properties);   
    $value = $request->input('id');
    

    try{
        $checkitems = cus_orders::where('item_id', $request->nameproduct)->where('cus_id', $value)->get();

            if(!$checkitems->isEmpty()){
                $qty=0;
                $getid=0;
                $cusitemid=0;
                foreach($checkitems as $checkd){
                    $qty =($checkd->qty)+$request->quantity;
                    $getid=($checkd->id);
                    $cusitemid=$checkd->id;
            }
            $checinse = cus_orders::find($getid);
            $checinse->qty=$qty;
            $checinse->pro_amount=$request->product_price;
            $checinse->save();
            $delqty = ordersbarcode::where('itemordid', $getid)->where('productid', $request->nameproduct)->get();
            foreach($delqty as $delete){
                $delete->delete();
            }
            
            for($i=0; $i<$qty; $i++){
                $addbarcode=new ordersbarcode;
                $addbarcode->customerid=$value;
                $addbarcode->productid=$request->nameproduct;
                $addbarcode->itemordid=$cusitemid;
                $addbarcode->barcode='-';
                $addbarcode->status='0';
                $addbarcode->save();
            }

            }
            else{
                $additem=new cus_orders;
                $additem->item_id=$request->input('nameproduct');
                $additem->cus_id=$value;
                $additem->attribute=$att;
                $additem->qty=$request->input('quantity');
                $additem->pro_amount=$request->product_price;
                $additem->barcode='-';
                $additem->save();

        for($i=0; $i<$request->quantity; $i++){
            $addbarcode=new ordersbarcode;
            $addbarcode->customerid=$value;
            $addbarcode->productid=$request->nameproduct;
            $addbarcode->itemordid=$additem->id;
            $addbarcode->barcode='-';
            $addbarcode->status='0';
            $addbarcode->save();
        }

    }
        $data = customer::find($value);
        $items = cus_orders::where('cus_id', $value)->get();
        $custds = customer::where('id', $value)->get();
        $deli=0;
        $unit=0;
        $tot=0;
        $nowpro=0;
    
        foreach($items as $item) {
            $unit = ($item->pro_amount)*($item->qty);
            $tot += $unit;
        }
        foreach($custds as $cusdata) {
            $deli = $cusdata->deliverycharge;
        }
        $data->cod=$tot+$deli;
        $data->save();
        return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }
}

// public function updateitemview(Request $request){

//     $att = json_encode($request->product_properties); 

//     try{
//     $id = $request->id;
//     $upddata = cus_orders::find($id);
//     $upddata->item_id = $request->nameproduct2;
//     $upddata->attribute=$att;
//     $upddata->qty = $request->quantity;
//     $upddata->pro_amount='0';
//     $upddata->save();

//     $data = customer::find($request->cusid);
//     $items = cus_orders::where('cus_id', $request->cusid)->get();
//     $custds = customer::where('id', $request->cusid)->get();
//     $items3 = orderItem::where('id', $request->nameproduct)->get();
//     $deli=0;
//     $unit=0;
//     $tot=0;
//     foreach($items as $item) {
//         $unit = ($item->orders->sell_price)*($item->qty);
//         $tot += $unit;
//     }
//     foreach($custds as $cusdata) {
//         $deli = $cusdata->deliverycharge;
//     }

//     $data->cod=$tot+$deli;
//     $data->save();

//     return redirect('/viwedetails/'.$request->cusid)->with('success', 'Successfully Saved!');

//     }
//     catch (Exception $ex){
//         return redirect('/viwedetails/'.$request->cusid)->with('error', 'Error : '.$ex->getMessage());
//     }
    
// }


public function updateitemview(Request $request){

    $att = json_encode($request->product_properties2); 

    try{
    $id = $request->id;
    $upddata = cus_orders::find($id);
    $upddata->item_id = $request->nameproduct2;
    $upddata->attribute=$att;
    $upddata->qty = $request->quantity;
    $upddata->pro_amount=$request->product_price;
    $upddata->save();

    $delqty = ordersbarcode::where('itemordid', $id)->get();
    foreach($delqty as $delete){
        $del = ordersbarcode::find($delete->id);
        $del->delete();
    }
    
    for($i=0; $i<$request->quantity; $i++){
        $addbarcode=new ordersbarcode;
        $addbarcode->customerid=$request->cusid;
        $addbarcode->productid=$request->nameproduct2;
        $addbarcode->itemordid=$id;
        $addbarcode->barcode='-';
        $addbarcode->status='0';
        $addbarcode->save();
    }

    $data = customer::find($request->cusid);
    $items = cus_orders::where('cus_id', $request->cusid)->get();
    $custds = customer::where('id', $request->cusid)->get();
    $items3 = orderItem::where('id', $request->nameproduct)->get();
    $deli=0;
    $unit=0;
    $tot=0;
    foreach($items as $item) {
        $unit = ($item->pro_amount)*($item->qty);
        $tot += $unit;
    }
    foreach($custds as $cusdata) {
        $deli = $cusdata->deliverycharge;
    }

    $data->cod=$tot+$deli;
    $data->save();

    return  Response::json(['status' => $upddata], 200);
}
catch (Exception $ex){
    return  Response::json(['status' => false], 423);
}
    
}

public function updatestatus(Request $request){
    $cus_id = $request->cus_id;
    $custodata = customer::where('id', $cus_id)->first();

    $getncid = customer::where('status',1)->first();
    $getncid1 = customer::where('status',2)->first();
    $getncid2 = customer::where('status',3)->first();
    $getncid3 = customer::where('status',4)->first();
    $getncid4 = customer::where('status',16)->first();
    $getncid5 = customer::where('status',17)->first();
    $getncid6 = customer::where('status',26)->first();

    $data = customer::find($cus_id);
    $data->status = $request->statusValu;
    $data->save();

    $statrack = new statustrack;
    $statrack->customerid=$cus_id;
    $statrack->username=Auth::user()->name;
    $statrack->orderstatus=$request->statusValu;
    $statrack->starttime=0;
    $statrack->endtime=0;
    $statrack->status=0;
    $statrack->save();

    if($request->nowstatus=='1'){
        if($getncid==null){
            return redirect('/viewpending');
        }
        else{
            return redirect('/viwedetails/'.$getncid->id); 
        }
    }
    elseif($request->nowstatus=='2'){
        if($getncid1==null){
            return redirect('/1stattempt');
        }
        else{
            return redirect('/viwedetails/'.$getncid1->id); 
        }
    }
    elseif($request->nowstatus=='3'){
        if($getncid2==null){
            return redirect('/2ndattempt');
        }
        else{
            return redirect('/viwedetails/'.$getncid2->id); 
        }
    }
    elseif($request->nowstatus=='4'){
        if($getncid3==null){
            return redirect('/3rdattempt');
        }
        else{
            return redirect('/viwedetails/'.$getncid3->id); 
        }
    }
    elseif($request->nowstatus=='16'){
        if($getncid4==null){
            return redirect('/phoneoff');
        }
        else{
            return redirect('/viwedetails/'.$getncid4->id); 
        }
    }
    elseif($request->nowstatus=='17'){
        if($getncid5==null){
            return redirect('/hewillcall');
        }
        else{
            return redirect('/viwedetails/'.$getncid5->id); 
        }
    }
    elseif($request->nowstatus=='26'){
        if($getncid6==null){
            return redirect('/hold');
        }
        else{
            return redirect('/viwedetails/'.$getncid6->id); 
        }
    }
    elseif($request->nowstatus=='5'){
        return redirect('/viewpending');
    }
    elseif($request->nowstatus=='6'){
        return redirect('/viewpending');
    }
    elseif($request->nowstatus=='7'){
        return redirect('/viewallorders/'.$cus_id);
    }
    elseif($request->nowstatus=='8'){
        return redirect('/viewallorders/'.$cus_id);
    }
    elseif($request->nowstatus=='9'){
        return redirect('/viewallorders/'.$cus_id);
    }
    elseif($request->nowstatus=='10'){
        return redirect('/viewpending');
    }
    else{
        return redirect('/viewpending');
    }

}

public function productattribute(Request $request,$id){

    $items = attribute::where('proid',$id)->get();
    $product = orderItem::where('hasattributes','yes')->get();
    
    return view('dashboard/product/ProductAttribute')->with(['pro_id'=>$id,'item'=>$items,'product'=>$product]);
}

public function addattributes(Request $request){
    $additem = new attribute();
    try{
        $additem->proid=$request->productid;
        $additem->attname=$request->name;
        $additem->attributes=$request->att;
        $additem->save();

        return redirect('/productattribute/'.$request->productid)->with('success', 'Successfully Saved!');

        }
        catch (Exception $ex){
            return redirect('/productattribute/'.$request->productid)->with('error', 'Error : '.$ex->getMessage());
        }

}
public function updateaddattributes(Request $request){

    $data = attribute::find($request->id);
    try{
        $data->attname=$request->name;
        $data->attributes=$request->att;
        $data->save();

        return redirect('/productattribute/'.$request->productid)->with('success', 'Successfully Saved!');

        }
        catch (Exception $ex){
            return redirect('/productattribute/'.$request->productid)->with('error', 'Error : '.$ex->getMessage());
        }

}

public function deletattribute(Request $request, $id){
    $data = attribute::find($id);
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        $data->delete();
        return  Response::json(['status' => $data], 200);
   }
}

public function deliveryserice(){
    $datas = deliveryservice::get();

    $dataor =  deliveryservice::select('deliveryservices.id','deliveryservices.deliveryname','deliveryservices.deliveryphone','deliveryservices.deliveryaddress', DB::raw("COUNT(trackingranges.trackingno) as ctrack"))
    ->join('trackingranges', 'trackingranges.deliveryid', '=' , 'deliveryservices.id')
    ->where('trackingranges.status', '=', 0)
    ->groupBy('deliveryservices.id')->get();



    return view('dashboard/product/deliveryservice',['item'=>$datas,'countdata'=>$dataor]);
}

public function adddelivery(Request $request){
    $data = new deliveryservice();
    try{

    $data->deliveryname = $request->Name;
    $data->deliveryphone = $request->Phone_Number;
    $data->deliveryaddress = $request->Address;
    $data->email = $request->email;
    $data->save();

    return redirect('/deliveryserice')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/deliveryserice')->with('error', 'Error : '.$ex->getMessage());
    }
}
public function deletedelivery(Request $request,$id){

    $data = deliveryservice::find($id);
    $range = trackingrange::where('deliveryid', $id);
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();
        $range->delete();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}
public function deliveryupdate(Request $request){
    $data = deliveryservice::find($request->id);
    try{

    $data->deliveryname = $request->Name;
    $data->deliveryphone = $request->Phone_Number;
    $data->deliveryaddress = $request->Address;
    $data->email = $request->email;
    $data->save();

    return redirect('/deliveryserice')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/deliveryserice')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function trackingrange(Request $request,$id){
    $datas = deliveryservice::where('id',$id)->get();
    $ranges = trackingrange::where('deliveryid',$id)->get();
    return view('dashboard/product/trackingrange',['item'=>$datas, 'range'=>$ranges]);
}

public function adddeliveryrang(Request $request){
    ini_set('max_execution_time', 1000);
    $min = $request->min_no;
    $max = $request->max_no;
    try{
        if($request->Tracking == "Tracking"){
        for($i = $min; $i<=$max;$i++){
            $data = new trackingrange();

            $data->deliveryid = $request->sid;
            $data->customerid = '-';
            $data->trackingno = $i;
            $data->status = '0';
            $data->save();
        }   
    }
    else if($request->Delete == "Delete"){
        $del = trackingrange::where('deliveryid',$request->sid)->where('status',0);
        $del->delete();
    }
        return redirect('/trackingrange/'.$request->sid)->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/trackingrange/'.$request->sid)->with('error', 'Error : '.$ex->getMessage());
        }
}
public function rangetrackinupdate(Request $request){

    $cus_id = $request->input('id');
    $code = $request->input('tracking');

    $data = trackingrange::find($cus_id);

    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        $data->trackingno = $code;
        $data->save();
        return  Response::json(['status' => $data], 200);
   } 
}

public function deletedeliveryrange(Request $request,$id)
{
    $data = trackingrange::find($id);
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();
               return  Response::json([
        'status' => $data
    ], 200);
   }
}

public function courierserviceadd(Request $request){
    $checid = $request->checkids;
    $cbCount = count($checid);
    $avatracking = trackingrange::where('status', 0)->where('deliveryid', $request->delivery)->get()->count();
    if($cbCount==0){
        return redirect('/todayconfirm')->with('error', 'No select Orders');
    }else{
    if($request->dropex=="dropex"){
        foreach($checid as $checiddata){
        $data = customer::find($checiddata);
        $data->status = '19';
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$checiddata;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=19;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();

        }
        return redirect('/todayconfirm')->with('success', 'Successfully Saved!');

    }
    else if($request->adddelivery=="adddelivery"){   

    if($cbCount>$avatracking){     

        return redirect('/todayconfirm')->with('error', 'Tracking Numbers Over, Enter New Tracking Numbers Range');
    }
    else{
    try{

    if($request->delivery == 1){
        foreach($checid as $checiddata){
            $range = trackingrange::where('status', 0)->where('deliveryid', $request->delivery)->orderBy('id', 'asc')->first();

                $data = customer::find($checiddata);
                $data->status = '19';
                $data->tracking = $range->trackingno;
                $data->deliveryservice = $request->delivery;
                $data->save();

                $statrack = new statustrack;
                $statrack->customerid=$checiddata;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=19;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();

                $tradata = trackingrange::find($range->id);
                $tradata->customerid = $checiddata;
                $tradata->status = '1';
                $tradata->save();
           }

    }
    else if($request->delivery == 6){
        foreach($checid as $checiddata){
            $range = trackingrange::where('status', 0)->where('deliveryid', $request->delivery)->orderBy('id', 'asc')->first();

                $data = customer::find($checiddata);
                $data->status = '11';
                $data->tracking = $range->trackingno;
                $data->deliveryservice = $request->delivery;
                $data->orderdelivery = 0;
                $data->save();

                $statrack = new statustrack;
                $statrack->customerid=$checiddata;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=11;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();

                $tradata = trackingrange::find($range->id);
                $tradata->customerid = $checiddata;
                $tradata->status = '1';
                $tradata->save();
           }

    }
    else{
        foreach($checid as $checiddata){
            $range = trackingrange::where('status', 0)->where('deliveryid', $request->delivery)->orderBy('id', 'asc')->first();

                $data = customer::find($checiddata);
                $data->status = '11';
                $data->tracking = $range->trackingno;
                $data->deliveryservice = $request->delivery;
                $data->save();

                $statrack = new statustrack;
                $statrack->customerid=$checiddata;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=11;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();

                $tradata = trackingrange::find($range->id);
                $tradata->customerid = $checiddata;
                $tradata->status = '1';
                $tradata->save();
           }
    }

  
        return redirect('/todayconfirm')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/todayconfirm')->with('error', 'Error : '.$ex->getMessage());
        }
    }
}
}
}
public function adddeliveryguycmbo(Request $request){
    $checid = $request->checkids;
    $cbCount = count($checid);

    if($cbCount==0){
        return redirect('/colomboorder')->with('error', 'No select Orders');
    }
    else{
        if($request->rider=="rider"){
            try{
                foreach($checid as $checiddata){
        
                        $data = customer::find($checiddata);
                        $data->status = '12';
                        $data->ridername = $request->delivery_name;
                        $data->companydelivery = "1";
                        $data->save();
                        
                        $statrack = new statustrack;
                        $statrack->customerid=$checiddata;
                        $statrack->username=Auth::user()->name;
                        $statrack->orderstatus=12;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();
                   }
          
                return redirect('/colomboorder')->with('success', 'Successfully Saved!');
                    }
                catch (Exception $ex){
                    return redirect('/colomboorder')->with('error', 'Error : '.$ex->getMessage());
                }
            }
    else if($request->dropex=="dropex"){

        try{
            foreach($checid as $checiddata){
    
                    $data = customer::find($checiddata);
                    $data->status = '6';
                    $data->ridername="-";
                    $data->companydelivery=0;
                    $data->save();

                    $statrack = new statustrack;
                    $statrack->customerid=$checiddata;
                    $statrack->username=Auth::user()->name;
                    $statrack->orderstatus=6;
                    $statrack->starttime=0;
                    $statrack->endtime=0;
                    $statrack->status=0;
                    $statrack->save();
               }
      
            return redirect('/colomboorder')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/colomboorder')->with('error', 'Error : '.$ex->getMessage());
            }

    }
        }

}

public function colombo_print(Request $request){
    $ldate = date('Y-m-d');
    $cus = customer::with('cus_or')->where('status', '12')->where('ridername', $request->delivery_name)->get();
    $user = user::where('id', $request->delivery_name)->get();
    $prod = DB::connection('mysql2')->select('select * from order_items');
    $pdf = PDF::loadView('dashboard.shipping.colombopdf', array('prod'=>$prod,'cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a4', 'landscape');
  return $pdf->stream(); 
}

public function today_print(Request $request){
    $ldate = date('Y-m-d');
    $cus = customer::with('cus_or')->where('status', '11')->where('deliveryservice', $request->delivery_name)->get();
    $user = deliveryservice::where('id', $request->delivery_name)->get();
    $prod = DB::connection('mysql2')->select('select * from order_items');
    $pdf = PDF::loadView('dashboard.shipping.todayprintpdf', array('prod'=>$prod,'cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a4');
  return $pdf->stream(); 
}



// public function printstatuschangecolombo(Request $request){
//     $checid = $request->checkids;
//     $cbCount = count($checid);
//     if($cbCount==0){
//         return redirect('/colomboprint')->with('error', 'No select Orders');
//     }
//     else{
    
//         if($request->sendpacking=="sendpacking"){
//             try{
//                 foreach($checid as $checiddata){
        
//                         $data = customer::find($checiddata);
//                         $data->status = '14';
//                         $data->print = '1';
//                         $data->save();
//                    }
          
//                 return redirect('/colomboprint')->with('success', 'Successfully Saved!');
//                     }
//                 catch (Exception $ex){
//                     return redirect('/colomboprint')->with('error', 'Error : '.$ex->getMessage());
//                 }

//         }else if($request->pdfprint=="pdfprint"){
//             $ldate = date('Y-m-d');
//             $cus = customer::with('cus_or')->where('status', '12')->where('ridername', $request->delivery_name)->get();
//             $user = user::where('id', $request->delivery_name)->get();
        
//             $pdf = PDF::loadView('dashboard.shipping.colombopdf', array('cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a4', 'landscape');
//           return $pdf->stream(); 
//         }
//         else{
//             return redirect('/colomboprint')->with('error', 'No Action');
//         }


//     }
// }

public function addbarcode(Request $request){

    $checkbarcode = productbarcode::where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st1 = productbarcode::where('barcode', $request->barcode)->where('productid', $request->pro_id)->first();
    $st2 = productbarcode::where('itemstatus', 1)->where('barcode', $request->barcode)->get();
    
    if($checkbarcode==null){
        return redirect('/inventorytoday')->with('error', 'This Barcode is not in the database');
    }
    else if($st1==null){
        return redirect('/inventorytoday')->with('error', 'Product Not Matching');
    }
    else {
        try{
            $data = cus_orders::find($request->itemid);
            $data->barcode = $request->barcode;
            $data->save();

            $range = productbarcode::where('barcode', $request->barcode)->first();
            $range->itemstatus = "1";
            $range->save();
      
            return redirect('/inventorytoday')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/inventorytoday')->with('error', 'Error : '.$ex->getMessage());
        }
}

}

public function completeorders(Request $request){
    $checid = $request->checkids;
    $cbCount = count($checid);
    if($cbCount==0){
        return redirect('/inventorytoday')->with('error', 'No select Orders');
    }

    else{
    try{
        foreach($checid as $checiddata){

        $checkbar = cus_orders::where('cus_id', $checiddata)->get();
        foreach($checkbar as $chechdata){

            if($chechdata->barcode=="-"){
                $ex= "invoice No - ".$checiddata." Please Enter the Barcode";
                return redirect('/inventorytoday')->with('error', $ex);
            }
        }


        $data = customer::find($checiddata);
        $data->status = '15';
        $data->save();

        $items2 = cus_orders::where('cus_id', $checiddata)->get();
        $getqty=0;
        $stock=0;
        foreach($items2 as $item) {
            $productdata = orderItem::where('id', $item->item_id)->get();
            // $productdata = orderItem::find($item->item_id);
            $getqty=$item->qty;
            foreach($productdata as $prodata) {
                $stock=$prodata->stock;   
                $stockchange = orderItem::find($prodata->id);  
                $stockchange->stock = $stock-$getqty;
                $stockchange->save();
            }
        }

           }
  
        return redirect('/inventorytoday')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/inventorytoday')->with('error', 'Error : '.$ex->getMessage());
        }
    }
}

// 

public function addbarcodecmbo(Request $request){

    $checkbarcode = productbarcode::where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st1 = productbarcode::where('barcode', $request->barcode)->where('productid', $request->pro_id)->first();
    $st2 = productbarcode::where('itemstatus', 1)->where('barcode', $request->barcode)->get();
    
    if($checkbarcode==null){
        return redirect('/inventorycolombo')->with('error', 'This Barcode is not in the database');
    }
    else if($st1==null){
        return redirect('/inventorycolombo')->with('error', 'Product Not Matching');
    }
    else {
        try{
            $data = cus_orders::find($request->itemid);
            $data->barcode = $request->barcode;
            $data->save();

            $range = productbarcode::where('barcode', $request->barcode)->first();
            $range->itemstatus = "1";
            $range->save();
      
            return redirect('/inventorycolombo')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/inventorycolombo')->with('error', 'Error : '.$ex->getMessage());
        }
}

}

public function checklistbarcode(Request $request){

    $checkbarcode = productbarcode::where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st1 = productbarcode::where('barcode', $request->barcode)->where('productid', $request->pro_id)->first();
    $st2 = productbarcode::where('itemstatus', 1)->where('barcode', $request->barcode)->get();
    
    if($checkbarcode==null){
        // return redirect('/inventorycolombo')->with('error', 'This Barcode is not in the database');
        return  Response::json(['status' => false], 423);
    }
    else if($st1==null){
        // return redirect('/inventorycolombo')->with('error', 'Product Not Matching');
        return  Response::json(['status' => false], 423);
    }
    else {
        try{
            $data = tempriderbarcode::find($request->id);
            $data->barcode = $request->barcode;
            $data->save();

            $range = productbarcode::where('barcode', $request->barcode)->first();
            $range->itemstatus = "1";
            $range->save();
            // return redirect('/inventorycolombo')->with('success', 'Successfully Saved!');
            return  Response::json(['status' => $data], 200);
                }
            catch (Exception $ex){
                return  Response::json(['status' => false], 423);
                // return redirect('/inventorycolombo')->with('error', 'Product Not Matching');
        }
}

}





public function completeorderscmbo(Request $request){
    $checid = $request->checkids;
    $cbCount = count($checid);
    if($cbCount==0){
        return redirect('/inventorycolombo')->with('error', 'No select Orders');
    }

    else{
    try{
        foreach($checid as $checiddata){

        $checkbar = cus_orders::where('cus_id', $checiddata)->get();
        foreach($checkbar as $chechdata){

            if($chechdata->barcode=="-"){
                $ex= "invoice No - ".$checiddata." Please Enter the Barcode";
                return redirect('/inventorycolombo')->with('error', $ex);
            }
        }


        $data = customer::find($checiddata);
        $data->status = '8';
        $data->save();

        $items2 = cus_orders::where('cus_id', $checiddata)->get();
        $getqty=0;
        $stock=0;
        foreach($items2 as $item) {
            $productdata = orderItem::where('id', $item->item_id)->get();
            // $productdata = orderItem::find($item->item_id);
            $getqty=$item->qty;
            foreach($productdata as $prodata) {
                $stock=$prodata->stock;   
                $stockchange = orderItem::find($prodata->id);  
                $stockchange->stock = $stock-$getqty;
                $stockchange->save();
            }
        }

           }
  
        return redirect('/inventorycolombo')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/inventorycolombo')->with('error', 'Error : '.$ex->getMessage());
        }
    }
}

public function allitemprinttoday()
{
    $ldate = date('Y-m-d');
    $cus = customer::with('cus_or')->where('status', '11')->get();

    $dataor =  customer::select('cus_orders.item_id','order_items.name','order_items.image as img', DB::raw("SUM(cus_orders.qty) as qty"))
    ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
    ->join('order_items', 'order_items.id', '=' , 'cus_orders.item_id')
    ->where('customers.status', '=', 11)
    ->groupBy('cus_orders.item_id')
    ->get();

    
    $pdf = PDF::loadView('dashboard.shipping.allitempdf', array('data'=>$dataor,'cus'=>$cus,'ldate'=> $ldate));
  return $pdf->stream(); 
}


public function allitemprintcolombo()
{
    ini_set('max_execution_time', 1000);
    $ldate = date('Y-m-d H:i:s');
    $cus = customer::with('cus_or')->where('status', '12')->get();

    $dataor =  customer::select('cus_orders.item_id','order_items.name','order_items.image as img', DB::raw("SUM(cus_orders.qty) as qty"))
    ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
    ->join('order_items', 'order_items.id', '=' , 'cus_orders.item_id')
    ->where('customers.status', '=', 12)
    ->groupBy('cus_orders.item_id')
    ->get();

    
    $pdf = PDF::loadView('dashboard.shipping.allitempdf', array('data'=>$dataor,'cus'=>$cus,'ldate'=> $ldate));
  return $pdf->stream(); 
}

public function returnrecive(){
    $products = DB::connection('mysql2')->select('select * from order_items');
    return view('dashboard/inventory/returnrecive')->with(['product'=>$products]);
}


public function getallorders()
{
    $users = customer::select(['id','name', 'phone', 'tracking'])->where('status',8);

    return Datatables::of($users)->addColumn('action', function($users){
        return
        '&nbsp;&nbsp;<a data-id="'.$users->id.'" class="btn btn-primary btn-xs" href="viwedetailsinventory/'.$users->id.'">View</a>';})
    ->make(true);
}


public function sendreturnreciveid(Request $request)
{
    $data = customer::find($request->id);
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $checkretu = customer::where('id', $request->id)->first();

        if($checkretu->status==7){
            $data=2;
            return  Response::json(['status' => $data], 200);
        }
        else if($checkretu->status==11 AND $checkretu->status==12 AND $checkretu->status==13 AND $checkretu->status==14 AND $checkretu->status==15){
            $data=2;
            return  Response::json(['status' => $data], 200);
        }
        else{

            $items2 = ordersbarcode::where('customerid', $request->id)->get();
            foreach($items2 as $item) {
                $users = DB::connection('mysql2')->select("update `productbarcodes` set `itemstatus` = 0 where barcode = '$item->barcode' ");
            }

            $items2 = cus_orders::where('cus_id', $request->id)->get();
            $getqty=0;
            $stock=0;
            foreach($items2 as $item) {
                $productdata=DB::connection('mysql2')->table('order_items')->where('id', $item->orders->pro_id)->get();
                $getqty=$item->qty;
                foreach($productdata as $prodata) {
                    $stock=($prodata->stock)+($getqty);   
                    $proid=$prodata->id;
                    $users = DB::connection('mysql2')->select("update `order_items` set `stock` = '$stock' where id = '$proid' ");
                }
            }


            $data->status = '7';
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=7;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
            
            $data=3;
               return  Response::json(['status' => $data], 200);
   }
}
}

public function damageitem(){
    $items = pages::get();
    $products = productbarcode::get();

    return view('dashboard/inventory/damageitem')->with(['item'=>$items, 'product'=>$products]);
}
public function getdamageitem()
{
    $users = productbarcode::select(['id','productid','barcode', 'itemstatus']);

    return Datatables::of($users)->addColumn('action', function($users){
        return
        '&nbsp;&nbsp;<a data-id="'.$users->id.'" class="btn btn-primary btn-xs" href="viwedetails/'.$users->id.'">View</a>';})
    ->make(true);
}

public function senddamageitem(Request $request)
{
    $barcod = productbarcode::where('barcode', $request->waybill)->first();
    $tempbar = tempriderbarcode::where('barcode', $request->waybill)->first();

   if($barcod==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{

        $barcod->itemstatus = '2';
        $barcod->save();

               return  Response::json([
        'status' => $barcod
    ], 200);
   }
}

public function exportpage(Request $request){
    $deliveryid =$request->delivery;
    $disid =$request->dispachid;
    $ldate = date('Y-m-d');

    if($request->Koobiyo=="Koobiyo"){
        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=Koobiyo-$ldate-orders.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","district","paymentmethod","note"])->where('dispatchid',$disid)->get();
        $columns = array('Waybill Id', 'Order Number', 'Receiver Name', 'Delivery Address', 'District Name', 'Receiver Phone', 'COD','Description');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            // $file = fopen('public/export/' . $fileName, 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->tracking,  $review->id, $review->name, $review->address,$review->district, $ph,  $cod,$da));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);

    }
    else if($request->Domex=="Domex"){

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=Domex-$ldate-orders.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::with('cus_or')->select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","district","paymentmethod","city","note"])->where('dispatchid',$disid)->get();
        $columns = array('RECEIVER NAME', 'RECEIVER ADDRESS 1', 'RECEIVER ADDRESS 2', 'RECEIVER CITY', 'RECEIVER CONTACT', 'PCs', 'WEIGHT(K)','WEIGHT(G)','REFERENCE','AMOUNT','ITEM NAME','SHORT NAME','Vibrant REF','WAYBILL NO','BARCODE');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);           
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->name,$review->address," ",$review->getcity->city,$ph,"1",$review->weight," "," ", $review->cod,$da,$da,$review->id,$review->tracking,$review->tracking ));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);

    }
    else if($request->Trans=="Trans"){

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=Trans-$ldate-orders.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::with('cus_or')->select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","district","city","paymentmethod","tracecity","note"])->where('dispatchid',$disid)->get();
        $columns = array('Traking Number', 'Order Number', 'Customer Name', 'Address', 'Order Description', 'Customer Phone','Phone 2', 'COD Amount','Trans City','Remarks');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid"){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->tracking,  $review->id, $review->name, $review->address, $da , $review->phone, $review->secondaryphone , $cod, $review->trancecity->city_name ,$review->note));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);

    }
    else if($request->Fardar=="Fardar"){

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=Fardar-$ldate-orders.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","district","paymentmethod","city","note"])->where('dispatchid',$disid)->get();
        $columns = array('ID', 'Parcel Type', 'Order ID', 'Parcel Description', 'Recipient Name', 'Recipient Mobile', 'Recipient Address','Recipient City','COD Amount','Exchange');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->tracking,'1', $review->id, $da, $review->name, $ph, $review->address, $review->getcity->city,   $cod ,'0'));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);

    }

    else if($request->Grasshopper=="Grasshopper"){

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=Grasshopper-$ldate-orders.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","district","paymentmethod","city","note"])->where('dispatchid',$disid)->get();
        $columns = array('B2B#', 'SLEEPING#', 'RECIPIENT_NAME', 'PHONE#', 'PHONE#2', 'STREET', 'CITY', 'ZIP_CODE', 'DELIVERY_METHOD', 'CATEGORY', 'ITEM_DESCRIPTION', 'QTY', 'PAYMENT_TYPE', 'AMOUNT', 'PAYMENT_METHOD', 'WEIGHT(KG)', 'DIMENSION_TYPE', 'SP_INSTRUCTIONS');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid"){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->id,$review->tracking, $review->name,$review->phone , $review->secondaryphone, $review->address, $review->getcity->city,"","STANDARD","PACKAGE", $da,"1","CASH_ON_DELIVERY", $cod,"CASH","1","STANDARD_SIZE",""));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);

    }


}

public function courierpdfdata(Request $request){
    $ldate = date('Y-m-d');
    $noof=$request->noofline;
    $deliveryname=$request->delivery;
    $disid =$request->dispachid;
    $createb =$request->create;
    $cdate =$request->cdate;
    
    $cus = customer::where('dispatchid',$disid)->get();

    $pdf = PDF::loadView('dashboard.orders.courierpdf', array('cdate'=>$cdate,'createb'=>$createb,'id'=>$disid,'name'=>$deliveryname,'cus'=>$cus,'ldate'=> $ldate,'noof'=> $noof))->setPaper('a4');
  return $pdf->stream(); 
}



public function dispathnew(Request $request){
    $data = new dispatchsummary;
    try{
        $cusdata = customer::where('status', '15')->where('deliveryservice', $request->delivery)->get();
        $cuscount = customer::where('status', '15')->where('deliveryservice', $request->delivery)->get()->count();

        $data->courierservice = $request->delivery;
        $data->noofline =0;
        $data->createdby = Auth::user()->name;
        $data->save();

        // foreach($cusdata as $custd){
        // $cusdispatch = customer::find($custd->id);
        // $cusdispatch->dispatchid = $data->id;
        // $cusdispatch->status = "8";
        // $cusdispatch->save();

        // $items2 = cus_orders::where('cus_id', $custd->id)->get();
        // $getqty=0;
        // $stock=0;
        // foreach($items2 as $item) {
        //     $productdata = orderItem::where('id', $item->item_id)->get();
        //     $getqty=$item->qty;
        //     foreach($productdata as $prodata) {
        //         $stock=$prodata->stock;   
        //         $stockchange = orderItem::find($prodata->id);  
        //         $stockchange->stock = $stock-$getqty;
        //         $stockchange->save();
        //     }
        // }
        // }

    
        return redirect('/dispatchsummary')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/dispatchsummary')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function dispatchupdate(Request $request){
    $ldate = date('Y-m-d h:m:s');
    $data2 = dispatchsummary::find($request->id);
    $data2->updated_at = $ldate;
    $data2->save();
    try{

        if($request->sync=="sync"){
            $sy = customer::where('status',8)->where('deliverystatus',21)->where('dispatchid',$request->id)->skip(0)->take(100)->get();
            foreach($sy as $sdata){
                $oarray = array(
                    'waybill_id' => $sdata->tracking
                );
                $arr = json_encode($oarray);
         
                $curl = curl_init();
                curl_setopt_array($curl, array(
                  CURLOPT_URL => 'https://portal.transexpress.lk/api/tracking',
                  CURLOPT_RETURNTRANSFER => true,
                  CURLOPT_ENCODING => '',
                  CURLOPT_MAXREDIRS => 10,
                  CURLOPT_TIMEOUT => 0,
                  CURLOPT_FOLLOWLOCATION => true,
                  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                  CURLOPT_CUSTOMREQUEST => 'POST',
                  CURLOPT_POSTFIELDS =>$arr,
                  CURLOPT_HTTPHEADER => array(
                    'Content-Type: application/json',
                    'Cookie: trans_express_services_lanka_session=Ty2q2qRo8N6iEIPFZQYRBdwttV44OElCz69l2eSI'
                  ),
                ));
                
                $response = curl_exec($curl);
                $err = curl_error($curl);
                $data = json_decode($response, TRUE);
                curl_close($curl);
            
                foreach($data as $dattaa){
                    if($dattaa['waybill_id'] != $sdata->tracking ){
                        foreach($dattaa['waybill_id'] as $err){
        
                    return redirect('/dispatchsummary')->with('error', 'Invoice ID - '.$sdata->id.' Tracking Number - '.$sdata->tracking. '-' . $err);

                        }
                    }
                    else{
                    if($dattaa["current_status"] == "Rescheduled"){
                        $data2 = customer::find($sdata->id);
                        $data2->deliverystatus = 30;
                        $data2->save();
    
                        $statrack = new statustrack;
                        $statrack->customerid=$sdata->id;
                        $statrack->username=Auth::user()->name;
                        $statrack->orderstatus=30;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();
                    }
                    else if($dattaa["current_status"] == "Failed to Deliver"){
                        $data2 = customer::find($sdata->id);
                        $data2->deliverystatus = 46;
                        $data2->save();
    
                        $statrack = new statustrack;
                        $statrack->customerid=$sdata->id;
                        $statrack->username=Auth::user()->name;
                        $statrack->orderstatus=46;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();
                    }
                    else if($dattaa["current_status"] == "Delivered"){
                        $data2 = customer::find($sdata->id);
                        $data2->status = 18;
                        $data2->save();
    
                        $statrack = new statustrack;
                        $statrack->customerid=$sdata->id;
                        $statrack->username=Auth::user()->name;
                        $statrack->orderstatus=18;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();
                    }
                
                }
            }
        }
            $jsonstu ="Successfully sync All Orders";
     
        }
      
    
        return redirect('/dispatchsummary')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/dispatchsummary')->with('error', 'Error : '.$ex->getMessage());
    }


}




public function btnstatuschange(Request $request){

    if($request->pending=="pending"){
        try{
        $data = customer::find($request->cus_id);
        $data->status = "1";
        $data->save();
        return redirect('/viewpending');
    }
            
        catch (Exception $ex){
            return redirect('/viewpending')->with('error', 'Error : '.$ex->getMessage());
    }
}
        else if($request->Attempt=="Attempt"){
            try{

            $data = customer::find($request->cus_id);
            $data->status = "2";
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=2;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

            $getncid = customer::where('status',1)->first();
            $getncid1 = customer::where('status',2)->first();
            $getncid2 = customer::where('status',3)->first();
            $getncid3 = customer::where('status',4)->first();

            if($request->nowstatus=='1'){
                if($getncid==null){
                    return redirect('/viewpending');
                }
                else{
                    return redirect('/viwedetails/'.$getncid->id); 
                }
            }
            elseif($request->nowstatus=='2'){
                if($getncid1==null){
                    return redirect('/1stattempt');
                }
                else{
                    return redirect('/viwedetails/'.$getncid1->id); 
                }
            }
            elseif($request->nowstatus=='3'){
                if($getncid2==null){
                    return redirect('/2ndattempt');
                }
                else{
                    return redirect('/viwedetails/'.$getncid2->id); 
                }
            }
            elseif($request->nowstatus=='4'){
                if($getncid3==null){
                    return redirect('/3rdattempt');
                }
                else{
                    return redirect('/viwedetails/'.$getncid3->id); 
                }
            }
            elseif($request->nowstatus=='5'){
                return redirect('/viewpending');
            }
            elseif($request->nowstatus=='6'){
                return redirect('/viewpending');
            }
            elseif($request->nowstatus=='7'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='8'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='9'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='10'){
                return redirect('/viewpending');
            }
            else{
                return redirect('/viewpending');
            }
                    }
                catch (Exception $ex){
                    return redirect('/viewpending')->with('error', 'Error : '.$ex->getMessage());
            }

        }
        else if($request->Colombo=="Colombo"){
            try{
            $custds = customer::where('id',$request->cus_id)->get()->first();
            $items = cus_orders::where('cus_id', $request->cus_id)->get();
            $weight=0;
            $deli=0;
            foreach($items as $item) {
                $weight+=($item->orders->weight)*($item->qty);
            }
            if($weight <= 1){
                $deli=200;
            }
            else if($weight <= 2){
                $deli=250;
            }
            else if($weight <= 3){
                $deli=300;
            }
            else if($weight <= 4){
                $deli=350;
            }
            else if($weight <= 5){
                $deli=400;
            }
            else if($weight <= 6){
                $deli=450;
            }
            else if($weight <= 7){
                $deli=500;
            }
            else if($weight <= 8){
                $deli=550;
            }
            else if($weight <= 9){
                $deli=600;
            }
            else if($weight <= 10){
                $deli=650;
            }
            else if($weight <= 11){
                $deli=700;
            }
            else if($weight <= 12){
                $deli=750;
            }
            else if($weight <= 13){
                $deli=800;
            }
            else if($weight <= 14){
                $deli=850;
            }
            else if($weight <= 15){
                $deli=900;
            }
            else if($weight <= 16){
                $deli=950;
            }
            else if($weight <= 17){
                $deli=1000;
            }
            else if($weight <= 18){
                $deli=1050;
            }
            else if($weight <= 19){
                $deli=1100;
            }
            else if($weight <= 20){
                $deli=1150;
            }
            if($custds->ordertype == 3){
                $deli=0;
            }else{}

            $data = customer::find($request->cus_id);
            $data->status = "5";
            $data->orderdelivery=$deli;
            $data->weight=$weight;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=5;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

            $getncid = customer::where('status',1)->first();
            $getncid1 = customer::where('status',2)->first();
            $getncid2 = customer::where('status',3)->first();
            $getncid3 = customer::where('status',4)->first();

            if($request->nowstatus=='1'){
                return redirect('/closewindow'); 
            }
            elseif($request->nowstatus=='2'){
                return redirect('/1stattempt');
            }
            elseif($request->nowstatus=='3'){
                return redirect('/2ndattempt');
            }
            elseif($request->nowstatus=='4'){
                return redirect('/3rdattempt');
            }
            elseif($request->nowstatus=='5'){
                return redirect('/viewpending');
            }
            elseif($request->nowstatus=='6'){
                return redirect('/viewpending');
            }
            elseif($request->nowstatus=='7'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='8'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='9'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='10'){
                return redirect('/viewpending');
            }
            else{
                return redirect('/viewpending');
            }
                    }
                catch (Exception $ex){
                    return redirect('/viewpending')->with('error', 'Error : '.$ex->getMessage());
            }

        }
        else if($request->Confirm=="Confirm"){
            try{
            $custds = customer::where('id',$request->cus_id)->get()->first();
            $items = cus_orders::where('cus_id', $request->cus_id)->get();
            $weight=0;
            $deli=0;
            foreach($items as $item) {
                $weight+=($item->orders->weight)*($item->qty);
            }
            if($weight <= 1){
                $deli=300;
            }
            else if($weight <= 2){
                $deli=350;
            }
            else if($weight <= 3){
                $deli=400;
            }
            else if($weight <= 4){
                $deli=450;
            }
            else if($weight <= 5){
                $deli=500;
            }
            else if($weight <= 6){
                $deli=550;
            }
            else if($weight <= 7){
                $deli=600;
            }
            else if($weight <= 8){
                $deli=650;
            }
            else if($weight <= 9){
                $deli=700;
            }
            else if($weight <= 10){
                $deli=750;
            }
            else if($weight <= 11){
                $deli=800;
            }
            else if($weight <= 12){
                $deli=850;
            }
            else if($weight <= 13){
                $deli=900;
            }
            else if($weight <= 14){
                $deli=950;
            }
            else if($weight <= 15){
                $deli=1000;
            }
            else if($weight <= 16){
                $deli=1050;
            }
            else if($weight <= 17){
                $deli=1100;
            }
            else if($weight <= 18){
                $deli=1150;
            }
            else if($weight <= 19){
                $deli=1200;
            }
            else if($weight <= 20){
                $deli=1250;
            }
            if($custds->ordertype == 3){
                $deli=0;
                }else{}

            $data = customer::find($request->cus_id);
            $data->status = "6";
            $data->ridername="-";
            $data->companydelivery=0;
            $data->orderdelivery=$deli;
            $data->weight=$weight;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=6;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

            $getncid = customer::where('status',1)->first();
            $getncid1 = customer::where('status',2)->first();
            $getncid2 = customer::where('status',3)->first();
            $getncid3 = customer::where('status',4)->first();

            if($request->nowstatus=='1'){
                if($getncid==null){
                    return redirect('/viewpending');
                }
                else{
                    return redirect('/viwedetails/'.$getncid->id); 
                }
            }
            elseif($request->nowstatus=='2'){
                if($getncid1==null){
                    return redirect('/1stattempt');
                }
                else{
                    return redirect('/viwedetails/'.$getncid1->id); 
                }
            }
            elseif($request->nowstatus=='3'){
                if($getncid2==null){
                    return redirect('/2ndattempt');
                }
                else{
                    return redirect('/viwedetails/'.$getncid2->id); 
                }
            }
            elseif($request->nowstatus=='4'){
                if($getncid3==null){
                    return redirect('/3rdattempt');
                }
                else{
                    return redirect('/viwedetails/'.$getncid3->id); 
                }
                return redirect('/viwedetails/'.$getncid3->id); 
            }
            elseif($request->nowstatus=='5'){
                return redirect('/viewpending');
            }
            elseif($request->nowstatus=='6'){
                return redirect('/viewpending');
            }
            elseif($request->nowstatus=='7'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='8'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='9'){
                return redirect('/viewallorders');
            }
            elseif($request->nowstatus=='10'){
                return redirect('/viewpending');
            }
            else{
                return redirect('/viewpending');
            }
                    }
                catch (Exception $ex){
                    return redirect('/viewpending')->with('error', 'Error : '.$ex->getMessage());
            }
        } 
        else if($request->Cancel=="Cancel"){
            try{            

                $data = customer::find($request->cus_id);
                $data->status = "10";
                $data->save();

                $statrack = new statustrack;
                $statrack->customerid=$request->cus_id;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=10;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();

                $getncid = customer::where('status',1)->first();
                $getncid1 = customer::where('status',2)->first();
                $getncid2 = customer::where('status',3)->first();
                $getncid3 = customer::where('status',4)->first();
    
                if($request->nowstatus=='1'){
                    if($getncid==null){
                        return redirect('/viewpending');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid->id); 
                    }
                }
                elseif($request->nowstatus=='2'){
                    if($getncid1==null){
                        return redirect('/1stattempt');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid1->id); 
                    }
                }
                elseif($request->nowstatus=='3'){
                    if($getncid2==null){
                        return redirect('/2ndattempt');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid2->id); 
                    }
                }
                elseif($request->nowstatus=='4'){
                    if($getncid3==null){
                        return redirect('/3rdattempt');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid3->id); 
                    }
                    return redirect('/viwedetails/'.$getncid3->id); 
                }
                elseif($request->nowstatus=='5'){
                    return redirect('/viewpending');
                }
                elseif($request->nowstatus=='6'){
                    return redirect('/viewpending');
                }
                elseif($request->nowstatus=='7'){
                    return redirect('/viewallorders');
                }
                elseif($request->nowstatus=='8'){
                    return redirect('/viewallorders');
                }
                elseif($request->nowstatus=='9'){
                    return redirect('/viewallorders');
                }
                elseif($request->nowstatus=='10'){
                    return redirect('/viewpending');
                }
                else{
                    return redirect('/viewpending');
                }
                    }
                catch (Exception $ex){
                    return redirect('/viewpending')->with('error', 'Error : '.$ex->getMessage());
            }
        }
        else if($request->dropex=="dropex"){
            try{            


                $data = customer::find($request->cus_id);
                $data->status = "19";
                $data->ridername="-";
                $data->companydelivery=0;
                $data->save();

                $statrack = new statustrack;
                $statrack->customerid=$request->cus_id;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=19;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();
    
                $getncid = customer::where('status',1)->first();
                $getncid1 = customer::where('status',2)->first();
                $getncid2 = customer::where('status',3)->first();
                $getncid3 = customer::where('status',4)->first();

                if($request->nowstatus=='1'){
                    if($getncid==null){
                        return redirect('/viewpending');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid->id); 
                    }
                }
                elseif($request->nowstatus=='2'){
                    if($getncid1==null){
                        return redirect('/1stattempt');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid1->id); 
                    }
                }
                elseif($request->nowstatus=='3'){
                    if($getncid2==null){
                        return redirect('/2ndattempt');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid2->id); 
                    }
                }
                elseif($request->nowstatus=='4'){
                    if($getncid3==null){
                        return redirect('/3rdattempt');
                    }
                    else{
                        return redirect('/viwedetails/'.$getncid3->id); 
                    }
                    return redirect('/viwedetails/'.$getncid3->id); 
                }
                elseif($request->nowstatus=='5'){
                    return redirect('/viewpending');
                }
                elseif($request->nowstatus=='6'){
                    return redirect('/viewpending');
                }
                elseif($request->nowstatus=='7'){
                    return redirect('/viewallorders');
                }
                elseif($request->nowstatus=='8'){
                    return redirect('/viewallorders');
                }
                elseif($request->nowstatus=='9'){
                    return redirect('/viewallorders');
                }
                elseif($request->nowstatus=='10'){
                    return redirect('/viewpending');
                }
                else{
                    return redirect('/viewpending');
                }
                    }
                catch (Exception $ex){
                    return redirect('/viewpending')->with('error', 'Error : '.$ex->getMessage());
            }
        }
        
}





// public function cityupdate(Request $request){
//     $data = customer::find($request->id);
//     $cusdata = citylist::where('id', $request->cituselect)->first();
//     // cituselect
//     try{

//         $data->city = $request->cituselect;
//         $data->district = $cusdata->district;
//         $data->save();

    
//         return  Response::json(['status' => $data], 200);
//     }
//     catch (Exception $ex){
//         return  Response::json(['status' => false], 423);
//     }
// }





public function donecheckcolombo(Request $request){
    $tembarcode = tempriderbarcode::where('date', $request->delivery_date)->where('rider', $request->delivery_name)->get();
    $cusds = customer::where('deliverydate', $request->delivery_date)->where('ridername', $request->delivery_name)->where('status', 14)->get();
    try{
        foreach($tembarcode as $datadd){
            $data = tempriderbarcode::find($datadd->id);
            $data->status = '1';
            $data->save();
        }
        foreach($cusds as $cusdata){
            $data = customer::find($cusdata->id);
            $data->status = '8';
            $data->save();

            $items2 = cus_orders::where('cus_id', $checiddata)->get();
            $getqty=0;
            $stock=0;
            foreach($items2 as $item) {
                $productdata = orderItem::where('id', $item->item_id)->get();
                // $productdata = orderItem::find($item->item_id);
                $getqty=$item->qty;
                foreach($productdata as $prodata) {
                    $stock=$prodata->stock;   
                    $stockchange = orderItem::find($prodata->id);  
                    $stockchange->stock = $stock-$getqty;
                    $stockchange->save();
                }
            }
        }



    
        return redirect('/inventorycolombo');
    }
    catch (Exception $ex){
        return redirect('/inventorycolombo')->with('error', 'Error : '.$ex->getMessage());
}

}


public function searchinventorycolombo2(Request $request){
    $delise = user::get();
    $ldate=$request->delivery_date;
    $deli=$request->delivery_name;

    $items = customer::where('status', '14')->get();
    $tembarcode = tempriderbarcode::where('date', $request->delivery_date)->where('rider', $request->delivery_name)->get();


    return view('dashboard/inventory/colomboinventory')->with(['ldate'=>$ldate,'deli'=>$deli,'dataor'=>$tembarcode,'delise'=>$delise,'item'=>$items]);
}

public function searchinventorycolombo(Request $request){
    $delise = user::get();
    $ldate=$request->delivery_date;
    $deli=$request->delivery_name;

    if(Auth::user()->type=="super_admin"){
        if($request->delivery_name=="all"){
            $items = customer::where('status', '14')->get();
            $data = tempriderbarcode::where('date', $request->delivery_date)->where('status', 0)->get();
        }
        else{
            $items = customer::where('status', '14')->get();
            $data = tempriderbarcode::where('date', $request->delivery_date)->where('status', 0)->where('rider', $request->delivery_name)->get();
        }

    }
    else{
        if($request->delivery_name=="all"){
            $items = customer::where('status', '14')->get();
            $data = tempriderbarcode::where('date', $request->delivery_date)->where('status', 0)->where('branch', Auth::user()->branch)->get();
        }
        else{
            $items = customer::where('status', '14')->get();
            $data = tempriderbarcode::where('date', $request->delivery_date)->where('status', 0)->where('rider', $request->delivery_name)->where('branch', Auth::user()->branch)->get();
        }
    }

    return Response::json($data, 200);
    // return view('dashboard/inventory/colomboinventory')->with(['ldate'=>$ldate,'deli'=>$deli,'dataor'=>$tembarcode,'delise'=>$delise,'item'=>$items]);

}


public function dispatchordersputupdate(Request $request){
    $data = customer::find($request->waybill);
    $checkdeli = customer::where('id', $request->waybill)->first();

    if($request->courierid!=$checkdeli->deliveryservice){
        $dd=1;
        return  Response::json(['status' => $dd], 200);
    }
    else if($request->dispachid == $checkdeli->dispatchid){
        $dd=2;
        return  Response::json(['status' => $dd], 200);
    }
    else if($checkdeli->status != 15){
        $dd=5;
        return  Response::json(['status' => $dd], 200);
    }
    else{
    try{

        $data->status = 8;
        $data->dispatchid = $request->dispachid;
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$request->waybill;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=8;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();

        $cusdata = customer::where('dispatchid', $request->dispachid)->get()->count();
        $disup = dispatchsummary::find($request->dispachid);
        $disup->noofline = $cusdata;
        $disup->save();

        $items2 = cus_orders::where('cus_id', $request->waybill)->get();
        $getqty=0;
        $stock=0;
        foreach($items2 as $item) {
            $productdata=DB::connection('mysql2')->table('order_items')->where('id', $item->orders->pro_id)->get();
            // $productdata = orderItem::where('id', $item->item_id)->get();
            $getqty=$item->qty;
            foreach($productdata as $prodata) {
                $stock=($prodata->stock)-($getqty);   
                $proid=$prodata->id;
                $users = DB::connection('mysql2')->select("update `order_items` set `stock` = '$stock' where id = '$proid' ");
            }
        }

        return  Response::json(['status' => $data], 200);
            
        
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }
}
}


public function dispatchexcelgetdata(Request $request,$id)
{
    if(Auth::user()->type="super_admin"){
        $data = customer::select(['id','pagename', 'name', 'address', 'phone'])->where('dispatchid',3);

    }
    else{
        $data = customer::select(['id','pagename', 'name', 'address', 'phone'])->where('dispatchid',3)->where('branch', Auth::user()->branch);
    }
    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{
        return  Response::json(['status' => $data], 200);
    }

}

public function testchecklistbarcode(Request $request){

    $checkbarcode = productbarcode::where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st1 = productbarcode::where('barcode', $request->barcode)->where('productid', $request->pro_id)->first();
    $st2 = productbarcode::where('itemstatus', 1)->where('barcode', $request->barcode)->get();
    
    if($checkbarcode==null){
        $data="1";
        return  Response::json(['status' => $data], 200);
    }
    else if($st1==null){
        $data="2";
        return  Response::json(['status' => $data], 200);
    }
    else {

            $data = tempriderbarcode::find($request->id);
            $data->barcode = $request->barcode;
            $data->save();

            $range = productbarcode::where('barcode', $request->barcode)->first();
            $range->itemstatus = "1";
            $range->save();

            return  Response::json(['status' => $data], 200);
    }

}

public function inventorytoday2(Request $request){
    $items = customer::where('id', $request->id)->get();
    $prodata = ordersbarcode::where('customerid', $request->id)->get();
    $checkstat = customer::where('id', $request->id)->get()->first();
    $delise = deliveryservice::get();
    
    if($checkstat->status != 13){
        return redirect('/inventorytoday')->with('error', 'Error : The status of this order is not a pack, please check order status');
    }
    else{
    return view('dashboard/inventory/todayinventory2')->with(['cus_id'=>$request->id,'prodata'=>$prodata,'delise'=>$delise,'item'=>$items]);
}
}

public function getbarcodetabledata()
{
    $users = ordersbarcode::select(['id','productid', 'barcode', 'status']);

    return Datatables::of($users)->make(true);
}

public function packingbarcodeupdate(Request $request){

    $checkbarcode=DB::connection('mysql2')->table('productbarcodes')->where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st2 = ordersbarcode::where('status', 0)->where('customerid', $request->id)->orderBy('id', 'asc')->get();
    $st3 = ordersbarcode::where('status', 0)->where('customerid', $request->id)->count();
    // $st1 = productbarcode::where('barcode', $request->barcode)->where('productid', $request->pro_id)->first();
    $checksource = customer::where('id',$request->id)->first();
    if($request->barcode=="dailydeals"){
        if($st3==0){
            if($checksource->ordersource=="Store Pickup"){
                $cusdat = customer::find($request->id);
                $cusdat->status = '18';
                $cusdat->save();

                $statrack = new statustrack;
                $statrack->customerid=$request->id;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=15;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();

                $data="4";
                return  Response::json(['status' => $data], 200);
            }
            else{
                $cusdat = customer::find($request->id);
                $cusdat->status = '15';
                $cusdat->save();

                $statrack = new statustrack;
                $statrack->customerid=$request->id;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=15;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();
        
                $data="4";
                return  Response::json(['status' => $data], 200);
            }

        }
        else{
            $data="5";
            return  Response::json(['status' => $data], 200);
        }

    }
    else if($checkbarcode==null){
        $data="1";
        return  Response::json(['status' => $data], 200);
    }
    else{
    foreach($st2 as $bardata){
        if($bardata->id==null){
            $data="3";
            return  Response::json(['status' => $data], 200);
        }
        else if($checkbarcode->productid == $bardata->ordersbarcodepro->pro_id){

            $data = ordersbarcode::find($bardata->id);
            $data->barcode = $request->barcode;
            $data->status = 1;
            $data->save();
            
            $varco=$request->barcode;
            $users = DB::connection('mysql2')->select("update `productbarcodes` set `itemstatus` = 1 where barcode = '$varco' ");
            // $range = DB::connection('mysql2')->table('productbarcodes')->where('barcode', $request->barcode)->first();
            // $range->itemstatus = 1;
            // $range->save();

            return  Response::json(['status' => $data], 200);
        }
        else{
            $data="2";
            return  Response::json(['status' => $data], 200);
        }
    }
}

}




public function colombopackingupdate(Request $request){

    $checkbarcode = productbarcode::where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st2 = tempriderbarcode::where('status', 0)->where('rider', $request->riderid)->where('date', $request->date)->orderBy('id', 'asc')->get();

    
    if($request->barcode=="wasimart"){
        $data="4";

        return  Response::json(['status' => $data], 200);
    }
    else if($checkbarcode==null){
        $data="1";
        return  Response::json(['status' => $data], 200);
    }
    else{
    foreach($st2 as $bardata){
        if($bardata->id==null){
            $data="3";
            return  Response::json(['status' => $data], 200);
        }
        else if($checkbarcode->productid == $bardata->productid){

            $data = tempriderbarcode::find($bardata->id);
            $data->barcode = $request->barcode;
            $data->status = 1;
            $data->save();

            $range = productbarcode::where('barcode', $request->barcode)->first();
            $range->itemstatus = "1";
            $range->save();

            return  Response::json(['status' => $data], 200);
        }
        else{
            $data="2";
            return  Response::json(['status' => $data], 200);
        }
    }
}

}


// public function getdataprobarcode(Request $request)
// {
//     $users = ordersbarcode::select(['id','productid', 'barcode', 'status'])->where('customerid', $request->id);

//     return Datatables::of($users)->addColumn('action', function($users){
//         $x='';
//         if($users->status=="1"){$x.='<span class="badge badge-success">Barcode Add successfully</span>';}else{$x.='<span class="badge badge-warning">Not Added Barcode</span>';}
//         return ''.$x.'';})
//     ->make(true);
// }

public function getdataprobarcode(Request $request)
{
    $users = ordersbarcode::select(['id','productid', 'barcode', 'status'])->where('customerid', $request->id);

    return Datatables::of($users)->addColumn('productname', function($users){return ''.$users->ordersbarcodepro->pro_name.'';})->addColumn('action', function($users){
        $x='';
        if($users->status=="1"){$x.='<span class="badge badge-success">Barcode Add successfully</span>';}else{$x.='<span class="badge badge-warning">Not Added Barcode</span>';}
        return ''.$x.'';})
    ->make(true);
}

public function getdatatempbarcoderider(Request $request)
{
    $users = tempriderbarcode::select(['id','productid', 'barcode', 'status'])->where('rider', $request->rider)->where('date', $request->date);

    return Datatables::of($users)->addColumn('productname', function($users){return ''.$users->productgetn->name.'';})
    ->addColumn('action', function($users){return '&nbsp;&nbsp;<a class="btn btn-danger btn-xs" data-id="'.$users->id .'"  href="">Delete</a>';})
    ->make(true);
}


public function paymentmethodup(Request $request){
        try{
        $data = customer::find($request->id);
        $data->paymentmethod=$request->payment;
        $data->save();
        return  Response::json(['status' => $data], 200);
        }
        catch (Exception $ex){
            return  Response::json(['status' => false], 423);
        }    
}

public function ordertypeupdate(Request $request){
    try{
    $data = customer::find($request->id);
    if($request->ordertype == 1){
        $items = cus_orders::where('cus_id', $request->id)->get();
        $custds = customer::where('id', $request->id)->get()->first();
    
        $deli=0;
        $unit=0;
        $tot=0;
        $weight=0;
        foreach($items as $item) {
            $unit = ($item->pro_amount)*($item->qty);
            $tot += $unit;
            $weight+=($item->orders->weight)*($item->qty);

            $reprice = sellerproduct::where('id', $item->item_id)->first();
            $reupdat = cus_orders::find($item->id);
            $reupdat->reseller_cost=$reprice->cost;
            $reupdat->save();

        }
        if($weight <= 1){
            $deli=300;
        }
        else if($weight <= 2){
            $deli=350;
        }
        else if($weight <= 3){
            $deli=400;
        }
        else if($weight <= 4){
            $deli=450;
        }
        else if($weight <= 5){
            $deli=500;
        }
        else if($weight <= 6){
            $deli=550;
        }
        else if($weight <= 7){
            $deli=600;
        }
        else if($weight <= 8){
            $deli=650;
        }
        else if($weight <= 9){
            $deli=700;
        }
        else if($weight <= 10){
            $deli=750;
        }
        else if($weight <= 11){
            $deli=800;
        }
        else if($weight <= 12){
            $deli=850;
        }
        else if($weight <= 13){
            $deli=900;
        }
        else if($weight <= 14){
            $deli=950;
        }
        else if($weight <= 15){
            $deli=1000;
        }
        else if($weight <= 16){
            $deli=1050;
        }
        else if($weight <= 17){
            $deli=1100;
        }
        else if($weight <= 18){
            $deli=1150;
        }
        else if($weight <= 19){
            $deli=1200;
        }
        else if($weight <= 20){
            $deli=1250;
        }
    
        $data->cod=$tot+$deli;
        $data->deliverycharge=$deli;
        $data->weight=$weight;
        $data->ordertype=$request->ordertype;
        $data->oldwaybill="-";
        $data->save();
    }
    else if($request->ordertype == 2){
        $items = cus_orders::where('cus_id', $request->id)->get();
        $custds = customer::where('id', $request->id)->get()->first();
    
        $deli=0;
        $unit=0;
        $tot=0;
        $weight=0;
        foreach($items as $item) {
            $unit = ($item->pro_amount)*($item->qty);
            $tot += $unit;
            $weight+=($item->orders->weight)*($item->qty);

            $reupdat = cus_orders::find($item->id);
            $reupdat->reseller_cost=0;
            $reupdat->save();
        }
        if($weight <= 1){
            $deli=300;
        }
        else if($weight <= 2){
            $deli=350;
        }
        else if($weight <= 3){
            $deli=400;
        }
        else if($weight <= 4){
            $deli=450;
        }
        else if($weight <= 5){
            $deli=500;
        }
        else if($weight <= 6){
            $deli=550;
        }
        else if($weight <= 7){
            $deli=600;
        }
        else if($weight <= 8){
            $deli=650;
        }
        else if($weight <= 9){
            $deli=700;
        }
        else if($weight <= 10){
            $deli=750;
        }
        else if($weight <= 11){
            $deli=800;
        }
        else if($weight <= 12){
            $deli=850;
        }
        else if($weight <= 13){
            $deli=900;
        }
        else if($weight <= 14){
            $deli=950;
        }
        else if($weight <= 15){
            $deli=1000;
        }
        else if($weight <= 16){
            $deli=1050;
        }
        else if($weight <= 17){
            $deli=1100;
        }
        else if($weight <= 18){
            $deli=1150;
        }
        else if($weight <= 19){
            $deli=1200;
        }
        else if($weight <= 20){
            $deli=1250;
        }
    
        $data->cod=$tot+$deli;
        $data->deliverycharge=$deli;
        $data->weight=$weight;
        $data->ordertype=$request->ordertype;
        $data->oldwaybill=$request->oldwaybill;
        $data->save();
    }
    else if($request->ordertype == 3){
        $items = cus_orders::where('cus_id', $request->id)->get();
        $custds = customer::where('id', $request->id)->get()->first();
    
        $deli=0;
        $unit=0;
        $tot=0;
        $weight=0;
        foreach($items as $item) {
            $unit = ($item->pro_amount)*($item->qty);
            $tot += $unit;
            $weight+=($item->orders->weight)*($item->qty);

            $reupdat = cus_orders::find($item->id);
            $reupdat->reseller_cost=0;
            $reupdat->save();
        }
        $data->cod=$tot+$deli;
        $data->weight=$weight;
        $data->deliverycharge=0;
        $data->ordertype=$request->ordertype;
        $data->oldwaybill=$request->oldwaybill;
        $data->save();
    }

    return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }    
}

public function colombodelivery(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $deli="all";

    $delise = user::get();

    return view('dashboard/accounts/cmbodelivery')->with(['ldate'=>$ldate,'deli'=>$deli,'delise'=>$delise]);
}
public function paymentrecovecolomboserch(Request $request){

    $delise = user::get();

    $ldate=$request->delivery_date;
    $deli=$request->delivery_name;
    $tcod=0;
    $riderdelivery=0;
    $noofline=0;
    $maxcoun=0;
    $mincoun=0;

            $items = customer::where('ridername', $deli)->where('deliverydate', $ldate)->where('moneyrecivestatus', 1)->get();
            $noofline=$items->count();
            foreach($items as $idata){
                $tcod+=$idata->cod;
                $riderdelivery+=$idata->riderdelivery;
            }
    $ridern = user::where('id',$request->delivery_name)->first();


    return view('dashboard/accounts/cmbodelivery2')->with(['maxcoun'=>$maxcoun,'mincoun'=>$mincoun,'riderns'=>$ridern,'riderdelivery'=>$riderdelivery,'noofline'=>$noofline,'tcod'=>$tcod,'ldate'=>$ldate,'deli'=>$deli,'delise'=>$delise,'item'=>$items]);
}

public function getpayblecod(Request $request)
{
    $tcod=0;
    $riderdelivery=0;
    $noofline=0;
        $users = customer::select(['id','cod','status'])->where('ridername', $request->rider)->where('deliverydate', $request->date)->where('moneyrecivestatus', 1);

            $items = customer::where('ridername', $request->rider)->where('deliverydate', $request->date)->where('moneyrecivestatus', 1)->get();
            $noofline =$items->count();
            $riderdelivery= $noofline*200;

            foreach($items as $idata){
                $tcod+=$idata->cod;
            }

    return Datatables::of($users)->addColumn('data1', function($users){
    $x='';
    foreach($users as $idata){$x=($tcod+=$idata->cod);}
    return ''.$x.'';})->make(true);
}

public function getcusdatatoacc(Request $request)
{
    $users = customer::select(['id','name', 'phone','tracking','cod','status','deliverystatus','riderdelivery'])->where('ridername', $request->rider)->where('deliverydate', $request->date);

    return Datatables::of($users)->addColumn('action', function($users){
        return
        '&nbsp;&nbsp;<button type="button" data-id="'.$users->id .'" data-riderdelivery="'.$users->riderdelivery .'"  data-status="'.$users->status.'" class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodel">Edit</button>'.
        '&nbsp;&nbsp;<button type="button" data-id="'.$users->id .'" class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodelbarcode">Add Barcode</button>'.
        '&nbsp;&nbsp;<a data-id="'.$users->id.'" target="_blank" class="btn btn-primary btn-xs" href="viewallorders/'.$users->id.'">View</a>';})
    ->make(true);
}

public function accountcolombostatusupdate(Request $request){
    $sta = $request->has('recivemon');

    $cus_id = $request->input('id');
    $riderdelivery = $request->input('riderdelivery');

    $data = customer::find($cus_id);

    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        $data->riderdelivery = $riderdelivery;
        $data->save();
        if($sta=="true"){
            $data->status = 9;
            $data->moneyrecivestatus = 1;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=9;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();    
            
        }
        else{
            $data->status = 8;
            $data->moneyrecivestatus = 0;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=8;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

         }
        
        return  Response::json(['status' => $data], 200);
   } 
}

public function getbarcodecustomer(Request $request,$id){
    $data = ordersbarcode::with('ordersbarcodepro')->where('customerid', $id)->get();

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{

        return  Response::json(['status' => $data], 200);
   }
}

public function accountbarcodeupdate(Request $request){
$datas=$request->id;

    if($datas==null){
        return  Response::json(['status' => false], 423);
   }else{
        for($i=0; $i<count($request->id); $i++){

            $data = ordersbarcode::find($request->id[$i]);
            $data->barcode = $request->barcode[$i];
            $data->save();

        }

        return  Response::json(['status' => $data], 200);
   } 
}

// public function allordersserach(Request $request){
//     list($da1, $da2) = explode('-', $request->daterange);
//     $date1 = str_replace('/', '-', $da1);
//     $date2 = str_replace('/', '-', $da2);
//     $date11 = $date1.'00:00:00';
//     $date22 = $date2.' 23:59:59';
//     $items = customer::whereBetween('created_at', [$date11, $date22])->get();

//     if (!empty($request->DeliveryPartner)) {
//         $items = $items->whereIn('deliveryservice', $request->DeliveryPartner);
//     }
//     else{
//         $request->DeliveryPartner="a";
//     }
    
//     if(!empty($request->OrderSource)){
//         $items = $items->whereIn('ordersource', $request->OrderSource);
//     }
//     else{
//         $request->OrderSource="a";
//     }
//     if(!empty($request->PaymentMode)){
//         $items = $items->whereIn('paymentmethod', $request->PaymentMode);
//     }
//     else{
//         $request->PaymentMode="a";
//     }
//     if(!empty($request->OrderStatus)){
//         $items = $items->whereIn('status', $request->OrderStatus);
//     }
//     else{
//         $request->OrderStatus="a";
//     }
//     if(!empty($request->DeliveryRider)){
//         $items = $items->whereIn('ridername', $request->DeliveryRider);
//     }
//     else{
//         $request->DeliveryRider="a";
//     }
//     if(!empty($request->Branch)){
//         $items = $items->whereIn('branch', $request->Branch);
//     }
//     else{
//         $request->Branch="a";
//     }

    
//     $cuso = cus_orders::get();
//     $del = deliveryservice::get();
//     $delise = user::get();

//     return view('dashboard/orders/allorders2')->with(['DeliveryPartner'=>$request->DeliveryPartner,'OrderSource'=>$request->OrderSource,'PaymentMode'=>$request->PaymentMode,'OrderStatus'=>$request->OrderStatus,'DeliveryRider'=>$request->DeliveryRider,'Branch'=>$request->Branch,'drange'=>$request->daterange, 'delise'=>$delise,'cuso'=>$cuso,'item'=>$items, 'del'=>$del]);
// }


public function allordercustomertable(Request $request)
{
    list($da1, $da2) = explode('-', $request->daterange);
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da2);
    $date11 = $date1.'00:00:00';
    $date22 = $date2.' 23:59:59';

$items =  customer::select('id','user','name','address','phone','tracking','cod','status','deliveryservice','paymentmethod','ridername','deliverystatus')
->wherein('status',[5,6,7,8,9,11,12,13,14,15,17,18,33,34,35,36,32])->whereBetween('updated_at', [$date11, $date22])->groupBy('id');

    if (!empty($request->DeliveryPartner)) {
        $items = $items->whereIn('deliveryservice', $request->DeliveryPartner);
    }
    else{
        
    }
    
    if(!empty($request->reseller)){
        $items = $items->whereIn('user', $request->reseller);
    }
    else{
       
    }
    if(!empty($request->OrderStatus)){
        $items = $items->whereIn('status', $request->OrderStatus);
    }
    else{
        
    }
    if(!empty($request->DeliveryRider)){
        $items = $items->whereIn('ridername', $request->DeliveryRider);
    }
    else{
        
    }

    if(!empty($request->phone)){
        $items = customer::select(['id','name','address', 'phone','tracking','cod','status']);
        $items = $items->orWhere('phone', 'like', '%'.$request->phone.'%');
    }
    else{
       
    }
    if(!empty($request->invoice)){
        $items = customer::select(['id','name','address', 'phone','tracking','cod','status']);
        $items = $items->orWhere('id', 'like', '%'.$request->invoice.'%');
    }
    else{
       
    }

    if(!empty($request->returnauth)){
        $items = $items->wherein('deliverystatus', $request->returnauth);
    }
    else{
       
    }

    return Datatables::of($items)->addColumn('productname', function($items){
        $y=[];
        foreach($items->cus_or as $data){$y[]=$data->orders->pro_name;}$da=implode(', ', $y);
        return ''.$da.''; })->addColumn('action', function($items){
        $xy='';
        if($items->status== 0 OR $items->status == 1 OR $items->status == 2 OR  $items->status == 3  OR $items->status == 4 OR  $items->status == 5  OR $items->status == 6 OR $items->status == 11 OR $items->status == 12 OR $items->status == 13 OR $items->status == 19 OR $items->status == 16 OR $items->status == 17 OR $items->status == 26 OR $items->status == 27 OR $items->status == 28){
          $xy='<a data-id="'.$items->id .'"  target="_blank" class="btn btn-primary btn-xs" href="viwedetails/'.$items->id .'">View</a>';  
        }else{$xy='<a data-id="'.$items->id .'"  target="_blank" class="btn btn-primary btn-xs" href="viewallorders/'.$items->id .'">View</a>';}
            return ''.$xy.'';})
    ->make(true);
}

public function primaryphoneupdate(Request $request){
        try{
        $id = $request->id;
        $data = customer::find($id);
        $data->phone=$request->phone;
        $data->save();

        return  Response::json(['status' => $data], 200);
        }
        catch (Exception $ex){
            return  Response::json(['status' => false], 423);
        }    
}

public function secondaryphoneupdate(Request $request){
    try{
    $id = $request->id;
    $data = customer::find($id);
    $data->secondaryphone=$request->secondary;
    $data->save();

    return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }    
}
public function cityupdate(Request $request){
    $data = customer::find($request->id);
    $trac = trancecity::where('id', $request->cituselect)->first();
    $cusdata = citylist::where('city', $trac->city_name)->first();
   
    // cituselect
    try{
        if($cusdata != null){
            $data->city = $cusdata->id;
            $data->save();
        }
 
        $data->tracecity = $request->cituselect;
        $data->district = $trac->distric_name;
        $data->save();
        $dd=$trac->distric_name;
        return  Response::json(['status' => $dd], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }   
}

public function fardercityupdate(Request $request){
    $data = customer::find($request->id);
    try{

        $data->confirmuser = $request->fardercituselect;
        $data->save();
        return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }   
}
public function colomboassign(){
 
    $items = customer::where('status', '12')->get();

    $delise = user::get();
    $deli="all";
    return view('dashboard/shipping/colomboassign')->with(['deli'=>$deli,'delise'=>$delise,'item'=>$items]);
}
public function colomboprintfilter(Request $request){
    $items = customer::where('status', '40')->where('ridername', $request->delivery_name)->get();

    $deli = $request->delivery_name;
    $delise = user::get();
    return view('dashboard/shipping/colomboprint2')->with(['deli'=>$deli, 'delise'=>$delise,'item'=>$items]);

}
public function colomboassignfilter(Request $request){
    $items = customer::where('status', '12')->where('ridername', $request->delivery_name)->get();

    $deli = $request->delivery_name;
    $delise = user::get();
    return view('dashboard/shipping/colomboassign2')->with(['deli'=>$deli, 'delise'=>$delise,'item'=>$items]);

}

public function printstatuschangecolombo(Request $request){
    $ldate = date('Y/m/d');

    if($request->oldprint=="oldprint"){

        $cus = customer::with('cus_or')->where('ridername', $request->delivery_name)->where('status', 8)->get();
        $user = user::where('id', $request->delivery_name)->get();
    
        $ldate = date('Y/m/d');
    
        foreach($cus as $cusodata){
                $data = customer::find($cusodata->id);
                $data->deliverydate = $ldate;
                $data->save();
           }
           $dis=1;
    
        $pdf = PDF::loadView('dashboard.shipping.colombopdf', array('dis'=>$dis,'cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a4', 'landscape');
      return $pdf->stream(); 
    
    }
    $checid = $request->checkids;
    $cbCount = count($checid);
    if($cbCount==0){
        return redirect('/colomboprint')->with('error', 'No select Orders');
    }
    else{
    if($request->sendpacking=="sendpacking"){
        try{
        //     $cus = customer::with('cus_or')->where('status', '12')->where('ridername', $request->delivery_name)->get();
        //     foreach($cus as $checiddata){
        //             $getdate = $checiddata->deliverydate;
        //        }

        //     $dataor2 =  customer::select('cus_orders.item_id','order_items.name','order_items.image as img', DB::raw("SUM(cus_orders.qty) as qty"))
        //     ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
        //     ->join('order_items', 'order_items.id', '=' , 'cus_orders.item_id');            
            
        //     $dataor2= $dataor2->wherein('customers.id', $checid)->groupBy('cus_orders.item_id')->get();
        //     $ddate = date('Y/m/d'); 
        //     foreach($dataor2 as $dataordata){
        //         for($i=0; $i<$dataordata->qty; $i++){
        //             $tempbar = new tempriderbarcode;
        //             $tempbar->productid = $dataordata->item_id;
        //             $tempbar->rider = $request->delivery_name;
        //             $tempbar->date = $ddate;
        //             $tempbar->barcode = '-';
        //             $tempbar->status = '0';
        //             $tempbar->save();
        //         }
        // }
        $ldate = date('Y/m/d');

            foreach($checid as $checiddata){
                    $data = customer::find($checiddata);
                    $data->status = 14;
                    $data->print = 1;
                    $data->deliverydate = $ldate;
                    $data->save();

                    $statrack = new statustrack;
                    $statrack->customerid=$checiddata;
                    $statrack->username=Auth::user()->name;
                    $statrack->orderstatus=14;
                    $statrack->starttime=0;
                    $statrack->endtime=0;
                    $statrack->status=0;
                    $statrack->save();
               }

      
            return redirect('/colomboprint')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/colomboprint')->with('error', 'Error : '.$ex->getMessage());
            }

    }
    else if($request->sendprint=="sendprint"){
        try{

        $ldate = date('Y/m/d');

            foreach($checid as $checiddata){
                    $data = customer::find($checiddata);
                    $data->status = 40;
                    $data->deliverydate = $ldate;
                    $data->save();

                    $statrack = new statustrack;
                    $statrack->customerid=$checiddata;
                    $statrack->username=Auth::user()->name;
                    $statrack->orderstatus=40;
                    $statrack->starttime=0;
                    $statrack->endtime=0;
                    $statrack->status=0;
                    $statrack->save();
               }

      
               return redirect('/colomboassign')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/colomboassign')->with('error', 'Error : '.$ex->getMessage());
        }

    }
    else if($request->pdfprint=="pdfprint"){

        foreach($checid as $checiddata){
            $data = customer::find($checiddata);
            $data->print = '1';
            $data->save();
       }

        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->wherein('id', $checid)->get();
        $user = user::where('id', $request->delivery_name)->get();
        $prod = DB::connection('mysql2')->select('select * from order_items');
        $pdf = PDF::loadView('dashboard.shipping.colombopdf', array('prod'=>$prod,'cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a5', 'landscape');
      return $pdf->stream(); 
    }
    else if($request->check=="check"){

        $ldate = date('Y-m-d H:i:s');
        $cus = customer::with('cus_or')->where('status', '12')->get();
    
        $dataor =  customer::select('cus_orders.item_id','sellerproducts.pro_name', DB::raw("SUM(cus_orders.qty) as qty"))
        ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
        ->join('sellerproducts', 'sellerproducts.id', '=' , 'cus_orders.item_id');

        $dataor=$dataor->wherein('customers.id',$checid)->groupBy('cus_orders.item_id')->get();
        
        $pdf = PDF::loadView('dashboard.shipping.allitempdf', array('data'=>$dataor,'cus'=>$cus,'ldate'=> $ldate));
      return $pdf->stream(); 
    }

    else if($request->invoicepdf=="invoicepdf"){
        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->wherein('id', $checid)->get();
    
        $pdf = PDF::loadView('dashboard.shipping.colomboinvoice', array('cus'=>$cus,'ldate'=> $ldate))->setPaper('a4');
      return $pdf->stream(); 

    }
    else if($request->ebay=="ebay"){
        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->wherein('id', $checid)->get();
        $customPaper = array(0,0,432.00,288.00);
        $pdf = PDF::loadView('dashboard.shipping.ebaypdf2', array('cus'=>$cus,'ldate'=> $ldate))->setPaper($customPaper, 'landscape');
      return $pdf->stream(); 
    
    
}
    else{
        return redirect('/colomboprint')->with('error', 'No Action');
    }
}
}
public function checklist(){

    $del = deliveryservice::get();
    $delise = resellerdetails::get();
    $product = DB::connection('mysql2')->select('select * from order_items');

    return view('dashboard/reports/checklist')->with(['product'=>$product,'delise'=>$delise, 'del'=>$del]);
}
public function checklistfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $ldate = date('Y-m-d');

  $items =  customer::select('customers.id','customers.name','customers.address','customers.phone','customers.tracking','customers.cod','customers.status','customers.branch' ,'cus_orders.item_id','sellerproducts.pro_id','sellerproducts.pro_name', DB::raw("SUM(cus_orders.qty) as qty"))
  ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
  ->join('sellerproducts', 'sellerproducts.id', '=' , 'cus_orders.item_id')->whereBetween('customers.updated_at', [$da, $da2]);



  if (!empty($request->DeliveryPartner)) {
    $items = $items->whereIn('customers.deliveryservice', $request->DeliveryPartner);
}
else{
    
}

if(!empty($request->PaymentMode)){
    $items = $items->whereIn('customers.paymentmethod', $request->PaymentMode);
}
else{
   
}
if(!empty($request->OrderStatus)){
    $items = $items->whereIn('customers.status', $request->OrderStatus);
}
else{
    
}
if(!empty($request->DeliveryRider)){
    $items = $items->whereIn('customers.user', $request->DeliveryRider);
}
else{
    
}

if(!empty($request->productname)){

    $items = $items->wherein('sellerproducts.pro_id', $request->productname);

}
else{
   
}
if(!empty($request->returnauth)){
    $items = $items->wherein('customers.deliverystatus', $request->returnauth);
}
else{
   
}

$items=$items->groupBy('sellerproducts.pro_id')->orderBy('qty', 'desc')->get();

  $pdf = PDF::loadView('dashboard.reports.allitempdf', array('data'=>$items,'ldate'=> $ldate));
  return $pdf->stream(); 
}


public function searchcolomboprint(Request $request){

    $items = customer::where('status', '12')->where('ridername', $request->delivery_name)->get();

    $deli = $request->delivery_name;
    $delise = user::get();
    return view('dashboard/shipping/colomboprint')->with(['deli'=>$deli, 'delise'=>$delise,'item'=>$items]);
}

public function searchoutprint(Request $request){

    $items = customer::where('status', '11')->where('deliveryservice', $request->delivery_name)->get();
    
    $deli = $request->delivery_name;
    $delise = deliveryservice::get();
    return view('dashboard/shipping/todayprint2')->with(['deli'=>$deli, 'delise'=>$delise,'item'=>$items]);
}

public function printstatuschange(Request $request){
    $checid = $request->checkids;
    $cbCount = count($checid);
    if($cbCount==0){
        return redirect('/todayprint')->with('error', 'No select Orders');
    }
    else{
        if($request->packing=="packing"){
    try{
        foreach($checid as $checiddata){

                $data = customer::find($checiddata);
                $data->status = '13';
                $data->print = '1';
                $data->save();

                $statrack = new statustrack;
                $statrack->customerid=$checiddata;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=13;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();
           }
  
        return redirect('/todayprint')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/todayprint')->with('error', 'Error : '.$ex->getMessage());
        }

    }
    else if($request->invoice=="invoice"){
        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->wherein('id', $checid)->get();
        $user = deliveryservice::where('id', $request->deliveryname)->get();
        $prod = DB::connection('mysql2')->select('select * from order_items');
        $pdf = PDF::loadView('dashboard.shipping.todayprintpdf', array('prod'=>$prod,'cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a4');
      return $pdf->stream(); 
    
    }
    else if($request->ebay=="ebay"){
        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->wherein('id', $checid)->get();
        $user = deliveryservice::where('id', $request->deliveryname)->get();
        $customPaper = array(0,0,432.00,288.00);
        $pdf = PDF::loadView('dashboard.shipping.ebaypdf', array('cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper($customPaper, 'landscape');
      return $pdf->stream(); 
    
    }
    else if($request->checklist=="checklist"){
        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->where('status', '11')->get();
    
        $dataor =  customer::select('customers.id','cus_orders.item_id','sellerproducts.pro_name', DB::raw("SUM(cus_orders.qty) as qty"))
        ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
        ->join('sellerproducts', 'sellerproducts.id', '=' , 'cus_orders.item_id');

        $dataor=$dataor->wherein('customers.id',$checid)->groupBy('cus_orders.item_id')->get();
 
        
        $pdf = PDF::loadView('dashboard.shipping.allitempdf', array('data'=>$dataor,'cus'=>$cus,'ldate'=> $ldate));
      return $pdf->stream(); 
    }

    else if($request->Excel=="Excel"){
        $ldate = date('Y-m-d');
        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=invoice-$ldate.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::with('cus_or')->select(["id","user","deliveryservice", "name", "address","pageName","deliverycharge", "phone","secondaryphone", "cod","tracking","district","paymentmethod","city","note","ordertype"])->wherein('id',$checid)->get();
        $columns = array('Inv No', 'Issue Date', 'Delivery Partner', 'Tracking No','Online Store', 'Address','Telephone','Cus Name','Cus Address','Cus Phone No','Nearst City','District','Item','total','Del Charge','Total COD');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);           
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name.' X '.$cusitems->qty;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                   $cod=0;
                   $net=0;
                   $del=0;
                   if($review->paymentmethod=="paid" OR $review->ordertype==2){
                       $cod=0.00;
                       $net=0.00;
                       $del=0.00;
                   }else{
                       $cod=$review->cod;
                       $del=$review->deliverycharge;
                   }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->id,$review->updated_at, $review->deliveryse->deliveryname,$review->tracking,$review->pageName,$review->getpage2->address,$review->getpage2->phone, $review->name,$review->address,$ph,$review->getcity->city, $review->district,$da,$cod-$del,$del,$cod ));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);

    }


    }
}

public function colombocustomerdataget(Request $request)
{
$users = customer::select(['id','pagename', 'name', 'address', 'phone','lockstatus','cod','lockuser'])->where('ridername',$request->delivery_name)->where('deliverydate',$request->delivery_date);
 
    return Datatables::of($users)->addColumn('productname', function($users){
        $y='';
        foreach($users->cus_or as $data){$y[]=$data->orders->name;}$da=implode(', ', $y);
        return ''.$da.''; })->addColumn('action', function($users){ return 
            '<a data-id="'.$users->id.'" class="btn btn-dark btn-xs returncustomer" >Cancel</a>'
            .'&nbsp;&nbsp;<a data-id="'.$users->id.'" target="_blank" class="btn btn-primary btn-xs" href="viwedetails/'.$users->id.'">View</a>';})
    ->make(true);
}

public function deletetempbarcode(Request $request,$id){
    $data = tempriderbarcode::find($id);
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
    $data = tempriderbarcode::where('id',$id)->first();
    if($data->barcode == '-'){
        $data->delete();
    }
    else{
        $barc = productbarcode::where('barcode', $data->barcode)->first();
        $barc->itemstatus=0;
        $barc->save();
    
            $data->delete();
    }
    

               return  Response::json([
        'status' => $data
    ], 200);
   }
}


public function returncustomertembar(Request $request,$id){
    $data = customer::find($id);
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->status='10';
        $data->ridername='-';
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=10;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}


public function deliverydate(Request $request){
    $data = customer::find($request->id);
    try{

        $data->deliverydate = $request->delivery_date;
        $data->save();
    
        return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }  
}

public function courierpayment(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $cuso = courierrecivemoney::get();
    $delise = deliveryservice::get();

    return view('dashboard/accounts/courierpayment')->with(['ldate'=>$ldate,'delise'=>$delise,'cuso'=>$cuso]);
}

public function addcourierpayment(Request $request){
    try{
        $data = new courierrecivemoney();

        $data->deliverycompany = $request->delivery_name;
        $data->courierpaymentid = $request->payid;
        $data->bank = "-";
        $data->codamount = $request->cod_amount;
        $data->deliverycharge = $request->deliverycharge;
        $data->payablecod = $request->payableamount;
        $data->status = '0';
        $data->paidat = $request->paid_date;
        $data->user = Auth::user()->name;
        $data->save();
 
        return redirect('/courierpayment')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/courierpayment')->with('error', 'Error : '.$ex->getMessage());
        }
}
public function courierpaymentupdate(Request $request){
    try{
        $data = courierrecivemoney::find($request->id);
        $sta = $request->has('paidstatus');

        $data->deliverycompany = $request->delivery_name2;
        $data->courierpaymentid = $request->payid;
        $data->bank = "-";
        $data->codamount = $request->cod_amount;
        $data->deliverycharge = $request->deliverycharge;
        $data->payablecod = $request->payableamount;
        $data->paidat = $request->paid_date;
        $data->save();

        if($sta=="true"){
            $data->status = '1';
            $data->save();
        }
        else{
            $data->status = '0';
            $data->save();
         }
 
        return redirect('/courierpayment')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/courierpayment')->with('error', 'Error : '.$ex->getMessage());
        }
}

public function deletecourierrecivemoney(Request $request,$id){
    $data = courierrecivemoney::find($id);

   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}

public function receivedetails(Request $request,$id){
    $purces = customer::where('courierreciveid', $id)->get();
    return view('dashboard/accounts/courierpayment2',['sumid'=>$id, 'item'=>$purces]);
}

public function importcouriersummary(Request $request){

		if($request->hasFile('import_file')){
			$path = $request->file('import_file')->getRealPath();
			$data = Excel::load($path, function($reader) {})->get();

			if(!empty($data) && $data->count()){
				foreach ($data->toArray() as $key => $value) {  
                        $gettac = customer::where('tracking',$value['waybill'])->get();
                        foreach($gettac as $trackd){
                            $updatecus = customer::find($trackd->id);
                            $updatecus->status='9';
                            $updatecus->moneyrecivestatus='1';
                            $updatecus->courierreciveid=$request->summeryid;
                            $updatecus->save();

                            $statrack = new statustrack;
                            $statrack->customerid=$trackd->id;
                            $statrack->username=Auth::user()->name;
                            $statrack->orderstatus=9;
                            $statrack->starttime=0;
                            $statrack->endtime=0;
                            $statrack->status=0;
                            $statrack->save();

                        }

          	}

				if(!empty($value)){
                    return back()->with('success','Insert Record successfully.');
                    
                }
			}
		}
		return back()->with('error','Please Check your file, Something is wrong there.');
    }

    public function closewindow(){    
        return view('dashboard/shipping/closewindow');
    }

    public function todayconfirmsearch(Request $request){
            $items = customer::where('status', '6')->where('branch', $request->branch)->get();
       
        $delise = deliveryservice::get();
        $bradata = branch::get();
        return view('dashboard/shipping/todayconfirm2')->with(['branch'=>$request->branch,'delise'=>$delise,'item'=>$items,'bradata'=>$bradata]);
    }

    public function wholesale(){
        $datas = wholesalecustomer::get();
        $bankd = companybank::get();
        return view('dashboard/product/addwholesale',['bankd'=>$bankd,'item'=>$datas]);
    }

    public function regwholesaler(Request $request){
        $data = new wholesalecustomer();
        try{
    
        $data->name = $request->Name;
        $data->address = $request->Address;
        $data->phone = $request->Phone_Number;
        $data->balance = 0;
        $data->save();
    
        return redirect('/wholesale')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/wholesale')->with('error', 'Error : '.$ex->getMessage());
        }
    }
    public function deletewholesaller(Request $request,$id){

        $data = wholesalecustomer::find($id);
       if($data==null){
            return  Response::json([
                'status' => false
            ], 423);
       }else{
            $data->delete();
    
                   return  Response::json([
            'status' => $data
        ], 200);
       }
    }
    public function wholesallerupdate(Request $request){
        $data = wholesalecustomer::find($request->id);
    
        try{
            $data->name = $request->Name;
            $data->address = $request->Address;
            $data->phone = $request->Phone_Number;
            $data->save();
    
            return redirect('/wholesale')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/wholesale')->with('error', 'Error : '.$ex->getMessage());
            }
    }

    public function addwholesale(){
        $ldate = date('Y-m-d H:i:s');

        $datas = wholesalecustomer::get();
        $products = orderItem::get();
        $purces = wholesale::get();
        $bankd = companybank::get();
        return view('dashboard/accounts/addwholesale',['bankd'=>$bankd,'ldate'=>$ldate,'item'=>$datas, 'product'=>$products, 'purce'=>$purces]);
    }
    public function accountswholesale(){
        $ldate = date('Y-m-d H:i:s');

        $datas = wholesalecustomer::get();
        $products = orderItem::get();
        $purces = wholesale::get();
        $bankd = companybank::get();
        return view('dashboard/accounts/accountswholesale',['bankd'=>$bankd,'ldate'=>$ldate,'item'=>$datas, 'product'=>$products, 'purce'=>$purces]);
    }
    

public function addwholesalepro(Request $request){

    $array = array_merge($request->pro,$request->qty,$request->unit,$request->tot);

    $data = new wholesale();
    

    try{
        $data->wholesaleuserid = $request->supplier_name;
        $data->total = $request->nettotal;
        $data->amountpaid = 0;
        $data->status = "0";
        $data->orderstatus = "0";
        $data->save();

        $getbalance = wholesalecustomer::where('id',$request->supplier_name)->first();

        $supupd = wholesalecustomer::find($request->supplier_name);
        $supupd->balance = floatval($request->nettotal)+floatval($getbalance->balance);
        $supupd->save();


        for($i=0; $i<count($request->pro); $i++){
            $dataprod = new wholesalebuyproduct();

            $dataprod->productid = $request->pro[$i];
            $dataprod->reciptid = $data->id;
            $dataprod->qty = $request->qty[$i];
            $dataprod->unitprice = $request->unit[$i];
            $dataprod->save();

            for($j=0; $j<$request->qty[$i]; $j++){
                $addbarcode=new wholesalebarcode;
                $addbarcode->wholsalecusid=$data->id;
                $addbarcode->wholebyrproid=$dataprod->id;
                $addbarcode->productid=$request->pro[$i];
                $addbarcode->barcode='-';
                $addbarcode->status='0';
                $addbarcode->save();
            }

            $products = orderItem::where('id',$request->pro[$i])->get();
            
            foreach($products as $dd){
                $oitem = orderItem::find($request->pro[$i]);
                $oitem->stock = $dd->stock-$request->qty[$i];
                $oitem->save();
            }
        }
        

    
    return redirect('/addwholesale')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/addwholesale')->with('error', 'Error : '.$ex->getMessage());
    }
}

    public function addwholsalerupdate(Request $request){
        $data = wholesale::find($request->id);
        $sta = $request->has('paidstatus');
        try{
            $bala=floatval($request->total)-floatval($request->cost);
            if($bala==0){
                if($sta=="true"){
                    $data->status = '1';
                    $data->save();
                }
                else{
                    $data->status = '0';
                    $data->save();
                    }

                    return redirect('/accountswholesale')->with('success', 'Successfully Saved!');


            }else{
                return redirect('/accountswholesale')->with('error', 'Balance Shoude be 0.00');
            }

            
                }
            catch (Exception $ex){
                return redirect('accountswholesale')->with('error', 'Error : '.$ex->getMessage());
            }
    }

// public function addwholsalerupdate(Request $request){
//         $data = wholesale::find($request->id);
//         $sta = $request->has('paidstatus');
//         try{
    
//             if($request->payment=="cash"){
//                 $data->wholesaleuserid = $request->supplier_name;
//                 $data->paymentmethod = $request->payment;
//                 $data->paiddate = $request->paid_date;
//                 $data->ccdate = "-";
//                 $data->amountpaid = $request->cost;
//                 $data->bankid = $request->bank;
//                 $data->save();
//                 if($sta=="true"){
//                     $balancedata = floatval($request->total)-floatval($request->cost);
//                     $bankto = companybank::where('id',$request->bank)->first();

//                     $bandata = new banktransaction();
//                     $bandata->user = Auth::user()->name;
//                     $bandata->bankid = $request->bank;
//                     $bandata->withdrawal = 0;
//                     $bandata->deposit = $balancedata;
//                     $bandata->balance = floatval($bankto->balance)+floatval($balancedata);
//                     $bandata->note = $request->wholsesalename.' wholesale-paid-full-amount';
//                     $bandata->accoption = '-';
//                     $bandata->save();
            
//                     $oitem2 = companybank::find($request->bank);
//                     $oitem2->balance = floatval($bankto->balance)-floatval($balancedata);
//                     $oitem2->save();

//                     $data->amountpaid = floatval($request->cost)+$balancedata;
//                     $data->status = '1';
//                     $data->save();
//                 }
//                 else{
//                     $data->status = '0';
//                     $data->save();
//                  }
//             }
//             else{
//             $data->wholesaleuserid = $request->supplier_name;
//             $data->paymentmethod = $request->payment;
//             $data->paiddate = '-';
//             $data->ccdate = $request->paid_date;
//             $data->amountpaid = $request->cost;
//             $data->bankid = $request->bank;
//             $data->save();
//             if($sta=="true"){

//                 $balancedata = floatval($request->total)-floatval($request->cost);
//                 $bankto = companybank::where('id',$request->bank)->first();

//                 $bandata = new banktransaction();
//                 $bandata->user = Auth::user()->name;
//                 $bandata->bankid = $request->bank;
//                 $bandata->withdrawal = 0;
//                 $bandata->deposit = $balancedata;
//                 $bandata->balance = floatval($bankto->balance)+floatval($balancedata);
//                 $bandata->note = $request->wholsesalename.' wholesale-paid-full-amount';
//                 $bandata->accoption = '-';
//                 $bandata->save();
        
//                 $oitem2 = companybank::find($request->bank);
//                 $oitem2->balance = floatval($bankto->balance)-floatval($balancedata);
//                 $oitem2->save();

//                 $data->amountpaid = floatval($request->cost)+$balancedata;
//                 $data->status = '1';
//                 $data->paiddate =$request->paid_date;
//                 // $data->ccdate ='-';
//                 $data->save();
//             }
//             else{
//                 $data->status = '0';
//                 $data->save();
//              }
//             }
    
//             return redirect('/accountswholesale')->with('success', 'Successfully Saved!');
//                 }
//             catch (Exception $ex){
//                 return redirect('accountswholesale')->with('error', 'Error : '.$ex->getMessage());
//             }
//     }




    public function wholesalerprodetails(Request $request,$id){
        $datas = wholesalecustomer::get();
        $products = orderItem::get();
        $whol = wholesale::where('id',$id)->get();
        $purces = wholesalebuyproduct::where('reciptid', $id)->get();
        $paidp = wholesalepayemet::where('paymentid', $id)->get();
        $bank = companybank::get();
        $ldate = date('Y-m-d H:i:s');

        return view('dashboard/accounts/wholesaleproductdetails',['ldate'=>$ldate,'bank'=>$bank,'paidp'=>$paidp,'item'=>$datas, 'whol'=>$whol, 'purce'=>$purces]);
    }

public function wholesalereciptprint(Request $request){
    $ldate = date('Y-m-d');
    $cus = wholesale::where('id', $request->wholeid)->get();
    $prod = wholesalebuyproduct::where('reciptid', $request->wholeid)->get();
    $paidp = wholesalepayemet::where('paymentid', $request->wholeid)->get();


    $pdf = PDF::loadView('dashboard.accounts.wholesaleinvoice', array('paidp'=>$paidp,'cus'=>$cus,'ldate'=> $ldate,'prod'=> $prod))->setPaper('a4');
  return $pdf->stream(); 
}


public function deliverystatus(Request $request){
    $ldate = date('Y/m/d');
    $items = customer::where('ridername', Auth::user()->id)->wherein('status',[12])->wherein('deliverystatus',[0,21,12])->get();
    $delise = user::get();

    return view('dashboard/accounts/deliveryriderpage')->with(['ldate'=>$ldate,'item'=>$items,'delise'=>$delise]);
}
public function riderrequest(Request $request){
    $ldate = date('Y/m/d');
    $items = customer::where('ridername', Auth::user()->id)->wherein('status',[41,42,43,44,45])->where('deliverydate','<=',$ldate)->wherein('deliverystatus',[0,21,12,46])->get();
    $delise = user::get();

    return view('dashboard/accounts/riderrequest')->with(['ldate'=>$ldate,'item'=>$items,'delise'=>$delise]);
}

public function riderconfirm(Request $request){
    $ldate = date('Y/m/d');
    $items = customer::where('ridername', Auth::user()->id)->wherein('status',[40,14])->wherein('deliverystatus',[0,21,12,47,48])->get();
    $delise = user::get();

    return view('dashboard/accounts/riderconfirm')->with(['ldate'=>$ldate,'item'=>$items,'delise'=>$delise]);
}
public function riderdispatch(Request $request){
    $ldate = date('Y/m/d');
    $items = customer::where('ridername', Auth::user()->id)->wherein('status',[8])->wherein('deliverystatus',[0,21,22,23,12,47,48])->get();
    $delise = user::get();

    return view('dashboard/accounts/riderdispatch')->with(['ldate'=>$ldate,'item'=>$items,'delise'=>$delise]);
}
public function riderrouteupload(Request $request){
    $ldate = date('Y/m/d');
    $items = customer::where('ridername', Auth::user()->id)->wherein('status',[8])->wherein('deliverystatus',[0,21,22,23,12,47,48])->get();
    $delise = riderimage::where('riderid',Auth::user()->id)->get();

    return view('dashboard/accounts/riderrouteupload')->with(['ldate'=>$ldate,'item'=>$items,'delise'=>$delise]);
}
public function riderdeliveryupdate(Request $request){


    $cus_id = $request->input('id');
    $data = customer::find($cus_id);

    try{
        if($request->statusdelauth==6){
            $data->status = 6;
            $data->note = $request->note;
            $data->ridername = '-';
            $data->companydelivery = 0;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=6;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

        }
        else if($request->statusdelauth==12){
            $data->ridername = $request->deliveryrid;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=12;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

        }
        
        else if($request->statusdelauth==18){
            $data->status = $request->statusdelauth;
            $data->deliverystatus = $request->statusdelauth;
            $data->note = $request->note;
            $data->save();
        
            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=$request->statusdelauth;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
            

        }
        else if($request->statusdelauth== 41 OR $request->statusdelauth== 42 OR $request->statusdelauth== 43 OR $request->statusdelauth== 44 OR $request->statusdelauth== 45){
            $data->status = $request->statusdelauth;
            $data->note = $request->note;
            $data->save();
        
            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=$request->statusdelauth;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
            

        }
        else if($request->statusdelauth== 46){
            // $data->status = $request->statusdelauth;
            $data->deliverystatus = $request->statusdelauth;
            $data->note = $request->note;
            $data->save();
        
            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=$request->statusdelauth;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
            

        }
        else{
            $data->deliverystatus = $request->statusdelauth;
            $data->note = $request->note;
            $data->ridername = $request->deliveryrid;
            $data->save();
        
            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=$request->statusdelauth;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

        }
        
         return back()->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return back()->with('error', 'Error : '.$ex->getMessage());
    }
   } 
   
   public function riderdeliverydate(Request $request){


    $cus_id = $request->input('id');
    $data = customer::find($cus_id);
    $getsta = customer::where('id',$cus_id)->first();

    try{
        if($getsta->status == 8){
            $data->deliverydate = $request->delivery_date;
            $data->save();
        }else{
            $data->deliverydate = $request->delivery_date;
            $data->status = 5;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=5;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }

        
        
         return back()->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return back()->with('error', 'Error : '.$ex->getMessage());
    }
   } 


   public function riderconfirmpost(Request $request){

    $data = customer::find($request->id);

    try{
        $data->status = 40;
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$request->id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=40;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();

        
        
         return redirect('/deliverystatus')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('deliverystatus')->with('error', 'Error : '.$ex->getMessage());
    }
   } 


   public function outappeal(Request $request){
    $data = customer::find($request->id);
    try{

        $data->status = 39;
        $data->save();
        
         return redirect('/callcentercolombo')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('callcentercolombo')->with('error', 'Error : '.$ex->getMessage());
    }
   } 

   public function callcenterapprovel($id){
    $data = customer::find($id);

    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{
        $check = customer::where('id',$id)->first();

        if($check->status == 38){
            $data->status = 12;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=12;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=12;
            $statrack->save();
        }
        else if($check->status == 41){
            $data->status = 10;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=10;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=10;
            $statrack->save();
        }
        else if($check->status == 42){
            $tomorrow = date("Y/m/d", strtotime('tomorrow'));

            $data->status = 5;
            $data->deliverydate = $tomorrow;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=16;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=16;
            $statrack->save();
        }
        else if($check->status == 43){
            $tomorrow = date("Y/m/d", strtotime('tomorrow'));

            $data->status = 5;
            $data->deliverydate = $tomorrow;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=5;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=5;
            $statrack->save();
        }
        else if($check->status == 44){
            $ldate=date('y/m/d');

            $data->status = 12;
            $data->deliverydate = $ldate;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=12;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        else if($check->status == 45){
            $data->status = 6;
            $data->ridername = '-';
            $data->companydelivery = 0;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=6;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        return  Response::json(['status' => $data], 200);
    }
   } 

   
   public function callcenterreassignbtn($id){
    $data = customer::find($id);

    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{
        $check = customer::where('id',$id)->first();

        $data->status = 12;
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=12;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=12;
        $statrack->save();
      

        return  Response::json(['status' => $data], 200);
    }
   } 

   public function failorderapprovel($id){
    $data = customer::find($id);

    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{
        $check = customer::where('id',$id)->first();

        if($check->deliverystatus == 30){
            $data->deliverystatus = 23;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=23;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        else if($check->deliverystatus == 46){
            $data->deliverystatus = 23;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=23;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        return  Response::json(['status' => $data], 200);
    }
   } 
   
   public function reshedulapprovel($id){
    $data = customer::find($id);

    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{
        $check = customer::where('id',$id)->first();

        if($check->deliverystatus == 30){
            $data->deliverystatus = 47;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=47;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        else if($check->deliverystatus == 46){
            $data->deliverystatus = 47;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=47;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        return  Response::json(['status' => $data], 200);
    }
   } 
   public function datechangereq(){
    if(Auth::user()->type=="super_admin"){
        // $items = customer::where('status', '38')->get();
        $items =  customer::select('customers.id','customers.phone','customers.deliverydate','customers.ridername','statustracks.username')
        ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->where('statustracks.orderstatus',5)->where('customers.status',38)
        ->groupBy('customers.id')->orderBy('customers.deliverydate', 'DESC')->get();
    }
    else{
        $items =  customer::select('customers.id','customers.phone','customers.deliverydate','customers.ridername','statustracks.username')
        ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->where('statustracks.orderstatus',5)->where('customers.status',38)
        ->where('customers.user',Auth::user()->resellerid)->groupBy('customers.id')->orderBy('customers.deliverydate', 'DESC')->get();

    }
    
    return view('dashboard/addorder/datechangereq')->with(['item'=>$items]);
}
public function refailorders(){
    if(Auth::user()->type=="super_admin"){
        // $items = customer::where('status', '38')->get();
        $items =  customer::select('customers.id','customers.phone','customers.deliverydate','customers.ridername','statustracks.username')
        ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->where('statustracks.orderstatus',5)->where('customers.status',38)
        ->groupBy('customers.id')->orderBy('customers.deliverydate', 'DESC')->get();
    }
    else{
        $items =  customer::select('customers.id','customers.phone','customers.deliverydate','customers.ridername','statustracks.username')
        ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->where('statustracks.orderstatus',5)->where('customers.status',38)
        ->where('customers.user',Auth::user()->resellerid)->groupBy('customers.id')->orderBy('customers.deliverydate', 'DESC')->get();

    }
    
    return view('dashboard/addorder/refailorders')->with(['item'=>$items]);
}
public function confirmrefailorders(){
    if(Auth::user()->type=="super_admin"){
        $items = customer::where('status', 8)->where('deliverystatus', 47)->get();
    }
    else{
        $items = customer::where('status', 8)->where('user', Auth::user()->resellerid)->where('deliverystatus', 47)->get();

    }
    
    return view('dashboard/addorder/confailorders')->with(['item'=>$items]);
}

public function postrescheduleorders(Request $request){
    try{
        DB::table('customers')->where('deliverystatus',47)->update(['deliverystatus' => 48]);
    
    return redirect('/confirmrefailorders')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/confirmrefailorders')->with('error', 'Error : '.$ex->getMessage());
    }   
}

public function updatereshedule(Request $request){
    $data = customer::find($request->id);
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
    $check = customer::where('id',$request->id)->first();

    if($check->deliverystatus == 30){
        $data->deliverystatus = 47;
        $data->deliverydate = $request->delivery_date;
        $data->note = $request->note;
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$request->id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=47;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();

        return  Response::json(['status' => $data], 200);

    }
    else if($check->deliverystatus == 46){
        if($check->companydelivery == 0){
            $data->deliverystatus = 47;
            $data->deliverydate = $request->delivery_date;
            $data->note = $request->note;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=47;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        else{
            $data->deliverystatus = 21;
            $data->deliverydate = $request->delivery_date;
            $data->note = $request->note;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=21;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }


        return  Response::json(['status' => $data], 200);

    }

   }
}








// public function riderdeliveryupdate(Request $request){


//     $cus_id = $request->input('id');
//     $data = customer::find($cus_id);

//     try{
//         if($request->statusdelauth==10){
//             $data->status = 10;
//             $data->note = $request->note;
//             $data->save();

//             $statrack = new statustrack;
//             $statrack->customerid=$cus_id;
//             $statrack->username=Auth::user()->name;
//             $statrack->orderstatus=10;
//             $statrack->starttime=0;
//             $statrack->endtime=0;
//             $statrack->status=0;
//             $statrack->save();

//         }
//        else if($request->statusdelauth==18){
//             $data->status = 18;
//             $data->save();

//             $statrack = new statustrack;
//             $statrack->customerid=$cus_id;
//             $statrack->username=Auth::user()->name;
//             $statrack->orderstatus=18;
//             $statrack->starttime=0;
//             $statrack->endtime=0;
//             $statrack->status=0;
//             $statrack->save();

//         }
//         else{
//             $data->deliverystatus = $request->statusdelauth;
//             $data->note = $request->note;
//             $data->ridername = $request->deliveryrid;
//             $data->save();
        
//             $statrack = new statustrack;
//             $statrack->customerid=$cus_id;
//             $statrack->username=Auth::user()->name;
//             $statrack->orderstatus=$request->statusdelauth;
//             $statrack->starttime=0;
//             $statrack->endtime=0;
//             $statrack->status=0;
//             $statrack->save();
            

//         }
        
//          return redirect('/deliverystatus')->with('success', 'Successfully Saved!');
//         }
//     catch (Exception $ex){
//         return redirect('deliverystatus')->with('error', 'Error : '.$ex->getMessage());
//     }
//    } 
   
//    public function riderdeliverydate(Request $request){


//     $cus_id = $request->input('id');
//     $data = customer::find($cus_id);

//     try{

//         $data->deliverydate = $request->delivery_date;
//         $data->status = 5;
//         $data->save();
        
        
//          return redirect('/deliverystatus')->with('success', 'Successfully Saved!');
//         }
//     catch (Exception $ex){
//         return redirect('deliverystatus')->with('error', 'Error : '.$ex->getMessage());
//     }
//    } 


   public function addexchange(Request $request){

    $ldate = date('Y/m/d');
    $cus_id = $request->input('cus_id');
    $cusdata = customer::where('id',$cus_id)->first();
    $orderbar = ordersbarcode::wherein('id',$request->exchangeitems)->groupBy('productid')->get();
    
    $dataor =  ordersbarcode::select('productid', DB::raw('count(*) as qty'))
    ->wherein('id', $request->exchangeitems)
    ->groupBy('productid')
    ->get();

    try{

        $additem=new customer;
        $additem->user=Auth::user()->name;
        $additem->pageName=$cusdata->pageName;
        $additem->name=$cusdata->name;
        $additem->address=$cusdata->address;
        $additem->phone=$cusdata->phone;
        $additem->secondaryphone=$cusdata->secondaryphone;
        $additem->status='1';
        $additem->tracking='-';
        $additem->note='None';
        $additem->print='0';
        $additem->cod='0';
        $additem->deliverycharge='0';
        $additem->deliveryservice='-';
        $additem->dispatchid='-';
        $additem->branch=$cusdata->branch;
        $additem->deliverydate=$ldate;
        $additem->ridername='-';
        $additem->companydelivery='0';
        $additem->city=$cusdata->city;
        $additem->district=$cusdata->district;
        $additem->lockstatus='-';
        $additem->lockuser='-';
        $additem->deliverystatus='0';
        $additem->moneyrecivestatus='0';
        $additem->ordersource=$cusdata->ordersource;
        $additem->paymentmethod='cash';
        $additem->confirmuser='-';
        $additem->courierreciveid='-';
        $additem->ordertype='Exchange';
        $additem->save();

        $statrack = new statustrack;
        $statrack->customerid=$additem->id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=25;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();

        foreach($dataor as $cusdata){
            $addord=new cus_orders;
            $addord->item_id= $cusdata->productid;
            $addord->cus_id= $additem->id;
            $addord->attribute='null';
            $addord->qty=$cusdata->qty;
            $addord->pro_amount='0';
            $addord->barcode='-';
            $addord->save();

        for($i=0; $i<$cusdata->qty; $i++){
            $barcoadd=new ordersbarcode;
            $barcoadd->customerid= $additem->id;
            $barcoadd->productid=$cusdata->productid;
            $barcoadd->itemordid=$addord->id;
            $barcoadd->barcode='-';
            $barcoadd->status='0';
            $barcoadd->save();
        }
        }
        foreach($request->barcode as $barids){
            $cusdata = productbarcode::where('barcode',$barids)->get();
            foreach($cusdata as $barcodeupd){
                $upup = productbarcode::find($barcodeupd->id);
                $upup->itemstatus= $request->itemstatus2;
                $upup->save();

            }
        }
        
        $cusdataadd = customer::find($cus_id);
        $cusdataadd->ordertype='Sent an Exchange';
        $cusdataadd->save();

        $statrack = new statustrack;
        $statrack->customerid=$cus_id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=24;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();
        
         return redirect('/viewpending')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/viewallorders/'.$cus_id)->with('error', 'Error : '.$ex->getMessage());
    }
   } 

   public function returnstatus(Request $request){

    $data = customer::find($request->cus_id);

    try{

        $data->deliverystatus = $request->statusdelauth;
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$request->cus_id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=$request->statusdelauth;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();
        
         return redirect('/viewallorders/'.$request->cus_id)->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/viewallorders/'.$request->cus_id)->with('error', 'Error : '.$ex->getMessage());
    }
   } 

   public function dropexorders(){
    $ldate=date('y-m-d');
    $items = customer::where('status', 19)->get();

    return view('dashboard/shipping/dropshipping')->with(['item'=>$items, 'ldate'=>$ldate]);
   } 

   public function dropexordersdispatch(){
    $ldate=date('y-m-d');
    $items = customer::where('status', 20)->get();

    return view('dashboard/orders/dropexdispatch')->with(['item'=>$items, 'ldate'=>$ldate]);
   } 

   public function dropexsendingdispatch(Request $request){
    $checid = $request->checkids;
    $cbCount = count($checid);

    if($cbCount==0){
        return redirect('/dropexorders')->with('error', 'No select Orders');
    }
    else{
    if($request->dispatch=="dispatch"){    
    try{
        foreach($checid as $checiddata){

                $data = customer::find($checiddata);
                $data->status = '20';
                $data->ridername = '-';
                $data->companydelivery = '0';
                $data->save();
                
                $statrack = new statustrack;
                $statrack->customerid=$checiddata;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=20;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();
            }
    
        return redirect('/dropexorders')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/dropexorders')->with('error', 'Error : '.$ex->getMessage());
        }
        }
    else if($request->excel=="excel"){
        $ldate=date('y-m-d');
        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=Dropex-$ldate-orders.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::with('cus_or')->select(["id", "name", "address", "phone", "cod","tracking","district","city","paymentmethod","note","deliverycharge"])->wherein('id',$checid)->get();
        $columns = array('NAME', 'ADDRESS', 'CITY', 'CONTACT', 'ITEM', 'QTY', 'UPRICE','DELIVERY','TOTAL','PAYMENT','kd','USER','PAGE');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->name;
                    $qty2[]= $cusitems->qty;
                    $proam[]= $cusitems->pro_amount;
                   }
                   $da=implode(', ', $datacccc);
                   $qtyim=implode(', ', $qty2);
                   $proim=implode(', ', $proam);
                   $datacccc = []; 
                   $qty2 = []; 
                   $proam = []; 

                    $cod=0;
                    if($review->paymentmethod=="paid"){
                        $cod=0.00;
                        $type="PAID";
                    }else{
                        $cod=$review->cod;
                        $type="COD";
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->name,$review->address,$review->getcity->city, $ph, $da, $qtyim,$proim, $review->deliverycharge, $cod ,$type, "Confirmed", "drDaily Deals","Daily Deals"));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);


    }
    }
}


   public function colomboprintcusd(Request $request)
   {
 
    $users = customer::select(['id','pagename', 'name', 'address', 'phone','cod','deliverydate','status','ridername'])->where('ridername',$request->delivery_name)->where('status',12);

       
   
       return Datatables::of($users)->addColumn('productname', function($users){
        $y=[];
        foreach($users->cus_or as $data){$y[]=$data->orders->pro_name;}$da=implode(', ', $y);
        return ''.$da.''; })->addColumn('action', function($users){
           return'<button type="button" data-rider="'.$users->ridername.'" data-id="'.$users->id.'" data-date="'.$users->deliverydate.'" data-status="'.$users->status.'"  class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodel">Update</button>';})
       ->make(true);
   }

   public function requestdata(Request $request)
   {
    if(Auth::user()->type=="super_admin"){
    $users = customer::select(['id','pagename', 'name', 'address', 'phone','lockstatus','lockuser','cod','deliverydate','status','ridername','user','note'])->whereIn('status',[41,38,42,43,44,45]);
    }
    else{
    $users = customer::select(['id','pagename', 'name', 'address', 'phone','lockstatus','lockuser','cod','deliverydate','status','ridername','user','note'])->where('user', Auth::user()->resellerid)->whereIn('status',[41,38,42,43,44,45]);

    }
    // if(Auth::user()->type=="super_admin"){
    //     // $items = customer::where('status', '38')->get();
    //     $users =  customer::select('customers.id','customers.phone','customers.note','customers.status','customers.deliverydate','customers.ridername','statustracks.username')
    //     ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->join('users', 'users.name', '=' , 'statustracks.username')
    //     ->where('statustracks.orderstatus',5)->whereIn('customers.status',[41,38,42,43,44,45])
    //     ->groupBy('customers.id')->orderBy('customers.deliverydate', 'DESC')->get();
    //     $user =User::where('type','Call_center')->get();

    // }
    // else{
    //     $users =  customer::select('customers.id','customers.phone','customers.note','customers.status','customers.deliverydate','customers.ridername','statustracks.username')
    //     ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->join('users', 'users.name', '=' , 'statustracks.username')
    //     ->where('statustracks.orderstatus',5)->whereIn('customers.status',[41,38,42,43,44,45])
    //     ->where('statustracks.username',Auth::user()->name)->groupBy('customers.id')->orderBy('customers.deliverydate', 'DESC')->get();

    // }
   
       return Datatables::of($users)->addColumn('reseller', function($users){return ''.$users->getpage2->companyname.''; })
       ->addColumn('ridername', function($users){
        $x='';if($users->ridername == '-'){$x='Not Assign';}else{$x=$users->userget->name;}
        return ''.$x.''; })->addColumn('productname', function($users){
           $y=[];
           foreach($users->cus_or as $data){$y[]=$data->orders->pro_name;}$da=implode(', ', $y);
           return ''.$da.''; })->addColumn('action', function($users){
            $x='';
            if($users->lockstatus=="1"){$x.='<span class="badge badge-warning">'.$users->lockuser.' in use</span>&nbsp;&nbsp;<a class="resetlockscreen" data-id="'.$users->id.'" href=""><i class="fas fa-sync"></i></a>';}
            else if($users->status==41){$x.='<a class="btn bg-gradient-danger btn-xs approvelbtn" data-id="'.$users->id.'" href="">Cancel</a>&nbsp;&nbsp;<a class="btn bg-gradient-success btn-xs reassignbtn" data-id="'.$users->id.'" href="">Re Assign</a>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            else if($users->status==42){$x.='<a class="btn bg-gradient-dark btn-xs approvelbtn" data-id="'.$users->id.'" href="">Next Day</a>&nbsp;&nbsp;<a class="btn bg-gradient-success btn-xs reassignbtn" data-id="'.$users->id.'" href="">Re Assign</a>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            else if($users->status==43){$x.='<a class="btn bg-gradient-dark btn-xs approvelbtn" data-id="'.$users->id.'" href="">Next Day</a>&nbsp;&nbsp;<a class="btn bg-gradient-success btn-xs reassignbtn" data-id="'.$users->id.'" href="">Re Assign</a>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            else if($users->status==44){$x.='<a class="btn bg-gradient-warning btn-xs approvelbtn" data-id="'.$users->id.'" href="">Stock Received</a>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            else if($users->status==45){$x.='<a class="btn bg-gradient-success btn-xs approvelbtn" data-id="'.$users->id.'" href="">Out</a>&nbsp;&nbsp;<a class="btn bg-gradient-success btn-xs reassignbtn" data-id="'.$users->id.'" href="">Re Assign</a>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            else{$x.='<a class="btn bg-gradient-success btn-xs approvelbtn" data-id="'.$users->id.'" href="">Approvel</a>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            return ''.$x.'';})->make(true);
   }

   public function faildata(Request $request)
   {
    if(Auth::user()->type=="super_admin"){
    $users = customer::select(['id','pagename', 'name', 'address', 'phone','lockstatus','lockuser','cod','deliverydate','status','ridername','deliveryservice','companydelivery','deliverystatus'])->where('status',8)->whereIn('deliverystatus',[30,46]);
    }
    else{
    $users = customer::select(['id','pagename', 'name', 'address', 'phone','lockstatus','lockuser','cod','deliverydate','status','ridername','deliveryservice','companydelivery','deliverystatus'])->where('status',8)->where('user', Auth::user()->resellerid)->whereIn('deliverystatus',[30,46]);

    }
    // if(Auth::user()->type=="super_admin"){
    //     // $items = customer::where('status', '38')->get();
    //     $users =  customer::select('customers.id','customers.companydelivery','customers.ridername','customers.phone','customers.note','customers.deliveryservice','customers.deliverystatus','customers.status','customers.deliverydate','customers.ridername','statustracks.username')
    //     ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->whereIn('statustracks.orderstatus',[6,5])->whereIn('customers.deliverystatus',[30,46])
    //     ->groupBy('customers.id')->get();
    // }
    // else{
    //     $users =  customer::select('customers.id','customers.companydelivery','customers.ridername','customers.phone','customers.note','customers.deliveryservice','customers.deliverystatus','customers.status','customers.deliverydate','customers.ridername','statustracks.username')
    //     ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->whereIn('statustracks.orderstatus',[6,5])->whereIn('customers.deliverystatus',[30,46])
    //     ->where('statustracks.username',Auth::user()->name)->groupBy('customers.id')->get();

    // }
   
       return Datatables::of($users)->addColumn('delservice', function($users){
        if($users->companydelivery == 1) $x=$users->userget->name; else $x=$users->deliveryse->deliveryname;
        return ''.$x.''; })->addColumn('productname', function($users){
           $y=[];
           foreach($users->cus_or as $data){$y[]=$data->orders->pro_name;}$da=implode(', ', $y);
           return ''.$da.''; })->addColumn('action', function($users){
            $x='';
            if($users->lockstatus=="1"){$x.='<span class="badge badge-warning">'.$users->lockuser.' in use</span>&nbsp;&nbsp;<a class="resetlockscreen" data-id="'.$users->id.'" href=""><i class="fas fa-sync"></i></a>';}
            else if($users->deliverystatus==30){$x.='<a class="btn bg-gradient-warning btn-xs approvelbtn" data-id="'.$users->id.'" href="">Authorized Return</a>&nbsp;&nbsp;<button type="button" data-note="'.$users->note.'" data-id="'.$users->id.'" data-date="'.$users->deliverydate.'" data-status="'.$users->status.'"  class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodel">Reshedule</button>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viewallorders/'.$users->id.'">view</a>';}
            else if($users->deliverystatus==46){$x.='<a class="btn bg-gradient-warning btn-xs approvelbtn" data-id="'.$users->id.'" href="">Authorized Return</a>&nbsp;&nbsp;<button type="button" data-note="'.$users->note.'" data-id="'.$users->id.'" data-date="'.$users->deliverydate.'" data-status="'.$users->status.'"  class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodel">Reshedule</button>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viewallorders/'.$users->id.'">view</a>';}
            return ''.$x.'';})->make(true);
   }

   public function faildatacon(Request $request)
   {
 
 
        $users =  customer::select('customers.id','customers.phone','customers.tracking','customers.note','customers.deliveryservice','customers.deliverystatus','customers.status','customers.deliverydate','customers.ridername','statustracks.username')
        ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')->where('statustracks.orderstatus',6)->where('customers.deliverystatus',47)
        ->groupBy('customers.id')->get();
   
       return Datatables::of($users)->addColumn('delservice', function($users){
        return ''.$users->deliveryse->deliveryname.''; })->addColumn('productname', function($users){
           $y=[];
           foreach($users->cus_or as $data){$y[]=$data->orders->name;}$da=implode(', ', $y);
           return ''.$da.''; })->addColumn('action', function($users){
            $x='';
            if($users->lockstatus=="1"){$x.='<span class="badge badge-warning">'.$users->lockuser.' in use</span>&nbsp;&nbsp;<a class="resetlockscreen" data-id="'.$users->id.'" href=""><i class="fas fa-sync"></i></a>';}
            else if($users->deliverystatus==47){$x.='<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            else if($users->deliverystatus==46){$x.='<a class="btn bg-gradient-warning btn-xs approvelbtn" data-id="'.$users->id.'" href="">Authorized Return</a>&nbsp;&nbsp;<a class="btn bg-gradient-dark btn-xs Reshedulebtn" data-id="'.$users->id.'" href="">Reshedule</a>&nbsp;&nbsp;<a class="btn bg-gradient-primary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';}
            return ''.$x.'';})->make(true);
   }
   
   public function colomboprintriderstatusupdate(Request $request){
    $data = customer::find($request->id);
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
            $data->status = $request->statusdelauth;
            $data->deliverydate = $request->delivery_date;
            $data->ridername = $request->deliveryrid;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=$request->statusdelauth;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

        return  Response::json(['status' => $data], 200);
   }
}

public function getdispatchcreatedata(Request $request,$id){
    $data = dispatchsummary::where('courierservice', $id)->get();

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{

        return  Response::json(['status' => $data], 200);
   }
}


public function dispatchedcusd(Request $request)
{
 $users = customer::select(['id','pagename', 'name', 'address', 'phone','cod','deliverydate','status'])->where('dispatchid',$request->dispachid);

    return Datatables::of($users)->addColumn('action', function($users){
        return'<a data-id'.$users->id.'" class="btn btn-primary btn-xs" href="/viewallorders/'.$users->id.'">View</a>';})
    ->make(true);
}

public function cusdispatchedcusd(Request $request)
{
 $users = customer::select(['id','pagename', 'name', 'address', 'phone','cod','deliverydate','status'])->where('status', 15)->where('deliveryservice', $request->courierservice);

    return Datatables::of($users)->addColumn('action', function($users){
        return'<a data-id'.$users->id.'" class="btn btn-primary btn-xs" href="/viewallorders/'.$users->id.'">View</a>';})
    ->make(true);
}


public function oneinvoiceprint(Request $request)
{
    if($request->Out=="Out"){
        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->where('id', $request->cus_id)->get();
        $user = deliveryservice::where('id', $request->deliveryname)->get();
    
        $pdf = PDF::loadView('dashboard.shipping.todayprintpdf', array('cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a4');
      return $pdf->stream(); 
    }
    else if($request->Colombo=="Colombo"){
        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->where('id', $request->cus_id)->get();
    
        $pdf = PDF::loadView('dashboard.shipping.colomboinvoice', array('cus'=>$cus,'ldate'=> $ldate))->setPaper('a4');
      return $pdf->stream(); 

    }

}

public function vieworderriderassign(Request $request){

    $data = customer::find($request->cus_id);

    try{
        if($request->deliveryrid=="notassign"){
            $data->status = "5";
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=5;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        else{
            $data->ridername = $request->deliveryrid;
            $data->status = "12";
            $data->companydelivery = 1;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=5;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->cus_id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=12;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        $getncid = customer::where('status',1)->first();
        $getncid1 = customer::where('status',2)->first();
        $getncid2 = customer::where('status',3)->first();
        $getncid3 = customer::where('status',4)->first();
        //  return redirect('/viwedetails/'.$getncid->id)->with('success', 'Successfully Saved!');
        if($request->nowstatus=='1'){
            if($getncid==null){
                return redirect('/viewpending');
            }
            else{
                return redirect('/viwedetails/'.$getncid->id); 
            }
        }
        elseif($request->nowstatus=='2'){
            if($getncid1==null){
                return redirect('/1stattempt');
            }
            else{
                return redirect('/viwedetails/'.$getncid1->id); 
            }
        }
        elseif($request->nowstatus=='3'){
            if($getncid2==null){
                return redirect('/2ndattempt');
            }
            else{
                return redirect('/viwedetails/'.$getncid2->id); 
            }
        }
        elseif($request->nowstatus=='4'){
            if($getncid3==null){
                return redirect('/3rdattempt');
            }
            else{
                return redirect('/viwedetails/'.$getncid3->id); 
            }
            return redirect('/viwedetails/'.$getncid3->id); 
        }
        else{
            return redirect('/viewpending')->with('success', 'Successfully Saved!');
        }
        }
    catch (Exception $ex){
        return redirect('/viwedetails/'.$request->cus_id)->with('error', 'Error : '.$ex->getMessage());
    }
   } 

   public function packwholesale(){

    $items = wholesale::where('orderstatus', '0')->get();

    $delise = deliveryservice::get();
    return view('dashboard/inventory/wholesale')->with(['delise'=>$delise,'item'=>$items]);
}

public function wholesalefilter(Request $request){
    $items = wholesale::where('id', $request->id)->get();
    $prodata = wholesalebarcode::where('wholsalecusid', $request->id)->get();

    $delise = deliveryservice::get();
    $page = pages::get();
    return view('dashboard/inventory/wholesale2')->with(['cus_id'=>$request->id,'prodata'=>$prodata,'delise'=>$delise,'item'=>$items,'pages'=>$page]);
}

public function getwholebarcode(Request $request)
{
    $users = wholesalebarcode::select(['id','productid', 'barcode', 'status'])->where('wholsalecusid', $request->id);

    return Datatables::of($users)->addColumn('productname', function($users){return ''.$users->wholebarcodepro->name.'';})->addColumn('action', function($users){
        $x='';
        if($users->status=="1"){$x.='<span class="badge badge-success">Barcode Add successfully</span>';}else{$x.='<span class="badge badge-warning">Not Added Barcode</span>';}
        return ''.$x.'';})
    ->make(true);
}

public function packingaddwholebarcode(Request $request){

    $checkbarcode = productbarcode::where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st2 = wholesalebarcode::where('status', 0)->where('wholsalecusid', $request->id)->orderBy('id', 'asc')->get();
    $st3 = wholesalebarcode::where('status', 0)->where('wholsalecusid', $request->id)->count();

    if($request->barcode=="wasimart"){
        if($st3==0){

            $cusdat = wholesale::find($request->id);
            $cusdat->orderstatus = '1';
            $cusdat->save();

            $data="4";
            return  Response::json(['status' => $data], 200); 

        }
        else{
            $data="5";
            return  Response::json(['status' => $data], 200);
        }

    }
    else if($checkbarcode==null){
        $data="1";
        return  Response::json(['status' => $data], 200);
    }
    else{
    foreach($st2 as $bardata){
        if($bardata->id==null){
            $data="3";
            return  Response::json(['status' => $data], 200);
        }
        else if($checkbarcode->productid == $bardata->productid){

            $data = wholesalebarcode::find($bardata->id);
            $data->barcode = $request->barcode;
            $data->status = 1;
            $data->save();

            $range = productbarcode::where('barcode', $request->barcode)->first();
            $range->itemstatus = "1";
            $range->save();

            return  Response::json(['status' => $data], 200);
        }
        else{
            $data="2";
            return  Response::json(['status' => $data], 200);
        }
    }
}

}

public function dispatchwholesale(){

    $items = wholesale::where('orderstatus', '1')->get();

    $delise = deliveryservice::get();
    return view('dashboard/orders/dispathchwholesale')->with(['delise'=>$delise,'item'=>$items]);
}

public function searchresult(Request $request){
    $id=$request->invoiceno;
    $items = customer::where('id', $id)->get();
    $check = customer::where('id', $id)->get()->count();

    if(empty($check)){
        return redirect('/home');
    }
    else{
    foreach($items as $itemsdata) {
        $status=$itemsdata->status;
    }

if($status==8 OR $status==7 OR $status==9 OR $status==15 OR $status==20){
    return redirect('/viewallorders/'.$id);

}
else{
    return redirect('/viwedetails/'.$id);
}
}
}

public function searchbarcodehe(Request $request){
    $id=$request->invoiceno;
    $items = ordersbarcode::where('barcode', $id)->get()->first();
    $check = ordersbarcode::where('barcode', $id)->get()->count();

    if(empty($check)){
        return redirect('/home');
    }
    else{

    return redirect('/viewallorders/'.$items->customerid);

}
}



public function Rejectcustomerupdate(Request $request,$id){
    $data = customer::find($id);
   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->status='27';
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$id;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=27;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}


public function companybank(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/accounts/bank',['accoption'=>$accoption,'supdata'=>$supdatas]);
}

public function addcompanybank(Request $request){
    $data = new companybank();
    try{

    $data->accountno = $request->Account_Number;
    $data->accountname = $request->Accont_Name;
    $data->bank = $request->Bank_Name;
    $data->branch = $request->Branch;
    $data->balance = $request->Balance;
    $data->save();

    return redirect('/companybank')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/companybank')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function supplierpayment(){
    $datas = supplier::get();
    $ban = companybank::get();
    $purces = purchasing::get();
    $purc = supplier::get();
    $products = orderItem::get();
    $ldate = date('Y-m-d H:i:s');

    return view('dashboard/accounts/supplierpayment',['product'=>$products,'purc'=>$purc,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
}

public function grnmanage(){
    $datas = supplier::get();
    $ban = companybank::get();
    $purces = purchasing::get();
    $purc = supplier::get();
    $products = orderItem::get();
    $ldate = date('Y-m-d H:i:s');
    $lastValue = DB::table('purchasings')->orderBy('invoiceno', 'desc')->first();
    $invno=0;
    if($lastValue == null){
        $invno=10001;
    }
    else{
        $invno=($lastValue->invoiceno)+1;
    }

    return view('dashboard/accounts/grn',['invno'=>$invno,'product'=>$products,'purc'=>$purc,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
}

public function purchesingfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $datas = supplier::get();
    $ban = companybank::get();
    $purc = supplier::get();
    $ldate = date('Y-m-d H:i:s');

    $purces = purchasing::where('supplierid',$request->supplier_name)->whereBetween('created_at',[$da,$da2])->get();


    return view('dashboard/accounts/supplierpayment2',['supid'=>$request->supplier_name,'dateran'=>$request->daterange,'purc'=>$purc,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
}

public function purchasingupdate2(Request $request){
    $data = purchasing::find($request->id);
    $sta = $request->has('paidstatus');
    $products = orderItem::where('id',$request->product_name)->get();
    $purchas = purchasing::where('id',$request->id)->get();
    $oitem = orderItem::find($request->product_name);
    try{

            $balance= floatval($request->cost)-floatval($request->paidamount);

            $data->supplierid = $request->supplier_name;
            $data->cost = $request->cost;
            $data->invoiceno = $request->invoiceno;
            $data->note = $request->note;
            $data->save();
            if($sta=="true"){
              
            if($balance==0){
                $data->status = '1';
                $data->save();
            }
            else{
                // return redirect('/supplierpayment')->with('error', 'Balance Shoud be 0');
                $data="1";
                return  Response::json(['status' => $data], 200); 
            }

            }
            else{
                $data->status = '0';
                $data->save();
             }

             return  Response::json(['status' => $data], 200);
        // return redirect('/supplierpayment')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return  Response::json(['status' => $data], 200);
            // return redirect('/supplierpayment')->with('error', 'Error : '.$ex->getMessage());
        }
}
public function transaction(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/accounts/transaction',['accoption'=>$accoption, 'supdata'=>$supdatas]);
}

public function getbanktransaction(Request $request){

    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    if($request->accoption == "all"){
        $users = banktransaction::select(['id','withdrawal', 'deposit', 'balance', 'note','created_at','bankid','user'])->where('bankid',$request->bank)->whereBetween('created_at',[$da,$da2]);
    }
    else{
        $users = banktransaction::select(['id','withdrawal', 'deposit', 'balance', 'note','created_at','bankid','user'])->where('accoption',$request->accoption)->where('bankid',$request->bank)->whereBetween('created_at',[$da,$da2]);
    }
    

    return Datatables::of($users)->make(true);
}

public function tansactionentery(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/accounts/tansactionentery',['accoption'=>$accoption,'supdata'=>$supdatas]);
}

public function addtransaction(Request $request){
    $data = new banktransaction();
    $bankdata = companybank::where('id',$request->bankche)->first();
   
    if( $request->payment=="withdraw"){
        try{

        $data->user = Auth::user()->name;
        $data->bankid = $request->bankche;
        $data->withdrawal = $request->amount;
        $data->deposit = 0;
        $data->balance = floatval($bankdata->balance)-floatval($request->amount);
        $data->note = $request->payment.'-'.$request->note;
        $data->accoption = "Withdraw";
        $data->save();

        $oitem = companybank::find($request->bankche);
        $oitem->balance = floatval($bankdata->balance)-floatval($request->amount);
        $oitem->save();
        
        return redirect('/cashwithdraw')->with('success', 'Successfully Saved!');
    
        }
    catch (Exception $ex){
        return redirect('/cashwithdraw')->with('error', 'Error : '.$ex->getMessage());
    }
    }
    else{
        try{

        $data->user = Auth::user()->name;
        $data->bankid = $request->bankche;
        $data->withdrawal = 0;
        $data->deposit = $request->amount;
        $data->balance = floatval($bankdata->balance)+floatval($request->amount);
        $data->note =  $request->payment.'-'.$request->note;
        $data->accoption = "Deposit";
        $data->save();

        $oitem = companybank::find($request->bankche);
        $oitem->balance = floatval($bankdata->balance)+floatval($request->amount);
        $oitem->save();

    


        return redirect('/cashdeposit')->with('success', 'Successfully Saved!');
        }        
    catch (Exception $ex){
        return redirect('/cashdeposit')->with('error', 'Error : '.$ex->getMessage());
    }
}
}

public function ownbanktranfer(Request $request){
    try{
        $bankform = companybank::where('id',$request->bankfrom)->first();

        $data = new banktransaction();
        $data->user = Auth::user()->name;
        $data->bankid = $request->bankfrom;
        $data->withdrawal = $request->amount;
        $data->deposit = 0;
        $data->balance = floatval($bankform->balance)-floatval($request->amount);
        $data->note = 'ownbankTransfer-withdraw-'.$request->note;
        $data->accoption = '-';
        $data->save();

        $oitem = companybank::find($request->bankfrom);
        $oitem->balance = floatval($bankform->balance)-floatval($request->amount);
        $oitem->save();


        $bankto = companybank::where('id',$request->bankto)->first();

        $data2 = new banktransaction();
        $data2->user = Auth::user()->name;
        $data2->bankid = $request->bankto;
        $data2->withdrawal = 0;
        $data2->deposit = $request->amount;
        $data2->balance = floatval($bankto->balance)+floatval($request->amount);
        $data2->note = 'ownbankTransfer-deposit-'.$request->note;
        $data2->accoption = '-';
        $data2->save();

        $oitem2 = companybank::find($request->bankto);
        $oitem2->balance = floatval($bankto->balance)+floatval($request->amount);
        $oitem2->save();


    return redirect('/ownbanktransaction')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/ownbanktransaction')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function salary(){
    $supdatas = companybank::get();
    $user = user::get();
    $sald = salarytable::get();
    return view('dashboard/accounts/salary',['sald'=>$sald,'supdata'=>$supdatas,'user'=>$user]);
}

public function addsalarypayment(Request $request){
    try{
 
        $data = new salarytable();
        $data->user = Auth::user()->name;
        $data->bankid = $request->bank;
        $data->userid = $request->employee;
        $data->basicsalary = $request->Salary;
        $data->nopay = $request->No_Pay;
        $data->otrate = $request->OT_Rate;
        $data->othrs = $request->OT_Hours;
        $data->otamount = $request->OT_Amount;
        $data->confirmcount = $request->Confirm_Count;
        $data->cancelcount = $request->return_count;
        $data->salecommision = $request->Sales_Commision;
        $data->otherallowance = $request->Other_Allowance;
        $data->deliverycommision = $request->Delivery_Commision;
        $data->foodallowance = $request->Food_Allowance;
        $data->bikeallowance = $request->Bike_Allowance;
        $data->epf = $request->epf2;
        $data->saladvance = $request->Salary_Advance;
        $data->loan = $request->Loan;
        $data->late = $request->Late;
        $data->insurance = $request->Insurance;
        $data->otherdeducation = $request->Other_Deductions;
        $data->subtotal = $request->Sub_Total;
        $data->bonus = $request->Attendance;
        $data->netsalary = $request->Net_Salary;
        $data->status = 0;
        $data->save();


    return redirect('/salary')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/salary')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function deleteemployeesal(Request $request,$id){
    $data = salarytable::find($id);

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        $data->delete();
        return  Response::json(['status' => $data], 200);
   }
}
public function employeepaymentupdate(Request $request){
    $salda = salarytable::find($request->id);
    $sta = $request->has('paidstatus');
    try{
        if($sta=="true"){
            $getsald = salarytable::where('id',$request->id)->first();

            $bankto = companybank::where('id',$getsald->bankid)->first();

            $data = new banktransaction();
            $data->user = Auth::user()->name;
            $data->bankid = $getsald->bankid;
            $data->withdrawal = $getsald->netsalary;
            $data->deposit = 0;
            $data->balance = floatval($bankto->balance)-floatval($getsald->netsalary);
            $data->note = $getsald->employeename->name.' salary payment';
            $data->accoption = '-';
            $data->save();
    
            $oitem2 = companybank::find($getsald->bankid);
            $oitem2->balance = floatval($bankto->balance)-floatval($getsald->netsalary);
            $oitem2->save();


            $salda->status = '1';
            $salda->save();
        }
        else{
            $salda->status = '0';
            $salda->save();
         }
        
        return redirect('/salary')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('salary')->with('error', 'Error : '.$ex->getMessage());
        }
}

public function salarypdf(Request $request){
    $ldate = date('m-Y');
    $saldata = salarytable::where('id', $request->salid)->get();
    
    $pdf = PDF::loadView('dashboard.accounts.salarypdf', array('saldata'=>$saldata,'ldate'=> $ldate))->setPaper('a4');
    return $pdf->stream(); 
}

public function riderpaymentsendtobank(Request $request){
    $data = new banktransaction();
    $bankdata = companybank::where('id',$request->bank)->first();
    try{

        $data->user = Auth::user()->name;
        $data->bankid = $request->bank;
        $data->withdrawal = 0;
        $data->deposit = $request->ridercollection;
        $data->balance = floatval($bankdata->balance)+floatval($request->ridercollection);
        $data->note = $request->ridername.' Daily-COD';
        $data->accoption = '-';
        $data->save();

        $oitem = companybank::find($request->bank);
        $oitem->balance = floatval($bankdata->balance)+floatval($request->ridercollection);
        $oitem->save();
    
    return redirect('/colombodelivery')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/colombodelivery')->with('error', 'Error : '.$ex->getMessage());
    }
}


public function test(){
    $countries = DB::table('order_items')->pluck("name","id");
    $users = User::where(DB::raw("(DATE_FORMAT(created_at,'%Y'))"),date('Y'))->get();

    $chart = Charts::database($users, 'bar', 'highcharts')
			      ->title("Monthly new Register Users")
			      ->elementLabel("Total Users")
			      ->dimensions(1000, 500)
			      ->responsive(false)
                  ->groupByMonth(date('Y'), true);
                
    $ordersmo = customer::where(DB::raw("(DATE_FORMAT(created_at,'%Y'))"),date('Y'))->where('status',9)->get();

    $chart2 = Charts::database($ordersmo, 'bar', 'highcharts')
			      ->title("Monthly Delivered Orders")
			      ->elementLabel("Total Orders")
			      ->dimensions(1000, 500)
			      ->responsive(false)
                  ->groupByMonth(date('Y'), true);
                  
    $pie  =	 Charts::create('pie', 'highcharts')
                  ->title('Order Status chart')
                  ->labels(['Dispatched','Confirm','Cancel', 'Attempt'])
                  ->values([5,10,20,20])
                  ->dimensions(1000,500)
                  ->responsive(false);

    return view('dashboard/product/test',compact('chart','chart2','pie'));
}

public function addaccountoptions(Request $request){
    $data = new accountoption();
    try{

        $data->option = $request->Accont_Name;
        $data->save();
    
    return redirect('/companybank')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/companybank')->with('error', 'Error : '.$ex->getMessage());
    }
}


public function wholesalemakepayment(Request $request){
    $data2 = wholesalecustomer::find($request->wholeid);
    try{

        if($request->payment=="cash" OR $request->payment=="Wire Transfer"){
            
                $bankto = companybank::where('id',$request->bank)->first();

                $bandata = new banktransaction();
                $bandata->user = Auth::user()->name;
                $bandata->bankid = $request->bank;
                $bandata->withdrawal = 0;
                $bandata->deposit = $request->amount;
                $bandata->balance = floatval($bankto->balance)+floatval($request->amount);
                $bandata->note = $request->wholename.' wholesale-paid';
                $bandata->accoption = $request->payment;
                $bandata->save();
        
                $oitem2 = companybank::find($request->bank);
                $oitem2->balance = floatval($bankto->balance)+floatval($request->amount);
                $oitem2->save();

                $wholepayment = new wholesalepayemet();
                $wholepayment->paymentid = $request->wholeid;
                $wholepayment->paymenttype = $request->payment;
                $wholepayment->checkno = $request->Cheque;
                $wholepayment->paiddate = $request->paid_date;
                $wholepayment->ccdate = "-";
                $wholepayment->amount = $request->amount;
                $wholepayment->bankid = $request->bank;
                $wholepayment->status = 1;
                $wholepayment->save();

                $getbal = wholesalecustomer::where('id',$request->wholeid)->first();

                $data2->balance = floatval($getbal->balance)-floatval($request->amount);
                $data2->save();
        }
        else{

            $wholepayment = new wholesalepayemet();
            $wholepayment->paymentid = $request->wholeid;
            $wholepayment->paymenttype = $request->payment;
            $wholepayment->checkno = $request->Cheque;
            $wholepayment->paiddate = "-";
            $wholepayment->ccdate = $request->paid_date;
            $wholepayment->amount = $request->amount;
            $wholepayment->bankid = $request->bank;
            $wholepayment->status = "0";
            $wholepayment->save();

            $getbal = wholesalecustomer::where('id',$request->wholeid)->first();

            $data2->balance = floatval($getbal->balance)-floatval($request->amount);
            $data2->save();

            // $data->amountpaid = floatval($request->cost)+floatval($request->amount);
            // $data->save();
         }

        return redirect('/wholesalepaymentnew')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/wholesalepaymentnew')->with('error', 'Error : '.$ex->getMessage());
        }
}


public function wholepaymentrecive(Request $request){
    $getwhodet = wholesalepayemet::where('id',$request->id)->first();

    $data = new banktransaction();
    $bankdata = companybank::where('id',$getwhodet->bankid)->first();
    $ldate = date('Y-m-d H:i:s');
    try{

        $data->user = Auth::user()->name;
        $data->bankid = $getwhodet->bankid;
        $data->withdrawal = 0;
        $data->deposit = $getwhodet->amount;
        $data->balance = floatval($bankdata->balance)+floatval($getwhodet->amount);
        $data->note = $getwhodet->paymenttype.'-'.$getwhodet->wholenameg->name.'-paid';
        $data->accoption = $getwhodet->paymenttype;
        $data->save();

        $oitem = companybank::find($getwhodet->bankid);
        $oitem->balance = floatval($bankdata->balance)+floatval($getwhodet->amount);
        $oitem->save();

        $wholepay = wholesalepayemet::find($request->id);
        $wholepay->status = "1";
        $wholepay->paiddate = $ldate;
        $wholepay->save();
    
        return  Response::json(['status' => $data], 200);
        }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }
}

public function supplierproductdetails(Request $request,$id){
    $datas = supplier::get();
    $products = orderItem::get();
    $whol = purchasing::where('id',$id)->get();
    $purces = purchesproduct::where('purchesid', $id)->get();
    $paidp = supplierpayment::where('paymentid', $id)->get();
    $bank = companybank::get();
    $ldate = date('Y-m-d H:i:s');

    return view('dashboard/accounts/supplierprodtails',['ldate'=>$ldate,'bank'=>$bank,'paidp'=>$paidp,'item'=>$datas, 'whol'=>$whol, 'purce'=>$purces]);
}


public function supplierpaymentadd(Request $request){
    $sdata = supplier::find($request->supplier_name);
    try{
        if($request->payment=="cash" OR $request->payment=="Wire Transfer"){

            $suppay = new supplierpayment();
            $suppay->paymentid = $request->supplier_name;
            $suppay->paymenttype = $request->payment;
            $suppay->paiddate = $request->paid_date;
            $suppay->ccdate = "-";
            $suppay->checkno = $request->Cheque;           
            $suppay->amount = $request->amount;
            $suppay->bankid = $request->bank;
            $suppay->status = 1;
            $suppay->save();

            $getbal = supplier::where('id',$request->supplier_name)->first();

            $sdata->balance = floatval($getbal->balance)-floatval($request->amount);
            $sdata->save();

            $data = new banktransaction();
            $bankdata = companybank::where('id',$request->bank)->first();

            $data->user = Auth::user()->name;
            $data->bankid = $request->bank;
            $data->withdrawal = $request->amount;
            $data->deposit = 0;
            $data->balance = floatval($bankdata->balance)-floatval($request->amount);
            $data->note = $request->payment.'-'.$request->suppliername.'-purchase-payment';
            $data->accoption = $request->payment;
            $data->save();
    
            $oitem = companybank::find($request->bank);
            $oitem->balance = floatval($bankdata->balance)-floatval($request->amount);
            $oitem->save();
        }
        else{
      
            $suppay = new supplierpayment();
            $suppay->paymentid = $request->supplier_name;
            $suppay->paymenttype = $request->payment;
            $suppay->paiddate = "-";
            $suppay->ccdate = $request->paid_date;
            $suppay->checkno = $request->Cheque;           
            $suppay->amount = $request->amount;
            $suppay->bankid = $request->bank;
            $suppay->status = "0";
            $suppay->save();

            // $data->amountpaid = floatval($request->cost)+floatval($request->amount);
            // $data->save();

            $getbal = supplier::where('id',$request->supplier_name)->first();

            $sdata->balance = floatval($getbal->balance)-floatval($request->amount);
            $sdata->save();

         }

        return redirect('/purpaymentnew')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/purpaymentnew')->with('error', 'Error : '.$ex->getMessage());
        }
}




public function supplierreciptprint(Request $request){
    $ldate = date('Y-m-d');
    $cus = purchasing::where('id', $request->wholeid)->get();
    $prod = purchesproduct::where('purchesid', $request->wholeid)->get();
    $paidp = supplierpayment::where('paymentid', $request->wholeid)->get();


    $pdf = PDF::loadView('dashboard.accounts.supplierinvoice', array('paidp'=>$paidp,'cus'=>$cus,'ldate'=> $ldate,'prod'=> $prod))->setPaper('a4');
  return $pdf->stream(); 
}


public function chequemanage(){
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $ldaco = date('Y/m/d');
    $today = $ldaco.' - '.$ldaco;

    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->get();
    $ldate = date('Y-m-d H:i:s');
    $paym="all";

    return view('dashboard/accounts/chequemanage',['chequem'=>$chequem,'ldate'=>$ldate,'whol'=>$whol,'supplier'=>$supplier,'today'=>$today,'paym'=>$paym]);
}

public function chequemangefilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

if($request->status=="all"){
    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->get();
}
else if($request->status==0){
    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->where('status',$request->status)->get();

}
else{
    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->whereBetween('created_at',[$da,$da2])->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->whereBetween('created_at',[$da,$da2])->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->where('status',$request->status)->get();
}

    $ldate = date('Y-m-d H:i:s');

    return view('dashboard/accounts/chequemanage',['chequem'=>$chequem,'ldate'=>$ldate,'whol'=>$whol,'supplier'=>$supplier,'today'=>$request->daterange,'paym'=>$request->status]);
}

public function bannedcustomers(){
    if(Auth::user()->type=="super_admin"){
        $items = customer::where('status', '28')->get();
    }
    else{
        $items = customer::where('status', '28')->where('branch', Auth::user()->branch)->get();
    }
    
    return view('dashboard/addorder/bannedcoustomers')->with(['item'=>$items]);
}
public function addbannedcustomers(){

$items = bannedcustomers::get();
    
    return view('dashboard/product/addbanned')->with(['item'=>$items]);
}


public function addbanned(Request $request){
    $data = new bannedcustomers();
    try{

    $data->phoneno = $request->Phone_Number;
    $data->reason = $request->reason;
    $data->save();

    $lastdi= substr($request->Phone_Number, -9);
    DB::table('customers')->wherein('status',[0,1,2,3,4,5,6,11,12,14,13,15])->Where('phone', 'like', '%' .$lastdi. '%')->update(['status' => 28]);

    return redirect('/addbannedcustomers')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/addbannedcustomers')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function updatebannedcus(Request $request){
    $data = bannedcustomers::find($request->id);

    try{

        $data->phoneno = $request->Phone_Number;
        $data->reason = $request->reason;
        $data->save();

        $lastdi= substr($request->Phone_Number, -9);
        DB::table('customers')->wherein('status',[0,1,2,3,4,5,6,11,12,14,13,15])->Where('phone', 'like', '%' .$lastdi. '%')->update(['status' => 28]);    

        return redirect('/addbannedcustomers')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/addbannedcustomers')->with('error', 'Error : '.$ex->getMessage());
        }
}

public function deletebannedcus(Request $request,$id){

    $data = bannedcustomers::find($id);
   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        $data->delete();
        return  Response::json(['status' => $data], 200);
   }
}


public function banneduser(Request $request)
{
    $data = DB::table('customers')->where('status',0)->get();
    $getbanned = bannedcustomers::get();
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
    foreach($getbanned as $bdata){
        $lastdi= substr($bdata->phoneno, -9);
        DB::table('customers')->where('status',0)->Where('phone', 'like', '%' .$lastdi. '%')->update(['status' => 28]);

    }
        return  Response::json(['status' => $data], 200);
   }
}

public function bulkdelivery(){        
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $item = customer::where('status',18)->whereBetween('updated_at',[$da,$da2])->get();

    return view('dashboard/orders/bulkdelivery',['item'=>$item]);
}

public function bulkexceldelivery(Request $request){

    if($request->hasFile('import_file')){
        $path = $request->file('import_file')->getRealPath();
        $data = Excel::load($path, function($reader) {})->get();

        if(!empty($data) && $data->count()){
            foreach ($data->toArray() as $key => $value) {  
                    $gettac = customer::where('tracking',$value['waybill'])->get();
                    foreach($gettac as $trackd){

                    if($trackd->status == 9 OR $trackd->status == 18 OR $trackd->status == 33 OR $trackd->status == 34){

                    }
                    else{
                        $updatecus = customer::find($trackd->id);
                        $updatecus->status='18';
                        $updatecus->deliverystatus='18';
                        $updatecus->save();

                        $statrack = new statustrack;
                        $statrack->customerid=$trackd->id;
                        $statrack->username=Auth::user()->name;
                        $statrack->orderstatus=18;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();

                    }

                    }

          }

            if(!empty($value)){
                return back()->with('success','Insert Record successfully.');
                
            }
        }
    }
    return back()->with('error','Please Check your file, Something is wrong there.');
}


public function unitpricechangesup(Request $request){

    try{
        $data = purchesproduct::find($request->unitpid);
        $data->unitprice = $request->uprice;
        $data->save();

        $items = purchesproduct::where('purchesid', $request->purid)->get();
        $unit=0;
        $tot=0;
        foreach($items as $item) {
            $unit = ($item->unitprice)*($item->qty);
            $tot += $unit;
        }
        $purup = purchasing::find($request->purid);
        $purup->cost = $tot;
        $purup->save();

        return redirect('/supplierproductdetails/'.$request->purid)->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/supplierproductdetails/'.$request->purid)->with('error', 'Error : '.$ex->getMessage());
        }
}


public function gotoeditpage(Request $request){
    $id=$request->invoiceno;
    $items = customer::where('id', $id)->get();
    $check = customer::where('id', $id)->get()->count();

    if(empty($check)){
        return redirect('/home');
    }
    else{
    foreach($items as $itemsdata) {
        $status=$itemsdata->status;
    }
    return redirect('/viwedetails/'.$id);

}
}

public function storepickupmoneyreceived(){
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $ldaco = date('Y/m/d');
    $today = $ldaco.' - '.$ldaco;

    $item = customer::where('ordersource', 'Store Pickup')->wherein('status',[18,9])->whereBetween('created_at',[$da,$da2])->get();
    $supdata = companybank::get();
    $ldate = date('Y-m-d H:i:s');

    return view('dashboard/accounts/storepickupmo',['supdata'=>$supdata,'ldate'=>$ldate,'item'=>$item,'today'=>$today]);
}


public function storepickupfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $item = customer::where('ordersource', 'Store Pickup')->wherein('status',[18,9])->whereBetween('created_at',[$da,$da2])->get();
    $supdata = companybank::get();
    $ldate = date('Y-m-d H:i:s');

    return view('dashboard/accounts/storepickupmo',['supdata'=>$supdata,'ldate'=>$ldate,'item'=>$item,'today'=>$request->daterange]);
}


public function storepaymentrecive(Request $request){
    $data = customer::find($request->id);
    $sta = $request->has('paidstatus');
    try{
        if($sta=="true"){

            $bankto = companybank::where('id',$request->bank)->first();

            $bandata = new banktransaction();
            $bandata->user = Auth::user()->name;
            $bandata->bankid = $request->bank;
            $bandata->withdrawal = 0;
            $bandata->deposit = $request->cod;
            $bandata->balance = floatval($bankto->balance)+floatval($request->cod);
            $bandata->note = $request->id.'-StorePickup-deposit';
            $bandata->accoption = 'deposit';
            $bandata->save();
    
            $oitem2 = companybank::find($request->bank);
            $oitem2->balance = floatval($bankto->balance)+floatval($request->cod);
            $oitem2->save();

            $data->status = 9;
            $data->moneyrecivestatus = 1;
            $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=9;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        else{

            }

    return redirect('/storepickupmoneyreceived')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/storepickupmoneyreceived')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function remindorders(){
    $ldate = date('Y/m/d');
    $ddate = $ldate.' - '.$ldate;
    $da2 = $ldate.' 23:59:59';

    $items = customer::whereIn('deliverystatus', [30,46])->where('deliverydate',$ldate)->get();    
    
    return view('dashboard/orders/remindorders')->with(['item'=>$items,'dateran'=>$ddate]);
}

public function remindfilter(Request $request){

    $items = customer::whereIn('deliverystatus', [30,46])->where('deliverydate',$request->delivery_date)->get();

    return view('dashboard/orders/remindorders',['item'=>$items,'dateran'=>$request->delivery_date]);
}
public function bulkremindorderupload(Request $request){
    $ldate = date('Y/m/d');

    if($request->Reshedule == "Reshedule"){
        if($request->hasFile('import_file')){
            $path = $request->file('import_file')->getRealPath();
            $data = Excel::load($path, function($reader) {})->get();
    
            if(!empty($data) && $data->count()){
                foreach ($data->toArray() as $key => $value) {  
                        $gettac = customer::where('tracking',$value['waybill'])->get();
                        foreach($gettac as $trackd){
    
                        if($trackd->status == 9 OR $trackd->status == 18 OR $trackd->status == 33 OR $trackd->status == 34){
    
                        }
                        else{
                            $updatecus = customer::find($trackd->id);
                            $updatecus->deliverystatus='30';
                            $updatecus->deliverydate=$ldate;
                            $updatecus->save();
    
                            $statrack = new statustrack;
                            $statrack->customerid=$trackd->id;
                            $statrack->username=Auth::user()->name;
                            $statrack->orderstatus=30;
                            $statrack->starttime=0;
                            $statrack->endtime=0;
                            $statrack->status=0;
                            $statrack->save();
    
                        }
    
                        }
    
              }
    
                if(!empty($value)){
                    return back()->with('success','Insert Record successfully.');
                    
                }
            }
        }
        return back()->with('error','Please Check your file, Something is wrong there.');

    }
    else{
        if($request->hasFile('import_file')){
            $path = $request->file('import_file')->getRealPath();
            $data = Excel::load($path, function($reader) {})->get();
    
            if(!empty($data) && $data->count()){
                foreach ($data->toArray() as $key => $value) {  
                        $gettac = customer::where('tracking',$value['waybill'])->get();
                        foreach($gettac as $trackd){
    
                        if($trackd->status == 9 OR $trackd->status == 18 OR $trackd->status == 33 OR $trackd->status == 34){
    
                        }
                        else{
                            $updatecus = customer::find($trackd->id);
                            $updatecus->deliverystatus='46';
                            $updatecus->deliverydate=$ldate;
                            $updatecus->save();
    
                            $statrack = new statustrack;
                            $statrack->customerid=$trackd->id;
                            $statrack->username=Auth::user()->name;
                            $statrack->orderstatus=46;
                            $statrack->starttime=0;
                            $statrack->endtime=0;
                            $statrack->status=0;
                            $statrack->save();
    
                        }
    
                        }
    
              }
    
                if(!empty($value)){
                    return back()->with('success','Insert Record successfully.');
                    
                }
            }
        }
        return back()->with('error','Please Check your file, Something is wrong there.');

    }


}
public function reasonupdateview(Request $request){
    try{

        $data = customer::find($request->id5);
        $data->status = 10;
        $data->note = $request->reason;
        $data->lockstatus=0;
        $data->save();

        $statrack = new statustrack;
        $statrack->customerid=$request->id5;
        $statrack->username=Auth::user()->name;
        $statrack->orderstatus=10;
        $statrack->starttime=0;
        $statrack->endtime=0;
        $statrack->status=0;
        $statrack->save();
    
    return redirect('/closewindow')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/closewindow')->with('error', 'Error : '.$ex->getMessage());
    }
}




public function addbranch(Request $request){
    $data = new branch();
    try{

    $data->branch = $request->branch;
    $data->save();

    return redirect('/branch')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/branch')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function branch(){

    $items = branch::get();
        
        return view('dashboard/product/addbranch')->with(['item'=>$items]);
    }
    
    public function updatebranch(Request $request){
        $data = branch::find($request->id);
    
        try{
    
            $data->branch = $request->branch;
            $data->save();
    
            return redirect('/branch')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/branch')->with('error', 'Error : '.$ex->getMessage());
            }
    }


    public function deletecheckorders(Request $request){
        $getcus = customer::where('user',Auth::user()->getresellerd->id)->where('status', 0)->get();
    
       if($getcus==null){
            return  Response::json([
                'status' => false
            ], 423);
       }else{
           foreach($getcus as $cusdata){
            $data = customer::find($cusdata->id);
            $itemde = cus_orders::where('cus_id', $cusdata->id);
            $bardel = ordersbarcode::where('customerid', $cusdata->id);
    
            $data->delete();
            $itemde->delete();
            $bardel->delete();
           }
    
                   return  Response::json(['status' => $getcus], 200);
       }
    }
    
    
    //report
    public function resellerorders(){
        $ldate = date('Y/m/d');
        $date = $ldate.' - '.$ldate;
        $ldate1 = date('Y-m-d');
        $da= $ldate1.' 00:00:00';
        $da2= $ldate1.' 23:59:59';
    
        $rese = resellerdetails::get();
        $del=" ";

        return view('dashboard/reports/resellerorders')->with(['rese'=>$rese,'del'=>$del,'date'=>$date]);
    }
    public function resellerorderfilter(Request $request){
        list($da1, $da222) = explode('-', $request->daterange);
          
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';
        $maindata=[];
        $rate=0;
        $rese = resellerdetails::get();
        foreach($rese as $redata){
            $con = customer::whereIn('status', [17,5,6,11,12,13,14,15,8,30,9,18,33,7,34,35,36,37])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
            $dis = customer::whereIn('status', [8])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
            $ret = customer::whereIn('status', [7,34,35])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
            $mone = customer::whereIn('status', [18,9,33])->where('user', $redata->id)->whereBetween('created_at',[$da,$da2])->count();
   
            if($mone !=0 AND $ret !=0){
                $rate=(($mone)/($ret+$mone))*100;
            }
            else{
                $rate=0;
            }
            $minudata=['name'=>$redata->companyname,'con'=>$con,'dis'=>$dis,'ret'=>$ret,'mone'=>$mone,'rate'=>$rate];
            array_push($maindata, $minudata);
        }
        
        return view('dashboard/reports/resellerorders2')->with(['maindata'=>$maindata,'rese'=>$rese,'date'=>$request->daterange]);
    }

public function unauthorizedreturn(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $items = customer::where('status', 7)->wherein('deliverystatus', [0,21,22])->where('deliveryservice','!=' ,'-')->whereBetween('updated_at',[$da,$da2])->get();
    $delise = deliveryservice::get();
    $del=" ";
    return view('dashboard/reports/unathorized')->with(['item'=>$items,'delise'=>$delise,'del'=>$del,'date'=>$date]);
}

public function unauthorizedreturnfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $items = customer::where('status', 7)->wherein('deliverystatus', [0,21,22])->where('deliveryservice', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();
    $delise = deliveryservice::get();
    
    return view('dashboard/reports/unathorized')->with(['item'=>$items,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);
}


public function userconfirm(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $allconfirmcount=0;
    $delise = user::where('resellerid',Auth::user()->resellerid)->get();
    $del="null";
    return view('dashboard/reports/userconfirm')->with(['allconfirmcount'=>$allconfirmcount,'delise'=>$delise,'del'=>$del,'date'=>$date]);
}

public function userconfirmfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';
    $delise = user::where('resellerid',Auth::user()->resellerid)->get();

    $allconfirmcount = DB::connection('mysql')->select("select username, count(*) as count from (select username, customerid from statustracks where orderstatus in (17) and created_at between '$da' and '$da2' group by customerid) dt group by username");

    $dataor =  customer::select('customers.id')
    ->join('statustracks', 'statustracks.customerid', '=' , 'customers.id');
    $dataor=$dataor->where('customers.status', 34)->wherein('statustracks.orderstatus', ([17]))->where('statustracks.username', $request->delivery)->whereBetween('customers.created_at',[$da,$da2])->get();
   
    $cancount = DB::connection('mysql')->select("select username, count(*) as count from (select statustracks.username from statustracks cross join customers on customers.id = statustracks.customerid where statustracks.orderstatus in (17) and customers.status = 34 and customers.updated_at between '$da' and '$da2' group by statustracks.customerid) dt group by username");

    $delmoney = customer::select('customers.id','customers.cod','customers.deliverycharge')->join('statustracks', 'statustracks.customerid', '=' , 'customers.id')
    ->where('customers.status', 33)->wherein('statustracks.orderstatus', ([17]))->where('statustracks.username', $request->delivery)->whereBetween('customers.created_at',[$da,$da2])->get();
    $cod=0;$delivery=0;
    foreach($delmoney as $money){
        $cod+=$money->cod;
        $delivery+=$money->deliverycharge;
    }

    return view('dashboard/reports/userconfirm')->with(['delivery'=>$delivery,'cod'=>$cod,'dataor'=>$cancount,'allconfirmcount'=>$allconfirmcount,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);
}


public function usertrackreport(){
    if(Auth::user()->email=="ashan.mal@gmail.com" OR Auth::user()->email=="mjayanatha@gmail.com"){

    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $delise = user::get();
    $del="null";
    return view('dashboard/reports/trackuser')->with(['delise'=>$delise,'del'=>$del,'date'=>$date]);

        
}

    else{
        return redirect('/home');
    }
}

public function usertrackreportfilter(Request $request){
    if(Auth::user()->email=="ashan.mal@gmail.com" OR Auth::user()->email=="mjayanatha@gmail.com"){

        list($da1, $da222) = explode('-', $request->daterange);
      
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';
        $delise = user::get();

    if($request->delivery == 01){
        $item = statustrack::wherein('orderstatus', [5,6,19,10])->where('starttime','!=', '0')->whereBetween('created_at',[$da,$da2])->get();

    }
    else{
        $item = statustrack::wherein('orderstatus', [5,6,19,10])->where('starttime','!=', '0')->where('username', $request->delivery)->whereBetween('created_at',[$da,$da2])->get();

    }



    return view('dashboard/reports/trackuser')->with(['item'=>$item,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);

        
}

    else{
        return redirect('/home');
    }
}

public function remainingstockreport(){
    $products = DB::connection('mysql2')->select('select * from order_items');
    
    return view('dashboard/reports/remaningstock',['product'=>$products]);
}

public function transactionsummary(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    $bank="";
    $accop="null";
    return view('dashboard/reports/transactionsummary',['accoption'=>$accoption, 'supdata'=>$supdatas,'date'=>$date,'bank'=>$bank,'acc'=>$accop]);
}

public function transactionsummaryfilter(Request $request){

    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $supdatas = companybank::get();
    $accoption = accountoption::get();

    if($request->accoption == "all"){
        $item = banktransaction::where('bankid',$request->bank)->whereBetween('created_at',[$da,$da2])->get();
    }
    else{
        $item = banktransaction::where('accoption',$request->accoption)->where('bankid',$request->bank)->whereBetween('created_at',[$da,$da2])->get();
    }
    

    return view('dashboard/reports/transactionsummary',['item'=>$item,'accoption'=>$accoption, 'supdata'=>$supdatas,'date'=>$request->daterange,'bank'=>$request->bank,'acc'=>$request->accoption]);
}

public function chequesummary(){
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $ldaco = date('Y/m/d');
    $today = $ldaco.' - '.$ldaco;

    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->get();
    $ldate = date('Y-m-d H:i:s');
    $paym="all";

    return view('dashboard/reports/chequesummary',['chequem'=>$chequem,'ldate'=>$ldate,'whol'=>$whol,'supplier'=>$supplier,'today'=>$today,'paym'=>$paym]);
}


public function chequesummaryfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

if($request->status=="all"){
    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->whereBetween('created_at',[$da,$da2])->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->get();

}
else if($request->status==0){
    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->where('status',$request->status)->get();

}
else{
    $whol = wholesalepayemet::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->whereBetween('created_at',[$da,$da2])->get();
    $supplier = supplierpayment::wherein('paymenttype',['cheque','credit'])->where('status',$request->status)->whereBetween('created_at',[$da,$da2])->get();
    $chequem = chequeownm::whereBetween('created_at',[$da,$da2])->where('status',$request->status)->get();

}

    $ldate = date('Y-m-d H:i:s');

    return view('dashboard/reports/chequesummary',['chequem'=>$chequem,'ldate'=>$ldate,'whol'=>$whol,'supplier'=>$supplier,'today'=>$request->daterange,'paym'=>$request->status]);
}

public function purchasesummary(){
    $datas = supplier::get();
    $ban = companybank::get();
    $purces = purchasing::get();
    $purc = supplier::get();
    $products = orderItem::get();
    $ldate = date('Y-m-d H:i:s');
    $ldaco = date('Y/m/d');
    $today = $ldaco.' - '.$ldaco;
    $sta = "";
    $supid = "null";

    return view('dashboard/reports/purchasesummary',['supid'=>$supid,'sta'=>$sta,'dateran'=>$today,'product'=>$products,'purc'=>$purc,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
}

public function purchasesummaryfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $datas = supplier::get();
    $ban = companybank::get();
    $purc = supplier::get();
    $ldate = date('Y-m-d H:i:s');

    if($request->status == 55){
        $purces = purchasing::where('supplierid',$request->supplier_name)->whereBetween('created_at',[$da,$da2])->get();

    }
    else if($request->status == 0){
        $purces = purchasing::where('supplierid',$request->supplier_name)->where('status',$request->status)->get();

    }
    else{
        $purces = purchasing::where('supplierid',$request->supplier_name)->where('status',$request->status)->whereBetween('created_at',[$da,$da2])->get();

    }

    return view('dashboard/reports/purchasesummary',['sta'=>$request->status,'supid'=>$request->supplier_name,'dateran'=>$request->daterange,'purc'=>$purc,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
}

public function wholesalesummary(){
    $ldate = date('Y-m-d H:i:s');

    $datas = wholesalecustomer::get();
    $products = orderItem::get();
    $purces = wholesale::get();
    $bankd = companybank::get();
    $whole = "null";
    $sta = "null";
    $ldaco = date('Y/m/d');
    $today = $ldaco.' - '.$ldaco;
    return view('dashboard/reports/wholesalesummary',['dateran'=>$today,'sta'=>$sta,'whole'=>$whole,'bankd'=>$bankd,'ldate'=>$ldate,'item'=>$datas, 'product'=>$products, 'purce'=>$purces]);
}


public function wholesalesummaryfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $ban = companybank::get();
    $datas = wholesalecustomer::get();
    $ldate = date('Y-m-d H:i:s');

    if($request->status == 55){
        $purces = wholesale::where('wholesaleuserid',$request->whole_name)->whereBetween('created_at',[$da,$da2])->get();

    }
    else if($request->status == 0){
        $purces = wholesale::where('wholesaleuserid',$request->whole_name)->where('status',$request->status)->get();

    }
    else{
        $purces = wholesale::where('wholesaleuserid',$request->whole_name)->where('status',$request->status)->whereBetween('created_at',[$da,$da2])->get();

    }

    return view('dashboard/reports/wholesalesummary',['sta'=>$request->status,'whole'=>$request->whole_name,'dateran'=>$request->daterange,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
}

public function riderpaymentsummary(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $deli="all";
    $delise = user::get();

    $tcod=0;
    $riderdelivery=0;
    $noofline=0;


    $dataor =  customer::select('customers.id','users.name', DB::raw("SUM(customers.cod) as cod"), DB::raw("COUNT(*) as count"))
    ->join('users', 'users.id', '=' , 'customers.ridername');

    $dataor=$dataor->where('customers.status', 9)->where('moneyrecivestatus', 1)->where('customers.deliverydate', $ldate)->where('customers.companydelivery', 1)->where('customers.companydelivery', 1)
    ->groupBy('users.name')->get();
    
    foreach($dataor as $dataordata){
        $tcod+=$dataordata->cod;
        $noofline+=$dataordata->count;
        
    }

    return view('dashboard/reports/riderpayment')->with(['dataor'=>$dataor,'riderdelivery'=>$riderdelivery,'noofline'=>$noofline,'tcod'=>$tcod,'ldate'=>$ldate,'deli'=>$deli,'delise'=>$delise]);
}

public function riderpaymentsummaryfilter(Request $request){
    $delise = user::get();

    $ldate=$request->delivery_date;
    $deli=$request->delivery_name;
    $tcod=0;
    $riderdelivery=0;
    $noofline=0;

    $dataor =  customer::select('customers.id','users.name', DB::raw("SUM(customers.cod) as cod"), DB::raw("COUNT(*) as count"))
    ->join('users', 'users.id', '=' , 'customers.ridername');

    $dataor=$dataor->where('customers.status', 9)->where('moneyrecivestatus', 1)->where('customers.deliverydate', $ldate)->where('customers.companydelivery', 1)->where('customers.companydelivery', 1)
    ->groupBy('users.name')->get();

    $ridern = user::where('id',$request->delivery_name)->first();

    foreach($dataor as $dataordata){
        $tcod+=$dataordata->cod;
        $noofline+=$dataordata->count;
        
    }

    return view('dashboard/reports/riderpayment')->with(['noofline'=>$noofline,'tcod'=>$tcod,'dataor'=>$dataor,'riderns'=>$ridern,'riderdelivery'=>$riderdelivery,'ldate'=>$ldate,'delise'=>$delise]);
}

public function courierpaymentsummary(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $cuso = courierrecivemoney::get();
    $delise = deliveryservice::get();
    $del = "null";

    return view('dashboard/reports/courierpayment')->with(['del'=>$del,'ldate'=>$ldate,'delise'=>$delise,'cuso'=>$cuso]);
}

public function courierpaymentsummaryfilter(Request $request){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $cuso = courierrecivemoney::where('deliverycompany',$request->delivery)->get();
    $delise = deliveryservice::get();
    $del = "null";

    return view('dashboard/reports/courierpayment')->with(['del'=>$request->delivery,'ldate'=>$ldate,'delise'=>$delise,'cuso'=>$cuso]);
}

public function salesummary(){

    return view('dashboard/reports/salesummary');
}


public function salesummaryfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $colombo = customer::where('status', 33)->where('companydelivery',1)->where('moneyrecivestatus', 1)->whereBetween('created_at',[$da,$da2])->get()->count();
    $out = customer::where('status', 33)->where('deliveryservice','!=','-')->whereBetween('created_at',[$da,$da2])->get()->count();

    $colombopa = customer::where('status', 33)->where('companydelivery',1)->where('moneyrecivestatus', 1)->whereBetween('created_at',[$da,$da2])->get();
    $outpa = customer::where('status', 33)->where('deliveryservice','!=','-')->whereBetween('created_at',[$da,$da2])->get();

    $coltot=0;
    foreach($colombopa as $colombopad){
        $coltot+=$colombopad->cod;
    }
    $outtot=0;
    foreach($outpa as $outpad){
        $outtot+=$outpad->cod;
    }

    //riderpayment
    $dataor =  customer::select('customers.id','users.name', DB::raw("SUM(customers.cod) as cod"), DB::raw("COUNT(*) as count"))
    ->join('users', 'users.id', '=' , 'customers.ridername');

    $dataor=$dataor->where('customers.status', 9)->where('moneyrecivestatus', 1)->whereBetween('customers.created_at',[$da,$da2])->where('customers.companydelivery', 1)
    ->groupBy('users.name')->get();
    $tcod=0;
    $riderdelivery=0;
    $noofline=0;
    foreach($dataor as $dataordata){
        $tcod+=$dataordata->cod;
        $noofline+=$dataordata->count;
        
    }

    $courierpay = courierrecivemoney::where('status',1)->whereBetween('created_at',[$da,$da2])->get();
    $coda=0;
    $delc=0;
    $palyb=0;
    foreach($courierpay as $courierpayd){
        $coda+=$courierpayd->codamount;
        $delc+=$courierpayd->deliverycharge;
        $palyb+=$courierpayd->payablecod;
        
    }

    $money = customer::where('status',33)->whereBetween('created_at',[$da,$da2])->get();
    $return = customer::where('status',34)->whereBetween('created_at',[$da,$da2])->get();
    $refund = customer::where('status',36)->whereBetween('created_at',[$da,$da2])->get();
    $counttot = customer::wherein('status',[34,33])->whereBetween('created_at',[$da,$da2])->get()->count();

    $mondel=0;
    $totcod=0;
    $totrefundcod=0;
    $totinventory=0;
    $servicech=0;
    $returnservice=0;
    $totservice=0;
    foreach($money as $modata){
        $mondel+=$modata->orderdelivery;
        $totcod+=$modata->cod;
        $servicech+=$modata->servicecharge;

    foreach($modata->cus_or as $iprod){
        $totinventory+=$iprod->reseller_cost*$iprod->qty;
        }
    }
    foreach($return as $returndat){
        $returnservice+=$returndat->servicecharge;
    }
    foreach($refund as $refunddat){
        $totrefundcod+=$refunddat->cod;
    }
    $totservice=$servicech+$returnservice;
    
    return view('dashboard/reports/salesummary2')->with(['servicech'=>$totservice,'totinventory'=>$totinventory,'refund'=>$refund,'totrefundcod'=>$totrefundcod,'counttot'=>$counttot,'totcod'=>$totcod,'mondel'=>$mondel,'deli'=>$request->resller,'return'=>$return,'money'=>$money, 'palyb'=>$palyb,'delc'=>$delc,'coda'=>$coda,'courierpay'=>$courierpay,'noofline'=>$noofline,'tcod'=>$tcod,'dataor'=>$dataor,'outtot'=>$outtot,'coltot'=>$coltot,'out'=>$out,'colombo'=>$colombo,'dateran'=>$request->daterange]);
}

public function addcheque(Request $request){
    try{
        if($request->payment == "Debit"){

            $cheq = new chequeownm();
            $cheq->dealername = $request->ownname;
            $cheq->paymenttype = $request->payment;
            $cheq->paiddate = '-';
            $cheq->ccdate = $request->Cheque_date;
            $cheq->checkno = $request->Chequeno;
            $cheq->amount = $request->amount;
            $cheq->bankid = $request->bankche;
            $cheq->accoption = "-";
            $cheq->status = 0;
            $cheq->note = $request->note;
            $cheq->save();
        }
        else{
            $cheq = new chequeownm();
            $cheq->dealername = $request->ownname;
            $cheq->paymenttype = $request->payment;
            $cheq->paiddate = '-';
            $cheq->ccdate = $request->Cheque_date;
            $cheq->checkno = $request->Chequeno;
            $cheq->amount = $request->amount;
            $cheq->bankid = $request->bankche;
            $cheq->accoption = "-";
            $cheq->status = 0;
            $cheq->note = $request->note;
            $cheq->save();

        }


    return redirect('/chequemanage')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/chequemanage')->with('error', 'Error : '.$ex->getMessage());
    }
}


public function chequemangepaidup(Request $request){
    $sta = $request->has('paidstatus');
    try{
    $getdata = chequeownm::where('id',$request->id)->first();
    if($sta=="true"){

        if($request->payment == "Debit" OR $request->payment == "cheque"){    
            $bankform = companybank::where('id',$request->bankche)->first();

            $data = new banktransaction();
            $data->user = Auth::user()->name;
            $data->bankid = $request->bankche;
            $data->withdrawal = $request->amount;
            $data->deposit = 0;
            $data->balance = floatval($bankform->balance)-floatval($request->amount);
            $data->note = $getdata->dealername.'-cheque-'.$getdata->checkno;
            $data->accoption = $getdata->accoption;
            $data->save();

            $oitem = companybank::find($request->bankche);
            $oitem->balance = floatval($bankform->balance)-floatval($request->amount);
            $oitem->save();
        }
        else{    
            $bankform = companybank::where('id',$request->bankche)->first();

            $data = new banktransaction();
            $data->user = Auth::user()->name;
            $data->bankid = $request->bankche;
            $data->withdrawal = 0;
            $data->deposit =$request->amount;
            $data->balance = floatval($bankform->balance)+floatval($request->amount);
            $data->note = $getdata->dealername.'-cheque-'.$getdata->checkno;
            $data->accoption = $getdata->accoption;
            $data->save();

            $oitem = companybank::find($request->bankche);
            $oitem->balance = floatval($bankform->balance)+floatval($request->amount);
            $oitem->save();

        }
            $ldate = date('Y-m-d');
            $updata = chequeownm::find($request->id);
            $updata->status = 1;
            $updata->paiddate = $ldate;
            $updata->save();
    }
        else{

         }
        
         return  Response::json(['status' => $data], 200);
        }
        catch (Exception $ex){
            return  Response::json(['status' => false], 423);
        }  
}



public function colomboretuenrecive(){
    $items = pages::get();
    $products = productbarcode::get();

    return view('dashboard/inventory/colomboretuenrecive')->with(['item'=>$items, 'product'=>$products]);
}
public function getcolomboretuen()
{
    $users = productbarcode::select(['id','productid','barcode', 'itemstatus']);

    return Datatables::of($users)->addColumn('action', function($users){
        return
        '&nbsp;&nbsp;<a data-id="'.$users->id.'" class="btn btn-primary btn-xs" href="viwedetails/'.$users->id.'">View</a>';})
    ->make(true);
}

public function updatecolomboreturn(Request $request)
{
    $barcod = productbarcode::where('barcode', $request->waybill)->first();
    $tempbar = tempriderbarcode::where('barcode', $request->waybill)->first();

   if($barcod==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{

        $tempbar->status = '2';
        $tempbar->save();

        $barcod->itemstatus = '0';
        $barcod->save();

               return  Response::json([
        'status' => $barcod
    ], 200);
   }
}

public function searchwaybille(Request $request){
    $id=$request->invoiceno;
    $items = trackingrange::where('trackingno', $id)->get()->first();
    $check = trackingrange::where('trackingno', $id)->get()->count();

    if(empty($check)){
        return redirect('/home');
    }
    else{

    return redirect('/viewallorders/'.$items->customerid);

}
}


public function checkapi(){
    $items = pages::get();
    $products = productbarcode::get();

    return view('dashboard/inventory/checkapi')->with(['item'=>$items, 'product'=>$products]);
}


public function checkapiupdate(Request $request){
    try{

        $api_key               = "api60fba3cb2733d";                             
        $client_id             = "1151";
        $recipient_name        = "kamal";
        $recipient_contact_no  = "0755555555";
        $recipient_address     = "kottawa,pannipitiya"; 
        $recipient_city        = "nugegoda"; 
        $parcel_type           = "1";
        $cod_amount            = "0"; 
        $parcel_description    = "book";
        $order_id              = "99999";        
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL,"https://fardardomestic.com/api/p_request_v1.02.php");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS,
        "client_id=$client_id&api_key=$api_key&recipient_name=$recipient_name&recipient_contact_no=$recipient_contact_no&recipient_address=$recipient_address&parcel_type=$parcel_type&recipient_city=$recipient_city&parcel_description=$parcel_description&cod_amount=$cod_amount&order_id=$order_id");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $server_output = curl_exec($ch);
        $err = curl_error($ch);
        $data = json_decode($server_output, TRUE);
        curl_close ($ch);  

        if ($err) {
            return  Response::json(['status' => $err], 423);
        } else {


        $wayup = customer::find(1000);
        $wayup->tracking = $data['waybill_no'];
        $wayup->save();


            return  Response::json(['status' => $data], 200);
        }

        
        
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }
}

public function getsupplierbalance(Request $request,$id){
    $data = supplier::where('id',$id)->get();

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{

        return  Response::json(['status' => $data], 200);
   }
}

public function purpaymentnew(){
    $datas = supplier::get();
    $ban = companybank::get();
    $purces = purchasing::get();
    $purc = supplier::get();
    $products = orderItem::get();
    $ldate = date('Y-m-d H:i:s');

    return view('dashboard/accounts/purpaymentnew',['product'=>$products,'purc'=>$purc,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
}


public function purchespayhistory(){
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $ldaco = date('Y/m/d');
    $today = $ldaco.' - '.$ldaco;

    $purc = supplier::get();

    $supplier = supplierpayment::whereBetween('created_at',[$da,$da2])->get();
    $ldate = date('Y-m-d H:i:s');
    $paym="all";
    $supid="null";
    return view('dashboard/accounts/purchespayhistory',['supid'=>$supid,'purc'=>$purc,'ldate'=>$ldate,'supplier'=>$supplier,'today'=>$today,'paym'=>$paym]);
}


public function packbulkprint(Request $request)
{
    $checid = $request->checkids;
    $cbCount = count($checid);
    if($cbCount==0){
        return redirect('/inventorytoday')->with('error', 'No select Orders');
    }
    else{
    $ldate = date('Y-m-d');
    $cus = customer::with('cus_or')->wherein('id', $checid)->get();
    $user = deliveryservice::where('id', $request->delivery)->get();
    $prod = DB::connection('mysql2')->select('select * from order_items');
    $pdf = PDF::loadView('dashboard.shipping.todayprintpdf', array('prod'=>$prod,'cus'=>$cus,'ldate'=> $ldate,'user'=> $user))->setPaper('a4');
  return $pdf->stream(); 
    }

}


public function purchespayhistoryfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    if($request->status=="all"){
        $supplier = supplierpayment::where('paymentid',$request->supplier_name)->whereBetween('created_at',[$da,$da2])->get();
    }
    else if($request->status==0){
        $supplier = supplierpayment::where('status',0)->where('paymentid',$request->supplier_name)->get();

    }
    else{
        $supplier = supplierpayment::where('status',$request->status)->where('paymentid',$request->supplier_name)->whereBetween('created_at',[$da,$da2])->get();

    }
    
    $purc = supplier::get();
    $ldate = date('Y-m-d H:i:s');


    return view('dashboard/accounts/purchespayhistory',['supid'=>$request->supplier_name,'purc'=>$purc,'ldate'=>$ldate,'supplier'=>$supplier,'today'=>$request->daterange,'paym'=>$request->status]);
}

public function supplierpaymentrecive(Request $request){
    $data = new banktransaction();
    $bankdata = companybank::where('id',$request->bank)->first();
    $ldate = date('Y-m-d H:i:s');
    try{

        $data->user = Auth::user()->name;
        $data->bankid = $request->bank;
        $data->withdrawal = $request->amount;
        $data->deposit = 0;
        $data->balance = floatval($bankdata->balance)-floatval($request->amount);
        $data->note = $request->type.'-'.$request->wholeid.'-purchase-payment';
        $data->accoption = $request->type;
        $data->save();

        $oitem = companybank::find($request->bank);
        $oitem->balance = floatval($bankdata->balance)-floatval($request->amount);
        $oitem->save();

        $suppay = supplierpayment::find($request->id);
        $suppay->status = "1";
        $suppay->paiddate = $ldate;
        $suppay->save();
    
        return  Response::json(['status' => $data], 200);
        }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }
}


public function chequedeposit(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/bank/chequedeposit',['accoption'=>$accoption,'supdata'=>$supdatas]);
}

public function chequewithdraw(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/bank/chequewithdraw',['accoption'=>$accoption,'supdata'=>$supdatas]);
}

public function getbankdata(Request $request,$id){
    $data = companybank::where('id',$id)->get();

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{

        return  Response::json(['status' => $data], 200);
   }
}

public function getbankdata2(Request $request,$id){
    $data = companybank::where('id',$id)->get();

   if($data==null){
        return  Response::json(['status' => false], 423);
   }else{

        return  Response::json(['status' => $data], 200);
   }
}

public function cashdeposit(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/bank/cashdeposit',['accoption'=>$accoption,'supdata'=>$supdatas]);
}
public function cashwithdraw(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/bank/cashwithdraw',['accoption'=>$accoption,'supdata'=>$supdatas]);
}
public function expenses(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/bank/expenses',['accoption'=>$accoption,'supdata'=>$supdatas]);
}

public function ownbanktransaction(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    return view('dashboard/bank/ownbanktransaction',['accoption'=>$accoption,'supdata'=>$supdatas]);
}


public function addexpenses(Request $request){
    $data = new banktransaction();
    $bankdata = companybank::where('id',$request->bankche)->first();
   
    if( $request->paymenttype=="cheque"){
        try{

        $cheq = new chequeownm();
        $cheq->dealername = $request->ownname;
        $cheq->paymenttype = $request->paymenttype;
        $cheq->paiddate = '-';
        $cheq->ccdate = $request->Cheque_date;
        $cheq->checkno = $request->Chequeno;
        $cheq->amount = $request->amount;
        $cheq->bankid = $request->bankche;
        $cheq->accoption = $request->accoption;
        $cheq->status = 0;
        $cheq->note = $request->note;
        $cheq->save();
        
        return redirect('/chequemanage')->with('success', 'Successfully Saved!');
    
        }
    catch (Exception $ex){
        return redirect('/expenses')->with('error', 'Error : '.$ex->getMessage());
    }
    }
    else{
        try{

        $data->user = Auth::user()->name;
        $data->bankid = $request->bankche;
        $data->withdrawal = $request->amount;
        $data->deposit = 0;
        $data->balance = floatval($bankdata->balance)-floatval($request->amount);
        $data->note =  $request->paymenttype.'-'.$request->note;
        $data->accoption = $request->accoption;
        $data->save();

        $oitem = companybank::find($request->bankche);
        $oitem->balance = floatval($bankdata->balance)-floatval($request->amount);
        $oitem->save();

    


        return redirect('/expenses')->with('success', 'Successfully Saved!');
        }        
    catch (Exception $ex){
        return redirect('/expenses')->with('error', 'Error : '.$ex->getMessage());
    }
}
}
public function expensestransaction(){
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    $tran = banktransaction::get();
    $bankd = "null";
    $acco = "null";

    $ldaco = date('Y/m/d');
    $today = $ldaco.' - '.$ldaco;
    $tot =0;
    return view('dashboard/bank/expenseshistory',['tot'=>$tot,'tran'=>$tran,'today'=>$today,'acco'=>$acco,'bankd'=>$bankd,'accoption'=>$accoption, 'supdata'=>$supdatas]);
}

public function expensestransactionfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    if($request->accoption=="all"){
        $tran = banktransaction::where('bankid',$request->bank)->whereBetween('created_at',[$da,$da2])->get();
    }

    else{
        $tran = banktransaction::where('bankid',$request->bank)->where('accoption',$request->accoption)->whereBetween('created_at',[$da,$da2])->get();

    }
    
    $supdatas = companybank::get();
    $accoption = accountoption::get();
    $tot =0;
    foreach($tran as $tranda){
        $tot+=$tranda->withdrawal;
    }


    return view('dashboard/bank/expenseshistory',['tot'=>$tot,'tran'=>$tran,'today'=>$request->daterange,'acco'=>$request->accoption,'bankd'=>$request->bank,'accoption'=>$accoption, 'supdata'=>$supdatas]);
}

public function colombopackfilter(Request $request){
    $items = customer::where('id', $request->id)->get();
    $prodata = ordersbarcode::where('customerid', $request->id)->get();
    $checkstat = customer::where('id', $request->id)->first();

    $delise = deliveryservice::get();
    if($checkstat->status != 14){
        return redirect('/inventorycolombo')->with('error', 'Error : The status of this order is not a pack, please check order status');
    }
    else{
    return view('dashboard/inventory/colombopacknew2')->with(['cus_id'=>$request->id,'prodata'=>$prodata,'delise'=>$delise,'item'=>$items]);
}
}

public function cmbopackingbarcodeupdate(Request $request){

    $checkbarcode=DB::connection('mysql2')->table('productbarcodes')->where('barcode', $request->barcode)->where('itemstatus', 0)->first();
    $st2 = ordersbarcode::where('status', 0)->where('customerid', $request->id)->orderBy('id', 'asc')->get();
    $st3 = ordersbarcode::where('status', 0)->where('customerid', $request->id)->count();
    // $st1 = productbarcode::where('barcode', $request->barcode)->where('productid', $request->pro_id)->first();
    $checksource = customer::where('id',$request->id)->first();
    if($request->barcode=="dailydeals"){
        if($st3==0){

            $cusdat = customer::find($request->id);
            $cusdat->status = 8;
            $cusdat->save();

            $items2 = cus_orders::where('cus_id', $request->id)->get();
            $getqty=0;
            $stock=0;
            foreach($items2 as $item) {
                $productdata=DB::connection('mysql2')->table('order_items')->where('id', $item->orders->pro_id)->get();
                // $productdata = orderItem::where('id', $item->item_id)->get();
                $getqty=$item->qty;
                foreach($productdata as $prodata) {
                    $stock=($prodata->stock)-($getqty);   
                    $proid=$prodata->id;
                    $users = DB::connection('mysql2')->select("update `order_items` set `stock` = '$stock' where id = '$proid' ");
                }
            }

            $statrack = new statustrack;
            $statrack->customerid=$request->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=15;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

            $statrack2 = new statustrack;
            $statrack2->customerid=$request->id;
            $statrack2->username=Auth::user()->name;
            $statrack2->orderstatus=8;
            $statrack2->starttime=0;
            $statrack2->endtime=0;
            $statrack2->status=0;
            $statrack2->save();
    
            $data="4";
            return  Response::json(['status' => $data], 200);

        }
        else{
            $data="5";
            return  Response::json(['status' => $data], 200);
        }

    }
    else if($checkbarcode==null){
        $data="1";
        return  Response::json(['status' => $data], 200);
    }
    else{
    foreach($st2 as $bardata){
        if($bardata->id==null){
            $data="3";
            return  Response::json(['status' => $data], 200);
        }
        else if($checkbarcode->productid == $bardata->ordersbarcodepro->pro_id){

            $data = ordersbarcode::find($bardata->id);
            $data->barcode = $request->barcode;
            $data->status = 1;
            $data->save();

            $varco=$request->barcode;
            $users = DB::connection('mysql2')->select("update `productbarcodes` set `itemstatus` = 1 where barcode = '$varco' ");

            return  Response::json(['status' => $data], 200);
        }
        else{
            $data="2";
            return  Response::json(['status' => $data], 200);
        }
    }
}

}


public function notice(){
$items = notice::get();
        
return view('dashboard/product/addnotice')->with(['item'=>$items]);
}
    
    
    public function addnotice(Request $request){
        $data = new notice();
        try{
    
        $data->heading = $request->Title;
        $data->body = $request->notice;
        $data->sdate = $request->start_date;
        $data->edate = $request->end_date;
        $data->save();
    
        return redirect('/notice')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/notice')->with('error', 'Error : '.$ex->getMessage());
        }
    }
    
    public function updatenotice(Request $request){
        $data = notice::find($request->id);
    
        try{
    
            $data->heading = $request->Title;
            $data->body = $request->notice;
            $data->sdate = $request->start_date;
            $data->edate = $request->end_date;
            $data->save();
    
            return redirect('/notice')->with('success', 'Successfully Saved!');
                }
            catch (Exception $ex){
                return redirect('/notice')->with('error', 'Error : '.$ex->getMessage());
            }
    }
    
    public function deletenotice(Request $request,$id){
    
        $data = notice::find($id);
       if($data==null){
            return  Response::json(['status' => false], 423);
       }else{
            $data->delete();
            return  Response::json(['status' => $data], 200);
       }
    }

    public function wholesalepaymentnew(){
        $datas = wholesalecustomer::get();
        $ban = companybank::get();
        $purces = purchasing::get();
        $purc = supplier::get();
        $products = orderItem::get();
        $ldate = date('Y-m-d H:i:s');
    
        return view('dashboard/wholesale/wholepaymentnew',['product'=>$products,'purc'=>$purc,'ldate'=>$ldate,'item'=>$datas, 'ban'=>$ban, 'purce'=>$purces]);
    }


    public function getwholesalebalance(Request $request,$id){
        $data = wholesalecustomer::where('id',$id)->get();
    
       if($data==null){
            return  Response::json(['status' => false], 423);
       }else{
    
            return  Response::json(['status' => $data], 200);
       }
    }

    public function wholepaymenthistory(){
        $ldate1 = date('Y-m-d');
        $da= $ldate1.' 00:00:00';
        $da2= $ldate1.' 23:59:59';
    
        $ldaco = date('Y/m/d');
        $today = $ldaco.' - '.$ldaco;
    
        $purc = wholesalecustomer::get();
    
        $supplier = wholesalepayemet::whereBetween('created_at',[$da,$da2])->get();
        $ldate = date('Y-m-d H:i:s');
        $paym="all";
        $supid="null";
        return view('dashboard/wholesale/wholepaymenthistory',['supid'=>$supid,'purc'=>$purc,'ldate'=>$ldate,'supplier'=>$supplier,'today'=>$today,'paym'=>$paym]);
    }

    public function wholepaymenthistoryfilter(Request $request){
        list($da1, $da222) = explode('-', $request->daterange);
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';
    
        if($request->status=="all"){
            $supplier = wholesalepayemet::where('paymentid',$request->wholename)->whereBetween('created_at',[$da,$da2])->get();
        }
        else if($request->status==0){
            $supplier = wholesalepayemet::where('status',0)->where('paymentid',$request->wholename)->get();
    
        }
        else{
            $supplier = wholesalepayemet::where('status',$request->status)->where('paymentid',$request->wholename)->whereBetween('created_at',[$da,$da2])->get();
    
        }
        
        $purc = wholesalecustomer::get();
        $ldate = date('Y-m-d H:i:s');
    
    
        return view('dashboard/wholesale/wholepaymenthistory',['supid'=>$request->wholename,'purc'=>$purc,'ldate'=>$ldate,'supplier'=>$supplier,'today'=>$request->daterange,'paym'=>$request->status]);
    }
    

    public function orderuploadsummary(){
        $date = date('Y/m/d');
        $ldate = $date."-".$date;
        $del = "null";
        $sou = "null";
        return view('dashboard/reports/orderuploadreport')->with(['sou'=>$sou,'del'=>$del,'ldate'=>$ldate]);
    }
    
    public function ordersstatusfilter(Request $request){
        list($da1, $da222) = explode('-', $request->daterange);
          
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';
    
    
        $dataor =  customer::select('customers.id','customers.status','customers.ordersource','order_items.name', DB::raw("COUNT(customers.id) as count"))
        ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
        ->join('order_items', 'order_items.id', '=' , 'cus_orders.item_id');
        $dataor=$dataor->where('cus_orders.item_id',$request->product_d)->where('customers.ordersource',$request->source)->whereBetween('customers.created_at',[$da,$da2])->groupBy('customers.status')->orderBy('count', 'DESC')->get();
        $del = "null";
    
    
        return view('dashboard/reports/orderuploadreport',['sou'=>$request->source,'dataor'=>$dataor,'del'=>$request->product_d,'ldate'=>$request->daterange]);
    }
    
    
    public function dispatchedsummary(){
        $date = date('Y/m/d');
        $ldate = $date."-".$date;
        $del = "null";
        $sou = "null";
        $tot =0;
        return view('dashboard/reports/dispatchedsummary')->with(['tot'=>$tot,'sou'=>$sou,'del'=>$del,'ldate'=>$ldate]);
    }
    
    public function dispatchedsummaryfilter(Request $request){
        list($da1, $da222) = explode('-', $request->daterange);
          
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';
    
        $product = dispatchsummary::whereBetween('created_at',[$da,$da2])->get();
    
        $dataor =  dispatchsummary::select('dispatchsummaries.id','deliveryservices.deliveryname', DB::raw("SUM(dispatchsummaries.noofline) as count"))
        ->join('deliveryservices', 'deliveryservices.id', '=' , 'dispatchsummaries.courierservice');
        $dataor=$dataor->whereBetween('dispatchsummaries.created_at',[$da,$da2])->groupBy('dispatchsummaries.courierservice')->orderBy('count', 'DESC')->get();
        $del = "null";
    
        $tot =0;
        foreach($dataor as $dataordata){
            $tot+=$dataordata->count;
        }
    
        return view('dashboard/reports/dispatchedsummary',['tot'=>$tot,'sou'=>$request->source,'dataor'=>$dataor,'product'=>$product,'del'=>$request->product_d,'ldate'=>$request->daterange]);
    }
    
    public function packedcount(){
        $ldate = date('Y/m/d');
        $date = $ldate.' - '.$ldate;
        $ldate1 = date('Y-m-d');
        $da= $ldate1.' 00:00:00';
        $da2= $ldate1.' 23:59:59';
    
        $allconfirmcount=0;
        $delise = user::get();
        $del="null";
        return view('dashboard/reports/packedcount')->with(['delise'=>$delise,'del'=>$del,'date'=>$date]);
    }
    
    public function packedcountfilter(Request $request){
        list($da1, $da222) = explode('-', $request->daterange);
          
        $date1 = str_replace('/', '-', $da1);
        $date2 = str_replace('/', '-', $da222);
        $da = $date1.'00:00:00';
        $da2 = $date2.' 23:59:59';
        $delise = user::get();
     
        $packe = DB::connection('mysql')->select("select username, count(*) as count from (select username, customerid from statustracks where orderstatus in (15) and created_at between '$da' and '$da2' group by customerid) dt group by username");

  
        return view('dashboard/reports/packedcount')->with(['dataor'=>$packe,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);
    }
    

public function purchecpaymentinvoice(Request $request)
{

    $ldate = date('Y-m-d');
    $cus = supplierpayment::where('id', $request->id)->get();

    $pdf = PDF::loadView('dashboard.accounts.supplierpaymentinvoice', array('cus'=>$cus,'ldate'=> $ldate))->setPaper('a4');
    return $pdf->stream(); 

}

public function wholepaymentinvoice(Request $request)
{

    $ldate = date('Y-m-d');
    $cus = wholesalepayemet::where('id', $request->id)->get();

    $pdf = PDF::loadView('dashboard.wholesale.wholepaymentinvoice', array('cus'=>$cus,'ldate'=> $ldate))->setPaper('a4');
    return $pdf->stream(); 

}

public function sellerassignpro(Request $request){
    $checid = $request->checkids;
    $cbCount = count($checid);
    if($cbCount==0){
        return redirect('/updateproduct')->with('error', 'No select Product');
    }
    else{
        
            if($request->removepro == 1){
                try{

                    foreach($checid as $checiddata){
                        
                    $getreseller = resellerdetails::wherein('id',$request->reseller_name)->get();
                    foreach($getreseller as $redata){
        
                        $data = sellerproduct::where('pro_id',$checiddata)->where('seller_id',$redata->id)->first();
                        if($data != null){
                            $data->delete();
                        }
                        else{
                        }  
                    
                    }
                      
                }
                return redirect('/updateproduct')->with('success', 'Successfully Saved!');
                    }
                catch (Exception $ex){
                    return redirect('/updateproduct')->with('error', 'Error : '.$ex->getMessage());
                }
            }
            else{
            try{

            foreach($checid as $checiddata){
                $getname = DB::connection('mysql2')->select("select name,resellerprice,weight,sell_price from order_items where id = '$checiddata' ");
                
            $getreseller = resellerdetails::wherein('id',$request->reseller_name)->get();
            foreach($getreseller as $redata){

                $data = sellerproduct::where('pro_id',$checiddata)->where('seller_id',$redata->id)->first();
                if($data == null){
                    foreach($getname as $nameg){

                        $sellpro = new sellerproduct;
                        $sellpro->seller_id=$redata->id;
                        $sellpro->pro_id=$checiddata;
                        $sellpro->pro_name=$nameg->name;
                        $sellpro->cost=$nameg->resellerprice;
                        $sellpro->sell_price=0;
                        $sellpro->weight=$nameg->weight;
                        $sellpro->save();
    
                    }
                }
                else{
                }  
            
            }
              
        }
        return redirect('/updateproduct')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/updateproduct')->with('error', 'Error : '.$ex->getMessage());
        }
    }
        

            
   }

}



public function priceupdate(){
    $delise = resellerdetails::get();
    $product = sellerproduct::get();
    
    return view('dashboard/product/priceadd')->with(['product'=>$product, 'delise'=>$delise]);
}


public function priceupdatefilter(Request $request){
    $delise = resellerdetails::get();
    $product = sellerproduct::where('seller_id',$request->reseller_name)->get();
    $prodet = DB::connection('mysql2')->select("select * from order_items");
    return view('dashboard/product/priceadd2')->with(['prodet'=>$prodet,'product'=>$product, 'delise'=>$delise,'sel'=>$request->reseller_name]);
}

public function selerrpricetabget(Request $request){

$users = sellerproduct::select(['id','seller_id', 'pro_id', 'pro_name', 'cost','sell_price','weight'])->where('seller_id',$request->reseller_name);

    return Datatables::of($users)->addColumn('action', function($users){return
        '&nbsp;&nbsp;<button type="button" data-id="'.$users->id .'" data-cost="'.$users->cost .'" data-weight="'.$users->weight .'" class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodelphone">Update</button>'.
        '&nbsp;&nbsp;<a class="btn btn-danger btn-xs" data-id="'.$users->id .'"  href="">Delete</a>';})
    ->make(true);
}

public function updatecost(Request $request){
    try{
    $data = sellerproduct::find($request->id);
    $data->cost = $request->cost;
    $data->weight = $request->weight;
    $data->save();

    return  Response::json(['status' => $data], 200);
        }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }
}

public function deletesellerpro(Request $request,$id){
    $data = sellerproduct::find($id);

   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();
               return  Response::json([
        'status' => $data
    ], 200);
   }
}


public function importcityupdate(Request $request){
    $data = customer::find($request->id);
    $cusdata = citylist::where('id', $request->cituselect)->first();
    $trac = trancecity::where('city_name',$cusdata->city)->first();

    try{
        if($trac != null){
            $data->tracecity = $trac->id;
            $data->save();
        }
        $data->city = $request->cituselect;
        $data->district = $cusdata->district;
        $data->save();
        return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }   
}

public function resellerproduct(){
    $getstock = DB::connection('mysql2')->select("select * from order_items");
    $prodet = sellerproduct::where('seller_id',Auth::user()->resellerid)->get();
    $resedata = resellerdetails::where('id',Auth::user()->resellerid)->first();

    if($resedata->inventory == 0){
        return redirect('/resellerdash')->with('error', 'Inventory Locked, Please Contact SellerCenter Customer Support!!!');
    }
    else{
        return view('dashboard/product/reselletproduct',['product'=>$prodet,'getstock'=>$getstock]);
    }
}

public function productdetails(Request $request,$id){

    $product = DB::connection('mysql2')->select("select * from order_items where id = '$id'");
    $prodata = DB::connection('mysql2')->select("select * from productdatas where product_id = '$id'");
    
    return view('dashboard/product/productdetails')->with(['product'=>$product,'prodata'=>$prodata]);
}

public function resellersellup(Request $request){
    $data = sellerproduct::find($request->id);
    try{
        $data->sell_price = $request->price;
        $data->save();
        return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }   
}

public function resellerallorder(){
    
    $pro = sellerproduct::where('seller_id',Auth::user()->resellerid)->get();

    return view('dashboard/orders/resellerallorder')->with(['pro'=>$pro]);
}



public function resellerallorderfilter(Request $request)
{
    list($da1, $da2) = explode('-', $request->daterange);
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da2);
    $date11 = $date1.'00:00:00';
    $date22 = $date2.' 23:59:59';

    // $items = customer::select(['id','name','address', 'phone','tracking','cod','status','user'])->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$date11, $date22]);


    $items =  customer::select('customers.id','customers.reorderid','customers.user','customers.name','customers.address','customers.phone','customers.tracking','customers.cod','customers.status')->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
    ->where('customers.user',Auth::user()->resellerid)->whereBetween('customers.created_at', [$date11, $date22])->groupBy('customers.id');



    if(!empty($request->OrderStatus)){
        $items = $items->whereIn('customers.status', $request->OrderStatus);
    }
    else{
        
    }

    if(!empty($request->product)){
        $items = $items->whereIn('cus_orders.item_id', $request->product);
    }
    else{
        
    }
    if(!empty($request->phone)){
        $items = $items->where('customers.phone', 'like', '%'.$request->phone.'%');
    }
    else{
       
    }
    if(!empty($request->invoice)){
        $items = $items->where('customers.id', 'like', '%'.$request->invoice.'%');
    }
    else{
       
    }
    return Datatables::of($items)->addColumn('action', function($items){
        $xy='';
        if($items->status== 0 OR $items->status == 1 OR $items->status == 2 OR  $items->status == 3  OR $items->status == 4 OR  $items->status == 16 OR  $items->status == 17){
          $xy='<a data-id="'.$items->id .'"  target="_blank" class="btn btn-primary btn-xs" href="viewaddorder/'.$items->id .'">View</a>';  
        }else{$xy='<a data-id="'.$items->id .'"  target="_blank" class="btn btn-primary btn-xs" href="viewallorders/'.$items->id .'">View</a>';}
            return ''.$xy.'';})
    ->make(true);
}

public function resellerpayment(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);

    $delise = resellerdetails::get();

    return view('dashboard/accounts/resellerpayment')->with(['ldate'=>$ldate,'delise'=>$delise]);
}

public function resellerpaymentfilter(Request $request){
    $delise = resellerdetails::get();
    $money = customer::where('status',9)->where('ordertype',1)->where('user',$request->resller)->get();
    $exchange = customer::where('status',9)->where('ordertype',2)->where('user',$request->resller)->get();
    $return = customer::where('status',7)->where('user',$request->resller)->get();
    $refund = customer::where('status',35)->where('user',$request->resller)->get();
    $counttot = customer::wherein('status',[7,9])->where('user',$request->resller)->get()->count();

    $mondel=0;
    $totcod=0;
    $totrefundcod=0;
    $totinventory=0;
    $servicech=0;
    $returnservice=0;
    $totservice=0;
    $exmondel=0;
    $extotcod=0;
    $exservicech=0;


    foreach($money as $modata){
        $mondel+=$modata->orderdelivery;
        $totcod+=$modata->cod;
        $servicech+=$modata->servicecharge;

    foreach($modata->cus_or as $iprod){
            $totinventory+=$iprod->reseller_cost*$iprod->qty;
        }
    }

    foreach($exchange as $exdata){
        $exmondel+=$exdata->orderdelivery;
        $extotcod+=$exdata->cod;
        $exservicech+=$exdata->servicecharge;
    }

    foreach($return as $returndat){
        $returnservice+=$returndat->servicecharge;
    }
    foreach($refund as $refunddat){
        $totrefundcod+=$refunddat->cod;
    }
    $totservice=$servicech+$returnservice+$exservicech;

    $comi = commission::where('resellerid',$request->resller)->get();
    $comdetails=[];
    $totcommi=0;
    foreach($comi as $comidata){
        $commismoney = customer::wherein('status',[9,33])->where('commisionstatus',0)->where('commisionid','-')->where('user',$comidata->commisereseller)->count();

        $comdet=['resname'=> $comidata->comgetreseller->companyname,'charge'=>$comidata->commischarge, 'count'=>$commismoney, 'total'=>$comidata->commischarge*$commismoney ];
        $totcommi+=$commismoney*$comidata->commischarge;

        array_push($comdetails, $comdet);
    }
    $advance = advance::where('status',0)->where('resellerid',$request->resller)->get();
    $totadvance=0;
    foreach($advance as $advancedata){
        $totadvance+=$advancedata->advance;   
    }

    return view('dashboard/accounts/resellerpayment2')->with(['exmondel'=>$exmondel,'extotcod'=>$extotcod,'exchange'=>$exchange,'totadvance'=>$totadvance,'totcommi'=>$totcommi,'comdetails'=>$comdetails,'servicech'=>$totservice,'totinventory'=>$totinventory,'refund'=>$refund,'totrefundcod'=>$totrefundcod,'counttot'=>$counttot,'totcod'=>$totcod,'mondel'=>$mondel,'deli'=>$request->resller,'return'=>$return,'delise'=>$delise,'money'=>$money]);
}

public function genrateallreportreseller(Request $request){

if($request->allreport == "allreport"){
    $delise = resellerdetails::get();
    foreach($delise as $redata){

        $money = customer::where('status',9)->where('ordertype',1)->where('user',$redata->id)->get();
        $exchange = customer::where('status',9)->where('ordertype',2)->where('user',$redata->id)->get();
        $return = customer::where('status',7)->where('user',$redata->id)->get();
        $refund = customer::where('status',35)->where('user',$redata->id)->get();
        $counttot = customer::wherein('status',[7,9])->where('user',$redata->id)->get()->count();
    
        $mondel=0;
        $totcod=0;
        $totrefundcod=0;
        $totinventory=0;
        $servicech=0;
        $returnservice=0;
        $totservice=0;
        $paidamount=0;
        $collectedcod=0;
        $exmondel=0;
        $extotcod=0;
        $exservicech=0;

        foreach($money as $modata){
            $mondel+=$modata->orderdelivery;
            $totcod+=$modata->cod;
            $servicech+=$modata->servicecharge;
    
        foreach($modata->cus_or as $iprod){
            $totinventory+=$iprod->reseller_cost*$iprod->qty;
            }
        }
        foreach($exchange as $exdata){
            $exmondel+=$exdata->orderdelivery;
            $extotcod+=$exdata->cod;
            $exservicech+=$exdata->servicecharge;
        }

        foreach($return as $returndat){
            $returnservice+=$returndat->servicecharge;
        }
        foreach($refund as $refunddat){
            $totrefundcod+=$refunddat->cod;
        }
        $totservice=$servicech+$returnservice+$exservicech;

        $comi = commission::where('resellerid',$redata->id)->get();
        $totcommi=0;
        foreach($comi as $comidata){
            $commismoney = customer::wherein('status',[9,33])->where('commisionstatus',0)->where('commisionid','-')->where('user',$comidata->commisereseller)->count();
            $totcommi+=$commismoney*$comidata->commischarge;
        }

        $advance = advance::where('status',0)->where('resellerid',$redata->id)->get();
        $totadvance=0;
        foreach($advance as $advancedata){
            $totadvance+=$advancedata->advance;   
        }

        $paidamount=($totcod + $totcommi + $extotcod) - $totrefundcod - $totinventory - $totadvance - ($mondel+$totservice);
        $collectedcod=($totcod+$extotcod)-$totrefundcod;


    if($paidamount>0){

        $data = new resellerpayment();
        $data->resellerid = $redata->id;
        $data->genratedby = Auth::user()->name;
        $data->collectedcod = $collectedcod;
        $data->deliverycharge = $mondel;
        $data->servicecharge = $totservice;
        $data->productscharge = $totinventory;
        $data->commision = $totcommi;
        $data->advance = $totadvance;
        $data->paidamount = $paidamount;
        $data->status = 0;
        $data->paiddate = "-";
        $data->save();

        $advance = advance::where('status',0)->where('resellerid',$redata->id)->get();
        $totadvance=0;
        foreach($advance as $advancedata){
            $adupdate = advance::find($advancedata->id); 
            $adupdate->paidid = $data->id;
            $adupdate->paiddate = date('Y-m-d H:i:s');
            $adupdate->status = 1;
            $adupdate->save();
        }
    
        $cusorders = customer::wherein('status',[7,9,35])->where('user',$redata->id)->get();
        foreach($cusorders as $cusdata){
            if($cusdata->status == 9){
                $stchange = customer::find($cusdata->id);
                $stchange->status = 33;
                $stchange->sellercodid = $data->id;
                $stchange->save();
    
                $statrack = new statustrack;
                $statrack->customerid=$cusdata->id;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=33;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();
            }
            else if($cusdata->status == 7){
                $stchange = customer::find($cusdata->id);
                $stchange->status = 34;
                $stchange->sellercodid = $data->id;
                $stchange->save();
    
                $statrack = new statustrack;
                $statrack->customerid=$cusdata->id;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=34;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();
    
            }
            else if($cusdata->status == 35){
                $stchange = customer::find($cusdata->id);
                $stchange->status = 36;
                $stchange->sellercodid = $data->id;
                $stchange->save();
    
                $statrack = new statustrack;
                $statrack->customerid=$cusdata->id;
                $statrack->username=Auth::user()->name;
                $statrack->orderstatus=36;
                $statrack->starttime=0;
                $statrack->endtime=0;
                $statrack->status=0;
                $statrack->save();
    
            }
    
        }
        $comi = commission::where('resellerid',$redata->id)->get();
        foreach($comi as $comidata){
            $commismoney = customer::wherein('status',[9,33])->where('commisionstatus',0)->where('commisionid','-')->where('user',$comidata->commisereseller)->get();
            foreach($commismoney as $comdata){
                $comch = customer::find($comdata->id);
                $comch->commisionstatus = 1;
                $comch->commisionid = $data->id;
                $comch->save();

            }
        }


    }

    }
    return redirect('/resellerpayment')->with('success', 'Successfully Saved!');

}

else if($request->Minus == "Minus"){
    $ldate = date('Y-m-d');
    $maindata=[];
    $delise = resellerdetails::get();
    foreach($delise as $redata){

        $money = customer::where('status',9)->where('ordertype',1)->where('user',$redata->id)->get();
        $exchange = customer::where('status',9)->where('ordertype',2)->where('user',$redata->id)->get();
        $return = customer::where('status',7)->where('user',$redata->id)->get();
        $refund = customer::where('status',35)->where('user',$redata->id)->get();
        $counttot = customer::wherein('status',[7,9])->where('user',$redata->id)->get()->count();
    
        $mondel=0;
        $totcod=0;
        $totrefundcod=0;
        $totinventory=0;
        $servicech=0;
        $returnservice=0;
        $totservice=0;
        $paidamount=0;
        $collectedcod=0;
        $exmondel=0;
        $extotcod=0;
        $exservicech=0;

        foreach($money as $modata){
            $mondel+=$modata->orderdelivery;
            $totcod+=$modata->cod;
            $servicech+=$modata->servicecharge;
    
        foreach($modata->cus_or as $iprod){
            $totinventory+=$iprod->reseller_cost*$iprod->qty;
            }
        }
        foreach($exchange as $exdata){
            $exmondel+=$exdata->orderdelivery;
            $extotcod+=$exdata->cod;
            $exservicech+=$exdata->servicecharge;
        }

        foreach($return as $returndat){
            $returnservice+=$returndat->servicecharge;
        }
        foreach($refund as $refunddat){
            $totrefundcod+=$refunddat->cod;
        }
        $totservice=$servicech+$returnservice+$exservicech;

        $comi = commission::where('resellerid',$redata->id)->get();
        $totcommi=0;
        foreach($comi as $comidata){
            $commismoney = customer::wherein('status',[9,33])->where('commisionstatus',0)->where('commisionid','-')->where('user',$comidata->commisereseller)->count();
            $totcommi+=$commismoney*$comidata->commischarge;
        }

        $advance = advance::where('status',0)->where('resellerid',$redata->id)->get();
        $totadvance=0;
        foreach($advance as $advancedata){
            $totadvance+=$advancedata->advance;   
        }

        $paidamount=($totcod + $totcommi + $extotcod) - $totrefundcod - $totinventory - $totadvance - ($mondel+$totservice);
        $collectedcod=($totcod+$extotcod)-$totrefundcod;
        
        $minudata=['totadvance'=>$totadvance,'collectedcod'=>$collectedcod,'delivery'=>$mondel,'product'=>$totinventory,'service'=>$totservice,'payble'=>$paidamount, 'resellername'=>$redata->companyname];
        array_push($maindata, $minudata);
    
    }


    $pdf = PDF::loadView('dashboard.accounts.resellerminus', array('ldate'=> $ldate,'maindata'=> $maindata))->setPaper('a4');
  return $pdf->stream(); 
}

else if($request->Plus == "Plus"){
    $ldate = date('Y-m-d');
    $maindata=[];
    $delise = resellerdetails::get();
    foreach($delise as $redata){

        $money = customer::where('status',9)->where('ordertype',1)->where('user',$redata->id)->get();
        $exchange = customer::where('status',9)->where('ordertype',2)->where('user',$redata->id)->get();
        $return = customer::where('status',7)->where('user',$redata->id)->get();
        $refund = customer::where('status',35)->where('user',$redata->id)->get();
        $counttot = customer::wherein('status',[7,9])->where('user',$redata->id)->get()->count();
    
        $mondel=0;
        $totcod=0;
        $totrefundcod=0;
        $totinventory=0;
        $servicech=0;
        $returnservice=0;
        $totservice=0;
        $paidamount=0;
        $collectedcod=0;
        $exmondel=0;
        $extotcod=0;
        $exservicech=0;

        foreach($money as $modata){
            $mondel+=$modata->orderdelivery;
            $totcod+=$modata->cod;
            $servicech+=$modata->servicecharge;
    
        foreach($modata->cus_or as $iprod){
            $totinventory+=$iprod->reseller_cost*$iprod->qty;
            }
        }
        foreach($exchange as $exdata){
            $exmondel+=$exdata->orderdelivery;
            $extotcod+=$exdata->cod;
            $exservicech+=$exdata->servicecharge;
        }

        foreach($return as $returndat){
            $returnservice+=$returndat->servicecharge;
        }
        foreach($refund as $refunddat){
            $totrefundcod+=$refunddat->cod;
        }
        $totservice=$servicech+$returnservice+$exservicech;

        $comi = commission::where('resellerid',$redata->id)->get();
        $totcommi=0;
        foreach($comi as $comidata){
            $commismoney = customer::wherein('status',[9,33])->where('commisionstatus',0)->where('commisionid','-')->where('user',$comidata->commisereseller)->count();
            $totcommi+=$commismoney*$comidata->commischarge;
        }

        $advance = advance::where('status',0)->where('resellerid',$redata->id)->get();
        $totadvance=0;
        foreach($advance as $advancedata){
            $totadvance+=$advancedata->advance;   
        }

        $paidamount=($totcod + $totcommi + $extotcod) - $totrefundcod - $totinventory - $totadvance - ($mondel+$totservice);
        $collectedcod=($totcod+$extotcod)-$totrefundcod;
        
        $minudata=['totadvance'=>$totadvance,'collectedcod'=>$collectedcod,'delivery'=>$mondel,'product'=>$totinventory,'service'=>$totservice,'payble'=>$paidamount, 'resellername'=>$redata->companyname];
        array_push($maindata, $minudata);
    
    }


    $pdf = PDF::loadView('dashboard.accounts.resellerpluse', array('ldate'=> $ldate,'maindata'=> $maindata))->setPaper('a4');
  return $pdf->stream(); 
    
    
}




}


public function resellergenratereport(Request $request){
    $data = new resellerpayment();
    try{
    $data->resellerid = $request->resellerid;
    $data->genratedby = Auth::user()->name;
    $data->collectedcod = $request->collectedcod;
    $data->deliverycharge = $request->deliverycharge;
    $data->servicecharge = $request->servicecharge;
    $data->productscharge = $request->productscharge;
    $data->commision = $request->commision;
    $data->advance = $request->advance;
    $data->paidamount = $request->paidamount;
    $data->status = 0;
    $data->paiddate = "-";
    $data->save();

    $advance = advance::where('status',0)->where('resellerid',$request->resellerid)->get();
    $totadvance=0;
    foreach($advance as $advancedata){
        $adupdate = advance::find($advancedata->id); 
        $adupdate->paidid = $data->id;
        $adupdate->paiddate = date('Y-m-d H:i:s');
        $adupdate->status = 1;
        $adupdate->save();
    }

    $cusorders = customer::wherein('status',[7,9,35])->where('user',$request->resellerid)->get();
    foreach($cusorders as $cusdata){
        if($cusdata->status == 9){
            $stchange = customer::find($cusdata->id);
            $stchange->status = 33;
            $stchange->sellercodid = $data->id;
            $stchange->save();

            $statrack = new statustrack;
            $statrack->customerid=$cusdata->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=33;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
        else if($cusdata->status == 7){
            $stchange = customer::find($cusdata->id);
            $stchange->status = 34;
            $stchange->sellercodid = $data->id;
            $stchange->save();

            $statrack = new statustrack;
            $statrack->customerid=$cusdata->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=34;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

        }
        else if($cusdata->status == 35){
            $stchange = customer::find($cusdata->id);
            $stchange->status = 36;
            $stchange->sellercodid = $data->id;
            $stchange->save();

            $statrack = new statustrack;
            $statrack->customerid=$cusdata->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=36;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();

        }

    }
    $comi = commission::where('resellerid',$request->resellerid)->get();

    foreach($comi as $comidata){
        $commismoney = customer::wherein('status',[9,33])->where('commisionstatus',0)->where('commisionid','-')->where('user',$comidata->commisereseller)->get();
        foreach($commismoney as $comdata){
            $comch = customer::find($comdata->id);
            $comch->commisionstatus = 1;
            $comch->commisionid = $data->id;
            $comch->save();

        }
    }

    return redirect('/resellerpayment')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/resellerpayment')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function receivedcod(){
    $date = date('Y-m-d');
    $ldate = str_replace('-', '/', $date);
    $delise = resellerdetails::get();
    $repay = resellerpayment::where('status',0)->get();

    return view('dashboard/accounts/receivedcod')->with(['repay'=>$repay,'ldate'=>$ldate,'delise'=>$delise]);
}

public function receivedcodfilter(Request $request){
    $delise = resellerdetails::get();
    $repay = resellerpayment::where('resellerid',$request->resller)->get();

    return view('dashboard/accounts/receivedcod2')->with(['deli'=>$request->resller,'delise'=>$delise,'repay'=>$repay]);
}

public function resellerpayupdate(Request $request){
    try{
        $data = resellerpayment::find($request->id);
        $sta = $request->has('paidstatus');

        if($sta=="true"){
            $data->status = 1;
            $data->paiddate = $request->paid_date;
            $data->save();
        }
        else{
            $data->status = 0;
            $data->paiddate = $request->paid_date;
            $data->save();
         }
 
         return  Response::json(['status' => $data], 200);
        }
        catch (Exception $ex){
            return  Response::json(['status' => false], 423);
        } 
}

public function resellerpaymentorders(Request $request,$id){

    $item = customer::where('sellercodid',$id)->get(); 
    $paymere = resellerpayment::where('id',$id)->get();
    $rename = resellerpayment::where('id',$id)->first();
    
    $comi = commission::where('resellerid',$rename->resellerid)->get();
    $comdetails=[];
    foreach($comi as $comidata){
        $commismoney = customer::where('commisionid',$id)->where('user',$comidata->commisereseller)->count();
        $comdet=['resname'=> $comidata->comgetreseller->companyname,'charge'=>$comidata->commischarge, 'count'=>$commismoney, 'total'=>$comidata->commischarge*$commismoney ];
        array_push($comdetails, $comdet);
    }
    $advance=advance::where('paidid',$id)->get();

    return view('dashboard/accounts/recivedcodorders')->with(['advance'=>$advance,'comdetails'=>$comdetails,'item'=>$item,'paymere'=>$paymere]);
}

public function paymentsummery(){

    $money = customer::where('status',9)->where('ordertype',1)->where('user',Auth::user()->resellerid)->get();
    $exchange = customer::where('status',9)->where('ordertype',2)->where('user',Auth::user()->resellerid)->get();
    $return = customer::where('status',7)->where('user',Auth::user()->resellerid)->get();
    $refund = customer::where('status',35)->where('user',Auth::user()->resellerid)->get();
    $counttot = customer::wherein('status',[7,9])->where('user',Auth::user()->resellerid)->get()->count();

    $mondel=0;
    $totcod=0;
    $totrefundcod=0;
    $totinventory=0;
    $servicech=0;
    $returnservice=0;
    $totservice=0;
    $exmondel=0;
    $extotcod=0;
    $exservicech=0;

    foreach($money as $modata){
        $mondel+=$modata->orderdelivery;
        $totcod+=$modata->cod;
        $servicech+=$modata->servicecharge;
        foreach($modata->cus_or as $iprod){
            $totinventory+=$iprod->reseller_cost*$iprod->qty;
        }
    }
    foreach($exchange as $exdata){
        $exmondel+=$exdata->orderdelivery;
        $extotcod+=$exdata->cod;
        $exservicech+=$exdata->servicecharge;
    }

    foreach($return as $returndat){
        $returnservice+=$returndat->servicecharge;
    }
    foreach($refund as $refunddat){
        $totrefundcod+=$refunddat->cod;
    }
    $totservice=$servicech+$returnservice+$exservicech;

    $comi = commission::where('resellerid',Auth::user()->resellerid)->get();
    $comdetails=[];
    $totcommi=0;
    foreach($comi as $comidata){
        $commismoney = customer::wherein('status',[9,33])->where('commisionstatus',0)->where('commisionid','-')->where('user',$comidata->commisereseller)->count();

        $comdet=['resname'=> $comidata->comgetreseller->companyname,'charge'=>$comidata->commischarge, 'count'=>$commismoney, 'total'=>$comidata->commischarge*$commismoney ];
        $totcommi+=$commismoney*$comidata->commischarge;

        array_push($comdetails, $comdet);
    }
    $advance = advance::where('status',0)->where('resellerid',Auth::user()->resellerid)->get();
    $totadvance=0;
    foreach($advance as $advancedata){
        $totadvance+=$advancedata->advance;   
    }

    return view('dashboard/reseller/paymentsummery')->with(['exchange'=>$exchange,'exmondel'=>$exmondel,'extotcod'=>$extotcod,'advance'=>$advance,'totadvance'=>$totadvance,'totcommi'=>$totcommi,'comdetails'=>$comdetails,'servicech'=>$totservice,'totinventory'=>$totinventory,'refund'=>$refund,'totrefundcod'=>$totrefundcod,'counttot'=>$counttot,'totcod'=>$totcod,'mondel'=>$mondel,'return'=>$return,'money'=>$money]);
}

public function receivedcodsummery(Request $request){
    $repay = resellerpayment::where('resellerid',Auth::user()->resellerid)->get();

    return view('dashboard/reseller/receivedcodsummery')->with(['repay'=>$repay]);
}
public function receivedcodsummeryorders(Request $request,$id){

    $item = customer::where('sellercodid',$id)->get(); 
    $paymere = resellerpayment::where('id',$id)->get();

    $rename = resellerpayment::where('id',$id)->first();
    
    $comi = commission::where('resellerid',$rename->resellerid)->get();
    $comdetails=[];
    foreach($comi as $comidata){
        $commismoney = customer::where('commisionid',$id)->where('user',$comidata->commisereseller)->count();
        $comdet=['resname'=> $comidata->comgetreseller->companyname,'charge'=>$comidata->commischarge, 'count'=>$commismoney, 'total'=>$comidata->commischarge*$commismoney ];
        array_push($comdetails, $comdet);
    }
    $advance=advance::where('paidid',$id)->get();

    return view('dashboard/reseller/receivedcodorders')->with(['advance'=>$advance,'comdetails'=>$comdetails,'item'=>$item,'paymere'=>$paymere]);
}

public function exchange(){

    $items = customer::where('status', 1)->where('ordertype', 2)->get();
    $userd = resellerdetails::get();
    
    return view('dashboard/addorder/exchange')->with(['item'=>$items,'userd'=>$userd]);
}
public function refund(){
    $items = customer::where('status', '1')->where('ordertype',3)->get();
    $userd = resellerdetails::get();
    
    return view('dashboard/addorder/refund')->with(['item'=>$items,'userd'=>$userd]);
}
public function outofstock(){
    $items = customer::where('status', '32')->get();
    $userd = resellerdetails::get();
    
    return view('dashboard/addorder/outofstock')->with(['item'=>$items,'userd'=>$userd]);
}
public function resellerregister(){
    return view('dashboard/reseller/register');
}

public function registerreseller(Request $request){
    try{

        $data = new User;
        $data->name=$request->name;
        $data->email=$request->email;
        $data->password=bcrypt($request->password);
        $data->type=$request->type;
        $data->resellerid=Auth::user()->resellerid;
        $data->save();


    return redirect('/resellerregister')->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/resellerregister')->with('error', 'Error : '.$ex->getMessage());
    }

 }

 public function resellerusermange(){
    $items = User::where('resellerid',Auth::user()->resellerid)->get();
    return view('dashboard/reseller/resellerusermange')->with(['item'=>$items]);
}

public function resellerusermangeupdate(Request $request){
    $data = User::find($request->id);
    try{
        $data->name = $request->name;
        $data->email = $request->email;
        $data->type = $request->type;
        $data->save();

        return redirect('/resellerusermange')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/resellerusermange')->with('error', 'Error : '.$ex->getMessage());
        }

}

public function mangereseller(){
    $items = User::whereIn('type',["Reseller","User"])->get();
    $data = resellerdetails::get();
    return view('dashboard/user/resellermange')->with(['item'=>$items,'reseld'=>$data]);
}

public function resellerupdateuser(Request $request){
    $data = User::find($request->id);
    try{
        $data->name = $request->name;
        $data->type = $request->type;
        $data->resellerid = $request->resellerid;
        $data->save();

        return redirect('/mangereseller')->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/mangereseller')->with('error', 'Error : '.$ex->getMessage());
        }

}


public function resellerproductgride(Request $request){
    $getstock = DB::connection('mysql2')->select("select * from order_items");
    $prodet = sellerproduct::where('seller_id',Auth::user()->resellerid)->paginate(8);
    $newDateTime = Carbon::now()->subDays(10);
    $ldate = date('Y-m-d H:i:s');
    $edate=$newDateTime->toDateTimeString();
    $newpro= sellerproduct::where('seller_id',Auth::user()->resellerid)->whereBetween('created_at',[$edate,$ldate])->get();

    $resedata = resellerdetails::where('id',Auth::user()->resellerid)->first();

    if($resedata->inventory == 0){
        return redirect('/resellerdash')->with('error', 'Inventory Locked, Please Contact SellerCenter Customer Support!!!');
    }
    else{
        if ($request->ajax()) {
            $view = view('dashboard/reseller/product',['product'=>$prodet,'newpro'=>$newpro,'getstock'=>$getstock])->render();
            return response()->json(['html'=>$view]);
        }
        return view('dashboard/reseller/reselletproductgride',['newpro'=>$newpro,'product'=>$prodet,'getstock'=>$getstock]);
    }
}

public function productdescription(Request $request,$id){

    $product = DB::connection('mysql2')->select("select * from order_items where id = '$id'");
    $prodata = DB::connection('mysql2')->select("select * from productdatas where product_id = '$id'");
    $resellerpro = sellerproduct::where('pro_id',$id)->where('seller_id',Auth::user()->resellerid)->get();
    
    $resedata = resellerdetails::where('id',Auth::user()->resellerid)->first();

    if($resedata->inventory == 0){
        return redirect('/resellerdash')->with('error', 'Inventory Locked, Please Contact SellerCenter Customer Support!!!');
    }
    else{
        return view('dashboard/reseller/productdescription')->with(['resellerpro'=>$resellerpro,'product'=>$product,'prodata'=>$prodata]);
    }
}

public function duplicate(){
    $items = customer::where('status', 37)->where('user', Auth::user()->resellerid)->get();
    
    return view('dashboard/addorder/duplicate')->with(['item'=>$items]);
}


public function resellerbtnstatuschange(Request $request){
    try{
    if($request->attempt1=="attempt1"){
        $data = customer::find($request->cus_id);
        $data->status = 2;
        $data->lockstatus = 0;
        $data->save();
    }

    elseif($request->attempt2=="attempt2"){
        $data = customer::find($request->cus_id);
        $data->status = 3;
        $data->lockstatus = 0;
        $data->save();
    }
    elseif($request->attempt3=="attempt3"){
        $data = customer::find($request->cus_id);
        $data->status = 4;
        $data->lockstatus = 0;
        $data->save();
    }
    elseif($request->hold=="hold"){
        $data = customer::find($request->cus_id);
        $data->status = 16;
        $data->lockstatus = 0;
        $data->save();
    }
    elseif($request->Confirm=="Confirm"){
        $check = customer::where('id',$request->cus_id)->first();
        if($check->cus_or->isEmpty()){
            return redirect('/viewaddorder/'.$request->cus_id)->with('error', 'No products added');
        }
        else if($check->tracecity == "-"){
            return redirect('/viewaddorder/'.$request->cus_id)->with('error', 'No select City');
        }
        else{
            $data = customer::find($request->cus_id);
            $data->status = 17;
            $data->lockstatus = 0;
            $data->save();
    
            $statrack = new statustrack;
            $statrack->customerid=$request->cus_id;
            $statrack->username=Auth::user()->email;
            $statrack->orderstatus=17;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }
    
    } 
    elseif($request->cancel=="cancel"){
    
        $data = customer::find($request->cus_id);
        $data->status = 10;
        $data->lockstatus = 0;
        $data->save();
    
    } 

if($request->status == 1){
    return redirect('/resellerpending');
}
elseif($request->status == 2){
    return redirect('/1stattempt');
}
elseif($request->status == 3){
    return redirect('/2ndattempt');
}
elseif($request->status == 4){
    return redirect('/3rdattempt');
}
elseif($request->status == 16){
    return redirect('/hold');
}
elseif($request->status == 10){
    return redirect('/cancel');
}
else{
    return redirect('/resellerpending');
}
}

catch (Exception $ex){
    return redirect('/resellerpending')->with('error', 'Error : '.$ex->getMessage());
}
        
}


public function resellerpending(){

    $items = customer::where('status', 1)->where('user',Auth::user()->resellerid)->get();

    return view('dashboard/callcenter/resellerpending')->with(['item'=>$items]);
}

public function attempt1st(){

    $items = customer::where('status', 2)->where('user',Auth::user()->resellerid)->get();

    return view('dashboard/callcenter/attempt1st')->with(['item'=>$items]);
}

public function attempt2nd(){

    $items = customer::where('status', 3)->where('user',Auth::user()->resellerid)->get();

    return view('dashboard/callcenter/attempt2nd')->with(['item'=>$items]);
}

public function attempt3rd(){

    $items = customer::where('status', 4)->where('user',Auth::user()->resellerid)->get();

    return view('dashboard/callcenter/attempt3rd')->with(['item'=>$items]);
}

public function hold(){

    $items = customer::where('status', 16)->where('user',Auth::user()->resellerid)->get();

    return view('dashboard/callcenter/hold')->with(['item'=>$items]);
}

public function cancel(){

    $items = customer::where('status', 10)->where('user',Auth::user()->resellerid)->get();

    return view('dashboard/callcenter/cancel')->with(['item'=>$items]);
}

public function outconfirmpending($id){

    $data = customer::find($id);
    $getpro=cus_orders::where('cus_id',$id)->get();
    $checkstock = DB::connection('mysql2')->select("select * from order_items");

    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{
        foreach($getpro as $prodata){
            foreach($checkstock as $storedata){
                if($prodata->orders->pro_id == $storedata->id){
                    if($storedata->stock <= 0){

                        $data->status=32;
                        $data->save();
                
                        $statrack = new statustrack;
                        $statrack->customerid=$id;
                        $statrack->username="System";
                        $statrack->orderstatus=32;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();

                        $data=2;
                        return  Response::json(['status' => $data], 200);
                    }
                    else{
                        $custds = customer::where('id',$id)->get()->first();
                        $items = cus_orders::where('cus_id', $id)->get();
                        $weight=0;
                        $deli=0;
                        foreach($items as $item) {
                            $weight+=($item->orders->weight)*($item->qty);
                        }
                        if($weight <= 1){
                            $deli=375;
                        }
                        else if($weight <= 2){
                            $deli=425;
                        }
                        else if($weight <= 3){
                            $deli=475;
                        }
                        else if($weight <= 4){
                            $deli=525;
                        }
                        else if($weight <= 5){
                            $deli=575;
                        }
                        else if($weight <= 6){
                            $deli=625;
                        }
                        else if($weight <= 7){
                            $deli=675;
                        }
                        else if($weight <= 8){
                            $deli=725;
                        }
                        else if($weight <= 9){
                            $deli=775;
                        }
                        else if($weight <= 10){
                            $deli=825;
                        }
                        else if($weight <= 11){
                            $deli=875;
                        }
                        else if($weight <= 12){
                            $deli=925;
                        }
                        else if($weight <= 13){
                            $deli=975;
                        }
                        else if($weight <= 14){
                            $deli=1025;
                        }
                        else if($weight <= 15){
                            $deli=1075;
                        }
                        else if($weight <= 16){
                            $deli=1125;
                        }
                        else if($weight <= 17){
                            $deli=1175;
                        }
                        else if($weight <= 18){
                            $deli=1225;
                        }
                        else if($weight <= 19){
                            $deli=1275;
                        }
                        else if($weight <= 20){
                            $deli=1325;
                        }
                        if($custds->ordertype == 3){
                            $deli=0;
                        }else{}
                    

                        $data->status=6;
                        $data->orderdelivery=$deli;
                        $data->weight=$weight;
                        $data->save();
                
                        $statrack = new statustrack;
                        $statrack->customerid=$id;
                        $statrack->username=Auth::user()->name;
                        $statrack->orderstatus=6;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();

                        return  Response::json(['status' => $data], 200);
                    }
                }
            }
        }



        
    }
}

public function colomboconfirmpending($id){

    $data = customer::find($id);
    $getpro=cus_orders::where('cus_id',$id)->get();
    $checkstock = DB::connection('mysql2')->select("select * from order_items");

    if($data==null){
        return  Response::json(['status' => false], 423);
    }else{

        foreach($getpro as $prodata){
            foreach($checkstock as $storedata){
                if($prodata->orders->pro_id == $storedata->id){
                    if($storedata->stock <= 0){

                        $data->status=32;
                        $data->save();
                
                        $statrack = new statustrack;
                        $statrack->customerid=$id;
                        $statrack->username="System";
                        $statrack->orderstatus=32;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();

                        $data=2;
                        return  Response::json(['status' => $data], 200);
                    }
                    else{
                        $custds = customer::where('id',$id)->get()->first();
                        $items = cus_orders::where('cus_id', $id)->get();
                        $weight=0;
                        $deli=0;
                        foreach($items as $item) {
                            $weight+=($item->orders->weight)*($item->qty);
                        }
                        if($weight <= 1){
                            $deli=300;
                        }
                        else if($weight <= 2){
                            $deli=400;
                        }
                        else if($weight <= 3){
                            $deli=500;
                        }
                        else if($weight <= 4){
                            $deli=600;
                        }
                        else if($weight <= 5){
                            $deli=700;
                        }
                        else if($weight <= 6){
                            $deli=800;
                        }
                        else if($weight <= 7){
                            $deli=900;
                        }
                        else if($weight <= 8){
                            $deli=1000;
                        }
                        else if($weight <= 8){
                            $deli=1100;
                        }
                        else if($weight <= 9){
                            $deli=1200;
                        }
                        else if($weight <= 10){
                            $deli=1300;
                        }
                        else if($weight <= 11){
                            $deli=1400;
                        }
                        else if($weight <= 12){
                            $deli=1500;
                        }
                        else if($weight <= 13){
                            $deli=1600;
                        }
                        else if($weight <= 14){
                            $deli=1700;
                        }
                        else if($weight <= 15){
                            $deli=1800;
                        }
                        else if($weight <= 16){
                            $deli=1900;
                        }
                        else if($weight <= 17){
                            $deli=2000;
                        }
                        else if($weight <= 18){
                            $deli=2100;
                        }
                        else if($weight <= 19){
                            $deli=2200;
                        }
                        else if($weight <= 20){
                            $deli=2300;
                        }
                        if($custds->ordertype == 3){
                            $deli=0;
                        }else{}

                        $data->status=5;
                        $data->orderdelivery=$deli;
                        $data->weight=$weight;
                        $data->save();
                
                        $statrack = new statustrack;
                        $statrack->customerid=$id;
                        $statrack->username=Auth::user()->name;
                        $statrack->orderstatus=5;
                        $statrack->starttime=0;
                        $statrack->endtime=0;
                        $statrack->status=0;
                        $statrack->save();

                        return  Response::json(['status' => $data], 200);
                    }
                }
            }
        }

    }
}


public function exchangedatatable(Request $request){

    if($request->resellerid=="all"){
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','city','cod','user','oldwaybill','oldwaybillstatus'])->where('status',17)->where('ordertype',2);
    }else{
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','city','cod','user','oldwaybill','oldwaybillstatus'])->where('status',17)->where('ordertype',2)->where('user',$request->resellerid);
    }
        

    return Datatables::of($users)->addColumn('citydata', function($users){
        $x='';
        if($users->city == "-"){$x.= 'No select city';}else{$x.= ''.$users->getcity->city.'';};
        return ''.$x.'';})->addColumn('action', function($users){
        $x='';
        if($users->oldwaybillstatus==0){$x='<span class="badge badge-warning">Not Return Received</span>';}else{
        $x.=
        '&nbsp;&nbsp;<a class="btn btn-success btn-xs outconfirm" data-id="'.$users->id .'"  href="">Out</a>'.
        '&nbsp;&nbsp;<a class="btn btn-info btn-xs colomboconfirm" data-id="'.$users->id .'"  href="">Colombo</a>'.
        '&nbsp;&nbsp;<a class="btn bg-gradient-secondary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';};
        return ''.$x.'';})
    ->make(true);
}

public function refunddatatable(Request $request){

    if($request->resellerid=="all"){
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','city','oldwaybill','oldwaybillstatus','cod','user'])->where('status',17)->where('ordertype',3);
    }else{
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','city','oldwaybill','oldwaybillstatus','cod','user'])->where('status',17)->where('ordertype',3)->where('user',$request->resellerid);
    }
        

    return Datatables::of($users)->addColumn('citydata', function($users){
        $x='';
        if($users->city == "-"){$x.= 'No select city';}else{$x.= ''.$users->getcity->city.'';};
        return ''.$x.'';})->addColumn('action', function($users){
            $x='';
            if($users->oldwaybillstatus==0){$x='<span class="badge badge-warning">Not Return Received</span>';}else{
            $x.='<a class="btn bg-gradient-secondary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';};
            return ''.$x.'';})
    ->make(true);
}

public function outofstocktable(Request $request){

    if($request->resellerid=="all"){
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','city','cod','user'])->where('status',32);
    }else{
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','city','cod','user'])->where('status',32)->where('user',$request->resellerid);
    }
        

    return Datatables::of($users)->addColumn('citydata', function($users){
        $x='';
        if($users->city == "-"){$x.= 'No select city';}else{$x.= ''.$users->getcity->city.'';};
        return ''.$x.'';})->addColumn('action', function($users){
        $x='';
        $x.=
        '&nbsp;&nbsp;<a class="btn btn-success btn-xs outconfirm" data-id="'.$users->id .'"  href="">Out</a>'.
        '&nbsp;&nbsp;<a class="btn btn-info btn-xs colomboconfirm" data-id="'.$users->id .'"  href="">Colombo</a>'.
        '&nbsp;&nbsp;<a class="btn bg-gradient-secondary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';
        return ''.$x.'';})
    ->make(true);
}

public function updatecusdetailsreseller(Request $request){
try{
    $cus_id = $request->cus_id;

    $data = customer::find($cus_id);
    $data->name = $request->name;
    $data->address = $request->address;
    $data->phone = $request->phone;
    $data->note = $request->note;
    $data->save();
    return redirect('/viewaddorder/'.$cus_id); 
    }
    catch (Exception $ex){
        return redirect('/viewaddorder/'.$cus_id)->with('error', 'Error : '.$ex->getMessage());
    }
}

public function exchangereturn(){
    $products = DB::connection('mysql2')->select('select * from order_items');
    return view('dashboard/inventory/exchangereturn')->with(['product'=>$products]);
}

public function postexchangereturn(Request $request)
{
    $data = customer::find($request->id);
    $excha=customer::where('oldwaybill',$request->id)->orderBy('id', 'desc')->first();

   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $checkretu = customer::where('id', $request->id)->first();

        if($checkretu->status==7){
            $data=2;
            return  Response::json(['status' => $data], 200);
        }
        else if($excha == null){
            $data=4;
            return  Response::json(['status' => $data], 200);
        }
        else{
            $data5 = customer::find($excha->id);
            $data5->oldwaybillstatus=1;
            $data5->save();

            $items2 = ordersbarcode::where('customerid', $request->id)->get();
            foreach($items2 as $item) {
                $users = DB::connection('mysql2')->select("update `productbarcodes` set `itemstatus` = 0 where barcode = '$item->barcode' ");
            }

            $items2 = cus_orders::where('cus_id', $request->id)->get();
            $getqty=0;
            $stock=0;
            foreach($items2 as $item) {
                $productdata=DB::connection('mysql2')->table('order_items')->where('id', $item->orders->pro_id)->get();
                $getqty=$item->qty;
                foreach($productdata as $prodata) {
                    $stock=($prodata->stock)+($getqty);   
                    $proid=$prodata->id;
                    $users = DB::connection('mysql2')->select("update `order_items` set `stock` = '$stock' where id = '$proid' ");
                }
            }


            // $data->status = 38;
            // $data->save();

            $statrack = new statustrack;
            $statrack->customerid=$request->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=38;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
            
            $data=3;
               return  Response::json(['status' => $data], 200);
   }
}
}


public function sendemail(Request $request){

    $deliveryid =$request->delivery;
    $disid =$request->dispachid;
    $ldate = date('Y-m-d H:i:s');
    

    if($request->Koobiyo=="Koobiyo"){
        $fileName="Koobiyo.csv";
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","city","district","paymentmethod","note"])->where('dispatchid',$disid)->get();
        $columns = array('Waybill Id', 'Order Number', 'Receiver Name', 'Delivery Address', 'District Name', 'Receiver Phone', 'COD','Description');
    
    
            // $file = fopen('php://output', 'w');
            $file = fopen('uploads/Koobiyo.csv', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                fputcsv($file, array($review->tracking,  $review->id, $review->name, $review->address,$review->district, $ph,  $cod,$da));
            }
            fclose($file);
    }
    else if($request->Domex=="Domex"){
        $fileName="Domex.csv";
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","city","district","paymentmethod","note"])->where('dispatchid',$disid)->get();
        $columns = array('RECEIVER NAME', 'RECEIVER ADDRESS 1', 'RECEIVER ADDRESS 2', 'RECEIVER CITY', 'RECEIVER CONTACT', 'PCs', 'WEIGHT(K)','WEIGHT(G)','REFERENCE','AMOUNT','ITEM NAME','SHORT NAME','Vibrant REF','WAYBILL NO','BARCODE');
    
    
            // $file = fopen('php://output', 'w');
            $file = fopen('uploads/Domex.csv', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                    fputcsv($file, array($review->name,$review->address," ",$review->getcity->city,$ph,"1",$review->weight," "," ", $review->cod,$da,$da,$review->id,$review->tracking,$review->tracking ));
            }
            fclose($file);

    }
    else if($request->Trans=="Trans"){
        $fileName="Trans.csv";
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","city","district","paymentmethod","note"])->where('dispatchid',$disid)->get();
        $columns = array('Traking Number', 'Order Number', 'Customer Name', 'Address', 'Order Description', 'Customer Phone', 'COD Amount','District','City','Remarks');
    
    
            // $file = fopen('php://output', 'w');
            $file = fopen('uploads/Trans.csv', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                    fputcsv($file, array($review->tracking,  $review->id, $review->name, $review->address, $da , $ph , $cod, $review->district, $review->getcity->city ,$review->note));
            }
            fclose($file);

    }
    else if($request->Fardar=="Fardar"){
        $fileName="Fardar.csv";
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","city","district","paymentmethod","note"])->where('dispatchid',$disid)->get();
        $columns = array('ID', 'Parcel Type', 'Order ID', 'Parcel Description', 'Recipient Name', 'Recipient Mobile', 'Recipient Address','Recipient City','COD Amount','Exchange');
    
    
            // $file = fopen('php://output', 'w');
            $file = fopen('uploads/Fardar.csv', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                    fputcsv($file, array($review->tracking,'1', $review->id, $da, $review->name, $ph, $review->address, $review->getcity->city,   $cod ,'0'));
            }
            fclose($file);

    }
    else if($request->Grasshopper=="Grasshopper"){
        $fileName="Grasshopper.csv";
    
        $reviews = customer::select(["id", "name", "address", "phone","secondaryphone", "cod","tracking","city","district","paymentmethod","note"])->where('dispatchid',$disid)->get();
        $columns = array('B2B#', 'SLEEPING#', 'RECIPIENT_NAME', 'PHONE#', 'PHONE#2', 'STREET', 'CITY', 'ZIP_CODE', 'DELIVERY_METHOD', 'CATEGORY', 'ITEM_DESCRIPTION', 'QTY', 'PAYMENT_TYPE', 'AMOUNT', 'PAYMENT_METHOD', 'WEIGHT(KG)', 'DIMENSION_TYPE', 'SP_INSTRUCTIONS');
    
    
            // $file = fopen('php://output', 'w');
            $file = fopen('uploads/Grasshopper.csv', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {

                foreach($review->cus_or as $cusitems){
                    $datacccc[] = $cusitems->orders->pro_name;
                   }
                   $da=implode(', ', $datacccc);
                   $datacccc = []; 

                    $numbers = explode(',', $review->address);
                    $lastNumber = end($numbers);
                    $cod=0;
                    if($review->paymentmethod=="paid" OR $review->ordertype==2){
                        $cod=0.00;
                    }else{
                        $cod=$review->cod;
                    }
                    $ph = $review->phone.'/'.$review->secondaryphone;
                    fputcsv($file, array($review->id,$review->tracking, $review->name,$review->phone , $review->secondaryphone, $review->address, $review->getcity->city,"","STANDARD","PACKAGE", $da,"1","CASH_ON_DELIVERY", $cod,"CASH","1","STANDARD_SIZE",""));
            }
            fclose($file);

    }

    $to_name = $request->delivery;
    $to_email = $request->email;
    $data = array('date'=>$ldate, "noof"=> $request->noofline);    

    Mail::send("dashboard.orders.mail", $data, function($message) use ($to_name, $to_email, $fileName) {
        $message->to($to_email, $to_name)->subject('Seller Center Dispatched orders')->cc(['mjayanatha@gmail.com','infortec2016@gmail.com']);
        $message->attach('uploads/' . $fileName);
        $message->from('support@wasimartoffice.com','Seller Center Dispatched orders');
        });
        
    return redirect('/courierexcel/'.$disid); 

}

public function trancecheck(){
    
    return view('dashboard/shipping/trancetest');
}

public function trancecheckfilter(Request $request){

    $waybill=40115047;
    $order_no=40115047;
    $customer_name="test";
    $address="test";
    $description="test";
    $phone_no="0777777777";
    $cod=1500;
    $district_id=5;
    $city_id=846;
    $note="test";


    $postRequest = array(
        'waybill_id' => $waybill,
        'order_no' => $order_no,
        'customer_name' => $customer_name,
        'address' => $address,
        'description' => $description,
        'phone_no' => $phone_no,
        'cod' => $cod,
        'district_id' => $district_id,
        'city_id' => $city_id,
        'note' => $note

    );


    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://portal.transexpress.lk/api/orders/upload/single-manual',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>$postRequest,
      CURLOPT_HTTPHEADER => array(
        'Accept: application/json',
        'Content-Type: multipart/form-data',
        'Authorization: Bearer b6wJKchU3wc24bl4ppBxFQieD0Ig6mROHukHqBbEZMWtNxig3c3OchyUN7NszmXWlyWev7lfPT0asziA',
        'Cookie: trans_express_services_lanka_session=MYoe9Cz37BA0gZNVAZfnJsKLcOV4SgQFUR97SDZT'
      ),
    ));
    
    $response = curl_exec($curl);
    $err = curl_error($curl);
    $data = json_decode($response, TRUE);
    curl_close($curl);
 
    dd($data);

//     $ch = curl_init();
//     curl_setopt($ch, CURLOPT_URL,"https://portal.transexpress.lk/api/orders/upload/single-manual");
//     curl_setopt($ch, CURLOPT_POST, 1);
//     curl_setopt($ch, CURLOPT_POSTFIELDS,$postRequest);
//     curl_setopt($ch, CURLOPT_HTTPHEADER,
//     array(
//         'Accept: application/json',
//         'Content-Type: multipart/form-data',
//         'Authorization: Bearer b6wJKchU3wc24bl4ppBxFQieD0Ig6mROHukHqBbEZMWtNxig3c3OchyUN7NszmXWlyWev7lfPT0asziA',
//         'Cookie: trans_express_services_lanka_session=MYoe9Cz37BA0gZNVAZfnJsKLcOV4SgQFUR97SDZT'
//       )
// );
//     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
//     $server_output = curl_exec($ch);
//     $err = curl_error($ch);
//     $data = json_decode($server_output, TRUE);
//     curl_close ($ch);


    dd($data);
    
    return view('dashboard/shipping/trancetest');
}




public function loginfilter(Request $request){

    $email="udrop.lk@gmail.com";
    $pass="danush20";

    $postRequest = array(
        'email' => $email,
        'password' => $pass
    );

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'https://portal.transexpress.lk/api/login/client',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>$postRequest,
      CURLOPT_HTTPHEADER => array(
        'Accept: application/json'
      ),
    ));
    
    $response = curl_exec($curl);
    $err = curl_error($curl);
    $data = json_decode($response, TRUE);
    curl_close($curl);

    
    dd($data);
 
    
    return view('dashboard/shipping/trancetest');
}


public function outcity(){
    $delivery = deliveryservice::get();
    $city = citylist::get();
    $fardcity = fardarcitylist::get();

    return view('dashboard/shipping/cityupdate')->with(['city'=>$city,'fardcity'=>$fardcity,'delivery'=>$delivery]);
}

public function cityupfilter(Request $request){
    $delivery = deliveryservice::get();
    $city = trancecity::get();
    $fardcity = fardarcitylist::get();

    return view('dashboard/shipping/cityupdate2')->with(['city'=>$city,'fardcity'=>$fardcity,'delivery'=>$delivery,'del'=>$request->resellerid ]);
}


public function cityupdatedatatable(Request $request){

$users = customer::select(['id','pagename', 'name', 'address', 'phone','ordertype','tracecity','cod','user','deliveryservice'])->where('status',19)->where('deliveryservice',$request->resellerid);

return Datatables::of($users)->addColumn('citydata', function($users){
    $x='';
    if($users->tracecity == "-"){$x.= 0;}else{$x.= ''.$users->trancecity->city_name.'';};
    return ''.$x.'';})->addColumn('action', function($users){
    $x='';
    $x.=
    '&nbsp;&nbsp;<button type="button" data-id="'.$users->id .'" data-city="'.$users->tracecity .'" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#editordermodelphone">Select City</button>'.
    '&nbsp;&nbsp;<a class="btn bg-gradient-secondary btn-xs" data-id="'.$users->id.'"  target="_blank" href="viwedetails/'.$users->id.'">view</a>';
    return ''.$x.'';})
->make(true);
}


public function trancecityupdate(Request $request){
    $data = customer::find($request->id);
    try{

        $data->tracecity = $request->cituselect;
        $data->save();
        return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }   
}

public function sendoutprint(Request $request){
try{
    $cus = customer::where('status',19)->where('deliveryservice',$request->delservice)->where('tracecity', '!=' ,"-")->get();

    foreach($cus as $cusdata){
        $data2 = customer::find($cusdata->id);
        $data2->status = 11;
        $data2->save();
    }
    return redirect('/outcity')->with('success', 'Successfully Saved!');
    }
    catch (Exception $ex){
    return redirect('/outcity')->with('error', 'Error : '.$ex->getMessage());
    }

}


public function assignresellerpriceup(Request $request){
    $proid=$request->id;
    $reprice=$request->price;
    $wei=$request->weight;
    try{
        $item = DB::connection('mysql2')->select("update `order_items` set `resellerprice` = '$reprice',`weight` = '$wei'  where id = '$proid' ");

        $sellp = sellerproduct::where('pro_id',$request->id)->get();
        foreach($sellp as $sellpdata){
            $data = sellerproduct::find($sellpdata->id);
            $data->cost = $request->price;
            $data->weight = $request->weight;
            $data->save();
        }
        $data=1;
        return  Response::json(['status' => $data], 200);
    }
    catch (Exception $ex){
        return  Response::json(['status' => false], 423);
    }   
}



public function sendtosellercenter(Request $request)
{
    $newDateTime = Carbon::now()->subDays(5);
    $ldate = date('Y-m-d H:i:s');
    $edate=$newDateTime->toDateTimeString();

    $cusdata= customer::where('status','!=',0)->whereBetween('created_at',[$edate,$ldate])->get();
    $import = customer::where('status',0)->get();
    $importco = customer::where('status',0)->get()->count();
// if($importco != 0){
//     foreach($cusdata as $cdata){
//         foreach($import as $idata){
//             $phone1= substr($cdata->phone, -9);
//             $phone2= substr($idata->phone, -9);
//             foreach($cdata->cus_or as $prod1){
//                 foreach($idata->cus_or as $prod2){
//                     if($prod1->orders->pro_id == $prod2->orders->pro_id AND $phone1 == $phone2 ){

//                         DB::table('customers')->where('id',$idata->id)->update(['status' => 37]);
//                         $statrack = new statustrack;
//                         $statrack->customerid=$idata->id;
//                         $statrack->username="System";
//                         $statrack->orderstatus=37;
//                         $statrack->starttime=0;
//                         $statrack->endtime=0;
//                         $statrack->status=0;
//                         $statrack->save();

//                     }

//                 }

//             }

//         }
//     }

// }


    $data = DB::table('customers')->where('status',0)->get();
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
        DB::table('customers')->where('user',Auth::user()->resellerid)->where('status',0)->where('city',"!=","-")->update(['status' => 17]);
        return  Response::json(['status' => $data], 200);
   }
   

}


public function bulkimportorders(){

    $city = citylist::get();
    $product = sellerproduct::where('seller_id',Auth::user()->resellerid)->get();
    $tempo = bulktemporders::where('sellerid',Auth::user()->resellerid)->get();

    $resedata = resellerdetails::where('id',Auth::user()->resellerid)->first();
    if($resedata->inventory == 0){
        return redirect('/resellerdash')->with('error', 'Inventory Locked, Please Contact SellerCenter Customer Support!!!');
    }
    else{
    return view('dashboard/addorder/importorders2')->with(['product'=>$product,'tempo'=>$tempo,'city'=>$city ]);
    }
}


public function resellerpaymentexcel(Request $request){

    $ldate= date('d-m-Y');
if($request->payment == "payment"){

    $firstDay = Carbon::now()->toDateString();

    $headers = array(
        "Content-type" => "text/csv",
        "Content-Disposition" => "attachment; filename=resellers-payment-$ldate.csv",
        "Pragma" => "no-cache",
        "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
        "Expires" => "0"
    );

    $reviews = resellerpayment::select(["id", "resellerid", "paidamount"])->where('status',0)->get();
    $columns = array('Origin Account number (15 Chars)', 'Origin Account Name', 'Value Date (DD/MM/YYYY)', 'Benificiary Bank Code', 'Benificiary Branch Code', 'Benificiary Account Number', 'Benificiary Account Name', 'Amount','Particulars','References');

    $callback = function() use ($reviews, $columns)
    {
        $file = fopen('php://output', 'w');
        fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
        fputcsv($file, $columns);

        foreach($reviews as $review) {
            $newdate=date('d/m/Y');
            fprintf($file, chr(0xEF).chr(0xBB).chr(0xBF));
            fputcsv($file, array("101013195470001","Vibrant Technologies",$newdate,$review->getresellerbank->bankcode, $review->getresellerbank->branchcode, $review->getresellerbank->accountNo, $review->getresellerbank->name, $review->paidamount,"Reseller Payment",$review->getresellerd2->companyname));
        }
        fclose($file);
    };
    return Response::stream($callback, 200, $headers);

}    
else{
    $mon = customer::where('status',33)->where('comcommission',"-")->get();

    $data = new resellerpayment();
    $data->resellerid = 318;
    $data->genratedby = Auth::user()->name;
    $data->collectedcod = $mon->count()*20;
    $data->deliverycharge = 0;
    $data->servicecharge = 0;
    $data->productscharge = 0;
    $data->commision = $mon->count();
    $data->advance = 20;
    $data->paidamount = $mon->count()*20;
    $data->status = 0;
    $data->paiddate = "-";
    $data->save();

    foreach($mon as $mdata){
        $stchange = customer::find($mdata->id);
        $stchange->comcommission = $data->id;
        $stchange->save();
    }
    return redirect('/receivedcod')->with('success', 'Successfully Saved!');

}
    
}


public function postbulkimport(Request $request){

    $redate= date('Y-m-d H:i:s');
    $resed = resellerdetails::find(Auth::user()->getresellerd->id);
    $resed->date = $redate;
    $resed->save();

    $gettempd = bulktemporders::where('sellerid',Auth::user()->getresellerd->id);
    $gettempd->delete();

		if($request->hasFile('import_file')){
			$path = $request->file('import_file')->getRealPath();
			$data = Excel::load($path, function($reader) {})->get();
            $date = date('Y-m-d');
            $ldate = str_replace('-', '/', $date);
			if(!empty($data) && $data->count()){
				foreach ($data->toArray() as $key => $value) {  

                $gweig = sellerproduct::where('seller_id',Auth::user()->getresellerd->id)->where('pro_name',$value['item'])->first();
                $getcity = citylist::where('city',$value['city'])->first();
                $trac = trancecity::where('city_name',$value['city'])->first();
                
                if($gweig == null){     
                    $bulktemporders = bulktemporders::create(['sellerid' => Auth::user()->getresellerd->id,'name' => $value['name'], 'address' => $value['address'], 'city' => $value['city'],'tp_1' =>$value['tp_1'],'tp_2' =>$value['tp_2'],'item' =>$value['item'],'qty' =>$value['qty'],'unit_price' =>$value['unit_price'],'delivery' =>$value['delivery'],'total' =>$value['total'],'error_code' =>'Product Name Invalid']);                                  
                }
                // else if($getcity == null){
                //     $bulktemporders = bulktemporders::create(['sellerid' => Auth::user()->getresellerd->id,'name' => $value['name'], 'address' => $value['address'], 'city' => $value['city'],'tp_1' =>$value['tp_1'],'tp_2' =>$value['tp_2'],'item' =>$value['item'],'qty' =>$value['qty'],'unit_price' =>$value['unit_price'],'delivery' =>$value['delivery'],'total' =>$value['total'],'error_code' =>'City Invalid']);                                  
                // }
                else{

                $upprice = sellerproduct::find($gweig->id);
                $upprice->sell_price = $value['unit_price'];
                $upprice->save();
                
                $delc=0;
                $weight=floatval($gweig->weight)*floatval($value['qty']);
                
                if($weight <= floatval(1)){
                    $delc=300;
                }
                else if($weight <= floatval(2)){
                    $delc=350;
                }
                else if($weight <= floatval(3)){
                    $delc=400;
                }
                else if($weight <= floatval(4)){
                    $delc=450;
                }
                else if($weight <= floatval(5)){
                    $delc=500;
                }
                else if($weight <= floatval(6)){
                    $delc=550;
                }
                else if($weight <= floatval(7)){
                    $delc=600;
                }
                else if($weight <= floatval(8)){
                    $delc=650;
                }
                else if($weight <= floatval(9)){
                    $delc=700;
                }
                else if($weight <= floatval(10)){
                    $delc=750;
                }
                else if($weight <= floatval(11)){
                    $delc=800;
                }
                else if($weight <= floatval(12)){
                    $delc=850;
                }
                else if($weight <= floatval(13)){
                    $delc=900;
                }
                else if($weight <= floatval(14)){
                    $delc=950;
                }
                else if($weight <= floatval(15)){
                    $delc=1000;
                }
                else if($weight <= floatval(16)){
                    $delc=1050;
                }
                else if($weight <= floatval(17)){
                    $delc=1100;
                }
                else if($weight <= floatval(18)){
                    $delc=1150;
                }
                else if($weight <= floatval(19)){
                    $delc=1200;
                }
                else if($weight <= floatval(20)){
                    $delc=1250;
                }

                if($getcity == null){
                    $inscustomer = customer::create(['reorderid' => $value['order_id'],'user' => Auth::user()->getresellerd->id,'addeduser' => Auth::user()->id,'pageName' => Auth::user()->getresellerd->companyname,'name' => $value['name'], 'address' => $value['address'], 'phone' => $value['tp_1'], 'secondaryphone' => $value['tp_2'], 'status' => '20','tracking' => '-', 'note' => 'None', 'print' => '0', 'cod' => $value['total'], 'deliverycharge' => $value['delivery'], 'deliveryservice' => '-','dispatchid' => '-','branch' => '-','deliverydate' => $ldate,'ridername' => '-','companydelivery' => '0','city' => "-",'district' => "-",'weight' => $weight,'sellercodid' => '0','deliverystatus' => '21','moneyrecivestatus' => '0','oldwaybill' => '-','oldwaybillstatus' => '0','paymentmethod' => 'cash','confirmuser' => '-', 'courierreciveid' => '-','ordertype' => 1,'orderdelivery' => $delc,'lockuser' => '-', 'lockstatus' => 0, 'tracecity' => '-','servicecharge' => Auth::user()->getresellerd->service, 'commisionstatus'=>0,'commisionid'=>'-','riderdelivery'=>250,'comcommission'=>'-']);
                }
                else{
                    $inscustomer = customer::create(['reorderid' => $value['order_id'],'user' => Auth::user()->getresellerd->id,'addeduser' => Auth::user()->id,'pageName' => Auth::user()->getresellerd->companyname,'name' => $value['name'], 'address' => $value['address'], 'phone' => $value['tp_1'], 'secondaryphone' => $value['tp_2'], 'status' => '20','tracking' => '-', 'note' => 'None', 'print' => '0', 'cod' => $value['total'], 'deliverycharge' => $value['delivery'], 'deliveryservice' => '-','dispatchid' => '-','branch' => '-','deliverydate' => $ldate,'ridername' => '-','companydelivery' => '0','city' => $getcity->id,'district' => $getcity->district,'weight' => $weight,'sellercodid' => '0','deliverystatus' => '21','moneyrecivestatus' => '0','oldwaybill' => '-','oldwaybillstatus' => '0','paymentmethod' => 'cash','confirmuser' => '-', 'courierreciveid' => '-','ordertype' => 1,'orderdelivery' => $delc,'lockuser' => '-', 'lockstatus' => 0, 'tracecity' => '-','servicecharge' => Auth::user()->getresellerd->service, 'commisionstatus'=>0,'commisionid'=>'-','riderdelivery'=>250,'comcommission'=>'-']);
                }
                // $inscustomer = customer::create(['reorderid' => $value['order_id'],'user' => Auth::user()->getresellerd->id,'addeduser' => Auth::user()->id,'pageName' => Auth::user()->getresellerd->companyname,'name' => $value['name'], 'address' => $value['address'], 'phone' => $value['tp_1'], 'secondaryphone' => $value['tp_2'], 'status' => '20','tracking' => '-', 'note' => 'None', 'print' => '0', 'cod' => $value['total'], 'deliverycharge' => $value['delivery'], 'deliveryservice' => '-','dispatchid' => '-','branch' => '-','deliverydate' => $ldate,'ridername' => '-','companydelivery' => '0','city' => $getcity->id,'district' => $getcity->district,'weight' => $weight,'sellercodid' => '0','deliverystatus' => '21','moneyrecivestatus' => '0','oldwaybill' => '-','oldwaybillstatus' => '0','paymentmethod' => 'cash','confirmuser' => '-', 'courierreciveid' => '-','ordertype' => 1,'orderdelivery' => $delc,'lockuser' => '-', 'lockstatus' => 0, 'tracecity' => '-','servicecharge' => Auth::user()->getresellerd->service, 'commisionstatus'=>0,'commisionid'=>'-','riderdelivery'=>250,'comcommission'=>'-']);
                $insorder = cus_orders::create(['item_id' => $gweig->id, 'cus_id' => $inscustomer->id, 'attribute' => 'null', 'qty' => $value['qty'], 'pro_amount' => $value['unit_price'],'reseller_cost'=>$gweig->cost,'barcode' =>'-']);
                $statustrack = statustrack::create(['customerid' => $inscustomer->id, 'username' => Auth::user()->name, 'orderstatus' => '0','starttime' =>'0','endtime' =>'0','status' =>'0']);          
                if($trac != null){
                    $data = customer::find($inscustomer->id);
                    $data->tracecity = $trac->id;
                    $data->save();
                }  

                for($i=0; $i<$value['qty']; $i++){
                    $qtybarcode = ordersbarcode::create(['customerid' => $inscustomer->id, 'productid' => $gweig->id, 'itemordid' => $insorder->id, 'barcode' => '-', 'status' => '0']);
                }
				}

            }
				if(!empty($value)){
                    return back()->with('success','Insert Record successfully.');
                    
                }
			}
		}
		return back()->with('error','Please Check your file, Something is wrong there.');
    }


    public function bulkpendingorders()
    {
        $users = customer::select(['id','pagename', 'name', 'address', 'phone','city','confirmuser','cod'])->where('user',Auth::user()->resellerid)->where('status',20);
    
        return Datatables::of($users)->addColumn('citydata', function($users){
            $x='';
            if($users->city == "-"){$x.= 0;}else{$x.= ''.$users->getcity->city.'';};
            return ''.$x.'';})->addColumn('action', function($users){
            return
            '&nbsp;&nbsp;<button type="button" data-id="'.$users->id .'" data-city="'.$users->city .'" data-fadercity="'.$users->confirmuser .'" class="btn btn-warning btn-xs" data-toggle="modal" data-target="#editordermodelphone">Select City</button>'.
            '&nbsp;&nbsp;<a class="btn btn-danger btn-xs bulkdelete" data-id="'.$users->id .'"  href="">Delete</a>'.
            '&nbsp;&nbsp;<a data-id="'.$users->id.'" class="btn btn-primary btn-xs" target="_blank" href="viewaddorder/'.$users->id.'">View</a>';})
        ->make(true);
    }

    public function deletebulkcustomer(Request $request){
        $getcus = customer::where('user',Auth::user()->getresellerd->id)->where('status', 20)->get();
    
       if($getcus==null){
            return  Response::json([
                'status' => false
            ], 423);
       }else{
           foreach($getcus as $cusdata){
            $data = customer::find($cusdata->id);
            $itemde = cus_orders::where('cus_id', $cusdata->id);
            $bardel = ordersbarcode::where('customerid', $cusdata->id);
    
            $data->delete();
            $itemde->delete();
            $bardel->delete();
           }
    
                   return  Response::json(['status' => $getcus], 200);
       }
    }



    public function tempordersdown(Request $request){
    
    try{
        if($request->delete =="delete"){
            $getcus = bulktemporders::where('sellerid',Auth::user()->getresellerd->id)->get();
            foreach($getcus as $cusdata){
                $data = bulktemporders::find($cusdata->id);
                $data->delete();
                }
                return redirect('/bulkimportorders');

        }else{

            $ldate= date('d-m-Y');
        
            $headers = array(
                "Content-type" => "text/csv",
                "Content-Disposition" => "attachment; filename=Failed-Orders-$ldate.csv",
                "Pragma" => "no-cache",
                "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
                "Expires" => "0"
            );
        
            $reviews = bulktemporders::select(["sellerid", "name", "address", "city", "tp_1", "tp_2", "item", "qty","unit_price","delivery","total"])->where('sellerid',Auth::user()->getresellerd->id)->get();
            $columns = array('name', 'address', 'city', 'tp_1', 'tp_2', 'item', 'qty', 'unit_price','delivery','total');
        
            $callback = function() use ($reviews, $columns)
            {
                $file = fopen('php://output', 'w');
                fputcsv($file, $columns);
        
                foreach($reviews as $review) {
                    fputcsv($file, array($review->name,$review->address,$review->city,$review->tp_1,$review->tp_2,$review->item,$review->qty,$review->unit_price,$review->delivery,$review->total));
                }
                fclose($file);
            };
            return Response::stream($callback, 200, $headers);

        }

    
    }
    catch (Exception $ex){
        return redirect('/bulkimportorders')->with('error', 'Error : '.$ex->getMessage());
    }
}

public function sentocallcenter2(Request $request)
{
    $newDateTime = Carbon::now()->subDays(5);
    $ldate = date('Y-m-d H:i:s');
    $edate=$newDateTime->toDateTimeString();

    $cusdata= customer::where('status','!=',20)->whereBetween('created_at',[$edate,$ldate])->get();
    $import = customer::where('status',20)->where('user',Auth::user()->resellerid)->get();

//     foreach($cusdata as $cdata){
//         foreach($import as $idata){
//             $phone1= substr($cdata->phone, -9);
//             $phone2= substr($idata->phone, -9);
//             foreach($cdata->cus_or as $prod1){
//                 foreach($idata->cus_or as $prod2){
//                     if($prod1->orders->pro_id == $prod2->orders->pro_id AND $phone1 == $phone2 ){

//                         DB::table('customers')->where('id',$idata->id)->update(['status' => 37]);
//                         $statrack = new statustrack;
//                         $statrack->customerid=$idata->id;
//                         $statrack->username="System";
//                         $statrack->orderstatus=37;
//                         $statrack->starttime=0;
//                         $statrack->endtime=0;
//                         $statrack->status=0;
//                         $statrack->save();

//                     }

//                 }

//             }

//         }

// }


    $data = DB::table('customers')->where('user',Auth::user()->resellerid)->where('status',20)->get();
    if($data==null){
        return  Response::json(['status' => false], 423);

   }else{
        DB::table('customers')->where('user',Auth::user()->resellerid)->where('status',20)->update(['status' => 1]);
        return  Response::json(['status' => $data], 200);
   }
   

}


public function sendtosellercenter2(Request $request)
{
    $newDateTime = Carbon::now()->subDays(5);
    $ldate = date('Y-m-d H:i:s');
    $edate=$newDateTime->toDateTimeString();

    // $cusdata= customer::where('status','!=',20)->whereBetween('created_at',[$edate,$ldate])->get();
    // $import = customer::where('status',20)->get();
    // foreach($cusdata as $cdata){
    //     foreach($import as $idata){
    //         $phone1= substr($cdata->phone, -9);
    //         $phone2= substr($idata->phone, -9);
    //         foreach($cdata->cus_or as $prod1){
    //             foreach($idata->cus_or as $prod2){
    //                 if($prod1->orders->pro_id == $prod2->orders->pro_id AND $phone1 == $phone2 ){

    //                     DB::table('customers')->where('id',$idata->id)->update(['status' => 37]);
    //                     $statrack = new statustrack;
    //                     $statrack->customerid=$idata->id;
    //                     $statrack->username="System";
    //                     $statrack->orderstatus=37;
    //                     $statrack->starttime=0;
    //                     $statrack->endtime=0;
    //                     $statrack->status=0;
    //                     $statrack->save();

    //                 }

    //             }

    //         }

    //     }
    // }




    $data = DB::table('customers')->where('user',Auth::user()->getresellerd->id)->where('status',20)->get();
    if($data==null){
        return  Response::json(['status' => false], 423);
   }else{
    $dataup = customer::where('status',20)->where('user',Auth::user()->getresellerd->id)->where('city',"!=","-")->get();

        foreach($dataup as $dataas){

            $da = customer::find($dataas->id);
            $da->status=17;
            $da->save();

            $statrack = new statustrack;
            $statrack->customerid=$dataas->id;
            $statrack->username=Auth::user()->name;
            $statrack->orderstatus=17;
            $statrack->starttime=0;
            $statrack->endtime=0;
            $statrack->status=0;
            $statrack->save();
        }

        // DB::table('customers')->where('status',20)->where('city',"!=","-")->update(['status' => 17]);
        return  Response::json(['status' => $data], 200);
   }
   

}

public function notreceivedmoney(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $items = customer::where('status', 18)->where('deliveryservice','!=' ,'-')->whereBetween('updated_at',[$da,$da2])->get();
    $delise = deliveryservice::get();
    $del[]=" ";
    return view('dashboard/reports/notrecivemoney')->with(['item'=>$items,'delise'=>$delise,'del'=>$del,'date'=>$date]);
}

public function notreceivedmoneyfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $delise = deliveryservice::get();

    if($request->PDF == "PDF"){
        $ldate = date('Y-m-d');

        $items = customer::where('status', 18)->wherein('deliveryservice', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();
    
        $pdf = PDF::loadView('dashboard.reports.notrecivedmonpdf', array('del'=>$request->delivery,'delise'=>$delise,'ldate'=> $ldate,'item'=> $items,'date'=>$request->daterange))->setPaper('a4');
      return $pdf->stream(); 
    }
    else if($request->Missing == "Missing"){
        $items = customer::where('status', 8)->wherein('deliveryservice', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();

    }
    else if($request->Filter == "Filter"){
        $items = customer::where('status', 18)->wherein('deliveryservice', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();

    }
    else if($request->MissingPDF == "MissingPDF"){
        $ldate = date('Y-m-d');
        $items = customer::where('status', 8)->wherein('deliveryservice', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();
    
        $pdf = PDF::loadView('dashboard.reports.missingparcelpdf', array('del'=>$request->delivery,'delise'=>$delise,'ldate'=> $ldate,'item'=> $items,'date'=>$request->daterange))->setPaper('a4');
      return $pdf->stream(); 
    }
    
    return view('dashboard/reports/notrecivemoney')->with(['item'=>$items,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);
}



public function colombomissing(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $items = customer::where('status', 18)->where('companydelivery',1)->whereBetween('updated_at',[$da,$da2])->get();
    $delise = User::get();
    $del[]=" ";
    return view('dashboard/reports/colombomissing')->with(['item'=>$items,'delise'=>$delise,'del'=>$del,'date'=>$date]);
}

public function colombomissingfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $delise = User::get();

    if($request->PDF == "PDF"){
        $ldate = date('Y-m-d');

        $items = customer::where('status', 18)->wherein('ridername', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();
    
        $pdf = PDF::loadView('dashboard.reports.colombonotrecivedmonpdf', array('del'=>$request->delivery,'delise'=>$delise,'ldate'=> $ldate,'item'=> $items,'date'=>$request->daterange))->setPaper('a4');
      return $pdf->stream(); 
    }
    else if($request->Missing == "Missing"){
        $items = customer::where('status', 8)->wherein('ridername', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();

    }
    else if($request->Filter == "Filter"){
        $items = customer::where('status', 18)->wherein('ridername', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();

    }
    else if($request->MissingPDF == "MissingPDF"){
        $ldate = date('Y-m-d');
        $items = customer::where('status', 8)->wherein('ridername', $request->delivery)->whereBetween('updated_at',[$da,$da2])->get();
    
        $pdf = PDF::loadView('dashboard.reports.colombomissingparcelpdf', array('del'=>$request->delivery,'delise'=>$delise,'ldate'=> $ldate,'item'=> $items,'date'=>$request->daterange))->setPaper('a4');
      return $pdf->stream(); 
    }
    
    return view('dashboard/reports/colombomissing')->with(['item'=>$items,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);
}

public function resellerreport(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $allconfirmcount=0;
    $delise = resellerdetails::get();
    $del="null";
    $proc=0;$dis=0;$ret=0;$mone=0;
    return view('dashboard/reports/resellerreport')->with(['proc'=>$proc,'dis'=>$dis,'ret'=>$ret,'mone'=>$mone,'delise'=>$delise,'del'=>$del,'date'=>$date]);
}

public function resellerreportfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';
    $delise = resellerdetails::get();
 
    $packe = customer::wherein('status',[17,5,6,7,8,9,10,11,12,13,14,15,18,19,32,33,34,35,36,37,38])->where('user',$request->delivery)->whereBetween('created_at',[$da,$da2])->get();
    $proc = customer::wherein('status',[17,5,6,11,12,13,14,15,32])->where('user',$request->delivery)->whereBetween('created_at',[$da,$da2])->count();
    $dis = customer::wherein('status',[8])->where('user',$request->delivery)->whereBetween('created_at',[$da,$da2])->count();
    $ret = customer::wherein('status',[7,34,35,36])->where('user',$request->delivery)->whereBetween('created_at',[$da,$da2])->count();
    $mone = customer::wherein('status',[9,33])->where('user',$request->delivery)->whereBetween('created_at',[$da,$da2])->count();

    return view('dashboard/reports/resellerreport')->with(['proc'=>$proc,'dis'=>$dis,'ret'=>$ret,'mone'=>$mone,'dataor'=>$packe,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);
}


public function productwiseorders(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $allconfirmcount=0;
    $delise = sellerproduct::where('seller_id',Auth::user()->resellerid)->get();
    $del="null";
    return view('dashboard/reports/productreport')->with(['allconfirmcount'=>$allconfirmcount,'delise'=>$delise,'del'=>$del,'date'=>$date]);
}

public function productwiseordersfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';
    $delise = sellerproduct::where('seller_id',Auth::user()->resellerid)->get();

    $items =  customer::select('customers.id','customers.name','customers.address','customers.phone','customers.tracking','customers.cod','customers.status')->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')->
where('cus_orders.item_id',$request->delivery)->whereBetween('customers.created_at', [$da, $da2])->groupBy('customers.id')->get();


    return view('dashboard/reports/productreport')->with(['items'=>$items,'delise'=>$delise,'del'=>$request->delivery,'date'=>$request->daterange]);
}

public function resellersellsummary(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $money = customer::where('status',33)->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get();
    $return = customer::where('status',34)->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get();
    $refund = customer::where('status',36)->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get();
    $counttot = customer::wherein('status',[33,34])->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get()->count();

    $mondel=0;
    $totcod=0;
    $totrefundcod=0;
    $totinventory=0;
    $servicech=0;
    $returnservice=0;
    $totservice=0;
    foreach($money as $modata){
        $mondel+=$modata->orderdelivery;
        $totcod+=$modata->cod;
        $servicech+=$modata->servicecharge;
        foreach($modata->cus_or as $iprod){
            $totinventory+=$iprod->reseller_cost*$iprod->qty;
        }
    }
    foreach($return as $returndat){
        $returnservice+=$returndat->servicecharge;
    }
    foreach($refund as $refunddat){
        $totrefundcod+=$refunddat->cod;
    }
    $totservice=$servicech+$returnservice;
    return view('dashboard/reports/resellersalesummary')->with(['date'=>$date,'servicech'=>$totservice,'totinventory'=>$totinventory,'refund'=>$refund,'totrefundcod'=>$totrefundcod,'counttot'=>$counttot,'totcod'=>$totcod,'mondel'=>$mondel,'return'=>$return,'money'=>$money]);
}


public function resellersellsummaryfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $money = customer::where('status',33)->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get();
    $return = customer::where('status',34)->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get();
    $refund = customer::where('status',36)->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get();
    $counttot = customer::wherein('status',[33,34])->where('user',Auth::user()->resellerid)->whereBetween('created_at', [$da, $da2])->get()->count();

    $mondel=0;
    $totcod=0;
    $totrefundcod=0;
    $totinventory=0;
    $servicech=0;
    $returnservice=0;
    $totservice=0;
    foreach($money as $modata){
        $mondel+=$modata->orderdelivery;
        $totcod+=$modata->cod;
        $servicech+=$modata->servicecharge;
        foreach($modata->cus_or as $iprod){
            $totinventory+=$iprod->reseller_cost*$iprod->qty;
        }
    }
    foreach($return as $returndat){
        $returnservice+=$returndat->servicecharge;
    }
    foreach($refund as $refunddat){
        $totrefundcod+=$refunddat->cod;
    }
    $totservice=$servicech+$returnservice;
    return view('dashboard/reports/resellersalesummary')->with(['date'=>$request->daterange,'servicech'=>$totservice,'totinventory'=>$totinventory,'refund'=>$refund,'totrefundcod'=>$totrefundcod,'counttot'=>$counttot,'totcod'=>$totcod,'mondel'=>$mondel,'return'=>$return,'money'=>$money]);
}

public function topselling(){
    $ldate = date('Y/m/d');
    $date = $ldate.' - '.$ldate;
    $ldate1 = date('Y-m-d');
    $da= $ldate1.' 00:00:00';
    $da2= $ldate1.' 23:59:59';

    $dataor =  customer::select('sellerproducts.weight','sellerproducts.sell_price','sellerproducts.cost','cus_orders.item_id','sellerproducts.pro_name','sellerproducts.seller_id', DB::raw("SUM(cus_orders.qty) as qty"))
    ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
    ->join('sellerproducts', 'sellerproducts.id', '=' , 'cus_orders.item_id');

    $dataor=$dataor->where('customers.user', Auth::user()->resellerid)->wherein('customers.status', [8,9,18,33])->whereBetween('customers.updated_at',[$da,$da2])->groupBy('sellerproducts.pro_id')->orderBy('qty', 'DESC')->get();



    return view('dashboard/reports/topselling')->with(['date'=>$date,'dataor'=>$dataor]);
}

public function topsellingfilter(Request $request){
    list($da1, $da222) = explode('-', $request->daterange);
      
    $date1 = str_replace('/', '-', $da1);
    $date2 = str_replace('/', '-', $da222);
    $da = $date1.'00:00:00';
    $da2 = $date2.' 23:59:59';

    $dataor =  customer::select('sellerproducts.weight','sellerproducts.sell_price','sellerproducts.cost','cus_orders.item_id','sellerproducts.pro_name','sellerproducts.seller_id', DB::raw("SUM(cus_orders.qty) as qty"))
    ->join('cus_orders', 'cus_orders.cus_id', '=' , 'customers.id')
    ->join('sellerproducts', 'sellerproducts.id', '=' , 'cus_orders.item_id');

    $dataor=$dataor->where('customers.user', Auth::user()->resellerid)->wherein('customers.status', [8,9,18,33])->whereBetween('customers.updated_at',[$da,$da2])->groupBy('sellerproducts.pro_id')->orderBy('qty', 'DESC')->get();



    return view('dashboard/reports/topselling')->with(['date'=>$request->daterange,'dataor'=>$dataor]);
}

public function commision($id){
    $datas2 = resellerdetails::where('id',$id)->get();
    $resel = resellerdetails::get();
    $supdatas = commission::where('resellerid',$id)->get();
    return view('dashboard/reseller/commision',['nowid'=>$id,'resel'=>$resel,'datas2'=>$datas2,'supdata'=>$supdatas]);
}


public function addcommision(Request $request){
    $data = new commission();
    try{

    $data->resellerid = $request->sid;
    $data->commisereseller = $request->reseller;
    $data->commischarge = $request->Commision;
    $data->status = 1;
    $data->save();

    return redirect('/commision/'.$request->sid)->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/commision/'.$request->sid)->with('error', 'Error : '.$ex->getMessage());
    }
}

public function commisionupdate(Request $request){
    $data = commission::find($request->id);

    try{
        $sta = $request->has('paidstatus');
        $status=0;
        if($sta=="true"){
            $status=1;
        }
        else{
            $status=0;
        }

        $data->commisereseller = $request->reseller;
        $data->commischarge = $request->Commision;
        $data->status = $status;
        $data->save();

        return redirect('/commision/'.$request->supid)->with('success', 'Successfully Saved!');
            }
        catch (Exception $ex){
            return redirect('/commision/'.$request->supid)->with('error', 'Error : '.$ex->getMessage());
        }
}
public function commisiondelete(Request $request,$id){
    $data = commission::find($id);

   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}


public function advance($id){
    $datas2 = resellerdetails::where('id',$id)->get();
    $supdatas = advance::where('resellerid',$id)->get();
    return view('dashboard/reseller/advance',['nowid'=>$id,'datas2'=>$datas2,'supdata'=>$supdatas]);
}


public function addadvance(Request $request){
    $data = new advance();
    try{

    $data->resellerid = $request->sid;
    $data->advance = $request->advance;
    $data->paidid = "-";
    $data->paiddate = "-";
    $data->status = 0;
    $data->save();

    return redirect('/advance/'.$request->sid)->with('success', 'Successfully Saved!');
        }
    catch (Exception $ex){
        return redirect('/advance/'.$request->sid)->with('error', 'Error : '.$ex->getMessage());
    }
}


public function advancedelete(Request $request,$id){
    $data = advance::find($id);

   if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        $data->delete();

               return  Response::json([
        'status' => $data
    ], 200);
   }
}












































































































    public function ajaxRequest(){
        return view('ajaxRequest');
    }

    public function ajaxRequestPost(Request $request){
        $input = $request->all(); 
        $name = $request->name;
        // dd($input);
        return response()->json(['success'=>$name]);
    }
    

    public function addProductTemplate(){
        return view('dashboard/addproduct');
    }


    public function addProduct(Request $request){
        // dd($request->all());
        $additem=new orderItem;
        $additem->name=$request->name;
        $additem->item_code=$request->code;
        $additem->sell_price=$request->price;
        $additem->cost_price=$request->cost;
        $additem->stock=$request->stock;
        $additem->save();
        return redirect()->back();
    }

















    public function viewafter(){

        $items = customer::where('status', '6')->get();
        
        return view('dashboard/orders/after')->with(['item'=>$items]);
    }

    public function viewnotanswer(){

        $items = customer::where('status', '5')->get();
        
        return view('dashboard/orders/notanswer')->with(['item'=>$items]);
    }



    public function viewreturn(){

        $items = customer::where('status', '3')->get();
        
        return view('dashboard/orders/return')->with(['item'=>$items]);
    }

    public function viewcomplete(){

        $items = customer::where('status', '2')->get();
        
        return view('dashboard/orders/complete')->with(['item'=>$items]);
    }

    // public function viewallorders(){

    //     $items = customer::get();
        
    //     return view('dashboard/orders/allorders')->with(['item'=>$items]);
    // }









    public function updatetracking(Request $request){

        $cus_id = $request->cus_id;

        $data = customer::find($cus_id);
        $data->tracking = $request->code;
        $data->save();

        return redirect('/viwedetails/'.$cus_id); 
    }

    public function updatenote(Request $request){

        $cus_id = $request->cus_id;

        $data = customer::find($cus_id);
        $data->note = $request->note;
        $data->save();

        return redirect('/viwedetails/'.$cus_id); 
    }



    public function updateprintstatus(Request $request, $id){
        //dd($id);
        $data = customer::find($id);
        if($data==null){
            return  Response::json([
                'status' => false
            ], 423);
       }else{
            $data->print = 1;
            $data->save();
                   return  Response::json([
            'status' => $data
        ], 200);
       }

    }

    public function deletecusorder(Request $request, $id){
        //dd($id);
        $data = customer::find($id);
        if($data==null){
            return  Response::json([
                'status' => false
            ], 423);
       }else{
            $data->delete();
                   return  Response::json(['status' => $data], 200);
       }

    }

    public function Editaddorder($id){
        
        // $value = Session::get('abc');
        $items = cus_orders::where('cus_id', $id)->get();
        $data = [];
        $deli=0;
        $unit=0;
        $tot=0;


        foreach($items as $item) {
            $orders = $item->orders;
            $d = [
                'quantity' => $item->qty,
                'delivery' => $item->delivery,
                'name' => $orders->name,
                'sellPrice'=> $orders->sell_price
            ];
            $deli +=$item->delivery;
            $unit = ($orders->sell_price)*($item->qty);
            $tot += $unit;

            //$data[] = $d;
            array_push($data, $d);
        }

        // return $data;

        // return $items;
        // dd($email);
        
        $items3 = orderItem::get();
        // $items2 = cus_orders::get();

        return view('dashboard/orders/additems')->with(['item'=>$items3, 'item2'=>$items, 'tot' => $tot, 'deli' => $deli,'cus_id'=>$id]);
    }

    public function editcustomerItems(Request $request){

        $att = json_encode($request->product_properties);
        $cus_id=$request->cus_id;
        $additem=new cus_orders;

        try{
        $additem->item_id=$request->nameproduct;
        $additem->cus_id=$cus_id;
        $additem->attribute=$att;
        $additem->qty=$request->quantity;
        $additem->delivery=$request->Delivery;
        $additem->save();

        return redirect('/Editaddorder/'.$cus_id)->with('success', 'Successfully Saved!');

        }
        catch (Exception $ex){
            return redirect('/Editaddorder/'.$cus_id)->with('error', 'Error : '.$ex->getMessage());
        }
        //return redirect('/viewaddorder');
    }


    public function editupdateitem(Request $request){

        $att = json_encode($request->product_properties);
        $cus_id =$request->cus_id;
        try{
        $id = $request->id;
        $data = cus_orders::find($id);
        $data->item_id = $request->nameproduct2;
        $data->attribute=$att;
        $data->qty = $request->quantity;
        $data->delivery=$request->Delivery;
        $data->save();

        return redirect('/Editaddorder/'.$cus_id)->with('success', 'Successfully Saved!');

        }
        catch (Exception $ex){
            return redirect('/Editaddorder/'.$cus_id)->with('error', 'Error : '.$ex->getMessage());
        }
        
    }




    public function viewtodeliver(){

        $items = customer::where('status', '1')->get();
        $items3 = pages::get();
        
        return view('dashboard/orders/today')->with(['item'=>$items,'page'=>$items3]);
    }

    public function selfdeliver(){

        $items = customer::where('status', '7')->get();
        $items3 = pages::get();
        
        return view('dashboard/orders/self')->with(['item'=>$items,'page'=>$items3]);
    }

    public function todaycode(Request $request){

        $cus_id = $request->input('id');
        $code = $request->input('code');

        $data = customer::find($cus_id);

        if($data==null){
            return  Response::json(['status' => false], 423);
       }else{
            $data->tracking = $code;
            $data->save();
            return  Response::json(['status' => $data], 200);
       } 
    }

    public function getBasicObjectData()
    {
        $users = customer::select(['id', 'name', 'cod', 'tracking','print','note'])->where('status',1);

        return Datatables::of($users)->addColumn('action', function($users){
            return
            '<p class="text-center">
            <button type="button" data-id="'.$users->id .'" data-tracking="'.$users->tracking .'" class="btn btn-info btn-xs" data-toggle="modal" data-target="#editordermodel">Tracking Code</button>'. 
            '&nbsp;&nbsp;<a class="btn btn-danger btn-xs" data-id="'.$users->id .'"  href=""><i class="fa fa-trash-o "></i></a>'.
            '&nbsp;&nbsp;<a data-id="'.$users->id.'" class="btn btn-primary btn-xs" href="viwedetails/'.$users->id.'">View</a></p>';})
        ->make(true);
    }

    public function getBasicObjectDataself()
    {
        $users = customer::select(['id', 'name', 'address', 'phone','cod'])->where('status',7);

        return Datatables::of($users)->addColumn('action', function($users){
            return
            '<p class="text-center">'. 
            '&nbsp;&nbsp;<a class="btn btn-danger btn-xs" data-id="'.$users->id .'"  href=""><i class="fa fa-trash-o "></i></a>'.
            '&nbsp;&nbsp;<a data-id="'.$users->id.'" class="btn btn-primary btn-xs" href="viwedetails/'.$users->id.'">View</a></p>';})
        ->make(true);
    }

    public function statuschange(Request $request,$id){

        $data = customer::find($id);
        $data->status = 0;
        $data->save();

        return redirect('/Editaddorder/'.$id);
    }

    public function exportselfdelivery(){

        $headers = array(
            "Content-type" => "text/csv",
            "Content-Disposition" => "attachment; filename=self.csv",
            "Pragma" => "no-cache",
            "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
            "Expires" => "0"
        );
    
        $reviews = customer::select(["id", "name", "address", "phone", "cod"])->where('status',7)->get();
        $columns = array('ID','Name', 'Adress', 'Phone','COD');
    
        $callback = function() use ($reviews, $columns)
        {
            $file = fopen('php://output', 'w');
            fputcsv($file, $columns);
    
            foreach($reviews as $review) {
                fputcsv($file, array($review->id, $review->name,$review->address, $review->phone,$review->cod));
            }
            fclose($file);
        };
        return Response::stream($callback, 200, $headers);
    }



    public function exportcsvgrass(){

    $headers = array(
        "Content-type" => "text/csv",
        "Content-Disposition" => "attachment; filename=grasshopper.csv",
        "Pragma" => "no-cache",
        "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
        "Expires" => "0"
    );

    $reviews = customer::select(["id", "name", "address", "phone", "cod"])->where('status',1)->get();
    $columns = array('B2B#', 'SLEEPING#', 'RECIPIENT_NAME', 'PHONE#', 'PHONE#2', 'STREET', 'CITY', 'ZIP_CODE', 'DELIVERY_METHOD', 'CATEGORY', 'ITEM_DESCRIPTION', 'QTY', 'PAYMENT_TYPE', 'AMOUNT', 'PAYMENT_METHOD', 'WEIGHT(KG)', 'DIMENSION_TYPE', 'SP_INSTRUCTIONS');

    $callback = function() use ($reviews, $columns)
    {
        $file = fopen('php://output', 'w');
        fputcsv($file, $columns);

        foreach($reviews as $review) {
            fputcsv($file, array($review->id, "", $review->name, $review->phone, "", $review->address, "","", "STANDARD","PACKAGE","Cosmetics","1","CASH_ON_DELIVERY", $review->cod,"CASH","1","STANDARD_SIZE"));
        }
        fclose($file);
    };
    return Response::stream($callback, 200, $headers);
}

public function exportcsvkoobiyo(){

    $headers = array(
        "Content-type" => "text/csv",
        "Content-Disposition" => "attachment; filename=koobiyo.csv",
        "Pragma" => "no-cache",
        "Cache-Control" => "must-revalidate, post-check=0, pre-check=0",
        "Expires" => "0"
    );

    $reviews = customer::select(["id", "name", "address", "phone", "cod","tracking","note"])->where('status',1)->get();
    $columns = array('Waybill Id', 'Order Number', 'Receiver Name', 'Delivery Address', 'District ID', 'City ID', 'Receiver Phone', 'COD','Description');

    $callback = function() use ($reviews, $columns)
    {
        $file = fopen('php://output', 'w');
        fputcsv($file, $columns);

        foreach($reviews as $review) {
            fputcsv($file, array($review->tracking,  $review->id, $review->name, $review->address,"1","1", $review->phone,  $review->cod, $review->note));
        }
        fclose($file);
    };
    return Response::stream($callback, 200, $headers);
}

public function completedUpdate(Request $request)
{
    $data = DB::table('customers')->where('status',1);
    if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{

    $customer = customer::where('status', '1')->get();
    foreach($customer as $cus) {
            $items2 = cus_orders::where('cus_id', $cus->id)->get();
            $getqty=0;
            $stock=0;
            foreach($items2 as $item) {
                $productdata = orderItem::where('id', $item->item_id)->get();
                // $productdata = orderItem::find($item->item_id);
                $getqty=$item->qty;
                foreach($productdata as $prodata) {
                    $stock=$prodata->stock;   
                    $stockchange = orderItem::find($prodata->id);  
                    $stockchange->stock = $stock-$getqty;
                    $stockchange->save();
                }
            }
        }
        DB::table('customers')->where('status',1)->update(['status' => 2]);
        return  Response::json([
        'status' => $data
    ], 200);
   }
   

}

public function printUpdate(Request $request)
{
    $data = DB::table('customers')->where('status',1);
    if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{
        DB::table('customers')->where('status',1)->update(['print' => 1]);
        return  Response::json([
        'status' => $data
    ], 200);
   }
   

}


public function completedUpdateself(Request $request)
{
    $data = DB::table('customers')->where('status',7);
    if($data==null){
        return  Response::json([
            'status' => false
        ], 423);
   }else{

    $customer = customer::where('status', '7')->get();
    foreach($customer as $cus) {
            $items2 = cus_orders::where('cus_id', $cus->id)->get();
            $getqty=0;
            $stock=0;
            foreach($items2 as $item) {
                $productdata = orderItem::where('id', $item->item_id)->get();
                // $productdata = orderItem::find($item->item_id);
                $getqty=$item->qty;
                foreach($productdata as $prodata) {
                    $stock=$prodata->stock;   
                    $stockchange = orderItem::find($prodata->id);  
                    $stockchange->stock = $stock-$getqty;
                    $stockchange->save();
                }
            }
        }
        DB::table('customers')->where('status',7)->update(['status' => 2]);
        return  Response::json([
        'status' => $data
    ], 200);
   }
   

}







//******************************************************* */


public function getdetails($id){
    $data = productdata::where('product_id',$id)->get();
    if($data==null){
        return  Response::json(['status' => false,'message'=>'product ID not Found '], 423);
   }else{
        
        return  Response::json(['status' => $data], 200);
   }
}

public function postdescription(Request $request){

    if($request['desid']==null){  
    
    $additem=new productdata;
    if(empty($request['products'])){
        return  Response::json(['status' => false,'message'=>'product ID not Found '], 423);
    }        
    else{        
        if($request->file('Picture1')!=null && $request->file('Picture2')!=null){
            $cover = $request->file('Picture1');
            $extension = $cover->getClientOriginalExtension();
            Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));
        
            $cover1 = $request->file('Picture2');
            $extension1 = $cover1->getClientOriginalExtension();
            Storage::disk('public')->put($cover1->getFilename().'.'.$extension1,  File::get($cover1));

            $additem->product_id=$request['products'];
            $additem->description=$request['summernoteInput'];
            $additem->img1 = $cover->getFilename().'.'.$extension;
            $additem->img2 = $cover1->getFilename().'.'.$extension1;
            $additem->save();        
            return  Response::json(['status' => 'success'], 200);

        }
        elseif($request->file('Picture1')!=null && $request->file('Picture2')==null){

            $cover = $request->file('Picture1');
            $extension = $cover->getClientOriginalExtension();
            Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));

            $additem->product_id=$request['products'];
            $additem->description=$request['summernoteInput'];
            $additem->img1 = $cover->getFilename().'.'.$extension;
            $additem->img2 = "";
            $additem->save();        
            return  Response::json(['status' => 'success'], 200);

        }
        elseif($request->file('Picture1')==null && $request->file('Picture2')!=null){

            $cover1 = $request->file('Picture2');
            $extension1 = $cover1->getClientOriginalExtension();
            Storage::disk('public')->put($cover1->getFilename().'.'.$extension1,  File::get($cover1));

            $additem->product_id=$request['products'];
            $additem->description=$request['summernoteInput'];
            $additem->img1 = "";
            $additem->img2 = $cover1->getFilename().'.'.$extension1;
            $additem->save();        
            return  Response::json(['status' => 'success'], 200);

        }
        else{
            $additem->product_id=$request['products'];
            $additem->description=$request['summernoteInput'];
            $additem->img1="";
            $additem->img2="";
            $additem->save();        
            return  Response::json(['status' => 'success'], 200);
        }
        // $additem->product_id=$request['products'];
        // $additem->description=$request['summernoteInput'];
        // $additem->img1 = $cover->getFilename().'.'.$extension;
        // $additem->img2 = $cover1->getFilename().'.'.$extension1;
        // $additem->save();
        // return  Response::json(['status' => 'success'], 200);
    } 
    }
    else{
        if($request->file('Picture1')!=null && $request->file('Picture2')!=null){

            $cover = $request->file('Picture1');
            $extension = $cover->getClientOriginalExtension();
            Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));
        
            $cover1 = $request->file('Picture2');
            $extension1 = $cover1->getClientOriginalExtension();
            Storage::disk('public')->put($cover1->getFilename().'.'.$extension1,  File::get($cover1));

            $editdes = productdata::find($request['desid']);
            $editdes->product_id=$request['products'];
            $editdes->description=$request['summernoteInput'];
            $editdes->img1 = $cover->getFilename().'.'.$extension;
            $editdes->img2 = $cover1->getFilename().'.'.$extension1;
            $editdes->save();        
            return  Response::json(['status' => 'success'], 200);

        }
        elseif($request->file('Picture1')!=null && $request->file('Picture2')==null){

            $cover = $request->file('Picture1');
            $extension = $cover->getClientOriginalExtension();
            Storage::disk('public')->put($cover->getFilename().'.'.$extension,  File::get($cover));

            $editdes = productdata::find($request['desid']);
            $editdes->product_id=$request['products'];
            $editdes->description=$request['summernoteInput'];
            $editdes->img1 = $cover->getFilename().'.'.$extension;
            $editdes->save();        
            return  Response::json(['status' => 'success'], 200);

        }
        elseif($request->file('Picture1')==null && $request->file('Picture2')!=null){

            $cover1 = $request->file('Picture2');
            $extension1 = $cover1->getClientOriginalExtension();
            Storage::disk('public')->put($cover1->getFilename().'.'.$extension1,  File::get($cover1));

            $editdes = productdata::find($request['desid']);
            $editdes->product_id=$request['products'];
            $editdes->description=$request['summernoteInput'];
            $editdes->img2 = $cover1->getFilename().'.'.$extension1;
            $editdes->save();        
            return  Response::json(['status' => 'success'], 200);

        }
        else{
            $editdes = productdata::find($request['desid']);
            $editdes->product_id=$request['products'];
            $editdes->description=$request['summernoteInput'];
            $editdes->save();        
            return  Response::json(['status' => 'success'], 200);
        }
    }

}  

public function myformAjax($id)
{
    $cities = DB::table("attributes")->where("proid",$id);
    return json_encode($cities);
}


public function getStates($id){        
    $states = DB::table("attributes")->where("proid",$id)->select(["attname","id","attributes"])->get();

    return Response::json($states, 200);
}

public function getStates2($id){        
    $states = DB::table("attributes")->where("proid",$id)->select(["attname","id","attributes"])->get();

    return Response::json($states, 200);
}

public function EditgetStates($id){    

    
    $states = DB::table("attributes")->where("proid",$id)->select(["attname","id","attributes"])->get();

    return Response::json($states, 200);
}

public function EditgetStates2($id){        
    $states = DB::table("attributes")->where("proid",$id)->select(["attname","id","attributes"])->get();

    return Response::json($states, 200);
}


public function importExcel(Request $request){

    $lastValue = DB::table('customers')->orderBy('id', 'desc')->first();
		if($request->hasFile('import_file')){
			$path = $request->file('import_file')->getRealPath();

			$data = Excel::load($path, function($reader) {})->get();

			if(!empty($data) && $data->count()){

				foreach ($data->toArray() as $key => $value) {                        
						
                    $inscustomer = customer::create(['user' => Auth::user()->name,'pageName' => '1','name' => $value['name'], 'address' => $value['address'], 'phone' => $value['phone'], 'status' => '0', 'tracking' => ' ', 'note' => 'None', 'print' => '0', 'cod' => '0']);
                    $insorder = cus_orders::create(['item_id' => $value['item'], 'cus_id' => $inscustomer->id, 'attribute' => 'null', 'qty' => '1', 'delivery' =>$value['delivery']]);
                      
						
					
				}

				if(!empty($value)){
                    // customer::insert($insert);
                    // cus_orders::insert($insert2);
                    return back()->with('success','Insert Record successfully.');
                    
                }
			}
		}
		return back()->with('error','Please Check your file, Something is wrong there.');
    }
    
    function get_customer_data(){
        $items = customer::where('status', '1')->get();
        $items3 = pages::get();

        return $items;
    }

    public function export_pdf()
    {

        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->where('status', '1')->get();

        $pdf = PDF::loadView('dashboard.orders.printinvoce', array('cus'=>$cus,'ldate'=> $ldate));
      return $pdf->stream(); 
    }

    public function export_pdf_koobiyo()
    {

        $ldate = date('Y-m-d');
        $cus = customer::with('cus_or')->where('status', '1')->get();

        // $numbers = explode(',', $review->address);
        // $lastNumber = end($numbers);

        $pdf = PDF::loadView('dashboard.orders.printkoobiyo', array('cus'=>$cus,'ldate'=> $ldate));
        $pdf->setPaper('a4');
      return $pdf->stream(); 
    }


    public function test2(){

        $custo = customer::where('status', '1')->get();


        $id=2;
        $data = customer::find($id);
        $items = customer::where('id', $id)->get();
        $items2 = cus_orders::where('cus_id', $id)->get();
        $page_data = pages::where('id', $data->pageName)->get();
        $ldate = date('Y-m-d');

        $deli=0;
        $unit=0;
        $tot=0;


        foreach($items2 as $item) {
            $orders = $item->orders;
            $deli +=$item->delivery;
            $unit = ($orders->sell_price)*($item->qty);
            $tot += $unit;

        }


        $cus = customer::with('cus_or')->where('status', '1')->get();
        // $cus = customer::find(55);
        // dd($cus);

 

        return view('dashboard/orders/test')->with(['cus'=>$cus,'custo'=>$custo,'item'=>$items,'tot' => $tot, 'deli' => $deli,'item3'=>$items2,'cus_id'=>$id,'pages'=>$page_data,'ldate'=> $ldate]);
    }

}





// public function importExcel(Request $request){

//     $lastValue = DB::table('customers')->orderBy('id', 'desc')->first();
// 		if($request->hasFile('import_file')){
// 			$path = $request->file('import_file')->getRealPath();

// 			$data = Excel::load($path, function($reader) {})->get();

// 			if(!empty($data) && $data->count()){

// 				foreach ($data->toArray() as $key => $value) {
//                     $uniqid = ($lastValue->id)+1;
// 					if(!empty($value)){
                        
						
// 							// $insert[] = ['name' => $value['name'], 'address' => $value['address'], 'phone' => $value['phone']];
// 							// $insert[] = ['user' =>'ashan','pageName' => '1','name' => $value['name'], 'address' => $value['address'], 'phone' => $value['phone'], 'status' => '0', 'tracking' => ' ', 'note' => 'None', 'print' => '0', 'cod' => '0'];
//                             // $insert2[] = ['item_id' => '1', 'cus_id' => $uniqid, 'attribute' => 'null', 'qty' => '1', 'delivery' => '300'];
//                         foreach($value as $row){
//                                 $inscustomer = customer::create(['user' =>'ashan','pageName' => '1','name' => $row['name'], 'address' => $row['address'], 'phone' => $row['phone'], 'status' => '0', 'tracking' => ' ', 'note' => 'None', 'print' => '0', 'cod' => '0']);
//                                 $insorder = cus_orders::create(['item_id' => '1', 'cus_id' => $inscustomer->id, 'attribute' => 'null', 'qty' => '1', 'delivery' => '300']);
//                             }
						
// 					}
// 				}

// 				if(!empty($value)){
//                     // customer::insert($insert);
//                     // cus_orders::insert($insert2);
//                     return back()->with('success','Insert Record successfully.');
                    
//                 }
// 			}
// 		}
// 		return back()->with('error','Please Check your file, Something is wrong there.');
// 	}